/*
 *      aps.c from Access Point SNMP Utils for Linux
 *
 * Copyright (c) 2002 Roman Festchook <roma at polesye dot net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 from
 * June 1991 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
#include <string.h>
#include <ncurses.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include "ap-utils.h"

extern WINDOW *main_sub/*, *win_for_menu*/;
extern short ap_type;

void APs()
{
    struct ap {
	unsigned char mac[6];
	unsigned char q1;
	unsigned char q2;
	unsigned char channel;
	unsigned char x2;
	unsigned char options;
	unsigned char x3[5];
	unsigned char essid[32];
    } *app = NULL;

    char operESSIDLength[] = { 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x01, 0x02, 0x00 };
    char operESSID[] = { 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x02, 0x01, 0x03, 0x00 };
	
    
    char KnownAP[] = { 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01,
	0x02, 0x07, 0x01, 0x00
    };

    char bridgeOperationalMode[] =
	{ 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x04, 0x01,
	0x00
    };
    char bridgeRemoteBridgeBSSID[] = { 0x2B, 0x06, 0x01, 0x04, 0x01, 0x83, 0x1A, 0x01, 0x01, 0x04, 0x02, 0x00 };
    
    struct known_AP {
	    char mac[6];
	    char *essid;
	    short essid_len;
	} ap[5];	    
    char message[1024];

    char value[] = "", c, bridge_mode;
    int i, j, aps_num=0;
    varbind varbinds[3];
   
   if (ME102 == ap_type) {
	operESSIDLength[5] = 0xE0;
	operESSIDLength[6] = 0x3E;
	operESSID[5] = 0xE0;
	operESSID[6] = 0x3E;
	KnownAP[5] = 0xE0;
	KnownAP[6] = 0x3E;
	bridgeOperationalMode[5] = 0xE0;
	bridgeOperationalMode[6] = 0x3E;
	bridgeRemoteBridgeBSSID[5] = 0xE0;
	bridgeRemoteBridgeBSSID[6] = 0x3E;
   }
    noecho();
    print_help(WAIT_RET);

	for(i=0; i<5; i++)
		ap[i].essid=NULL;
    
    varbinds[0].oid = bridgeOperationalMode;
    varbinds[0].len_oid = sizeof(bridgeOperationalMode);
    varbinds[0].value = bridgeOperationalMode;
    varbinds[0].len_val = 0;
    varbinds[0].type = NULL_VALUE;
    if (snmp(varbinds, 1, GET) <= 0) {
	print_help(ERR_RET);
	goto exit;
    }
    bridge_mode = *(varbinds[0].value);
    


    if (bridge_mode == 2) {
	mvwaddstr(main_sub, 3, 3,
		  _
		  ("Getting known AP's info need to reboot you AP and may cause lost of current configuration."));
	mvwaddstr(main_sub, 6, 3, _("Do you want to continue? "));
	wrefresh(main_sub);
	print_help(_("(Y - Yes; N - No (it's safer to ansver No)"));
	i = 1;
	while (i)
	    switch (getch()) {
	    case 'Y':
	    case 'y':
		clear_main(3);
		i = 0;
		break;
	    case 'n':
	    case 'N':
		goto quit;
	    }

	print_help(WAIT_RET);
	varbinds[0].oid = bridgeOperationalMode;
	varbinds[0].len_oid = sizeof(bridgeOperationalMode);
	varbinds[0].type = INT_VALUE;
	c = 3;
	varbinds[0].value = &c;
	varbinds[0].len_val = 1;
	if (snmp(varbinds, 1, SET) <= 0) {
	    print_help(ERR_RET);
	    goto exit;
	}

	if (SysUpload()) {
	    print_help(ERR_RET);
	    goto restore_before_exit;
	}
	sleep(10);
    }

get_stats:
    varbinds[0].oid = KnownAP;
    varbinds[0].len_oid = sizeof(KnownAP);
    varbinds[0].type = NULL_VALUE;
    varbinds[0].value = value;
    varbinds[0].len_val = sizeof(value);

    if (snmp(varbinds, 1, GET) <= 0) {
	print_help(ERR_RET);
	goto restore_before_exit;
    }

    print_title(_("Known Access Points"));
    mvwaddstr(main_sub, 0, 0, "#");
    mvwaddstr(main_sub, 0, 2, "ESSID");
    mvwaddstr(main_sub, 0, 18, "BSSID (mac)");
    mvwaddstr(main_sub, 0, 31, "CN");
    mvwaddstr(main_sub, 0, 34, _("NetworkType"));
    mvwaddstr(main_sub, 0, 49, "P");
    mvwaddstr(main_sub, 0, 51, "WEP");
    mvwaddstr(main_sub, 0, 56, "RSSI");
    mvwaddstr(main_sub, 0, 62, "LQ");
    for (i = 0, aps_num=0; i < varbinds[0].len_val; i += 48) {
	aps_num++;
	if (app)
	    free(app);
	app = (struct ap *) malloc(48);
	memcpy(app, varbinds[0].value + i, 48);

	if (!app->channel || app->channel>14 || app->mac[0] == 0xFF)
	    continue;
	for (j = 0; j < 32 && app->essid[j]; j++) {
	    mvwaddch(main_sub, aps_num+1, j+2, app->essid[j]);
	    message[j] = app->essid[j];
	}
	ap[aps_num-1].essid_len=j;
	if(ap[aps_num-1].essid)
		free(ap[aps_num-1].essid);
	ap[aps_num-1].essid = malloc(ap[aps_num-1].essid_len);
	memcpy(ap[aps_num-1].essid, message, ap[aps_num-1].essid_len);
    		
	sprintf(message, "%02X%02X%02X%02X%02X%02X",
		app->mac[0] & 0xFF, app->mac[1] & 0xFF,
		app->mac[2] & 0xFF, app->mac[3] & 0xFF,
		app->mac[4] & 0xFF, app->mac[5] & 0xFF);
	mvwaddstr(main_sub, aps_num+1, 18, message);
	memcpy(ap[aps_num-1].mac, app->mac, 6);
	sprintf(message, "%2u", app->channel);
	mvwaddstr(main_sub, aps_num+1, 31, message);
	mvwaddstr(main_sub, aps_num+1, 34,
		  (app->options & 1) ? _("Infrastructure") : "Ad-Hoc");
	mvwaddstr(main_sub, aps_num+1, 49,
		  (app->options & 32) ? "S" : "L");
	mvwaddstr(main_sub, aps_num+1, 51,
		  (app->options & 16) ? ON : OFF);
	sprintf(message, "%3ddBm", -96 + app->q1);
	mvwaddstr(main_sub, aps_num+1, 55, message);
	sprintf(message, "%2d", app->q2);
	mvwaddstr(main_sub, aps_num+1, 62, message);
   	mvwaddch(main_sub, aps_num+1, 0, '0'+aps_num);

    }
    mvwaddstr(main_sub, LINES - 6, 0,
	      _("CN: Channel; RSSI: Signal Strenght; LQ: Link Quality"));
    mvwaddstr(main_sub, LINES - 5, 0,
	      _("P: Preambule Type; S: Short; L: Long"));
    wrefresh(main_sub);

    print_help(_("# connect to this AP; R refresh with reset; G refresh without reset; Q quit"));
	while (1)
           switch (i = getch()) {
            case 'Q':
            case 'q':
		    goto restore_before_exit;
	    case '1':
            case '2':
	    case '3':
            case '4':
	    case '5':
		    print_help(WAIT_SET);
		    j = i - '0';
		    if(j < 0 || j > aps_num)
			    break;
	            varbinds[2].oid = bridgeRemoteBridgeBSSID;
		    varbinds[2].len_oid = sizeof(bridgeRemoteBridgeBSSID);
		    varbinds[2].value = ap[j-1].mac;
		    varbinds[2].len_val = 6;
		    varbinds[2].type = STRING_VALUE;
	            varbinds[0].oid = operESSIDLength;
		    varbinds[0].len_oid = sizeof(operESSIDLength);
		    varbinds[0].value = (char *) &ap[j-1].essid_len;
	            varbinds[0].len_val = 1;
	            varbinds[0].type = INT_VALUE;
	            varbinds[1].oid = operESSID;
		    varbinds[1].len_oid = sizeof(operESSID);
		    varbinds[1].value = ap[j-1].essid;
		    varbinds[1].len_val = ap[j-1].essid_len;
		    varbinds[1].type = STRING_VALUE;
                    if (snmp(varbinds, 3, SET) <= 0) {
                        print_help(ERR_SET);
                        goto restore_before_exit;
                    }

		    bridge_mode = (bridge_mode == 2) ? 3 : bridge_mode;
				
		    if (SysUpload() < 0 ) {
			    print_help(ERR_SET);
			    getch();
			    goto restore_before_exit;
			}
		    print_help(DONE_SET);
		    getch();
		    goto restore_before_exit;
	    case 'G':
	    case 'g':
		    print_help(WAIT_RET);
		    clear_main(0);
		    goto get_stats;
	    case 'R':
	    case 'r':
		    print_help(WAIT_RET);
		    if (SysReset() < 0) {
		      print_help(ERR_RET);
		      getch();
		      goto restore_before_exit;
		    }
		    clear_main(0);
		    sleep(10);
		    goto get_stats;
            }

  restore_before_exit:
    if (bridge_mode == 2) {
	print_help(WAIT_SET);
	varbinds[0].oid = bridgeOperationalMode;
	varbinds[0].len_oid = sizeof(bridgeOperationalMode);
	varbinds[0].value = (char *) &bridge_mode;
	varbinds[0].len_val = 1;
	varbinds[0].type = INT_VALUE;
	if (snmp(varbinds, 1, SET) <= 0) {
	    print_help(ERR_RET);
	    goto exit;
	}

	if (SysUpload()) {
	    print_help(ERR_RET);
	    goto exit;
	}
    }
 goto quit;

 exit:
    getch();
  quit:
    if (app)
	free(app);
    print_title("");
    clear_main(0);
    for(aps_num=0; aps_num<5; aps_num++)
	if(ap[aps_num].essid)
		free(ap[aps_num].essid);
}

