#!/bin/sh
[ "$1" = "-h" ] && cat <<tac

This example tests the features/changes added for release 1.58:

   - MIME type regexp changes
   - Filename policy algorithm changes

tac

$ANOMY/bin/sanitizer.pl -nofprot $SAN_CONF \
    'file_list_rules = 1' \
    'file_list_1_scanner = 0' \
    'file_list_1_policy = drop' \
    'file_list_1 = .exe$' \
    'file_default_policy = accept' \
    'file_default_filename = unknown.000' \
    'file_name_tpl = ./.tmp.$$$' \
    'system_mime_types = ./mime.types' \
    'header_rev = 0' \
    'feat_testing = 1' \
    'feat_boundaries = 1' \
    'feat_force_name = 1' \
    'feat_mime_files = 1' \
    'feat_log_trace = 1' \
    'feat_log_inline = 2' \
    'feat_log_stderr = 0' <<EOF 2>test.log >test.out
Date: Tue, 27 May 2003 12:19:14 GMT
From: aves-test-1054037954@bre.klaki.net
Message-Id: <200305271219.h4RCJE921460@is105.filter.complex.is>
To: bre@klaki.net
Subject: Pstsuprf (EXE skr), beta0.is105.filter.complex.is, 12:19 27-05-2003Content-Type: multipart/mixed; boundary="filter-test-boundary"
Content-Type: multipart/mixed; boundary="filter-test-boundary"
Content-Disposition: inline

--filter-test-boundary
Content-Type: multipart/alternative; boundary="filter-test-2bound"
Content-Disposition: inline

--filter-test-2bound
Content-Type: text/un.known+foo; charset=iso-8859-1
Content-Disposition: inline

etta er tilraunaskeyti til a lta reyna  uppsetningu pstsu fyrir
bre@klaki.net, sent gegnum vlina beta0.is105.filter.complex.is.

etta skeyti er me eitt vihengi sem ykist vera .EXE skr.

--
Bjarni R. Einarsson                      / FRISK Software International
--------------------------v--------------------------------------------
Email:     xxx@xxxxx.is   | Company home page:  http://www.frisk.is/
Phone/SMS: +354-XXXXXXX   | Personal home page: http://bre.klaki.net/

--filter-test-2bound
Content-Type: text/html; charset=iso-8859-1
Content-Disposition: inline

<html><body>
etta er tilraunaskeyti til a lta reyna  uppsetningu pstsu fyrir
bre@klaki.net, sent gegnum vlina beta0.is105.filter.complex.is. <p>

etta skeyti er me eitt vihengi sem ykist vera .EXE skr.
<p>

<pre>
--
Bjarni R. Einarsson                      / FRISK Software International
--------------------------v--------------------------------------------
Email:     xxx@xxxxx.is   | Company home page:  http://www.frisk.is/
Phone/SMS: +354-XXXXXXX   | Personal home page: http://bre.klaki.net/
</pre>
</body></html>

--filter-test-2bound--
--filter-test-boundary
Content-Type: text/plain; charset=us-ascii; name="foo.txt"
Content-Transfer-Encoding: 8bit
Content-Disposition: attachment; filename="foo.txt"; 
  filename="test.exe";
  filename="foo.txt"

I'm a harmless fake .exe file.

--filter-test-boundary
Content-Type: application/x-ms-dos-executable; charset=us-ascii
Content-Transfer-Encoding: 8bit
Content-Disposition: attachment; filename="foo.txt"; 

I'm another harmless fake .exe file.

--filter-test-boundary
Content-Type: text/plain; charset=us-ascii
Content-Transfer-Encoding: 8bit
Content-Description: evil.exe
Content-Disposition: attachment

I'm another harmless fake .exe file.

--filter-test-boundary
Content-Type: text/plain; charset=us-ascii
Content-Transfer-Encoding: 8bit
Content-ID: <evil.exe>>
Content-Disposition: attachment

I'm another harmless fake .exe file.

--filter-test-boundary
Content-Type: application/pdf; charset=us-ascii
Content-Transfer-Encoding: 8bit
Content-Disposition: attachment; filename="foo.txt"; 
Content-ID: <alphabet>

This is text file with a PDF MIME type.

--filter-test-boundary--
EOF

echo "*** Exit code was $? ***" >>test.out
exit 0
