" acr syntax plugin for vim
"
" @author: pancake <pancake@phreaker.net>

if exists("b:current_syntax")
	finish
endif

syn case ignore

syn keyword acrContact PKGNAME VERSION CONTACT
syn keyword acrDirective USE_BACKUP EXPORT_DEFINED NOP LOCAL: GLOBAL:
syn keyword acrDirective REQUIRE_ACR_VERSION
syn keyword acrLanguage LANG_C LANG_CC LANG_CXX LANG_BASH LANG_TCL LANG_PERL
syn keyword acrLanguage LANG_JAVA LANG_PYTHON LANG_RUBY
syn keyword acrKeyword CHKPRG CHECK_PROGRAM 
syn keyword acrKeyword CHKINC CHECK_INCLUDE
syn keyword acrKeyword CHKFNC CHECK_FUNCTION
syn keyword acrKeyword ENDIAN CHECK_ENDIAN SIZEOF
syn keyword acrKeyword CHECK
syn keyword acrKeyword CHECK_PERL_MODULE CHK_PM
syn keyword acrKeyword CHECK_PYTHON_MODULE CHK_PY
syn keyword acrKeyword CHECK_RUBY_MODULE CHK_RU
syn keyword acrKeyword CHECK_VERSION CHKVER
syn keyword acrKeyword CHECK_CLASSPATH CHK_CP
syn keyword acrKeyword PKGCFG PKG_CONFIG PKGCONFIG
syn keyword acrKeyword CHKLIB CHECK_LIB
syn keyword acrKeyword USE_DL USE_ICONV USE_PTHREAD
syn keyword acrKeyword USE_PERL_THREADS USE_X11 USE_TK USE_GMAKE USE_JNI
syn keyword acrKeyword PKGCONFIG PKGCFG EXEC
syn keyword acrKeyword SUBDIRS SUBST_FILES
syn keyword acrKeyword IF IFNOT IFAND IFNOTAND IFEQ IFNOTEQ IFEQVAL IFNOTEQVAL
syn keyword acrKeyword IFNULL IFNOTNULL DIE DIENOT
syn keyword acrKeyword ARG_WITH ARG_WITHOUT ARG_ENABLE ARG_DISABLE
syn keyword acrOutput EXPORT OUTPUT_H OUTPUT_SH SUBST 
syn keyword acrOutput SUBST_FILES SUBDIRS SUBCONF REPORT
syn match acrOperator "=" 
syn match acrOperator "+="
syn match acrOperator "?="
syn match acrOperator "<-"
syn keyword acrTodo TODO FIXME XXX NOTE
"syn region acrTag start="@" end="@" # TODO
syn region  acrComment start="((" end="))" contains=acrTodo
syn region  acrComment start="##" end="##" contains=acrTodo
syn region  acrComment start="//" end="\\" contains=acrTodo
syn region  acrOutput start="<<EOF" end="<<EOF" contains=acrTodo
"syn match   acrNumber "-\=\<\d*\.\=[0-9_]\>" # may help ?
syn match acrSeparator ";" 
syn match acrSeparator "{" 
syn match acrSeparator "}" 
syn match acrSeparator "}{" 
syn match acrSeparator "}ELSE{" 
syn match acrError "<="
syn match acrMark "\$[a-zA-Z]*"

syn sync ccomment acrComment

command -nargs=+ HiLink hi def link <args>

HiLink acrSpecial Number
HiLink acrContact Special
HiLink acrKeyword Type
HiLink acrLanguage acrKeyword
HiLink acrOperator Type
HiLink acrDirective String
HiLink acrTodo Todo
HiLink acrComment Comment
HiLink acrKeyword Repeat
HiLink acrOutput Number
HiLink acrSeparator Macro
HiLink acrError Error
HiLink acrMark Function

delcommand HiLink

let b:current_syntax = "acr"
