/*
 * Basic versioning gathered from the git repository.
 * Automatically generated by ../git_version.sh.
 */

#ifndef git_version_h
#define git_version_h 1

/* whether this is a dist tarball or not */
#undef GIT_IS_DIST

/* No errors occured while running git */
#undef GIT_ERRORS

/* git utilities not found */
#define GIT_NOT_FOUND "'git-symbolic-ref' not found"
#undef GIT_VERSION

/* No git repo found, probably building from dist tarball */
#undef GIT_REPO

/* Define GIT_MESSAGE such that
 *    printf("%s: built from %s", argv[0], GIT_MESSAGE);
 * forms a proper sentence.
 */

#ifdef GIT_DIRTY
# define GIT_DIRTY_MSG " + changes"
#else /* !GIT_DIRTY */
# define GIT_DIRTY_MSG ""
#endif /* GIT_DIRTY */

#ifdef GIT_ERRORS
# define GIT_ERROR_MSG " with error: " GIT_ERRORS
#else /* !GIT_ERRORS */
# define GIT_ERROR_MSG ""
#endif /* GIT_ERRORS */

#ifdef GIT_IS_DIST
# define GIT_DIST_MSG "dist of "
#else /* !GIT_IS_DIST */
# define GIT_DIST_MSG ""
#endif /* GIT_IS_DIST */

#ifdef GIT_REPO
# ifdef GIT_NOT_FOUND
#  define GIT_MESSAGE GIT_DIST_MSG "git sources without git: " GIT_NOT_FOUND
# else /* !GIT_NOT_FOUND */
#  define GIT_MESSAGE \
       GIT_DIST_MSG \
       "git branch " GIT_BRANCH ", " \
       "commit " GIT_SHAID GIT_DIRTY_MSG \
       GIT_ERROR_MSG
# endif /* GIT_NOT_FOUND */
#else /* !GIT_REPO */
# define GIT_MESSAGE GIT_DIST_MSG "non-git sources" GIT_ERROR_MSG
#endif /* GIT_REPO */

#endif /* git_version_h */
