/*
 * Copyright 2006-2007 Advanced Micro Devices, Inc.  
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */


/****************************************************************************/	
/*Portion I: Definitions  shared between VBIOS and Driver                   */
/****************************************************************************/


#ifndef _ATOMBIOS_H
#define _ATOMBIOS_H

#define ATOM_VERSION_MAJOR                   0x00020000
#define ATOM_VERSION_MINOR                   0x00000002

#define ATOM_HEADER_VERSION (ATOM_VERSION_MAJOR | ATOM_VERSION_MINOR)


#ifdef _H2INC
  #ifndef ULONG 
    typedef unsigned long ULONG;
  #endif

  #ifndef UCHAR
    typedef unsigned char UCHAR;
  #endif

  #ifndef USHORT 
    typedef unsigned short USHORT;
  #endif
#endif
      
#define ATOM_DAC_A            0 
#define ATOM_DAC_B            1
#define ATOM_EXT_DAC          2

#define ATOM_CRTC1            0
#define ATOM_CRTC2            1

#define ATOM_DIGA             0
#define ATOM_DIGB             1

#define ATOM_PPLL1            0
#define ATOM_PPLL2            1

#define ATOM_SCALER1          0
#define ATOM_SCALER2          1

#define ATOM_SCALER_DISABLE   0   
#define ATOM_SCALER_CENTER    1   
#define ATOM_SCALER_EXPANSION 2   
#define ATOM_SCALER_MULTI_EX  3   

#define ATOM_DISABLE          0
#define ATOM_ENABLE           1
#define ATOM_LCD_BLOFF                          (ATOM_DISABLE+2)
#define ATOM_LCD_BLON                           (ATOM_ENABLE+2)
#define ATOM_LCD_BL_BRIGHTNESS_CONTROL          (ATOM_ENABLE+3)
#define ATOM_LCD_SELFTEST_START									(ATOM_DISABLE+5)
#define ATOM_LCD_SELFTEST_STOP									(ATOM_ENABLE+5)
#define ATOM_ENCODER_INIT			                  (ATOM_DISABLE+7)

#define ATOM_BLANKING         1
#define ATOM_BLANKING_OFF     0

#define ATOM_CURSOR1          0
#define ATOM_CURSOR2          1

#define ATOM_ICON1            0
#define ATOM_ICON2            1

#define ATOM_CRT1             0
#define ATOM_CRT2             1

#define ATOM_TV_NTSC          1
#define ATOM_TV_NTSCJ         2
#define ATOM_TV_PAL           3
#define ATOM_TV_PALM          4
#define ATOM_TV_PALCN         5
#define ATOM_TV_PALN          6
#define ATOM_TV_PAL60         7
#define ATOM_TV_SECAM         8
#define ATOM_TV_CV            16

#define ATOM_DAC1_PS2         1
#define ATOM_DAC1_CV          2
#define ATOM_DAC1_NTSC        3
#define ATOM_DAC1_PAL         4

#define ATOM_DAC2_PS2         ATOM_DAC1_PS2
#define ATOM_DAC2_CV          ATOM_DAC1_CV
#define ATOM_DAC2_NTSC        ATOM_DAC1_NTSC
#define ATOM_DAC2_PAL         ATOM_DAC1_PAL
 
#define ATOM_PM_ON            0
#define ATOM_PM_STANDBY       1
#define ATOM_PM_SUSPEND       2
#define ATOM_PM_OFF           3

/* Bit0:{=0:single, =1:dual},
   Bit1 {=0:666RGB, =1:888RGB},
   Bit2:3:{Grey level}
   Bit4:{=0:LDI format for RGB888, =1 FPDI format for RGB888}*/

#define ATOM_PANEL_MISC_DUAL               0x00000001
#define ATOM_PANEL_MISC_888RGB             0x00000002
#define ATOM_PANEL_MISC_GREY_LEVEL         0x0000000C
#define ATOM_PANEL_MISC_FPDI               0x00000010
#define ATOM_PANEL_MISC_GREY_LEVEL_SHIFT   2
#define ATOM_PANEL_MISC_SPATIAL            0x00000020
#define ATOM_PANEL_MISC_TEMPORAL           0x00000040
#define ATOM_PANEL_MISC_API_ENABLED        0x00000080


#define MEMTYPE_DDR1              "DDR1"
#define MEMTYPE_DDR2              "DDR2"
#define MEMTYPE_DDR3              "DDR3"
#define MEMTYPE_DDR4              "DDR4"

#define ASIC_BUS_TYPE_PCI         "PCI"
#define ASIC_BUS_TYPE_AGP         "AGP"
#define ASIC_BUS_TYPE_PCIE        "PCI_EXPRESS"

/* Maximum size of that FireGL flag string */

#define ATOM_FIREGL_FLAG_STRING     "FGL"             
#define ATOM_MAX_SIZE_OF_FIREGL_FLAG_STRING  3        

#define ATOM_FAKE_DESKTOP_STRING    "DSK"             
#define ATOM_MAX_SIZE_OF_FAKE_DESKTOP_STRING  ATOM_MAX_SIZE_OF_FIREGL_FLAG_STRING 

#define ATOM_M54T_FLAG_STRING       "M54T"            
#define ATOM_MAX_SIZE_OF_M54T_FLAG_STRING    4        

#define HW_ASSISTED_I2C_STATUS_FAILURE          2
#define HW_ASSISTED_I2C_STATUS_SUCCESS          1

#pragma pack(1)                                       /* BIOS data must use byte aligment */

/*  Define offset to location of ROM header. */

#define OFFSET_TO_POINTER_TO_ATOM_ROM_HEADER		0x00000048L
#define OFFSET_TO_ATOM_ROM_IMAGE_SIZE				    0x00000002L

#define OFFSET_TO_ATOMBIOS_ASIC_BUS_MEM_TYPE    0x94
#define MAXSIZE_OF_ATOMBIOS_ASIC_BUS_MEM_TYPE   20    /* including the terminator 0x0! */
#define	OFFSET_TO_GET_ATOMBIOS_STRINGS_NUMBER		0x002f
#define	OFFSET_TO_GET_ATOMBIOS_STRINGS_START		0x006e

/* Common header for all ROM Data tables.
  Every table pointed  _ATOM_MASTER_DATA_TABLE has this common header. 
  And the pointer actually points to this header. */

typedef struct _ATOM_COMMON_TABLE_HEADER
{
  USHORT usStructureSize;
  UCHAR  ucTableFormatRevision;   /*Change it when the Parser is not backward compatible */
  UCHAR  ucTableContentRevision;  /*Change it only when the table needs to change but the firmware */
                                  /*Image can't be updated, while Driver needs to carry the new table! */
}ATOM_COMMON_TABLE_HEADER;

typedef struct _ATOM_ROM_HEADER
{
  ATOM_COMMON_TABLE_HEADER		sHeader;
  UCHAR	 uaFirmWareSignature[4];    /*Signature to distinguish between Atombios and non-atombios, 
                                      atombios should init it as "ATOM", don't change the position */
  USHORT usBiosRuntimeSegmentAddress;
  USHORT usProtectedModeInfoOffset;
  USHORT usConfigFilenameOffset;
  USHORT usCRC_BlockOffset;
  USHORT usBIOS_BootupMessageOffset;
  USHORT usInt10Offset;
  USHORT usPciBusDevInitCode;
  USHORT usIoBaseAddress;
  USHORT usSubsystemVendorID;
  USHORT usSubsystemID;
  USHORT usPCI_InfoOffset; 
  USHORT usMasterCommandTableOffset; /*Offset for SW to get all command table offsets, Don't change the position */
  USHORT usMasterDataTableOffset;   /*Offset for SW to get all data table offsets, Don't change the position */
  UCHAR  ucExtendedFunctionCode;
  UCHAR  ucReserved;
}ATOM_ROM_HEADER;

/*==============================Command Table Portion==================================== */

#ifdef	UEFI_BUILD
	#define	UTEMP	USHORT
	#define	USHORT	void*
#endif

typedef struct _ATOM_MASTER_LIST_OF_COMMAND_TABLES{
  USHORT ASIC_Init;                              
  USHORT GetDisplaySurfaceSize;                  
  USHORT ASIC_RegistersInit;                     
  USHORT VRAM_BlockVenderDetection;              
  USHORT DIGxEncoderControl;										 
  USHORT MemoryControllerInit;                   
  USHORT EnableCRTCMemReq;                       
  USHORT MemoryParamAdjust; 										 
  USHORT DVOEncoderControl;                      
  USHORT GPIOPinControl;												 
  USHORT SetEngineClock;                         
  USHORT SetMemoryClock;                         
  USHORT SetPixelClock;                          
  USHORT DynamicClockGating;                     
  USHORT ResetMemoryDLL;                         
  USHORT ResetMemoryDevice;                      
  USHORT MemoryPLLInit;
  USHORT AdjustDisplayPll;												
  USHORT AdjustMemoryController;                 
  USHORT EnableASIC_StaticPwrMgt;                
  USHORT ASIC_StaticPwrMgtStatusChange;          
  USHORT DAC_LoadDetection;                      
  USHORT LVTMAEncoderControl;                    
  USHORT LCD1OutputControl;                      
  USHORT DAC1EncoderControl;                     
  USHORT DAC2EncoderControl;                     
  USHORT DVOOutputControl;                       
  USHORT CV1OutputControl;                       
  USHORT GetConditionalGoldenSetting;            
  USHORT TVEncoderControl;                       
  USHORT TMDSAEncoderControl;                    
  USHORT LVDSEncoderControl;                     
  USHORT TV1OutputControl;                       
  USHORT EnableScaler;                           
  USHORT BlankCRTC;                              
  USHORT EnableCRTC;                             
  USHORT GetPixelClock;                          
  USHORT EnableVGA_Render;                       
  USHORT EnableVGA_Access;                       
  USHORT SetCRTC_Timing;                         
  USHORT SetCRTC_OverScan;                       
  USHORT SetCRTC_Replication;                    
  USHORT SelectCRTC_Source;                      
  USHORT EnableGraphSurfaces;                    
  USHORT UpdateCRTC_DoubleBufferRegisters;
  USHORT LUT_AutoFill;                           
  USHORT EnableHW_IconCursor;                    
  USHORT GetMemoryClock;                         
  USHORT GetEngineClock;                         
  USHORT SetCRTC_UsingDTDTiming;                 
  USHORT ExternalEncoderControl;                 
  USHORT LVTMAOutputControl;                     
  USHORT VRAM_BlockDetectionByStrap;
  USHORT MemoryCleanUp;                          
  USHORT ProcessI2cChannelTransaction;           
  USHORT WriteOneByteToHWAssistedI2C;            
  USHORT ReadHWAssistedI2CStatus;                
  USHORT SpeedFanControl;                        
  USHORT PowerConnectorDetection;                
  USHORT MC_Synchronization;                     
  USHORT ComputeMemoryEnginePLL;                 
  USHORT MemoryRefreshConversion;                
  USHORT VRAM_GetCurrentInfoBlock;
  USHORT DynamicMemorySettings;                  
  USHORT MemoryTraining;
  USHORT EnableSpreadSpectrumOnPPLL;             
  USHORT TMDSAOutputControl;                     
  USHORT SetVoltage;                             
  USHORT DAC1OutputControl;                      
  USHORT DAC2OutputControl;                      
  USHORT SetupHWAssistedI2CStatus;               
  USHORT ClockSource;                            
  USHORT MemoryDeviceInit;                       
  USHORT EnableYUV;                              
  USHORT DIG1EncoderControl;                     
  USHORT DIG2EncoderControl;                     
  USHORT DIG1TransmitterControl;                 
  USHORT DIG2TransmitterControl;	               
  USHORT ProcessAuxChannelTransaction;					 
  USHORT DPEncoderService;											 
}ATOM_MASTER_LIST_OF_COMMAND_TABLES;   

#define ReadEDIDFromHWAssistedI2C                ProcessI2cChannelTransaction

#define UNIPHYTransmitterControl						     DIG1TransmitterControl
#define LVTMATransmitterControl							     DIG2TransmitterControl
#define SetCRTC_DPM_State                                    GetConditionalGoldenSetting

typedef struct _ATOM_MASTER_COMMAND_TABLE
{
  ATOM_COMMON_TABLE_HEADER           sHeader;
  ATOM_MASTER_LIST_OF_COMMAND_TABLES ListOfCommandTables;
}ATOM_MASTER_COMMAND_TABLE;

typedef struct _ATOM_TABLE_ATTRIBUTE
{
  USHORT  WS_SizeInBytes:8;           
  USHORT  PS_SizeInBytes:7;           
  USHORT  UpdatedByUtility:1;         
}ATOM_TABLE_ATTRIBUTE;





typedef struct _ATOM_COMMON_ROM_COMMAND_TABLE_HEADER
{
  ATOM_COMMON_TABLE_HEADER CommonHeader;
  ATOM_TABLE_ATTRIBUTE     TableAttribute;	
}ATOM_COMMON_ROM_COMMAND_TABLE_HEADER;


typedef struct _ASIC_INIT_PARAMETERS
{
  ULONG ulDefaultEngineClock;         
  ULONG ulDefaultMemoryClock;         
}ASIC_INIT_PARAMETERS;

#define COMPUTE_MEMORY_PLL_PARAM        1
#define COMPUTE_ENGINE_PLL_PARAM        2

typedef struct _COMPUTE_MEMORY_ENGINE_PLL_PARAMETERS
{
  ULONG   ulClock;        
  UCHAR   ucAction;       
  UCHAR   ucReserved;     
  UCHAR   ucFbDiv;        
  UCHAR   ucPostDiv;      
}COMPUTE_MEMORY_ENGINE_PLL_PARAMETERS;

typedef struct _COMPUTE_MEMORY_ENGINE_PLL_PARAMETERS_V2
{
  ULONG   ulClock;        
  UCHAR   ucAction;       
  USHORT  usFbDiv;		    
  UCHAR   ucPostDiv;      
}COMPUTE_MEMORY_ENGINE_PLL_PARAMETERS_V2;
#define COMPUTE_MEMORY_ENGINE_PLL_PARAMETERS_PS_ALLOCATION   COMPUTE_MEMORY_ENGINE_PLL_PARAMETERS


#define SET_CLOCK_FREQ_MASK                     0x00FFFFFF  
#define USE_NON_BUS_CLOCK_MASK                  0x01000000  
#define USE_MEMORY_SELF_REFRESH_MASK            0x02000000	
#define SKIP_INTERNAL_MEMORY_PARAMETER_CHANGE   0x04000000  
#define FIRST_TIME_CHANGE_CLOCK									0x08000000	
#define SKIP_SW_PROGRAM_PLL											0x10000000	
#define USE_SS_ENABLED_PIXEL_CLOCK  USE_NON_BUS_CLOCK_MASK

#define b3USE_NON_BUS_CLOCK_MASK                  0x01       
#define b3USE_MEMORY_SELF_REFRESH                 0x02	     
#define b3SKIP_INTERNAL_MEMORY_PARAMETER_CHANGE   0x04       
#define b3FIRST_TIME_CHANGE_CLOCK									0x08       
#define b3SKIP_SW_PROGRAM_PLL											0x10			 

typedef struct _SET_ENGINE_CLOCK_PARAMETERS
{
  ULONG ulTargetEngineClock;          
}SET_ENGINE_CLOCK_PARAMETERS;

typedef struct _SET_ENGINE_CLOCK_PS_ALLOCATION
{
  ULONG ulTargetEngineClock;          
  COMPUTE_MEMORY_ENGINE_PLL_PARAMETERS_PS_ALLOCATION sReserved;
}SET_ENGINE_CLOCK_PS_ALLOCATION;


typedef struct _SET_MEMORY_CLOCK_PARAMETERS
{
  ULONG ulTargetMemoryClock;          
}SET_MEMORY_CLOCK_PARAMETERS;

typedef struct _SET_MEMORY_CLOCK_PS_ALLOCATION
{
  ULONG ulTargetMemoryClock;          
  COMPUTE_MEMORY_ENGINE_PLL_PARAMETERS_PS_ALLOCATION sReserved;
}SET_MEMORY_CLOCK_PS_ALLOCATION;

typedef struct _ASIC_INIT_PS_ALLOCATION
{
  ASIC_INIT_PARAMETERS sASICInitClocks;
  SET_ENGINE_CLOCK_PS_ALLOCATION sReserved; 
}ASIC_INIT_PS_ALLOCATION;


typedef struct _DYNAMIC_CLOCK_GATING_PARAMETERS 
{
  UCHAR ucEnable;                     
  UCHAR ucPadding[3];
}DYNAMIC_CLOCK_GATING_PARAMETERS;
#define  DYNAMIC_CLOCK_GATING_PS_ALLOCATION  DYNAMIC_CLOCK_GATING_PARAMETERS


typedef struct _ENABLE_ASIC_STATIC_PWR_MGT_PARAMETERS
{
  UCHAR ucEnable;                     
  UCHAR ucPadding[3];
}ENABLE_ASIC_STATIC_PWR_MGT_PARAMETERS;
#define ENABLE_ASIC_STATIC_PWR_MGT_PS_ALLOCATION  ENABLE_ASIC_STATIC_PWR_MGT_PARAMETERS


typedef struct _DAC_LOAD_DETECTION_PARAMETERS
{
  USHORT usDeviceID;                  
  UCHAR  ucDacType;                   
  UCHAR  ucMisc;											
}DAC_LOAD_DETECTION_PARAMETERS;


#define DAC_LOAD_MISC_YPrPb						0x01


typedef struct _DAC_LOAD_DETECTION_PS_ALLOCATION
{
  DAC_LOAD_DETECTION_PARAMETERS            sDacload;
  ULONG                                    Reserved[2];
}DAC_LOAD_DETECTION_PS_ALLOCATION;


typedef struct _DAC_ENCODER_CONTROL_PARAMETERS 
{
  USHORT usPixelClock;                
  UCHAR  ucDacStandard;               
  UCHAR  ucAction;                    
                                      
                                      
}DAC_ENCODER_CONTROL_PARAMETERS;

#define DAC_ENCODER_CONTROL_PS_ALLOCATION  DAC_ENCODER_CONTROL_PARAMETERS

typedef struct _TV_ENCODER_CONTROL_PARAMETERS
{
  USHORT usPixelClock;                
  UCHAR  ucTvStandard;                
  UCHAR  ucAction;                    
                                      
}TV_ENCODER_CONTROL_PARAMETERS;

typedef struct _DIG_ENCODER_CONTROL_PARAMETERS
{
  USHORT usPixelClock;		
  UCHAR  ucConfig;		  
                            
                            
                            
                            
                            
                            
                            
  UCHAR ucAction;           
                            
  UCHAR ucEncoderMode;
                            
                            
                            
                            
                            
  UCHAR ucLaneNum;          
  UCHAR ucReserved[2];
}DIG_ENCODER_CONTROL_PARAMETERS;
#define DIG_ENCODER_CONTROL_PS_ALLOCATION			  DIG_ENCODER_CONTROL_PARAMETERS
#define EXTERNAL_ENCODER_CONTROL_PARAMETER			DIG_ENCODER_CONTROL_PARAMETERS
#define EXTERNAL_ENCODER_CONTROL_PS_ALLOCATION	DIG_ENCODER_CONTROL_PS_ALLOCATION


#define ATOM_ENCODER_CONFIG_DPLINKRATE_MASK				0x01
#define ATOM_ENCODER_CONFIG_DPLINKRATE_1_62GHZ		0x00
#define ATOM_ENCODER_CONFIG_DPLINKRATE_2_70GHZ		0x01
#define ATOM_ENCODER_CONFIG_LINK_SEL_MASK				  0x04
#define ATOM_ENCODER_CONFIG_LINKA								  0x00
#define ATOM_ENCODER_CONFIG_LINKB								  0x04
#define ATOM_ENCODER_CONFIG_LINKA_B							  ATOM_TRANSMITTER_CONFIG_LINKA
#define ATOM_ENCODER_CONFIG_LINKB_A							  ATOM_ENCODER_CONFIG_LINKB
#define ATOM_ENCODER_CONFIG_TRANSMITTER_SEL_MASK	0x08
#define ATOM_ENCODER_CONFIG_UNIPHY							  0x00
#define ATOM_ENCODER_CONFIG_LVTMA								  0x08
#define ATOM_ENCODER_CONFIG_TRANSMITTER1				  0x00
#define ATOM_ENCODER_CONFIG_TRANSMITTER2				  0x08
#define ATOM_ENCODER_CONFIG_DIGB								  0x80			





#define ATOM_ENCODER_MODE_DP											0
#define ATOM_ENCODER_MODE_LVDS										1
#define ATOM_ENCODER_MODE_DVI											2
#define ATOM_ENCODER_MODE_HDMI										3
#define ATOM_ENCODER_MODE_SDVO										4
#define ATOM_ENCODER_MODE_TV											13
#define ATOM_ENCODER_MODE_CV											14
#define ATOM_ENCODER_MODE_CRT											15

typedef struct _ATOM_DP_VS_MODE
{
  UCHAR ucLaneSel;
  UCHAR ucLaneSet;
}ATOM_DP_VS_MODE;

typedef struct _DIG_TRANSMITTER_CONTROL_PARAMETERS
{
	union
	{
  USHORT usPixelClock;		
	USHORT usInitInfo;			
  ATOM_DP_VS_MODE asMode; 
	} unionname;
  UCHAR ucConfig;
													
													
                          
													
													
  												
													
		  										
                          
                          
                          
                          
                          
	UCHAR ucAction;				  
	                        
  UCHAR ucReserved[4];
}DIG_TRANSMITTER_CONTROL_PARAMETERS;

#define DIG_TRANSMITTER_CONTROL_PS_ALLOCATION		DIG_TRANSMITTER_CONTROL_PARAMETERS					


#define ATOM_TRAMITTER_INITINFO_CONNECTOR_MASK	0x00ff			


#define ATOM_TRANSMITTER_CONFIG_8LANE_LINK			0x01
#define ATOM_TRANSMITTER_CONFIG_COHERENT				0x02
#define ATOM_TRANSMITTER_CONFIG_LINK_SEL_MASK		0x04
#define ATOM_TRANSMITTER_CONFIG_LINKA						0x00
#define ATOM_TRANSMITTER_CONFIG_LINKB						0x04
#define ATOM_TRANSMITTER_CONFIG_LINKA_B					0x00			
#define ATOM_TRANSMITTER_CONFIG_LINKB_A					0x04

#define ATOM_TRANSMITTER_CONFIG_ENCODER_SEL_MASK	0x08			
#define ATOM_TRANSMITTER_CONFIG_DIG1_ENCODER		0x00				
#define ATOM_TRANSMITTER_CONFIG_DIG2_ENCODER		0x08				

#define ATOM_TRANSMITTER_CONFIG_CLKSRC_MASK			0x30
#define ATOM_TRANSMITTER_CONFIG_CLKSRC_PPLL			0x00
#define ATOM_TRANSMITTER_CONFIG_CLKSRC_PCIE			0x20
#define ATOM_TRANSMITTER_CONFIG_CLKSRC_XTALIN		0x30
#define ATOM_TRANSMITTER_CONFIG_LANE_SEL_MASK		0xc0
#define ATOM_TRANSMITTER_CONFIG_LANE_0_3				0x00
#define ATOM_TRANSMITTER_CONFIG_LANE_0_7				0x00
#define ATOM_TRANSMITTER_CONFIG_LANE_4_7				0x40
#define ATOM_TRANSMITTER_CONFIG_LANE_8_11				0x80
#define ATOM_TRANSMITTER_CONFIG_LANE_8_15				0x80
#define ATOM_TRANSMITTER_CONFIG_LANE_12_15			0xc0


#define ATOM_TRANSMITTER_ACTION_DISABLE					       0
#define ATOM_TRANSMITTER_ACTION_ENABLE					       1
#define ATOM_TRANSMITTER_ACTION_LCD_BLOFF				       2
#define ATOM_TRANSMITTER_ACTION_LCD_BLON				       3
#define ATOM_TRANSMITTER_ACTION_BL_BRIGHTNESS_CONTROL  4
#define ATOM_TRANSMITTER_ACTION_LCD_SELFTEST_START		 5
#define ATOM_TRANSMITTER_ACTION_LCD_SELFTEST_STOP			 6
#define ATOM_TRANSMITTER_ACTION_INIT						       7
#define ATOM_TRANSMITTER_ACTION_DISABLE_OUTPUT	       8
#define ATOM_TRANSMITTER_ACTION_ENABLE_OUTPUT		       9
#define ATOM_TRANSMITTER_ACTION_SETUP						       10
#define ATOM_TRANSMITTER_ACTION_SETUP_VSEMPH           11

/****************************Device Output Control Command Table Definitions**********************/
typedef struct _DISPLAY_DEVICE_OUTPUT_CONTROL_PARAMETERS
{
  UCHAR  ucAction;                    
                                      
                                      
                                      
                                      
  UCHAR  aucPadding[3];               
}DISPLAY_DEVICE_OUTPUT_CONTROL_PARAMETERS;

#define DISPLAY_DEVICE_OUTPUT_CONTROL_PS_ALLOCATION DISPLAY_DEVICE_OUTPUT_CONTROL_PARAMETERS


#define CRT1_OUTPUT_CONTROL_PARAMETERS     DISPLAY_DEVICE_OUTPUT_CONTROL_PARAMETERS 
#define CRT1_OUTPUT_CONTROL_PS_ALLOCATION  DISPLAY_DEVICE_OUTPUT_CONTROL_PS_ALLOCATION

#define CRT2_OUTPUT_CONTROL_PARAMETERS     DISPLAY_DEVICE_OUTPUT_CONTROL_PARAMETERS 
#define CRT2_OUTPUT_CONTROL_PS_ALLOCATION  DISPLAY_DEVICE_OUTPUT_CONTROL_PS_ALLOCATION

#define CV1_OUTPUT_CONTROL_PARAMETERS      DISPLAY_DEVICE_OUTPUT_CONTROL_PARAMETERS
#define CV1_OUTPUT_CONTROL_PS_ALLOCATION   DISPLAY_DEVICE_OUTPUT_CONTROL_PS_ALLOCATION

#define TV1_OUTPUT_CONTROL_PARAMETERS      DISPLAY_DEVICE_OUTPUT_CONTROL_PARAMETERS
#define TV1_OUTPUT_CONTROL_PS_ALLOCATION   DISPLAY_DEVICE_OUTPUT_CONTROL_PS_ALLOCATION

#define DFP1_OUTPUT_CONTROL_PARAMETERS     DISPLAY_DEVICE_OUTPUT_CONTROL_PARAMETERS
#define DFP1_OUTPUT_CONTROL_PS_ALLOCATION  DISPLAY_DEVICE_OUTPUT_CONTROL_PS_ALLOCATION

#define DFP2_OUTPUT_CONTROL_PARAMETERS     DISPLAY_DEVICE_OUTPUT_CONTROL_PARAMETERS
#define DFP2_OUTPUT_CONTROL_PS_ALLOCATION  DISPLAY_DEVICE_OUTPUT_CONTROL_PS_ALLOCATION

#define LCD1_OUTPUT_CONTROL_PARAMETERS     DISPLAY_DEVICE_OUTPUT_CONTROL_PARAMETERS
#define LCD1_OUTPUT_CONTROL_PS_ALLOCATION  DISPLAY_DEVICE_OUTPUT_CONTROL_PS_ALLOCATION

#define DVO_OUTPUT_CONTROL_PARAMETERS      DISPLAY_DEVICE_OUTPUT_CONTROL_PARAMETERS
#define DVO_OUTPUT_CONTROL_PS_ALLOCATION   DIG_TRANSMITTER_CONTROL_PS_ALLOCATION
#define DVO_OUTPUT_CONTROL_PARAMETERS_V3	 DIG_TRANSMITTER_CONTROL_PARAMETERS

/**************************************************************************/
typedef struct _BLANK_CRTC_PARAMETERS
{
  UCHAR  ucCRTC;                    	
  UCHAR  ucBlanking;                  
  USHORT usBlackColorRCr;
  USHORT usBlackColorGY;
  USHORT usBlackColorBCb;
}BLANK_CRTC_PARAMETERS;
#define BLANK_CRTC_PS_ALLOCATION    BLANK_CRTC_PARAMETERS


typedef struct _ENABLE_CRTC_PARAMETERS
{
  UCHAR ucCRTC;                    	  
  UCHAR ucEnable;                     
  UCHAR ucPadding[2];
}ENABLE_CRTC_PARAMETERS;
#define ENABLE_CRTC_PS_ALLOCATION   ENABLE_CRTC_PARAMETERS


typedef struct _SET_CRTC_OVERSCAN_PARAMETERS
{
  USHORT usOverscanRight;             
  USHORT usOverscanLeft;              
  USHORT usOverscanBottom;            
  USHORT usOverscanTop;               
  UCHAR  ucCRTC;                      
  UCHAR  ucPadding[3];
}SET_CRTC_OVERSCAN_PARAMETERS;
#define SET_CRTC_OVERSCAN_PS_ALLOCATION  SET_CRTC_OVERSCAN_PARAMETERS


typedef struct _SET_CRTC_REPLICATION_PARAMETERS
{
  UCHAR ucH_Replication;              
  UCHAR ucV_Replication;              
  UCHAR usCRTC;                       
  UCHAR ucPadding;
}SET_CRTC_REPLICATION_PARAMETERS;
#define SET_CRTC_REPLICATION_PS_ALLOCATION  SET_CRTC_REPLICATION_PARAMETERS


typedef struct _SELECT_CRTC_SOURCE_PARAMETERS
{
  UCHAR ucCRTC;                    	  
  UCHAR ucDevice;                     
  UCHAR ucPadding[2];
}SELECT_CRTC_SOURCE_PARAMETERS;
#define SELECT_CRTC_SOURCE_PS_ALLOCATION  SELECT_CRTC_SOURCE_PARAMETERS

typedef struct _SELECT_CRTC_SOURCE_PARAMETERS_V2
{
  UCHAR ucCRTC;                    	  
  UCHAR ucEncoderID;                  
  UCHAR ucEncodeMode;									
  UCHAR ucPadding;
}SELECT_CRTC_SOURCE_PARAMETERS_V2;






















typedef struct _PIXEL_CLOCK_PARAMETERS
{
  USHORT usPixelClock;                
                                      
  USHORT usRefDiv;                    
  USHORT usFbDiv;                     
  UCHAR  ucPostDiv;                   
  UCHAR  ucFracFbDiv;                 
  UCHAR  ucPpll;                      
  UCHAR  ucRefDivSrc;                 
  UCHAR  ucCRTC;                      
  UCHAR  ucPadding;
}PIXEL_CLOCK_PARAMETERS;




#define MISC_FORCE_REPROG_PIXEL_CLOCK 0x1
#define MISC_DEVICE_INDEX_MASK        0xF0
#define MISC_DEVICE_INDEX_SHIFT       4

typedef struct _PIXEL_CLOCK_PARAMETERS_V2
{
  USHORT usPixelClock;                
                                      
  USHORT usRefDiv;                    
  USHORT usFbDiv;                     
  UCHAR  ucPostDiv;                   
  UCHAR  ucFracFbDiv;                 
  UCHAR  ucPpll;                      
  UCHAR  ucRefDivSrc;                 
  UCHAR  ucCRTC;                      
  UCHAR  ucMiscInfo;                  
}PIXEL_CLOCK_PARAMETERS_V2;






















#define PIXEL_CLOCK_MISC_FORCE_PROG_PPLL						0x01
#define PIXEL_CLOCK_MISC_VGA_MODE										0x02
#define PIXEL_CLOCK_MISC_CRTC_SEL_MASK							0x04
#define PIXEL_CLOCK_MISC_CRTC_SEL_CRTC1							0x00
#define PIXEL_CLOCK_MISC_CRTC_SEL_CRTC2							0x04
#define PIXEL_CLOCK_MISC_USE_ENGINE_FOR_DISPCLK			0x08

typedef struct _PIXEL_CLOCK_PARAMETERS_V3
{
  USHORT usPixelClock;                
                                      
  USHORT usRefDiv;                    
  USHORT usFbDiv;                     
  UCHAR  ucPostDiv;                   
  UCHAR  ucFracFbDiv;                 
  UCHAR  ucPpll;                      
  UCHAR  ucTransmitterId;             
	union
	{
  UCHAR  ucEncoderMode;               
	UCHAR  ucDVOConfig;									
	} unnionname;
  UCHAR  ucMiscInfo;                  
                                      
}PIXEL_CLOCK_PARAMETERS_V3;

#define PIXEL_CLOCK_PARAMETERS_LAST			PIXEL_CLOCK_PARAMETERS_V2
#define GET_PIXEL_CLOCK_PS_ALLOCATION		PIXEL_CLOCK_PARAMETERS_LAST

typedef struct _ADJUST_DISPLAY_PLL_PARAMETERS
{
	USHORT usPixelClock;
	UCHAR ucTransmitterID;
	UCHAR ucEncodeMode;
	union
	{
		UCHAR ucDVOConfig;									
		UCHAR ucConfig;											
	} unnionname;
	UCHAR ucReserved[3];
}ADJUST_DISPLAY_PLL_PARAMETERS;

#define ADJUST_DISPLAY_CONFIG_SS_ENABLE       0x10

#define ADJUST_DISPLAY_PLL_PS_ALLOCATION			ADJUST_DISPLAY_PLL_PARAMETERS

typedef struct _ENABLE_YUV_PARAMETERS
{
  UCHAR ucEnable;                     
  UCHAR ucCRTC;                       
  UCHAR ucPadding[2];
}ENABLE_YUV_PARAMETERS;
#define ENABLE_YUV_PS_ALLOCATION ENABLE_YUV_PARAMETERS

typedef struct _GET_MEMORY_CLOCK_PARAMETERS
{
  ULONG ulReturnMemoryClock;          
} GET_MEMORY_CLOCK_PARAMETERS;
#define GET_MEMORY_CLOCK_PS_ALLOCATION  GET_MEMORY_CLOCK_PARAMETERS


typedef struct _GET_ENGINE_CLOCK_PARAMETERS
{
  ULONG ulReturnEngineClock;          
} GET_ENGINE_CLOCK_PARAMETERS;
#define GET_ENGINE_CLOCK_PS_ALLOCATION  GET_ENGINE_CLOCK_PARAMETERS




typedef struct _READ_EDID_FROM_HW_I2C_DATA_PARAMETERS
{
  USHORT    usPrescale;         
  USHORT    usVRAMAddress;      
  USHORT    usStatus;           
                                
  UCHAR     ucSlaveAddr;        
  UCHAR     ucLineNumber;       
}READ_EDID_FROM_HW_I2C_DATA_PARAMETERS;
#define READ_EDID_FROM_HW_I2C_DATA_PS_ALLOCATION  READ_EDID_FROM_HW_I2C_DATA_PARAMETERS


#define  ATOM_WRITE_I2C_FORMAT_PSOFFSET_PSDATABYTE                  0
#define  ATOM_WRITE_I2C_FORMAT_PSOFFSET_PSTWODATABYTES              1
#define  ATOM_WRITE_I2C_FORMAT_PSCOUNTER_PSOFFSET_IDDATABLOCK       2
#define  ATOM_WRITE_I2C_FORMAT_PSCOUNTER_IDOFFSET_PLUS_IDDATABLOCK  3
#define  ATOM_WRITE_I2C_FORMAT_IDCOUNTER_IDOFFSET_IDDATABLOCK       4

typedef struct _WRITE_ONE_BYTE_HW_I2C_DATA_PARAMETERS
{
  USHORT    usPrescale;         
  USHORT    usByteOffset;       
                                
                                
                                
                                
                                
                                
  UCHAR     ucData;             
  UCHAR     ucStatus;           
  UCHAR     ucSlaveAddr;        
  UCHAR     ucLineNumber;       
}WRITE_ONE_BYTE_HW_I2C_DATA_PARAMETERS;

#define WRITE_ONE_BYTE_HW_I2C_DATA_PS_ALLOCATION  WRITE_ONE_BYTE_HW_I2C_DATA_PARAMETERS

typedef struct _SET_UP_HW_I2C_DATA_PARAMETERS
{
  USHORT    usPrescale;         
  UCHAR     ucSlaveAddr;        
  UCHAR     ucLineNumber;       
}SET_UP_HW_I2C_DATA_PARAMETERS;


/**************************************************************************/
#define SPEED_FAN_CONTROL_PS_ALLOCATION   WRITE_ONE_BYTE_HW_I2C_DATA_PARAMETERS

typedef struct	_POWER_CONNECTOR_DETECTION_PARAMETERS
{
  UCHAR   ucPowerConnectorStatus;      
	UCHAR   ucPwrBehaviorId;							
	USHORT	usPwrBudget;								 
}POWER_CONNECTOR_DETECTION_PARAMETERS;

typedef struct POWER_CONNECTOR_DETECTION_PS_ALLOCATION
{                               
  UCHAR   ucPowerConnectorStatus;      
	UCHAR   ucReserved;
	USHORT	usPwrBudget;								 
  WRITE_ONE_BYTE_HW_I2C_DATA_PS_ALLOCATION    sReserved;
}POWER_CONNECTOR_DETECTION_PS_ALLOCATION;

/****************************LVDS SS Command Table Definitions**********************/
typedef struct	_ENABLE_LVDS_SS_PARAMETERS
{
  USHORT  usSpreadSpectrumPercentage;       
  UCHAR   ucSpreadSpectrumType;           
  UCHAR   ucSpreadSpectrumStepSize_Delay; 
  UCHAR   ucEnable;                       
  UCHAR   ucPadding[3];
}ENABLE_LVDS_SS_PARAMETERS;


typedef struct	_ENABLE_LVDS_SS_PARAMETERS_V2
{
  USHORT  usSpreadSpectrumPercentage;       
  UCHAR   ucSpreadSpectrumType;           
  UCHAR   ucSpreadSpectrumStep;           
  UCHAR   ucEnable;                       
  UCHAR   ucSpreadSpectrumDelay;
  UCHAR   ucSpreadSpectrumRange;
  UCHAR   ucPadding;
}ENABLE_LVDS_SS_PARAMETERS_V2;


typedef struct	_ENABLE_SPREAD_SPECTRUM_ON_PPLL
{
  USHORT  usSpreadSpectrumPercentage;
  UCHAR   ucSpreadSpectrumType;           
  UCHAR   ucSpreadSpectrumStep;           
  UCHAR   ucEnable;                       
  UCHAR   ucSpreadSpectrumDelay;
  UCHAR   ucSpreadSpectrumRange;
  UCHAR   ucPpll;												  
}ENABLE_SPREAD_SPECTRUM_ON_PPLL;

#define ENABLE_SPREAD_SPECTRUM_ON_PPLL_PS_ALLOCATION  ENABLE_SPREAD_SPECTRUM_ON_PPLL

/**************************************************************************/

typedef struct _SET_PIXEL_CLOCK_PS_ALLOCATION
{
  PIXEL_CLOCK_PARAMETERS sPCLKInput;
  ENABLE_SPREAD_SPECTRUM_ON_PPLL sReserved;
}SET_PIXEL_CLOCK_PS_ALLOCATION;

#define ENABLE_VGA_RENDER_PS_ALLOCATION   SET_PIXEL_CLOCK_PS_ALLOCATION

typedef struct	_MEMORY_TRAINING_PARAMETERS
{
  ULONG ulTargetMemoryClock;          
}MEMORY_TRAINING_PARAMETERS;
#define MEMORY_TRAINING_PS_ALLOCATION MEMORY_TRAINING_PARAMETERS



/****************************LVDS and other encoder command table definitions **********************/
typedef struct _LVDS_ENCODER_CONTROL_PARAMETERS
{
  USHORT usPixelClock;  
  UCHAR  ucMisc;        
                        
                        
                        
  UCHAR  ucAction;      
                        
}LVDS_ENCODER_CONTROL_PARAMETERS;

#define LVDS_ENCODER_CONTROL_PS_ALLOCATION  LVDS_ENCODER_CONTROL_PARAMETERS
   
#define TMDS1_ENCODER_CONTROL_PARAMETERS    LVDS_ENCODER_CONTROL_PARAMETERS
#define TMDS1_ENCODER_CONTROL_PS_ALLOCATION TMDS1_ENCODER_CONTROL_PARAMETERS

#define TMDS2_ENCODER_CONTROL_PARAMETERS    TMDS1_ENCODER_CONTROL_PARAMETERS
#define TMDS2_ENCODER_CONTROL_PS_ALLOCATION TMDS2_ENCODER_CONTROL_PARAMETERS

typedef struct _ENABLE_EXTERNAL_TMDS_ENCODER_PARAMETERS
{                               
  UCHAR    ucEnable;            
  UCHAR    ucMisc;              
  UCHAR    ucPadding[2];
}ENABLE_EXTERNAL_TMDS_ENCODER_PARAMETERS;

typedef struct _ENABLE_EXTERNAL_TMDS_ENCODER_PS_ALLOCATION
{                               
  ENABLE_EXTERNAL_TMDS_ENCODER_PARAMETERS    sXTmdsEncoder;
  WRITE_ONE_BYTE_HW_I2C_DATA_PS_ALLOCATION   sReserved;     
}ENABLE_EXTERNAL_TMDS_ENCODER_PS_ALLOCATION;



typedef struct _LVDS_ENCODER_CONTROL_PARAMETERS_V2
{
  USHORT usPixelClock;  
  UCHAR  ucMisc;        
  UCHAR  ucAction;      
                        
  UCHAR  ucTruncate;    
                        
                        
                        
  UCHAR  ucSpatial;     
                        
                        
                        
  UCHAR  ucTemporal;    
                        
                        
                        
                        
                        
  UCHAR  ucFRC;         
                        
                        
                        
                        
                        
                        
                        
}LVDS_ENCODER_CONTROL_PARAMETERS_V2;

#define LVDS_ENCODER_CONTROL_PS_ALLOCATION_V2  LVDS_ENCODER_CONTROL_PARAMETERS_V2
   
#define TMDS1_ENCODER_CONTROL_PARAMETERS_V2    LVDS_ENCODER_CONTROL_PARAMETERS_V2
#define TMDS1_ENCODER_CONTROL_PS_ALLOCATION_V2 TMDS1_ENCODER_CONTROL_PARAMETERS_V2
  
#define TMDS2_ENCODER_CONTROL_PARAMETERS_V2    TMDS1_ENCODER_CONTROL_PARAMETERS_V2
#define TMDS2_ENCODER_CONTROL_PS_ALLOCATION_V2 TMDS2_ENCODER_CONTROL_PARAMETERS_V2
#define ENABLE_EXTERNAL_TMDS_ENCODER_PARAMETERS_V2  LVDS_ENCODER_CONTROL_PARAMETERS_V2

typedef struct _ENABLE_EXTERNAL_TMDS_ENCODER_PS_ALLOCATION_V2
{                               
  ENABLE_EXTERNAL_TMDS_ENCODER_PARAMETERS_V2    sXTmdsEncoder;
  WRITE_ONE_BYTE_HW_I2C_DATA_PS_ALLOCATION      sReserved;     
}ENABLE_EXTERNAL_TMDS_ENCODER_PS_ALLOCATION_V2;





#define DVO_ENCODER_CONFIG_RATE_SEL							0x01
#define DVO_ENCODER_CONFIG_DDR_SPEED						0x00
#define DVO_ENCODER_CONFIG_SDR_SPEED						0x01
#define DVO_ENCODER_CONFIG_OUTPUT_SEL						0x0c
#define DVO_ENCODER_CONFIG_LOW12BIT							0x00
#define DVO_ENCODER_CONFIG_UPPER12BIT						0x04
#define DVO_ENCODER_CONFIG_24BIT								0x08

typedef struct _DVO_ENCODER_CONTROL_PARAMETERS_V3
{
  USHORT usPixelClock; 
  UCHAR  ucDVOConfig;
  UCHAR  ucAction;														
  UCHAR  ucReseved[4];
}DVO_ENCODER_CONTROL_PARAMETERS_V3;
#define DVO_ENCODER_CONTROL_PS_ALLOCATION_V3	DVO_ENCODER_CONTROL_PARAMETERS_V3






#define LVDS_ENCODER_CONTROL_PARAMETERS_V3     LVDS_ENCODER_CONTROL_PARAMETERS_V2
#define LVDS_ENCODER_CONTROL_PS_ALLOCATION_V3  LVDS_ENCODER_CONTROL_PARAMETERS_V3

#define TMDS1_ENCODER_CONTROL_PARAMETERS_V3    LVDS_ENCODER_CONTROL_PARAMETERS_V3
#define TMDS1_ENCODER_CONTROL_PS_ALLOCATION_V3 TMDS1_ENCODER_CONTROL_PARAMETERS_V3

#define TMDS2_ENCODER_CONTROL_PARAMETERS_V3    LVDS_ENCODER_CONTROL_PARAMETERS_V3
#define TMDS2_ENCODER_CONTROL_PS_ALLOCATION_V3 TMDS2_ENCODER_CONTROL_PARAMETERS_V3



#define LVDS_ENCODER_CONTROL_PARAMETERS_LAST     LVDS_ENCODER_CONTROL_PARAMETERS_V3
#define LVDS_ENCODER_CONTROL_PS_ALLOCATION_LAST  LVDS_ENCODER_CONTROL_PARAMETERS_LAST

#define TMDS1_ENCODER_CONTROL_PARAMETERS_LAST    LVDS_ENCODER_CONTROL_PARAMETERS_V3
#define TMDS1_ENCODER_CONTROL_PS_ALLOCATION_LAST TMDS1_ENCODER_CONTROL_PARAMETERS_LAST

#define TMDS2_ENCODER_CONTROL_PARAMETERS_LAST    LVDS_ENCODER_CONTROL_PARAMETERS_V3
#define TMDS2_ENCODER_CONTROL_PS_ALLOCATION_LAST TMDS2_ENCODER_CONTROL_PARAMETERS_LAST

#define DVO_ENCODER_CONTROL_PARAMETERS_LAST      DVO_ENCODER_CONTROL_PARAMETERS
#define DVO_ENCODER_CONTROL_PS_ALLOCATION_LAST   DVO_ENCODER_CONTROL_PS_ALLOCATION


#define PANEL_ENCODER_MISC_DUAL                0x01
#define PANEL_ENCODER_MISC_COHERENT            0x02
#define	PANEL_ENCODER_MISC_TMDS_LINKB					 0x04
#define	PANEL_ENCODER_MISC_HDMI_TYPE					 0x08

#define PANEL_ENCODER_ACTION_DISABLE           ATOM_DISABLE
#define PANEL_ENCODER_ACTION_ENABLE            ATOM_ENABLE
#define PANEL_ENCODER_ACTION_COHERENTSEQ       (ATOM_ENABLE+1)

#define PANEL_ENCODER_TRUNCATE_EN              0x01
#define PANEL_ENCODER_TRUNCATE_DEPTH           0x10
#define PANEL_ENCODER_SPATIAL_DITHER_EN        0x01
#define PANEL_ENCODER_SPATIAL_DITHER_DEPTH     0x10
#define PANEL_ENCODER_TEMPORAL_DITHER_EN       0x01
#define PANEL_ENCODER_TEMPORAL_DITHER_DEPTH    0x10
#define PANEL_ENCODER_TEMPORAL_LEVEL_4         0x20
#define PANEL_ENCODER_25FRC_MASK               0x10
#define PANEL_ENCODER_25FRC_E                  0x00
#define PANEL_ENCODER_25FRC_F                  0x10
#define PANEL_ENCODER_50FRC_MASK               0x60
#define PANEL_ENCODER_50FRC_A                  0x00
#define PANEL_ENCODER_50FRC_B                  0x20
#define PANEL_ENCODER_50FRC_C                  0x40
#define PANEL_ENCODER_50FRC_D                  0x60
#define PANEL_ENCODER_75FRC_MASK               0x80
#define PANEL_ENCODER_75FRC_E                  0x00
#define PANEL_ENCODER_75FRC_F                  0x80

/**************************************************************************/

#define SET_VOLTAGE_TYPE_ASIC_VDDC             1
#define SET_VOLTAGE_TYPE_ASIC_MVDDC            2
#define SET_VOLTAGE_TYPE_ASIC_MVDDQ            3
#define SET_VOLTAGE_TYPE_ASIC_VDDCI            4

#define SET_ASIC_VOLTAGE_MODE_ALL_SOURCE       0x1
#define SET_ASIC_VOLTAGE_MODE_SOURCE_A         0x2
#define SET_ASIC_VOLTAGE_MODE_SOURCE_B         0x4

#define	SET_ASIC_VOLTAGE_MODE_SET_VOLTAGE			 0x0
#define	SET_ASIC_VOLTAGE_MODE_GET_GPIOVAL			 0x1	
#define	SET_ASIC_VOLTAGE_MODE_GET_GPIOMASK		 0x2

typedef struct	_SET_VOLTAGE_PARAMETERS
{
  UCHAR    ucVoltageType;               
  UCHAR    ucVoltageMode;               
  UCHAR    ucVoltageIndex;              
  UCHAR    ucReserved;          
}SET_VOLTAGE_PARAMETERS;


typedef struct	_SET_VOLTAGE_PARAMETERS_V2
{
  UCHAR    ucVoltageType;               
  UCHAR    ucVoltageMode;               
  USHORT   usVoltageLevel;              
}SET_VOLTAGE_PARAMETERS_V2;


typedef struct _SET_VOLTAGE_PS_ALLOCATION
{
  SET_VOLTAGE_PARAMETERS sASICSetVoltage;
  WRITE_ONE_BYTE_HW_I2C_DATA_PS_ALLOCATION sReserved;
}SET_VOLTAGE_PS_ALLOCATION;

typedef struct _TV_ENCODER_CONTROL_PS_ALLOCATION
{
  TV_ENCODER_CONTROL_PARAMETERS sTVEncoder;          
  WRITE_ONE_BYTE_HW_I2C_DATA_PS_ALLOCATION    sReserved; 
}TV_ENCODER_CONTROL_PS_ALLOCATION;



#ifdef	UEFI_BUILD
	#define	UTEMP	USHORT
	#define	USHORT	void*
#endif

typedef struct _ATOM_MASTER_LIST_OF_DATA_TABLES
{
  USHORT        UtilityPipeLine;	        
  USHORT        MultimediaCapabilityInfo; 
  USHORT        MultimediaConfigInfo;     
  USHORT        StandardVESA_Timing;      
  USHORT        FirmwareInfo;             
  USHORT        DAC_Info;                 
  USHORT        LVDS_Info;                
  USHORT        TMDS_Info;                
  USHORT        AnalogTV_Info;            
  USHORT        SupportedDevicesInfo;     
  USHORT        GPIO_I2C_Info;            
  USHORT        VRAM_UsageByFirmware;     
  USHORT        GPIO_Pin_LUT;             
  USHORT        VESA_ToInternalModeLUT;   
  USHORT        ComponentVideoInfo;       
  USHORT        PowerPlayInfo;            
  USHORT        CompassionateData;        
  USHORT        SaveRestoreInfo;          
  USHORT        PPLL_SS_Info;             
  USHORT        OemInfo;                  
  USHORT        XTMDS_Info;               
  USHORT        MclkSS_Info;              
  USHORT        Object_Header;            
  USHORT        IndirectIOAccess;         
  USHORT        MC_InitParameter;         
  USHORT        ASIC_VDDC_Info;						
  USHORT        ASIC_InternalSS_Info;			
  USHORT        TV_VideoMode;							
  USHORT        VRAM_Info;								
  USHORT        MemoryTrainingInfo;				
  USHORT        IntegratedSystemInfo;			
  USHORT        ASIC_ProfilingInfo;				
  USHORT        VoltageObjectInfo;				
	USHORT				PowerSourceInfo;					
}ATOM_MASTER_LIST_OF_DATA_TABLES;

#ifdef	UEFI_BUILD
	#define	USHORT	UTEMP
#endif


typedef struct _ATOM_MASTER_DATA_TABLE
{ 
  ATOM_COMMON_TABLE_HEADER sHeader;  
  ATOM_MASTER_LIST_OF_DATA_TABLES   ListOfDataTables;
}ATOM_MASTER_DATA_TABLE;


typedef struct _ATOM_MULTIMEDIA_CAPABILITY_INFO
{
  ATOM_COMMON_TABLE_HEADER sHeader;  
  ULONG                    ulSignature;      
  UCHAR                    ucI2C_Type;       
  UCHAR                    ucTV_OutInfo;     
  UCHAR                    ucVideoPortInfo;  
  UCHAR                    ucHostPortInfo;   
}ATOM_MULTIMEDIA_CAPABILITY_INFO;


typedef struct _ATOM_MULTIMEDIA_CONFIG_INFO
{
  ATOM_COMMON_TABLE_HEADER sHeader;
  ULONG                    ulSignature;      
  UCHAR                    ucTunerInfo;      
  UCHAR                    ucAudioChipInfo;  
  UCHAR                    ucProductID;      
  UCHAR                    ucMiscInfo1;      
  UCHAR                    ucMiscInfo2;      
  UCHAR                    ucMiscInfo3;      
  UCHAR                    ucMiscInfo4;      
  UCHAR                    ucVideoInput0Info;
  UCHAR                    ucVideoInput1Info;
  UCHAR                    ucVideoInput2Info;
  UCHAR                    ucVideoInput3Info;
  UCHAR                    ucVideoInput4Info;
}ATOM_MULTIMEDIA_CONFIG_INFO;

/****************************Firmware Info Table Definitions**********************/






#define ATOM_BIOS_INFO_ATOM_FIRMWARE_POSTED         0x0001
#define ATOM_BIOS_INFO_DUAL_CRTC_SUPPORT            0x0002
#define ATOM_BIOS_INFO_EXTENDED_DESKTOP_SUPPORT     0x0004
#define ATOM_BIOS_INFO_MEMORY_CLOCK_SS_SUPPORT      0x0008
#define ATOM_BIOS_INFO_ENGINE_CLOCK_SS_SUPPORT      0x0010
#define ATOM_BIOS_INFO_BL_CONTROLLED_BY_GPU         0x0020
#define ATOM_BIOS_INFO_WMI_SUPPORT                  0x0040
#define ATOM_BIOS_INFO_PPMODE_ASSIGNGED_BY_SYSTEM   0x0080
#define ATOM_BIOS_INFO_HYPERMEMORY_SUPPORT          0x0100
#define ATOM_BIOS_INFO_HYPERMEMORY_SIZE_MASK        0x1E00
#define ATOM_BIOS_INFO_VPOST_WITHOUT_FIRST_MODE_SET 0x2000
#define ATOM_BIOS_INFO_BIOS_SCRATCH6_SCL2_REDEFINE  0x4000


#ifndef _H2INC


typedef struct _ATOM_FIRMWARE_CAPABILITY
{
  USHORT FirmwarePosted:1;
  USHORT DualCRTC_Support:1;
  USHORT ExtendedDesktopSupport:1;
  USHORT MemoryClockSS_Support:1;
  USHORT EngineClockSS_Support:1;
  USHORT GPUControlsBL:1;
  USHORT WMI_SUPPORT:1;
  USHORT PPMode_Assigned:1;
  USHORT HyperMemory_Support:1;
  USHORT HyperMemory_Size:4;
  USHORT Reserved:3;
}ATOM_FIRMWARE_CAPABILITY;

typedef union _ATOM_FIRMWARE_CAPABILITY_ACCESS
{
  ATOM_FIRMWARE_CAPABILITY sbfAccess;
  USHORT                   susAccess;
}ATOM_FIRMWARE_CAPABILITY_ACCESS;

#else

typedef union _ATOM_FIRMWARE_CAPABILITY_ACCESS
{
  USHORT                   susAccess;
}ATOM_FIRMWARE_CAPABILITY_ACCESS;

#endif

typedef struct _ATOM_FIRMWARE_INFO
{
  ATOM_COMMON_TABLE_HEADER        sHeader; 
  ULONG                           ulFirmwareRevision;
  ULONG                           ulDefaultEngineClock;       
  ULONG                           ulDefaultMemoryClock;       
  ULONG                           ulDriverTargetEngineClock;  
  ULONG                           ulDriverTargetMemoryClock;  
  ULONG                           ulMaxEngineClockPLL_Output; 
  ULONG                           ulMaxMemoryClockPLL_Output; 
  ULONG                           ulMaxPixelClockPLL_Output;  
  ULONG                           ulASICMaxEngineClock;       
  ULONG                           ulASICMaxMemoryClock;       
  UCHAR                           ucASICMaxTemperature;
  UCHAR                           ucPadding[3];               
  ULONG                           aulReservedForBIOS[3];      
  USHORT                          usMinEngineClockPLL_Input;  
  USHORT                          usMaxEngineClockPLL_Input;  
  USHORT                          usMinEngineClockPLL_Output; 
  USHORT                          usMinMemoryClockPLL_Input;  
  USHORT                          usMaxMemoryClockPLL_Input;  
  USHORT                          usMinMemoryClockPLL_Output; 
  USHORT                          usMaxPixelClock;            
  USHORT                          usMinPixelClockPLL_Input;   
  USHORT                          usMaxPixelClockPLL_Input;   
  USHORT                          usMinPixelClockPLL_Output;  
  ATOM_FIRMWARE_CAPABILITY_ACCESS usFirmwareCapability;
  USHORT                          usReferenceClock;           
  USHORT                          usPM_RTS_Location;          
  UCHAR                           ucPM_RTS_StreamSize;        
  UCHAR                           ucDesign_ID;                
  UCHAR                           ucMemoryModule_ID;          
}ATOM_FIRMWARE_INFO;

typedef struct _ATOM_FIRMWARE_INFO_V1_2
{
  ATOM_COMMON_TABLE_HEADER        sHeader; 
  ULONG                           ulFirmwareRevision;
  ULONG                           ulDefaultEngineClock;       
  ULONG                           ulDefaultMemoryClock;       
  ULONG                           ulDriverTargetEngineClock;  
  ULONG                           ulDriverTargetMemoryClock;  
  ULONG                           ulMaxEngineClockPLL_Output; 
  ULONG                           ulMaxMemoryClockPLL_Output; 
  ULONG                           ulMaxPixelClockPLL_Output;  
  ULONG                           ulASICMaxEngineClock;       
  ULONG                           ulASICMaxMemoryClock;       
  UCHAR                           ucASICMaxTemperature;
  UCHAR                           ucMinAllowedBL_Level;
  UCHAR                           ucPadding[2];               
  ULONG                           aulReservedForBIOS[2];      
  ULONG                           ulMinPixelClockPLL_Output;  
  USHORT                          usMinEngineClockPLL_Input;  
  USHORT                          usMaxEngineClockPLL_Input;  
  USHORT                          usMinEngineClockPLL_Output; 
  USHORT                          usMinMemoryClockPLL_Input;  
  USHORT                          usMaxMemoryClockPLL_Input;  
  USHORT                          usMinMemoryClockPLL_Output; 
  USHORT                          usMaxPixelClock;            
  USHORT                          usMinPixelClockPLL_Input;   
  USHORT                          usMaxPixelClockPLL_Input;   
  USHORT                          usMinPixelClockPLL_Output;  
  ATOM_FIRMWARE_CAPABILITY_ACCESS usFirmwareCapability;
  USHORT                          usReferenceClock;           
  USHORT                          usPM_RTS_Location;          
  UCHAR                           ucPM_RTS_StreamSize;        
  UCHAR                           ucDesign_ID;                
  UCHAR                           ucMemoryModule_ID;          
}ATOM_FIRMWARE_INFO_V1_2;

typedef struct _ATOM_FIRMWARE_INFO_V1_3
{
  ATOM_COMMON_TABLE_HEADER        sHeader; 
  ULONG                           ulFirmwareRevision;
  ULONG                           ulDefaultEngineClock;       
  ULONG                           ulDefaultMemoryClock;       
  ULONG                           ulDriverTargetEngineClock;  
  ULONG                           ulDriverTargetMemoryClock;  
  ULONG                           ulMaxEngineClockPLL_Output; 
  ULONG                           ulMaxMemoryClockPLL_Output; 
  ULONG                           ulMaxPixelClockPLL_Output;  
  ULONG                           ulASICMaxEngineClock;       
  ULONG                           ulASICMaxMemoryClock;       
  UCHAR                           ucASICMaxTemperature;
  UCHAR                           ucMinAllowedBL_Level;
  UCHAR                           ucPadding[2];               
  ULONG                           aulReservedForBIOS;         
  ULONG                           ul3DAccelerationEngineClock;
  ULONG                           ulMinPixelClockPLL_Output;  
  USHORT                          usMinEngineClockPLL_Input;  
  USHORT                          usMaxEngineClockPLL_Input;  
  USHORT                          usMinEngineClockPLL_Output; 
  USHORT                          usMinMemoryClockPLL_Input;  
  USHORT                          usMaxMemoryClockPLL_Input;  
  USHORT                          usMinMemoryClockPLL_Output; 
  USHORT                          usMaxPixelClock;            
  USHORT                          usMinPixelClockPLL_Input;   
  USHORT                          usMaxPixelClockPLL_Input;   
  USHORT                          usMinPixelClockPLL_Output;  
  ATOM_FIRMWARE_CAPABILITY_ACCESS usFirmwareCapability;
  USHORT                          usReferenceClock;           
  USHORT                          usPM_RTS_Location;          
  UCHAR                           ucPM_RTS_StreamSize;        
  UCHAR                           ucDesign_ID;                
  UCHAR                           ucMemoryModule_ID;          
}ATOM_FIRMWARE_INFO_V1_3;

typedef struct _ATOM_FIRMWARE_INFO_V1_4
{
  ATOM_COMMON_TABLE_HEADER        sHeader; 
  ULONG                           ulFirmwareRevision;
  ULONG                           ulDefaultEngineClock;       
  ULONG                           ulDefaultMemoryClock;       
  ULONG                           ulDriverTargetEngineClock;  
  ULONG                           ulDriverTargetMemoryClock;  
  ULONG                           ulMaxEngineClockPLL_Output; 
  ULONG                           ulMaxMemoryClockPLL_Output; 
  ULONG                           ulMaxPixelClockPLL_Output;  
  ULONG                           ulASICMaxEngineClock;       
  ULONG                           ulASICMaxMemoryClock;       
  UCHAR                           ucASICMaxTemperature;
  UCHAR                           ucMinAllowedBL_Level;
  USHORT                          usBootUpVDDCVoltage;        
  USHORT                          usLcdMinPixelClockPLL_Output; 
  USHORT                          usLcdMaxPixelClockPLL_Output; 
  ULONG                           ul3DAccelerationEngineClock;
  ULONG                           ulMinPixelClockPLL_Output;  
  USHORT                          usMinEngineClockPLL_Input;  
  USHORT                          usMaxEngineClockPLL_Input;  
  USHORT                          usMinEngineClockPLL_Output; 
  USHORT                          usMinMemoryClockPLL_Input;  
  USHORT                          usMaxMemoryClockPLL_Input;  
  USHORT                          usMinMemoryClockPLL_Output; 
  USHORT                          usMaxPixelClock;            
  USHORT                          usMinPixelClockPLL_Input;   
  USHORT                          usMaxPixelClockPLL_Input;   
  USHORT                          usMinPixelClockPLL_Output;  
  ATOM_FIRMWARE_CAPABILITY_ACCESS usFirmwareCapability;
  USHORT                          usReferenceClock;           
  USHORT                          usPM_RTS_Location;          
  UCHAR                           ucPM_RTS_StreamSize;        
  UCHAR                           ucDesign_ID;                
  UCHAR                           ucMemoryModule_ID;          
}ATOM_FIRMWARE_INFO_V1_4;

#define ATOM_FIRMWARE_INFO_LAST  ATOM_FIRMWARE_INFO_V1_4

#define IGP_CAP_FLAG_DYNAMIC_CLOCK_EN      0x2
#define IGP_CAP_FLAG_AC_CARD               0x4
#define IGP_CAP_FLAG_SDVO_CARD             0x8
#define IGP_CAP_FLAG_POSTDIV_BY_2_MODE     0x10

typedef struct _ATOM_INTEGRATED_SYSTEM_INFO
{
  ATOM_COMMON_TABLE_HEADER        sHeader; 
  ULONG	                          ulBootUpEngineClock;		    
  ULONG	                          ulBootUpMemoryClock;		    
  ULONG	                          ulMaxSystemMemoryClock;	    
  ULONG	                          ulMinSystemMemoryClock;	    
  UCHAR                           ucNumberOfCyclesInPeriodHi;
  UCHAR                           ucLCDTimingSel;             
  USHORT                          usReserved1;
  USHORT                          usInterNBVoltageLow;        
  USHORT                          usInterNBVoltageHigh;       
  ULONG	                          ulReserved[2];

  USHORT	                        usFSBClock;			            
  USHORT                          usCapabilityFlag;		        
																                              
                                                              
  USHORT	                        usPCIENBCfgReg7;				    
  USHORT	                        usK8MemoryClock;            
  USHORT	                        usK8SyncStartDelay;         
  USHORT	                        usK8DataReturnTime;         
  UCHAR                           ucMaxNBVoltage;
  UCHAR                           ucMinNBVoltage;
  UCHAR                           ucMemoryType;					      
  UCHAR                           ucNumberOfCyclesInPeriod;		
  UCHAR                           ucStartingPWM_HighTime;     
  UCHAR                           ucHTLinkWidth;              
  UCHAR                           ucMaxNBVoltageHigh;    
  UCHAR                           ucMinNBVoltageHigh;
}ATOM_INTEGRATED_SYSTEM_INFO;

/* Explanation on entries in ATOM_INTEGRATED_SYSTEM_INFO
ulBootUpMemoryClock:    For Intel IGP,it's the UMA system memory clock 
                        For AMD IGP,it's 0 if no SidePort memory installed or it's the boot-up SidePort memory clock
ulMaxSystemMemoryClock: For Intel IGP,it's the Max freq from memory SPD if memory runs in ASYNC mode or otherwise (SYNC mode) it's 0
                        For AMD IGP,for now this can be 0
ulMinSystemMemoryClock: For Intel IGP,it's 133MHz if memory runs in ASYNC mode or otherwise (SYNC mode) it's 0 
                        For AMD IGP,for now this can be 0

usFSBClock:             For Intel IGP,it's FSB Freq 
                        For AMD IGP,it's HT Link Speed

usK8MemoryClock:        For AMD IGP only. For RevF CPU, set it to 200
usK8SyncStartDelay:     For AMD IGP only. Memory access latency in K8, required for watermark calculation
usK8DataReturnTime:     For AMD IGP only. Memory access latency in K8, required for watermark calculation

VC:Voltage Control
ucMaxNBVoltage:         Voltage regulator dependent PWM value. Low 8 bits of the value for the max voltage.Set this one to 0xFF if VC without PWM. Set this to 0x0 if no VC at all.
ucMinNBVoltage:         Voltage regulator dependent PWM value. Low 8 bits of the value for the min voltage.Set this one to 0x00 if VC without PWM or no VC at all.

ucNumberOfCyclesInPeriod:   Indicate how many cycles when PWM duty is 100%. low 8 bits of the value. 
ucNumberOfCyclesInPeriodHi: Indicate how many cycles when PWM duty is 100%. high 8 bits of the value.If the PWM has an inverter,set bit [7]==1,otherwise set it 0 

ucMaxNBVoltageHigh:     Voltage regulator dependent PWM value. High 8 bits of  the value for the max voltage.Set this one to 0xFF if VC without PWM. Set this to 0x0 if no VC at all.
ucMinNBVoltageHigh:     Voltage regulator dependent PWM value. High 8 bits of the value for the min voltage.Set this one to 0x00 if VC without PWM or no VC at all.


usInterNBVoltageLow:    Voltage regulator dependent PWM value. The value makes the the voltage >=Min NB voltage but <=InterNBVoltageHigh. Set this to 0x0000 if VC without PWM or no VC at all.
usInterNBVoltageHigh:   Voltage regulator dependent PWM value. The value makes the the voltage >=InterNBVoltageLow but <=Max NB voltage.Set this to 0x0000 if VC without PWM or no VC at all.
*/


/*
The following IGP table is introduced from RS780, which is supposed to be put by SBIOS in FB before IGP VBIOS starts VPOST;
Then VBIOS will copy the whole structure to its image so all GPU SW components can access this data structure to get whatever they need. 
The enough reservation should allow us to never change table revisions. Whenever needed, a GPU SW component can use reserved portion for new data entries.

SW components can access the IGP system infor structure in the same way as before
*/


typedef struct _ATOM_INTEGRATED_SYSTEM_INFO_V2
{
  ATOM_COMMON_TABLE_HEADER   sHeader;
  ULONG	                     ulBootUpEngineClock;       
  ULONG			                 ulReserved1[2];            
  ULONG	                     ulBootUpUMAClock;          
  ULONG	                     ulBootUpSidePortClock;     
  ULONG	                     ulMinSidePortClock;        
  ULONG			                 ulReserved2[6];            
  ULONG                      ulSystemConfig;            
  ULONG                      ulBootUpReqDisplayVector;
  ULONG                      ulOtherDisplayMisc;
  ULONG                      ulDDISlot1Config;
  ULONG                      ulDDISlot2Config;
  UCHAR                      ucMemoryType;              
  UCHAR                      ucUMAChannelNumber;
  UCHAR                      ucDockingPinBit;
  UCHAR                      ucDockingPinPolarity;
  ULONG                      ulDockingPinCFGInfo;
  ULONG                      ulCPUCapInfo;
  USHORT                     usNumberOfCyclesInPeriod;
  USHORT                     usMaxNBVoltage;
  USHORT                     usMinNBVoltage;
  USHORT                     usBootUpNBVoltage;
  ULONG                      ulHTLinkFreq;              
  USHORT                     usMinHTLinkWidth;
  USHORT                     usMaxHTLinkWidth;
  USHORT                     usUMASyncStartDelay;
  USHORT                     usUMADataReturnTime;
  USHORT                     usLinkStatusZeroTime;
  USHORT                     usReserved;
  ULONG                      ulReserved3[101];          
}ATOM_INTEGRATED_SYSTEM_INFO_V2;   

/*
ulBootUpEngineClock:   Boot-up Engine Clock in 10Khz;
ulBootUpUMAClock:      Boot-up UMA Clock in 10Khz; it must be 0x0 when UMA is not present
ulBootUpSidePortClock: Boot-up SidePort Clock in 10Khz; it must be 0x0 when SidePort Memory is not present,this could be equal to or less than maximum supported Sideport memory clock

ulSystemConfig:  
Bit[0]: =1 PowerExpress mode =0 Non-PowerExpress mode; 
Bit[1]=1: system is running at overdrived engine clock =0:system is not running at overdrived engine clock

ulBootUpReqDisplayVector: This dword is a bit vector indicates what display devices are requested during boot-up. Refer to ATOM_DEVICE_xxx_SUPPORT for the bit vector definitions.

ulOtherDisplayMisc: [15:8]- Bootup LCD Expansion selection; 0-center, 1-full panel size expansion;
			              [7:0] - BootupTV standard selection; This is a bit vector to indicate what TV standards are supported by the system. Refer to ucTVSuppportedStd definition;

ulDDISlot1Config: Describes the PCIE lane configuration on this DDI PCIE slot (ADD2 card) or connector (Mobile design).
      [3:0]  - Bit vector to indicate PCIE lane config of the DDI slot/connector on chassis (bit 0=1 lane 3:0; bit 1=1 lane 7:4; bit 2=1 lane 11:8; bit 3=1 lane 15:12)
			[7:4]  - Bit vector to indicate PCIE lane config of the same DDI slot/connector on docking station (bit 0=1 lane 3:0; bit 1=1 lane 7:4; bit 2=1 lane 11:8; bit 3=1 lane 15:12)			
			[15:8] - Lane configuration attribute; 
      [23:16]- Connector type, possible value:
               CONNECTOR_OBJECT_ID_SINGLE_LINK_DVI_D
               CONNECTOR_OBJECT_ID_DUAL_LINK_DVI_D
               CONNECTOR_OBJECT_ID_HDMI_TYPE_A
               CONNECTOR_OBJECT_ID_DISPLAYPORT
			[31:24]- Reserved

ulDDISlot2Config: Same as Slot1.
ucMemoryType: SidePort memory type, set it to 0x0 when Sideport memory is not installed. Driver needs this info to change sideport memory clock. Not for display in CCC.
For IGP, Hypermemory is the only memory type showed in CCC.

ucUMAChannelNumber:  how many channels for the UMA;

ulDockingPinCFGInfo: [15:0]-Bus/Device/Function # to CFG to read this Docking Pin; [31:16]-reg offset in CFG to read this pin 
ucDockingPinBit:     which bit in this register to read the pin status;
ucDockingPinPolarity:Polarity of the pin when docked;

ulCPUCapInfo:        [7:0]=1:Griffin;[7:0]=2:Greyhound;[7:0]=3:K8, other bits reserved for now and must be 0x0
 
usNumberOfCyclesInPeriod:Indicate how many cycles when PWM duty is 100%.
usMaxNBVoltage:Voltage regulator dependent PWM value.Set this one to 0xFF if VC without PWM. Set this to 0x0 if no VC at all.
usMinNBVoltage:Voltage regulator dependent PWM value.Set this one to 0x00 if VC without PWM or no VC at all.
usBootUpNBVoltage:Boot-up voltage regulator dependent PWM value.


ulHTLinkFreq:        Current HT link Frequency in 10Khz.
usMinHTLinkWidth:   
usMaxHTLinkWidth:
usUMASyncStartDelay: Memory access latency, required for watermark calculation 
usUMADataReturnTime: Memory access latency, required for watermark calculation
usLinkStatusZeroTime:Memory access latency required for watermark calculation, set this to 0x0 for K8 CPU, set a proper value in 0.01 the unit of us 
for Griffin or Greyhound. SBIOS needs to convert to actual time by:
                     if T0Ttime [5:4]=00b, then usLinkStatusZeroTime=T0Ttime [3:0]*0.1us (0.0 to 1.5us)
                     if T0Ttime [5:4]=01b, then usLinkStatusZeroTime=T0Ttime [3:0]*0.5us (0.0 to 7.5us)
                     if T0Ttime [5:4]=10b, then usLinkStatusZeroTime=T0Ttime [3:0]*2.0us (0.0 to 30us)
                     if T0Ttime [5:4]=11b, and T0Ttime [3:0]=0x0 to 0xa, then usLinkStatusZeroTime=T0Ttime [3:0]*20us (0.0 to 200us)
*/

#define SYSTEM_CONFIG_POWEREXPRESS_ENABLE                 0x00000001
#define SYSTEM_CONFIG_RUN_AT_OVERDRIVE_ENGINE             0x00000002

#define IGP_DDI_SLOT_LANE_CONFIG_MASK                     0x000000FF

#define b0IGP_DDI_SLOT_LANE_MAP_MASK                      0x0F
#define b0IGP_DDI_SLOT_DOCKING_LANE_MAP_MASK              0xF0
#define b0IGP_DDI_SLOT_CONFIG_LANE_0_3                    0x01
#define b0IGP_DDI_SLOT_CONFIG_LANE_4_7                    0x02
#define b0IGP_DDI_SLOT_CONFIG_LANE_8_11                   0x04
#define b0IGP_DDI_SLOT_CONFIG_LANE_12_15                  0x08

#define IGP_DDI_SLOT_ATTRIBUTE_MASK                       0x0000FF00
#define IGP_DDI_SLOT_CONFIG_REVERSED                      0x00000100
#define b1IGP_DDI_SLOT_CONFIG_REVERSED                    0x01

#define IGP_DDI_SLOT_CONNECTOR_TYPE_MASK                  0x00FF0000

#define ATOM_CRT_INT_ENCODER1_INDEX                       0x00000000
#define ATOM_LCD_INT_ENCODER1_INDEX                       0x00000001
#define ATOM_TV_INT_ENCODER1_INDEX                        0x00000002
#define ATOM_DFP_INT_ENCODER1_INDEX                       0x00000003
#define ATOM_CRT_INT_ENCODER2_INDEX                       0x00000004
#define ATOM_LCD_EXT_ENCODER1_INDEX                       0x00000005
#define ATOM_TV_EXT_ENCODER1_INDEX                        0x00000006
#define ATOM_DFP_EXT_ENCODER1_INDEX                       0x00000007
#define ATOM_CV_INT_ENCODER1_INDEX                        0x00000008
#define ATOM_DFP_INT_ENCODER2_INDEX                       0x00000009
#define ATOM_CRT_EXT_ENCODER1_INDEX                       0x0000000A
#define ATOM_CV_EXT_ENCODER1_INDEX                        0x0000000B
#define ATOM_DFP_INT_ENCODER3_INDEX                       0x0000000C
#define ATOM_DFP_INT_ENCODER4_INDEX                       0x0000000D


#define ASIC_INT_DAC1_ENCODER_ID    											0x00 
#define ASIC_INT_TV_ENCODER_ID														0x02
#define ASIC_INT_DIG1_ENCODER_ID													0x03
#define ASIC_INT_DAC2_ENCODER_ID													0x04
#define ASIC_EXT_TV_ENCODER_ID														0x06
#define ASIC_INT_DVO_ENCODER_ID														0x07
#define ASIC_INT_DIG2_ENCODER_ID													0x09
#define ASIC_EXT_DIG_ENCODER_ID														0x05


#define ATOM_ANALOG_ENCODER																0
#define ATOM_DIGITAL_ENCODER															1		

#define ATOM_DEVICE_CRT1_INDEX                            0x00000000
#define ATOM_DEVICE_LCD1_INDEX                            0x00000001
#define ATOM_DEVICE_TV1_INDEX                             0x00000002
#define ATOM_DEVICE_DFP1_INDEX                            0x00000003
#define ATOM_DEVICE_CRT2_INDEX                            0x00000004
#define ATOM_DEVICE_LCD2_INDEX                            0x00000005
#define ATOM_DEVICE_TV2_INDEX                             0x00000006
#define ATOM_DEVICE_DFP2_INDEX                            0x00000007
#define ATOM_DEVICE_CV_INDEX                              0x00000008
#define ATOM_DEVICE_DFP3_INDEX														0x00000009
#define ATOM_DEVICE_RESERVEDA_INDEX                       0x0000000A
#define ATOM_DEVICE_RESERVEDB_INDEX                       0x0000000B
#define ATOM_DEVICE_RESERVEDC_INDEX                       0x0000000C
#define ATOM_DEVICE_RESERVEDD_INDEX                       0x0000000D
#define ATOM_DEVICE_RESERVEDE_INDEX                       0x0000000E
#define ATOM_DEVICE_RESERVEDF_INDEX                       0x0000000F
#define ATOM_MAX_SUPPORTED_DEVICE_INFO                    (ATOM_DEVICE_CV_INDEX+2)
#define ATOM_MAX_SUPPORTED_DEVICE_INFO_2                  ATOM_MAX_SUPPORTED_DEVICE_INFO
#define ATOM_MAX_SUPPORTED_DEVICE                         (ATOM_DEVICE_RESERVEDF_INDEX+1)

#define ATOM_DEVICE_CRT1_SUPPORT                          (0x1L << ATOM_DEVICE_CRT1_INDEX )
#define ATOM_DEVICE_LCD1_SUPPORT                          (0x1L << ATOM_DEVICE_LCD1_INDEX )
#define ATOM_DEVICE_TV1_SUPPORT                           (0x1L << ATOM_DEVICE_TV1_INDEX  )
#define ATOM_DEVICE_DFP1_SUPPORT                          (0x1L << ATOM_DEVICE_DFP1_INDEX)
#define ATOM_DEVICE_CRT2_SUPPORT                          (0x1L << ATOM_DEVICE_CRT2_INDEX )
#define ATOM_DEVICE_LCD2_SUPPORT                          (0x1L << ATOM_DEVICE_LCD2_INDEX )
#define ATOM_DEVICE_TV2_SUPPORT                           (0x1L << ATOM_DEVICE_TV2_INDEX  )
#define ATOM_DEVICE_DFP2_SUPPORT                          (0x1L << ATOM_DEVICE_DFP2_INDEX)
#define ATOM_DEVICE_CV_SUPPORT                            (0x1L << ATOM_DEVICE_CV_INDEX   )
#define ATOM_DEVICE_DFP3_SUPPORT													(0x1L << ATOM_DEVICE_DFP3_INDEX )

#define ATOM_DEVICE_CRT_SUPPORT                           ATOM_DEVICE_CRT1_SUPPORT | ATOM_DEVICE_CRT2_SUPPORT
#define ATOM_DEVICE_DFP_SUPPORT                           ATOM_DEVICE_DFP1_SUPPORT | ATOM_DEVICE_DFP2_SUPPORT |  ATOM_DEVICE_DFP3_SUPPORT
#define ATOM_DEVICE_TV_SUPPORT                            ATOM_DEVICE_TV1_SUPPORT  | ATOM_DEVICE_TV2_SUPPORT
#define ATOM_DEVICE_LCD_SUPPORT                           ATOM_DEVICE_LCD1_SUPPORT | ATOM_DEVICE_LCD2_SUPPORT

#define ATOM_DEVICE_CONNECTOR_TYPE_MASK                   0x000000F0
#define ATOM_DEVICE_CONNECTOR_TYPE_SHIFT                  0x00000004
#define ATOM_DEVICE_CONNECTOR_VGA                         0x00000001
#define ATOM_DEVICE_CONNECTOR_DVI_I                       0x00000002
#define ATOM_DEVICE_CONNECTOR_DVI_D                       0x00000003
#define ATOM_DEVICE_CONNECTOR_DVI_A                       0x00000004
#define ATOM_DEVICE_CONNECTOR_SVIDEO                      0x00000005
#define ATOM_DEVICE_CONNECTOR_COMPOSITE                   0x00000006
#define ATOM_DEVICE_CONNECTOR_LVDS                        0x00000007
#define ATOM_DEVICE_CONNECTOR_DIGI_LINK                   0x00000008
#define ATOM_DEVICE_CONNECTOR_SCART                       0x00000009
#define ATOM_DEVICE_CONNECTOR_HDMI_TYPE_A                 0x0000000A
#define ATOM_DEVICE_CONNECTOR_HDMI_TYPE_B                 0x0000000B
#define ATOM_DEVICE_CONNECTOR_CASE_1                      0x0000000E
#define ATOM_DEVICE_CONNECTOR_DISPLAYPORT                 0x0000000F


#define ATOM_DEVICE_DAC_INFO_MASK                         0x0000000F
#define ATOM_DEVICE_DAC_INFO_SHIFT                        0x00000000
#define ATOM_DEVICE_DAC_INFO_NODAC                        0x00000000
#define ATOM_DEVICE_DAC_INFO_DACA                         0x00000001
#define ATOM_DEVICE_DAC_INFO_DACB                         0x00000002
#define ATOM_DEVICE_DAC_INFO_EXDAC                        0x00000003

#define ATOM_DEVICE_I2C_ID_NOI2C                          0x00000000

#define ATOM_DEVICE_I2C_LINEMUX_MASK                      0x0000000F
#define ATOM_DEVICE_I2C_LINEMUX_SHIFT                     0x00000000

#define ATOM_DEVICE_I2C_ID_MASK                           0x00000070
#define ATOM_DEVICE_I2C_ID_SHIFT                          0x00000004
#define ATOM_DEVICE_I2C_ID_IS_FOR_NON_MM_USE              0x00000001
#define ATOM_DEVICE_I2C_ID_IS_FOR_MM_USE                  0x00000002
#define ATOM_DEVICE_I2C_ID_IS_FOR_SDVO_USE                0x00000003    
#define ATOM_DEVICE_I2C_ID_IS_FOR_DAC_SCL                 0x00000004    

#define ATOM_DEVICE_I2C_HARDWARE_CAP_MASK                 0x00000080
#define ATOM_DEVICE_I2C_HARDWARE_CAP_SHIFT                0x00000007
#define	ATOM_DEVICE_USES_SOFTWARE_ASSISTED_I2C            0x00000000
#define	ATOM_DEVICE_USES_HARDWARE_ASSISTED_I2C            0x00000001




























typedef struct _ATOM_I2C_ID_CONFIG
{
  UCHAR   bfI2C_LineMux:4;
  UCHAR   bfHW_EngineID:3;
  UCHAR   bfHW_Capable:1;
}ATOM_I2C_ID_CONFIG;

typedef union _ATOM_I2C_ID_CONFIG_ACCESS
{
  ATOM_I2C_ID_CONFIG sbfAccess;
  UCHAR              ucAccess;
}ATOM_I2C_ID_CONFIG_ACCESS;
   

typedef struct _ATOM_GPIO_I2C_ASSIGMENT
{
  USHORT                    usClkMaskRegisterIndex;
  USHORT                    usClkEnRegisterIndex;
  USHORT                    usClkY_RegisterIndex;
  USHORT                    usClkA_RegisterIndex;
  USHORT                    usDataMaskRegisterIndex;
  USHORT                    usDataEnRegisterIndex;
  USHORT                    usDataY_RegisterIndex;
  USHORT                    usDataA_RegisterIndex;
  ATOM_I2C_ID_CONFIG_ACCESS sucI2cId;
  UCHAR                     ucClkMaskShift;
  UCHAR                     ucClkEnShift;
  UCHAR                     ucClkY_Shift;
  UCHAR                     ucClkA_Shift;
  UCHAR                     ucDataMaskShift;
  UCHAR                     ucDataEnShift;
  UCHAR                     ucDataY_Shift;
  UCHAR                     ucDataA_Shift;
  UCHAR                     ucReserved1;
  UCHAR                     ucReserved2;
}ATOM_GPIO_I2C_ASSIGMENT;

typedef struct _ATOM_GPIO_I2C_INFO
{ 
  ATOM_COMMON_TABLE_HEADER	sHeader;
  ATOM_GPIO_I2C_ASSIGMENT   asGPIO_Info[ATOM_MAX_SUPPORTED_DEVICE];
}ATOM_GPIO_I2C_INFO;


#ifndef _H2INC
  

typedef struct _ATOM_MODE_MISC_INFO
{ 
  USHORT HorizontalCutOff:1;
  USHORT HSyncPolarity:1;      
  USHORT VSyncPolarity:1;      
  USHORT VerticalCutOff:1;
  USHORT H_ReplicationBy2:1;
  USHORT V_ReplicationBy2:1;
  USHORT CompositeSync:1;
  USHORT Interlace:1;
  USHORT DoubleClock:1;
  USHORT RGB888:1;
  USHORT Reserved:6;           
}ATOM_MODE_MISC_INFO;
  
typedef union _ATOM_MODE_MISC_INFO_ACCESS
{ 
  ATOM_MODE_MISC_INFO sbfAccess;
  USHORT              usAccess;
}ATOM_MODE_MISC_INFO_ACCESS;
  
#else
  
typedef union _ATOM_MODE_MISC_INFO_ACCESS
{ 
  USHORT              usAccess;
}ATOM_MODE_MISC_INFO_ACCESS;
   
#endif


#define ATOM_H_CUTOFF           0x01
#define ATOM_HSYNC_POLARITY     0x02             
#define ATOM_VSYNC_POLARITY     0x04             
#define ATOM_V_CUTOFF           0x08
#define ATOM_H_REPLICATIONBY2   0x10
#define ATOM_V_REPLICATIONBY2   0x20
#define ATOM_COMPOSITESYNC      0x40
#define ATOM_INTERLACE          0x80
#define ATOM_DOUBLE_CLOCK_MODE  0x100
#define ATOM_RGB888_MODE        0x200


#define ATOM_REFRESH_43         43
#define ATOM_REFRESH_47         47
#define ATOM_REFRESH_56         56	
#define ATOM_REFRESH_60         60
#define ATOM_REFRESH_65         65
#define ATOM_REFRESH_70         70
#define ATOM_REFRESH_72         72
#define ATOM_REFRESH_75         75
#define ATOM_REFRESH_85         85













typedef struct _SET_CRTC_USING_DTD_TIMING_PARAMETERS
{
  USHORT  usH_Size;
  USHORT  usH_Blanking_Time;
  USHORT  usV_Size;
  USHORT  usV_Blanking_Time;			
  USHORT  usH_SyncOffset;
  USHORT  usH_SyncWidth;
  USHORT  usV_SyncOffset;
  USHORT  usV_SyncWidth;
  ATOM_MODE_MISC_INFO_ACCESS  susModeMiscInfo;  
  UCHAR   ucH_Border;         
  UCHAR   ucV_Border;
  UCHAR   ucCRTC;             
  UCHAR   ucPadding[3];
}SET_CRTC_USING_DTD_TIMING_PARAMETERS;

typedef struct _SET_CRTC_TIMING_PARAMETERS
{
  USHORT                      usH_Total;        
  USHORT                      usH_Disp;         
  USHORT                      usH_SyncStart;    
  USHORT                      usH_SyncWidth;    
  USHORT                      usV_Total;        
  USHORT                      usV_Disp;         
  USHORT                      usV_SyncStart;    
  USHORT                      usV_SyncWidth;    
  ATOM_MODE_MISC_INFO_ACCESS  susModeMiscInfo;
  UCHAR                       ucCRTC;           
  UCHAR                       ucOverscanRight;  
  UCHAR                       ucOverscanLeft;   
  UCHAR                       ucOverscanBottom; 
  UCHAR                       ucOverscanTop;    
  UCHAR                       ucReserved;
}SET_CRTC_TIMING_PARAMETERS;
#define SET_CRTC_TIMING_PARAMETERS_PS_ALLOCATION SET_CRTC_TIMING_PARAMETERS


typedef struct _ATOM_MODE_TIMING
{
  USHORT  usCRTC_H_Total;
  USHORT  usCRTC_H_Disp;
  USHORT  usCRTC_H_SyncStart;
  USHORT  usCRTC_H_SyncWidth;
  USHORT  usCRTC_V_Total;
  USHORT  usCRTC_V_Disp;
  USHORT  usCRTC_V_SyncStart;
  USHORT  usCRTC_V_SyncWidth;
  USHORT  usPixelClock;					                 
  ATOM_MODE_MISC_INFO_ACCESS  susModeMiscInfo;
  USHORT  usCRTC_OverscanRight;
  USHORT  usCRTC_OverscanLeft;
  USHORT  usCRTC_OverscanBottom;
  USHORT  usCRTC_OverscanTop;
  USHORT  usReserve;
  UCHAR   ucInternalModeNumber;
  UCHAR   ucRefreshRate;
}ATOM_MODE_TIMING;

 
typedef struct _ATOM_DTD_FORMAT
{
  USHORT  usPixClk;
  USHORT  usHActive;
  USHORT  usHBlanking_Time;
  USHORT  usVActive;
  USHORT  usVBlanking_Time;			
  USHORT  usHSyncOffset;
  USHORT  usHSyncWidth;
  USHORT  usVSyncOffset;
  USHORT  usVSyncWidth;
  USHORT  usImageHSize;
  USHORT  usImageVSize;
  UCHAR   ucHBorder;
  UCHAR   ucVBorder;
  ATOM_MODE_MISC_INFO_ACCESS susModeMiscInfo;
  UCHAR   ucInternalModeNumber;
  UCHAR   ucRefreshRate;
}ATOM_DTD_FORMAT;

#define SUPPORTED_LCD_REFRESHRATE_30Hz          0x0004
#define SUPPORTED_LCD_REFRESHRATE_40Hz          0x0008
#define SUPPORTED_LCD_REFRESHRATE_50Hz          0x0010
#define SUPPORTED_LCD_REFRESHRATE_60Hz          0x0020

/****************************LVDS Info Table Definitions **********************/


typedef struct _ATOM_LVDS_INFO
{
  ATOM_COMMON_TABLE_HEADER sHeader;  
  ATOM_DTD_FORMAT     sLCDTiming;
  USHORT              usModePatchTableOffset;
  USHORT              usSupportedRefreshRate;     
  USHORT              usOffDelayInMs;
  UCHAR               ucPowerSequenceDigOntoDEin10Ms;
  UCHAR               ucPowerSequenceDEtoBLOnin10Ms;
  UCHAR               ucLVDS_Misc;               
                                                 
                                                 
                                                 
  UCHAR               ucPanelDefaultRefreshRate;
  UCHAR               ucPanelIdentification;
  UCHAR               ucSS_Id;
}ATOM_LVDS_INFO;



typedef struct _ATOM_LVDS_INFO_V12
{
  ATOM_COMMON_TABLE_HEADER sHeader;  
  ATOM_DTD_FORMAT     sLCDTiming;
  USHORT              usExtInfoTableOffset;
  USHORT              usSupportedRefreshRate;     
  USHORT              usOffDelayInMs;
  UCHAR               ucPowerSequenceDigOntoDEin10Ms;
  UCHAR               ucPowerSequenceDEtoBLOnin10Ms;
  UCHAR               ucLVDS_Misc;               
                                                 
                                                 
                                                 
  UCHAR               ucPanelDefaultRefreshRate;
  UCHAR               ucPanelIdentification;
  UCHAR               ucSS_Id;
  USHORT              usLCDVenderID;
  USHORT              usLCDProductID;
  UCHAR               ucLCDPanel_SpecialHandlingCap; 
	UCHAR								ucPanelInfoSize;					
  UCHAR               ucReserved[2];
}ATOM_LVDS_INFO_V12;

#define ATOM_LVDS_INFO_LAST  ATOM_LVDS_INFO_V12

typedef struct  _ATOM_PATCH_RECORD_MODE
{
  UCHAR     ucRecordType;
  USHORT    usHDisp;
  USHORT    usVDisp;
}ATOM_PATCH_RECORD_MODE;

typedef struct  _ATOM_LCD_RTS_RECORD
{
  UCHAR     ucRecordType;
  UCHAR     ucRTSValue;
}ATOM_LCD_RTS_RECORD;


typedef struct  _ATOM_LCD_MODE_CONTROL_CAP
{
  UCHAR     ucRecordType;
  USHORT    usLCDCap;
}ATOM_LCD_MODE_CONTROL_CAP;

#define LCD_MODE_CAP_BL_OFF                   1
#define LCD_MODE_CAP_CRTC_OFF                 2
#define LCD_MODE_CAP_PANEL_OFF                4

typedef struct _ATOM_FAKE_EDID_PATCH_RECORD
{
  UCHAR ucRecordType;
  UCHAR ucFakeEDIDLength;
  UCHAR ucFakeEDIDString[1];    
} ATOM_FAKE_EDID_PATCH_RECORD;

typedef struct  _ATOM_PANEL_RESOLUTION_PATCH_RECORD
{
   UCHAR    ucRecordType;
   USHORT		usHSize;
   USHORT		usVSize;
}ATOM_PANEL_RESOLUTION_PATCH_RECORD;

#define LCD_MODE_PATCH_RECORD_MODE_TYPE       1
#define LCD_RTS_RECORD_TYPE                   2
#define LCD_CAP_RECORD_TYPE                   3
#define LCD_FAKE_EDID_PATCH_RECORD_TYPE       4
#define LCD_PANEL_RESOLUTION_RECORD_TYPE      5
#define ATOM_RECORD_END_TYPE                  0xFF

/****************************Spread Spectrum Info Table Definitions **********************/



typedef struct _ATOM_SPREAD_SPECTRUM_ASSIGNMENT
{
  USHORT              usSpreadSpectrumPercentage; 
  UCHAR               ucSpreadSpectrumType;	    
  UCHAR               ucSS_Step;
  UCHAR               ucSS_Delay;
  UCHAR               ucSS_Id;
  UCHAR               ucRecommandedRef_Div;
  UCHAR               ucSS_Range;               
}ATOM_SPREAD_SPECTRUM_ASSIGNMENT;

#define ATOM_MAX_SS_ENTRY                      16
#define ATOM_DP_SS_ID1												 0x0f1			
#define ATOM_DP_SS_ID2												 0x0f2			


#define ATOM_SS_DOWN_SPREAD_MODE_MASK          0x00000000
#define ATOM_SS_DOWN_SPREAD_MODE               0x00000000
#define ATOM_SS_CENTRE_SPREAD_MODE_MASK        0x00000001
#define ATOM_SS_CENTRE_SPREAD_MODE             0x00000001
#define ATOM_INTERNAL_SS_MASK                  0x00000000
#define ATOM_EXTERNAL_SS_MASK                  0x00000002
#define EXEC_SS_STEP_SIZE_SHIFT                2
#define EXEC_SS_DELAY_SHIFT                    4    
#define ACTIVEDATA_TO_BLON_DELAY_SHIFT         4

typedef struct _ATOM_SPREAD_SPECTRUM_INFO
{ 
  ATOM_COMMON_TABLE_HEADER	sHeader;
  ATOM_SPREAD_SPECTRUM_ASSIGNMENT   asSS_Info[ATOM_MAX_SS_ENTRY];
}ATOM_SPREAD_SPECTRUM_INFO;

















#define NTSC_SUPPORT          0x1
#define NTSCJ_SUPPORT         0x2

#define PAL_SUPPORT           0x4
#define PALM_SUPPORT          0x8
#define PALCN_SUPPORT         0x10
#define PALN_SUPPORT          0x20
#define PAL60_SUPPORT         0x40
#define SECAM_SUPPORT         0x80

#define MAX_SUPPORTED_TV_TIMING    2

typedef struct _ATOM_ANALOG_TV_INFO
{
  ATOM_COMMON_TABLE_HEADER sHeader;  
  UCHAR                    ucTV_SupportedStandard;
  UCHAR                    ucTV_BootUpDefaultStandard; 
  UCHAR                    ucExt_TV_ASIC_ID;
  UCHAR                    ucExt_TV_ASIC_SlaveAddr;
/*   ATOM_DTD_FORMAT          aModeTimings[MAX_SUPPORTED_TV_TIMING]; */
  ATOM_MODE_TIMING         aModeTimings[MAX_SUPPORTED_TV_TIMING];
}ATOM_ANALOG_TV_INFO;


/**************************************************************************/








#ifndef VESA_MEMORY_IN_64K_BLOCK
#define VESA_MEMORY_IN_64K_BLOCK        0x100       
#endif

#define ATOM_EDID_RAW_DATASIZE          256         
#define ATOM_HWICON_SURFACE_SIZE        4096        
#define ATOM_HWICON_INFOTABLE_SIZE      32
#define MAX_DTD_MODE_IN_VRAM            6
#define ATOM_DTD_MODE_SUPPORT_TBL_SIZE  (MAX_DTD_MODE_IN_VRAM*28)    
#define ATOM_STD_MODE_SUPPORT_TBL_SIZE  32*8                         
#define DFP_ENCODER_TYPE_OFFSET					0x80
#define DP_ENCODER_LANE_NUM_OFFSET			0x84
#define DP_ENCODER_LINK_RATE_OFFSET			0x88

#define ATOM_HWICON1_SURFACE_ADDR       0
#define ATOM_HWICON2_SURFACE_ADDR       (ATOM_HWICON1_SURFACE_ADDR + ATOM_HWICON_SURFACE_SIZE)
#define ATOM_HWICON_INFOTABLE_ADDR      (ATOM_HWICON2_SURFACE_ADDR + ATOM_HWICON_SURFACE_SIZE)
#define ATOM_CRT1_EDID_ADDR             (ATOM_HWICON_INFOTABLE_ADDR + ATOM_HWICON_INFOTABLE_SIZE)
#define ATOM_CRT1_DTD_MODE_TBL_ADDR     (ATOM_CRT1_EDID_ADDR + ATOM_EDID_RAW_DATASIZE)
#define ATOM_CRT1_STD_MODE_TBL_ADDR	    (ATOM_CRT1_DTD_MODE_TBL_ADDR + ATOM_DTD_MODE_SUPPORT_TBL_SIZE)

#define ATOM_LCD1_EDID_ADDR             (ATOM_CRT1_STD_MODE_TBL_ADDR + ATOM_STD_MODE_SUPPORT_TBL_SIZE)
#define ATOM_LCD1_DTD_MODE_TBL_ADDR     (ATOM_LCD1_EDID_ADDR + ATOM_EDID_RAW_DATASIZE)
#define ATOM_LCD1_STD_MODE_TBL_ADDR   	(ATOM_LCD1_DTD_MODE_TBL_ADDR + ATOM_DTD_MODE_SUPPORT_TBL_SIZE)

#define ATOM_TV1_DTD_MODE_TBL_ADDR      (ATOM_LCD1_STD_MODE_TBL_ADDR + ATOM_STD_MODE_SUPPORT_TBL_SIZE)

#define ATOM_DFP1_EDID_ADDR             (ATOM_TV1_DTD_MODE_TBL_ADDR + ATOM_DTD_MODE_SUPPORT_TBL_SIZE)
#define ATOM_DFP1_DTD_MODE_TBL_ADDR     (ATOM_DFP1_EDID_ADDR + ATOM_EDID_RAW_DATASIZE)
#define ATOM_DFP1_STD_MODE_TBL_ADDR	    (ATOM_DFP1_DTD_MODE_TBL_ADDR + ATOM_DTD_MODE_SUPPORT_TBL_SIZE)

#define ATOM_CRT2_EDID_ADDR             (ATOM_DFP1_STD_MODE_TBL_ADDR + ATOM_STD_MODE_SUPPORT_TBL_SIZE)
#define ATOM_CRT2_DTD_MODE_TBL_ADDR     (ATOM_CRT2_EDID_ADDR + ATOM_EDID_RAW_DATASIZE)
#define ATOM_CRT2_STD_MODE_TBL_ADDR	    (ATOM_CRT2_DTD_MODE_TBL_ADDR + ATOM_DTD_MODE_SUPPORT_TBL_SIZE)

#define ATOM_LCD2_EDID_ADDR             (ATOM_CRT2_STD_MODE_TBL_ADDR + ATOM_STD_MODE_SUPPORT_TBL_SIZE)
#define ATOM_LCD2_DTD_MODE_TBL_ADDR     (ATOM_LCD2_EDID_ADDR + ATOM_EDID_RAW_DATASIZE)
#define ATOM_LCD2_STD_MODE_TBL_ADDR   	(ATOM_LCD2_DTD_MODE_TBL_ADDR + ATOM_DTD_MODE_SUPPORT_TBL_SIZE)

#define ATOM_TV2_EDID_ADDR              (ATOM_LCD2_STD_MODE_TBL_ADDR + ATOM_STD_MODE_SUPPORT_TBL_SIZE)
#define ATOM_TV2_DTD_MODE_TBL_ADDR      (ATOM_TV2_EDID_ADDR + ATOM_EDID_RAW_DATASIZE)
#define ATOM_TV2_STD_MODE_TBL_ADDR  	  (ATOM_TV2_DTD_MODE_TBL_ADDR + ATOM_DTD_MODE_SUPPORT_TBL_SIZE)

#define ATOM_DFP2_EDID_ADDR             (ATOM_TV2_STD_MODE_TBL_ADDR + ATOM_STD_MODE_SUPPORT_TBL_SIZE)
#define ATOM_DFP2_DTD_MODE_TBL_ADDR     (ATOM_DFP2_EDID_ADDR + ATOM_EDID_RAW_DATASIZE)
#define ATOM_DFP2_STD_MODE_TBL_ADDR     (ATOM_DFP2_DTD_MODE_TBL_ADDR + ATOM_DTD_MODE_SUPPORT_TBL_SIZE)

#define ATOM_CV_EDID_ADDR               (ATOM_DFP2_STD_MODE_TBL_ADDR + ATOM_STD_MODE_SUPPORT_TBL_SIZE)
#define ATOM_CV_DTD_MODE_TBL_ADDR       (ATOM_CV_EDID_ADDR + ATOM_EDID_RAW_DATASIZE)
#define ATOM_CV_STD_MODE_TBL_ADDR       (ATOM_CV_DTD_MODE_TBL_ADDR + ATOM_DTD_MODE_SUPPORT_TBL_SIZE)

#define ATOM_DFP3_EDID_ADDR             (ATOM_CV_STD_MODE_TBL_ADDR + ATOM_STD_MODE_SUPPORT_TBL_SIZE)
#define ATOM_DFP3_DTD_MODE_TBL_ADDR     (ATOM_DFP3_EDID_ADDR + ATOM_EDID_RAW_DATASIZE)
#define ATOM_DFP3_STD_MODE_TBL_ADDR     (ATOM_DFP3_DTD_MODE_TBL_ADDR + ATOM_DTD_MODE_SUPPORT_TBL_SIZE)

#define ATOM_DP_TRAINING_TBL_ADDR				(ATOM_DFP3_STD_MODE_TBL_ADDR+ATOM_STD_MODE_SUPPORT_TBL_SIZE)       

#define ATOM_STACK_STORAGE_START        (ATOM_DP_TRAINING_TBL_ADDR+256)       
#define ATOM_STACK_STORAGE_END          ATOM_STACK_STORAGE_START+512        


#define ATOM_VRAM_RESERVE_SIZE         ((((ATOM_STACK_STORAGE_END - ATOM_HWICON1_SURFACE_ADDR)>>10)+4)&0xFFFC)
   
#define	ATOM_VRAM_OPERATION_FLAGS_MASK         0xC0000000L
#define ATOM_VRAM_OPERATION_FLAGS_SHIFT        30
#define	ATOM_VRAM_BLOCK_NEEDS_NO_RESERVATION   0x1
#define	ATOM_VRAM_BLOCK_NEEDS_RESERVATION      0x0

#define ATOM_MAX_FIRMWARE_VRAM_USAGE_INFO			1

typedef struct _ATOM_FIRMWARE_VRAM_RESERVE_INFO
{
  ULONG   ulStartAddrUsedByFirmware;
  USHORT  usFirmwareUseInKb;
  USHORT  usReserved;
}ATOM_FIRMWARE_VRAM_RESERVE_INFO;

typedef struct _ATOM_VRAM_USAGE_BY_FIRMWARE
{
  ATOM_COMMON_TABLE_HEADER sHeader;  
  ATOM_FIRMWARE_VRAM_RESERVE_INFO	asFirmwareVramReserveInfo[ATOM_MAX_FIRMWARE_VRAM_USAGE_INFO];
}ATOM_VRAM_USAGE_BY_FIRMWARE;

/**************************************************************************/

typedef struct _ATOM_GPIO_PIN_ASSIGNMENT
{
  USHORT                   usGpioPin_AIndex;
  UCHAR                    ucGpioPinBitShift;
  UCHAR                    ucGPIO_ID;
}ATOM_GPIO_PIN_ASSIGNMENT;

typedef struct _ATOM_GPIO_PIN_LUT
{
  ATOM_COMMON_TABLE_HEADER  sHeader;
  ATOM_GPIO_PIN_ASSIGNMENT	asGPIO_Pin[1];
}ATOM_GPIO_PIN_LUT;

/**************************************************************************/


#define GPIO_PIN_ACTIVE_HIGH          0x1

#define MAX_SUPPORTED_CV_STANDARDS    5


#define ATOM_GPIO_SETTINGS_BITSHIFT_MASK  0x1F    
#define ATOM_GPIO_SETTINGS_RESERVED_MASK  0x60    
#define ATOM_GPIO_SETTINGS_ACTIVE_MASK    0x80    

typedef struct _ATOM_GPIO_INFO
{
  USHORT  usAOffset;
  UCHAR   ucSettings;
  UCHAR   ucReserved;
}ATOM_GPIO_INFO;


#define ATOM_CV_RESTRICT_FORMAT_SELECTION           0x2


#define ATOM_GPIO_DEFAULT_MODE_EN                   0x80 
#define ATOM_GPIO_SETTING_PERMODE_MASK              0x7F 



#define ATOM_CV_LINE3_ASPECTRATIO_16_9_GPIO_A       0x01     
#define ATOM_CV_LINE3_ASPECTRATIO_16_9_GPIO_B       0x02     
#define ATOM_CV_LINE3_ASPECTRATIO_16_9_GPIO_SHIFT   0x0   


#define ATOM_CV_LINE3_ASPECTRATIO_4_3_LETBOX_GPIO_A 0x04     
#define ATOM_CV_LINE3_ASPECTRATIO_4_3_LETBOX_GPIO_B 0x08     
#define ATOM_CV_LINE3_ASPECTRATIO_4_3_LETBOX_GPIO_SHIFT 0x2     


#define ATOM_CV_LINE3_ASPECTRATIO_4_3_GPIO_A        0x10     
#define ATOM_CV_LINE3_ASPECTRATIO_4_3_GPIO_B        0x20     
#define ATOM_CV_LINE3_ASPECTRATIO_4_3_GPIO_SHIFT    0x4 

#define ATOM_CV_LINE3_ASPECTRATIO_MASK              0x3F     

#define ATOM_CV_LINE3_ASPECTRATIO_EXIST             0x80     


#define ATOM_GPIO_INDEX_LINE3_ASPECRATIO_GPIO_A   3   
#define ATOM_GPIO_INDEX_LINE3_ASPECRATIO_GPIO_B   4   


typedef struct _ATOM_COMPONENT_VIDEO_INFO
{
  ATOM_COMMON_TABLE_HEADER sHeader;
  USHORT             usMask_PinRegisterIndex;
  USHORT             usEN_PinRegisterIndex;
  USHORT             usY_PinRegisterIndex;
  USHORT             usA_PinRegisterIndex;
  UCHAR              ucBitShift;
  UCHAR              ucPinActiveState;  
  ATOM_DTD_FORMAT    sReserved;         
  UCHAR              ucMiscInfo;
  UCHAR              uc480i;
  UCHAR              uc480p;
  UCHAR              uc720p;
  UCHAR              uc1080i;
  UCHAR              ucLetterBoxMode;
  UCHAR              ucReserved[3];
  UCHAR              ucNumOfWbGpioBlocks; 
  ATOM_GPIO_INFO     aWbGpioStateBlock[MAX_SUPPORTED_CV_STANDARDS];
  ATOM_DTD_FORMAT    aModeTimings[MAX_SUPPORTED_CV_STANDARDS];
}ATOM_COMPONENT_VIDEO_INFO;



typedef struct _ATOM_COMPONENT_VIDEO_INFO_V21
{
  ATOM_COMMON_TABLE_HEADER sHeader;
  UCHAR              ucMiscInfo;
  UCHAR              uc480i;
  UCHAR              uc480p;
  UCHAR              uc720p;
  UCHAR              uc1080i;
  UCHAR              ucReserved;
  UCHAR              ucLetterBoxMode;
  UCHAR              ucNumOfWbGpioBlocks; 
  ATOM_GPIO_INFO     aWbGpioStateBlock[MAX_SUPPORTED_CV_STANDARDS];
  ATOM_DTD_FORMAT    aModeTimings[MAX_SUPPORTED_CV_STANDARDS];
}ATOM_COMPONENT_VIDEO_INFO_V21;

#define ATOM_COMPONENT_VIDEO_INFO_LAST  ATOM_COMPONENT_VIDEO_INFO_V21

/**************************************************************************/

typedef struct _ATOM_OBJECT_HEADER
{ 
  ATOM_COMMON_TABLE_HEADER	sHeader;
  USHORT                    usDeviceSupport;
  USHORT                    usConnectorObjectTableOffset;
  USHORT                    usRouterObjectTableOffset;
  USHORT                    usEncoderObjectTableOffset;
  USHORT                    usProtectionObjectTableOffset; 
  USHORT                    usDisplayPathTableOffset;
}ATOM_OBJECT_HEADER;


typedef struct  _ATOM_DISPLAY_OBJECT_PATH
{
  USHORT    usDeviceTag;                                   
  USHORT    usSize;                                        
  USHORT    usConnObjectId;                                
  USHORT    usGPUObjectId;                                 
  USHORT    usGraphicObjIds[1];                             
}ATOM_DISPLAY_OBJECT_PATH;

typedef struct _ATOM_DISPLAY_OBJECT_PATH_TABLE
{
  UCHAR                           ucNumOfDispPath;
  UCHAR                           ucVersion;
  UCHAR                           ucPadding[2];
  ATOM_DISPLAY_OBJECT_PATH        asDispPath[1];
}ATOM_DISPLAY_OBJECT_PATH_TABLE;


typedef struct _ATOM_OBJECT                                
{
  USHORT              usObjectID;
  USHORT              usSrcDstTableOffset;
  USHORT              usRecordOffset;                     
  USHORT              usReserved;
}ATOM_OBJECT;

typedef struct _ATOM_OBJECT_TABLE                         
{
  UCHAR               ucNumberOfObjects;
  UCHAR               ucPadding[3];
  ATOM_OBJECT         asObjects[1];
}ATOM_OBJECT_TABLE;

typedef struct _ATOM_SRC_DST_TABLE_FOR_ONE_OBJECT         
{
  UCHAR               ucNumberOfSrc;
  USHORT              usSrcObjectID[1];
  UCHAR               ucNumberOfDst;
  USHORT              usDstObjectID[1];
}ATOM_SRC_DST_TABLE_FOR_ONE_OBJECT;



typedef struct _ATOM_COMMON_RECORD_HEADER
{
  UCHAR               ucRecordType;                      
  UCHAR               ucRecordSize;                      
}ATOM_COMMON_RECORD_HEADER;


#define ATOM_I2C_RECORD_TYPE                           1         
#define ATOM_HPD_INT_RECORD_TYPE                       2
#define ATOM_OUTPUT_PROTECTION_RECORD_TYPE             3
#define ATOM_CONNECTOR_DEVICE_TAG_RECORD_TYPE          4
#define	ATOM_CONNECTOR_DVI_EXT_INPUT_RECORD_TYPE	     5 
#define ATOM_ENCODER_FPGA_CONTROL_RECORD_TYPE          6 
#define ATOM_CONNECTOR_CVTV_SHARE_DIN_RECORD_TYPE      7
#define ATOM_JTAG_RECORD_TYPE                          8 
#define ATOM_OBJECT_GPIO_CNTL_RECORD_TYPE              9
#define ATOM_ENCODER_DVO_CF_RECORD_TYPE               10
#define ATOM_CONNECTOR_CF_RECORD_TYPE                 11
#define	ATOM_CONNECTOR_HARDCODE_DTD_RECORD_TYPE	      12
#define ATOM_CONNECTOR_PCIE_SUBCONNECTOR_RECORD_TYPE  13
#define ATOM_ROUTER_DDC_PATH_SELECT_RECORD_TYPE				14
#define ATOM_ROUTER_DATA_CLOCK_PATH_SELECT_RECORD_TYPE					15


#define ATOM_MAX_OBJECT_RECORD_NUMBER             ATOM_CONNECTOR_CF_RECORD_TYPE     

typedef struct  _ATOM_I2C_RECORD
{
  ATOM_COMMON_RECORD_HEADER   sheader;
  ATOM_I2C_ID_CONFIG          sucI2cId; 
  UCHAR                       ucI2CAddr;              
}ATOM_I2C_RECORD;

typedef struct  _ATOM_HPD_INT_RECORD
{
  ATOM_COMMON_RECORD_HEADER   sheader;
  UCHAR                       ucHPDIntGPIOID;         
  UCHAR                       ucPluggged_PinState;
}ATOM_HPD_INT_RECORD;


typedef struct  _ATOM_OUTPUT_PROTECTION_RECORD 
{
  ATOM_COMMON_RECORD_HEADER   sheader;
  UCHAR                       ucProtectionFlag;
  UCHAR                       ucReserved;
}ATOM_OUTPUT_PROTECTION_RECORD;

typedef struct  _ATOM_CONNECTOR_DEVICE_TAG
{
  ULONG                       ulACPIDeviceEnum;       
  USHORT                      usDeviceID;             
  USHORT                      usPadding;
}ATOM_CONNECTOR_DEVICE_TAG;

typedef struct  _ATOM_CONNECTOR_DEVICE_TAG_RECORD
{
  ATOM_COMMON_RECORD_HEADER   sheader;
  UCHAR                       ucNumberOfDevice;
  UCHAR                       ucReserved;
  ATOM_CONNECTOR_DEVICE_TAG   asDeviceTag[1];         
}ATOM_CONNECTOR_DEVICE_TAG_RECORD;


typedef struct  _ATOM_CONNECTOR_DVI_EXT_INPUT_RECORD
{
  ATOM_COMMON_RECORD_HEADER   sheader;
  UCHAR						            ucConfigGPIOID;
  UCHAR						            ucConfigGPIOState;	    
  UCHAR                       ucFlowinGPIPID;
  UCHAR                       ucExtInGPIPID;
}ATOM_CONNECTOR_DVI_EXT_INPUT_RECORD;

typedef struct  _ATOM_ENCODER_FPGA_CONTROL_RECORD
{
  ATOM_COMMON_RECORD_HEADER   sheader;
  UCHAR                       ucCTL1GPIO_ID;
  UCHAR                       ucCTL1GPIOState;        
  UCHAR                       ucCTL2GPIO_ID;
  UCHAR                       ucCTL2GPIOState;        
  UCHAR                       ucCTL3GPIO_ID;
  UCHAR                       ucCTL3GPIOState;        
  UCHAR                       ucCTLFPGA_IN_ID;
  UCHAR                       ucPadding[3];
}ATOM_ENCODER_FPGA_CONTROL_RECORD;

typedef struct  _ATOM_CONNECTOR_CVTV_SHARE_DIN_RECORD
{
  ATOM_COMMON_RECORD_HEADER   sheader;
  UCHAR                       ucGPIOID;               
  UCHAR                       ucTVActiveState;        
}ATOM_CONNECTOR_CVTV_SHARE_DIN_RECORD;

typedef struct  _ATOM_JTAG_RECORD
{
  ATOM_COMMON_RECORD_HEADER   sheader;
  UCHAR                       ucTMSGPIO_ID;
  UCHAR                       ucTMSGPIOState;         
  UCHAR                       ucTCKGPIO_ID;
  UCHAR                       ucTCKGPIOState;         
  UCHAR                       ucTDOGPIO_ID;
  UCHAR                       ucTDOGPIOState;         
  UCHAR                       ucTDIGPIO_ID;
  UCHAR                       ucTDIGPIOState;         
  UCHAR                       ucPadding[2];
}ATOM_JTAG_RECORD;



typedef struct _ATOM_GPIO_PIN_CONTROL_PAIR
{
  UCHAR                       ucGPIOID;               
  UCHAR                       ucGPIO_PinState;        
}ATOM_GPIO_PIN_CONTROL_PAIR;

typedef struct  _ATOM_OBJECT_GPIO_CNTL_RECORD
{
  ATOM_COMMON_RECORD_HEADER   sheader;
  UCHAR                       ucFlags;                
  UCHAR                       ucNumberOfPins;         
  ATOM_GPIO_PIN_CONTROL_PAIR  asGpio[1];              
}ATOM_OBJECT_GPIO_CNTL_RECORD;


#define GPIO_PIN_TYPE_INPUT             0x00
#define GPIO_PIN_TYPE_OUTPUT            0x10
#define GPIO_PIN_TYPE_HW_CONTROL        0x20


#define GPIO_PIN_OUTPUT_STATE_MASK      0x01
#define GPIO_PIN_OUTPUT_STATE_SHIFT     0
#define GPIO_PIN_STATE_ACTIVE_LOW       0x0
#define GPIO_PIN_STATE_ACTIVE_HIGH      0x1

typedef struct  _ATOM_ENCODER_DVO_CF_RECORD
{
  ATOM_COMMON_RECORD_HEADER   sheader;
  ULONG                       ulStrengthControl;      
  UCHAR                       ucPadding[2];
}ATOM_ENCODER_DVO_CF_RECORD;


#define ATOM_CONNECTOR_CF_RECORD_CONNECTED_UPPER12BITBUNDLEA   1
#define ATOM_CONNECTOR_CF_RECORD_CONNECTED_LOWER12BITBUNDLEB   2

typedef struct  _ATOM_CONNECTOR_CF_RECORD
{
  ATOM_COMMON_RECORD_HEADER   sheader;
  USHORT                      usMaxPixClk;
  UCHAR                       ucFlowCntlGpioId;
  UCHAR                       ucSwapCntlGpioId;
  UCHAR                       ucConnectedDvoBundle;
  UCHAR                       ucPadding;
}ATOM_CONNECTOR_CF_RECORD;

typedef struct  _ATOM_CONNECTOR_HARDCODE_DTD_RECORD
{
  ATOM_COMMON_RECORD_HEADER   sheader;
	ATOM_DTD_FORMAT							asTiming;
}ATOM_CONNECTOR_HARDCODE_DTD_RECORD;

typedef struct _ATOM_CONNECTOR_PCIE_SUBCONNECTOR_RECORD
{
  ATOM_COMMON_RECORD_HEADER   sheader;                
  UCHAR                       ucSubConnectorType;     
  UCHAR                       ucReserved;
}ATOM_CONNECTOR_PCIE_SUBCONNECTOR_RECORD;


typedef struct _ATOM_ROUTER_DDC_PATH_SELECT_RECORD
{
	ATOM_COMMON_RECORD_HEADER   sheader;                
	UCHAR												ucMuxType;							
	UCHAR												ucMuxControlPin;
	UCHAR												ucMuxState[2];					
}ATOM_ROUTER_DDC_PATH_SELECT_RECORD;

typedef struct _ATOM_ROUTER_DATA_CLOCK_PATH_SELECT_RECORD
{
	ATOM_COMMON_RECORD_HEADER   sheader;                
	UCHAR												ucMuxType;
	UCHAR												ucMuxControlPin;
	UCHAR												ucMuxState[2];					
}ATOM_ROUTER_DATA_CLOCK_PATH_SELECT_RECORD;


#define ATOM_ROUTER_MUX_PIN_STATE_MASK								0x0f
#define ATOM_ROUTER_MUX_PIN_SINGLE_STATE_COMPLEMENT		0x01

/**************************************************************************/


typedef struct  _ATOM_VOLTAGE_INFO_HEADER
{
   USHORT   usVDDCBaseLevel;                
   USHORT   usReserved;                     
   UCHAR    ucNumOfVoltageEntries;
   UCHAR    ucBytesPerVoltageEntry;
   UCHAR    ucVoltageStep;                  
   UCHAR    ucDefaultVoltageEntry;
   UCHAR    ucVoltageControlI2cLine;
   UCHAR    ucVoltageControlAddress;
   UCHAR    ucVoltageControlOffset;
}ATOM_VOLTAGE_INFO_HEADER;

typedef struct  _ATOM_VOLTAGE_INFO
{
   ATOM_COMMON_TABLE_HEADER	sHeader; 
   ATOM_VOLTAGE_INFO_HEADER viHeader;
   UCHAR    ucVoltageEntries[64];            
}ATOM_VOLTAGE_INFO;


typedef struct  _ATOM_VOLTAGE_FORMULA
{
   USHORT   usVoltageBaseLevel;             
   USHORT   usVoltageStep;                  
	 UCHAR		ucNumOfVoltageEntries;					
	 UCHAR		ucFlag;													
	 UCHAR		ucBaseVID;											
	 UCHAR		ucReserved;
	 UCHAR		ucVIDAdjustEntries[32];					
}ATOM_VOLTAGE_FORMULA;

typedef struct _ATOM_VOLTAGE_CONTROL
{
	UCHAR		 ucVoltageControlId;							
  UCHAR    ucVoltageControlI2cLine;
  UCHAR    ucVoltageControlAddress;
  UCHAR    ucVoltageControlOffset;	 	
  USHORT   usGpioPin_AIndex;								
  UCHAR    ucGpioPinBitShift[9];						
	UCHAR		 ucReserved;
}ATOM_VOLTAGE_CONTROL;


#define	VOLTAGE_CONTROLLED_BY_HW							0x00
#define	VOLTAGE_CONTROLLED_BY_I2C_MASK				0x7F
#define	VOLTAGE_CONTROLLED_BY_GPIO						0x80
#define	VOLTAGE_CONTROL_ID_LM64								0x01									
#define	VOLTAGE_CONTROL_ID_DAC								0x02									
#define	VOLTAGE_CONTROL_ID_VT116xM						0x03									
#define VOLTAGE_CONTROL_ID_DS4402							0x04									

typedef struct  _ATOM_VOLTAGE_OBJECT
{
 	 UCHAR		ucVoltageType;									
	 UCHAR		ucSize;													
	 ATOM_VOLTAGE_CONTROL			asControl;			
 	 ATOM_VOLTAGE_FORMULA			asFormula;			
}ATOM_VOLTAGE_OBJECT;

typedef struct  _ATOM_VOLTAGE_OBJECT_INFO
{
   ATOM_COMMON_TABLE_HEADER	sHeader; 
	 ATOM_VOLTAGE_OBJECT			asVoltageObj[3];	
}ATOM_VOLTAGE_OBJECT_INFO;

typedef struct  _ATOM_LEAKID_VOLTAGE
{
	UCHAR		ucLeakageId;
	UCHAR		ucReserved;
	USHORT	usVoltage;
}ATOM_LEAKID_VOLTAGE;

typedef struct  _ATOM_ASIC_PROFILE_VOLTAGE
{
	UCHAR		ucProfileId;
	UCHAR		ucReserved;
	USHORT	usSize;
	USHORT	usEfuseSpareStartAddr;
	USHORT	usFuseIndex[8];												
	ATOM_LEAKID_VOLTAGE					asLeakVol[2];			
}ATOM_ASIC_PROFILE_VOLTAGE;


#define	ATOM_ASIC_PROFILE_ID_EFUSE_VOLTAGE			1		
#define	ATOM_ASIC_PROFILE_ID_EFUSE_PERFORMANCE_VOLTAGE			1
#define	ATOM_ASIC_PROFILE_ID_EFUSE_THERMAL_VOLTAGE					2

typedef struct  _ATOM_ASIC_PROFILING_INFO
{
  ATOM_COMMON_TABLE_HEADER			asHeader; 
	ATOM_ASIC_PROFILE_VOLTAGE			asVoltage;
}ATOM_ASIC_PROFILING_INFO;

typedef struct _ATOM_POWER_SOURCE_OBJECT
{
	UCHAR	ucPwrSrcId;													
	UCHAR	ucPwrSensorType;										
	UCHAR	ucPwrSensId;											  
	UCHAR	ucPwrSensSlaveAddr;									
	UCHAR ucPwrSensRegIndex;									
	UCHAR ucPwrSensRegBitMask;								
	UCHAR	ucPwrSensActiveState;								
	UCHAR	ucReserve[3];												
	USHORT usSensPwr;													
}ATOM_POWER_SOURCE_OBJECT;

typedef struct _ATOM_POWER_SOURCE_INFO
{
		ATOM_COMMON_TABLE_HEADER		asHeader;
		UCHAR												asPwrbehave[16];
		ATOM_POWER_SOURCE_OBJECT		asPwrObj[1];
}ATOM_POWER_SOURCE_INFO;



#define POWERSOURCE_PCIE_ID1						0x00
#define POWERSOURCE_6PIN_CONNECTOR_ID1	0x01
#define POWERSOURCE_8PIN_CONNECTOR_ID1	0x02
#define POWERSOURCE_6PIN_CONNECTOR_ID2	0x04
#define POWERSOURCE_8PIN_CONNECTOR_ID2	0x08


#define POWER_SENSOR_ALWAYS							0x00
#define POWER_SENSOR_GPIO								0x01
#define POWER_SENSOR_I2C								0x02

/**************************************************************************/



#define ICS91719  1
#define ICS91720  2


typedef struct _ATOM_I2C_DATA_RECORD
{
  UCHAR         ucNunberOfBytes;                                              
  UCHAR         ucI2CData[1];                                                 
}ATOM_I2C_DATA_RECORD;



typedef struct _ATOM_I2C_DEVICE_SETUP_INFO
{
  ATOM_I2C_ID_CONFIG_ACCESS       sucI2cId;               
  UCHAR		                        ucSSChipID;             
  UCHAR		                        ucSSChipSlaveAddr;      
  UCHAR                           ucNumOfI2CDataRecords;  
  ATOM_I2C_DATA_RECORD            asI2CData[1];  
}ATOM_I2C_DEVICE_SETUP_INFO;


typedef struct  _ATOM_ASIC_MVDD_INFO
{
  ATOM_COMMON_TABLE_HEADER	      sHeader; 
  ATOM_I2C_DEVICE_SETUP_INFO      asI2CSetup[1];
}ATOM_ASIC_MVDD_INFO;


#define ATOM_MCLK_SS_INFO         ATOM_ASIC_MVDD_INFO


/**************************************************************************/

typedef struct _ATOM_ASIC_SS_ASSIGNMENT
{
	ULONG								ulTargetClockRange;						
  USHORT              usSpreadSpectrumPercentage;		
	USHORT							usSpreadRateInKhz;						
  UCHAR               ucClockIndication;					  
	UCHAR								ucSpreadSpectrumMode;					
	UCHAR								ucReserved[2];
}ATOM_ASIC_SS_ASSIGNMENT;


#define ASIC_INTERNAL_MEMORY_SS			1
#define ASIC_INTERNAL_ENGINE_SS			2
#define ASIC_INTERNAL_UVD_SS				3

typedef struct _ATOM_ASIC_INTERNAL_SS_INFO{
  ATOM_COMMON_TABLE_HEADER	      sHeader; 
  ATOM_ASIC_SS_ASSIGNMENT		      asSpreadSpectrum[4];
}ATOM_ASIC_INTERNAL_SS_INFO;


#define ATOM_DEVICE_CONNECT_INFO_DEF  0
#define ATOM_ROM_LOCATION_DEF         1
#define ATOM_TV_STANDARD_DEF          2
#define ATOM_ACTIVE_INFO_DEF          3
#define ATOM_LCD_INFO_DEF             4
#define ATOM_DOS_REQ_INFO_DEF         5
#define ATOM_ACC_CHANGE_INFO_DEF      6
#define ATOM_DOS_MODE_INFO_DEF        7
#define ATOM_I2C_CHANNEL_STATUS_DEF   8
#define ATOM_I2C_CHANNEL_STATUS1_DEF  9



#define ATOM_S0_CRT1_MONO               0x00000001L
#define ATOM_S0_CRT1_COLOR              0x00000002L
#define ATOM_S0_CRT1_MASK               (ATOM_S0_CRT1_MONO+ATOM_S0_CRT1_COLOR)

#define ATOM_S0_TV1_COMPOSITE_A         0x00000004L
#define ATOM_S0_TV1_SVIDEO_A            0x00000008L
#define ATOM_S0_TV1_MASK_A              (ATOM_S0_TV1_COMPOSITE_A+ATOM_S0_TV1_SVIDEO_A)

#define ATOM_S0_CV_A                    0x00000010L
#define ATOM_S0_CV_DIN_A                0x00000020L
#define ATOM_S0_CV_MASK_A               (ATOM_S0_CV_A+ATOM_S0_CV_DIN_A)


#define ATOM_S0_CRT2_MONO               0x00000100L
#define ATOM_S0_CRT2_COLOR              0x00000200L
#define ATOM_S0_CRT2_MASK               (ATOM_S0_CRT2_MONO+ATOM_S0_CRT2_COLOR)

#define ATOM_S0_TV1_COMPOSITE           0x00000400L
#define ATOM_S0_TV1_SVIDEO              0x00000800L
#define ATOM_S0_TV1_SCART               0x00004000L
#define ATOM_S0_TV1_MASK                (ATOM_S0_TV1_COMPOSITE+ATOM_S0_TV1_SVIDEO+ATOM_S0_TV1_SCART)

#define ATOM_S0_CV                      0x00001000L
#define ATOM_S0_CV_DIN                  0x00002000L
#define ATOM_S0_CV_MASK                 (ATOM_S0_CV+ATOM_S0_CV_DIN)


#define ATOM_S0_DFP1                    0x00010000L
#define ATOM_S0_DFP2                    0x00020000L
#define ATOM_S0_LCD1                    0x00040000L
#define ATOM_S0_LCD2                    0x00080000L
#define ATOM_S0_TV2                     0x00100000L
#define ATOM_S0_DFP3										0x00200000L

#define ATOM_S0_FAD_REGISTER_BUG        0x02000000L 
                                                    

#define ATOM_S0_THERMAL_STATE_MASK      0x1C000000L
#define ATOM_S0_THERMAL_STATE_SHIFT     26

#define ATOM_S0_SYSTEM_POWER_STATE_MASK 0xE0000000L
#define ATOM_S0_SYSTEM_POWER_STATE_SHIFT 29 

#define ATOM_S0_SYSTEM_POWER_STATE_VALUE_AC     1
#define ATOM_S0_SYSTEM_POWER_STATE_VALUE_DC     2
#define ATOM_S0_SYSTEM_POWER_STATE_VALUE_LITEAC 3


#define ATOM_S0_CRT1_MONOb0             0x01
#define ATOM_S0_CRT1_COLORb0            0x02
#define ATOM_S0_CRT1_MASKb0             (ATOM_S0_CRT1_MONOb0+ATOM_S0_CRT1_COLORb0)

#define ATOM_S0_TV1_COMPOSITEb0         0x04
#define ATOM_S0_TV1_SVIDEOb0            0x08
#define ATOM_S0_TV1_MASKb0              (ATOM_S0_TV1_COMPOSITEb0+ATOM_S0_TV1_SVIDEOb0)

#define ATOM_S0_CVb0                    0x10
#define ATOM_S0_CV_DINb0                0x20
#define ATOM_S0_CV_MASKb0               (ATOM_S0_CVb0+ATOM_S0_CV_DINb0)

#define ATOM_S0_CRT2_MONOb1             0x01
#define ATOM_S0_CRT2_COLORb1            0x02
#define ATOM_S0_CRT2_MASKb1             (ATOM_S0_CRT2_MONOb1+ATOM_S0_CRT2_COLORb1)

#define ATOM_S0_TV1_COMPOSITEb1         0x04
#define ATOM_S0_TV1_SVIDEOb1            0x08
#define ATOM_S0_TV1_SCARTb1             0x40
#define ATOM_S0_TV1_MASKb1              (ATOM_S0_TV1_COMPOSITEb1+ATOM_S0_TV1_SVIDEOb1+ATOM_S0_TV1_SCARTb1)

#define ATOM_S0_CVb1                    0x10
#define ATOM_S0_CV_DINb1                0x20
#define ATOM_S0_CV_MASKb1               (ATOM_S0_CVb1+ATOM_S0_CV_DINb1)

#define ATOM_S0_DFP1b2                  0x01
#define ATOM_S0_DFP2b2                  0x02
#define ATOM_S0_LCD1b2                  0x04
#define ATOM_S0_LCD2b2                  0x08
#define ATOM_S0_TV2b2                   0x10
#define ATOM_S0_DFP3b2									0x20

#define ATOM_S0_THERMAL_STATE_MASKb3    0x1C
#define ATOM_S0_THERMAL_STATE_SHIFTb3   2

#define ATOM_S0_SYSTEM_POWER_STATE_MASKb3 0xE0
#define ATOM_S0_LCD1_SHIFT              18


#define ATOM_S1_ROM_LOCATION_MASK       0x0000FFFFL
#define ATOM_S1_PCI_BUS_DEV_MASK        0xFFFF0000L

     

#define ATOM_S2_TV1_STANDARD_MASK       0x0000000FL
#define ATOM_S2_CURRENT_BL_LEVEL_MASK   0x0000FF00L
#define ATOM_S2_CURRENT_BL_LEVEL_SHIFT  8

#define ATOM_S2_CRT1_DPMS_STATE         0x00010000L
#define ATOM_S2_LCD1_DPMS_STATE	        0x00020000L
#define ATOM_S2_TV1_DPMS_STATE          0x00040000L
#define ATOM_S2_DFP1_DPMS_STATE         0x00080000L
#define ATOM_S2_CRT2_DPMS_STATE         0x00100000L
#define ATOM_S2_LCD2_DPMS_STATE         0x00200000L
#define ATOM_S2_TV2_DPMS_STATE          0x00400000L
#define ATOM_S2_DFP2_DPMS_STATE         0x00800000L
#define ATOM_S2_CV_DPMS_STATE           0x01000000L
#define ATOM_S2_DFP3_DPMS_STATE					0x02000000L

#define ATOM_S2_DEVICE_DPMS_STATE       (ATOM_S2_CRT1_DPMS_STATE+ATOM_S2_LCD1_DPMS_STATE+ATOM_S2_TV1_DPMS_STATE+\
                                        ATOM_S2_DFP1I_DPMS_STATE+ATOM_S2_CRT2_DPMS_STATE+ATOM_S2_LCD2_DPMS_STATE+\
                                        ATOM_S2_TV2_DPMS_STATE+ATOM_S2_DFP1X_DPMS_STATE+ATOM_S2_CV_DPMS_STATE+\
                                        ATOM_S2_DFP3_DPMS_STATE)


#define ATOM_S2_FORCEDLOWPWRMODE_STATE_MASK       0x0C000000L
#define ATOM_S2_FORCEDLOWPWRMODE_STATE_MASK_SHIFT 26
#define ATOM_S2_FORCEDLOWPWRMODE_STATE_CHANGE     0x10000000L

#define ATOM_S2_VRI_BRIGHT_ENABLE       0x20000000L

#define ATOM_S2_DISPLAY_ROTATION_0_DEGREE     0x0
#define ATOM_S2_DISPLAY_ROTATION_90_DEGREE    0x1
#define ATOM_S2_DISPLAY_ROTATION_180_DEGREE   0x2
#define ATOM_S2_DISPLAY_ROTATION_270_DEGREE   0x3
#define ATOM_S2_DISPLAY_ROTATION_DEGREE_SHIFT 30
#define ATOM_S2_DISPLAY_ROTATION_ANGLE_MASK   0xC0000000L



#define ATOM_S2_TV1_STANDARD_MASKb0     0x0F
#define ATOM_S2_CURRENT_BL_LEVEL_MASKb1 0xFF
#define ATOM_S2_CRT1_DPMS_STATEb2       0x01
#define ATOM_S2_LCD1_DPMS_STATEb2       0x02
#define ATOM_S2_TV1_DPMS_STATEb2        0x04
#define ATOM_S2_DFP1_DPMS_STATEb2       0x08
#define ATOM_S2_CRT2_DPMS_STATEb2       0x10
#define ATOM_S2_LCD2_DPMS_STATEb2       0x20
#define ATOM_S2_TV2_DPMS_STATEb2        0x40
#define ATOM_S2_DFP2_DPMS_STATEb2       0x80
#define ATOM_S2_CV_DPMS_STATEb3         0x01
#define ATOM_S2_DFP3_DPMS_STATEb3				0x02

#define ATOM_S2_DEVICE_DPMS_MASKw1      0x3FF
#define ATOM_S2_FORCEDLOWPWRMODE_STATE_MASKb3     0x0C
#define ATOM_S2_FORCEDLOWPWRMODE_STATE_CHANGEb3   0x10
#define ATOM_S2_VRI_BRIGHT_ENABLEb3     0x20
#define ATOM_S2_ROTATION_STATE_MASKb3   0xC0



#define ATOM_S3_CRT1_ACTIVE             0x00000001L
#define ATOM_S3_LCD1_ACTIVE             0x00000002L
#define ATOM_S3_TV1_ACTIVE              0x00000004L
#define ATOM_S3_DFP1_ACTIVE             0x00000008L
#define ATOM_S3_CRT2_ACTIVE             0x00000010L
#define ATOM_S3_LCD2_ACTIVE             0x00000020L
#define ATOM_S3_TV2_ACTIVE              0x00000040L
#define ATOM_S3_DFP2_ACTIVE             0x00000080L
#define ATOM_S3_CV_ACTIVE               0x00000100L
#define ATOM_S3_DFP3_ACTIVE							0x00000200L

#define ATOM_S3_DEVICE_ACTIVE_MASK      0x000003FFL

#define ATOM_S3_LCD_FULLEXPANSION_ACTIVE         0x00001000L
#define ATOM_S3_LCD_EXPANSION_ASPEC_RATIO_ACTIVE 0x00002000L

#define ATOM_S3_CRT1_CRTC_ACTIVE        0x00010000L
#define ATOM_S3_LCD1_CRTC_ACTIVE        0x00020000L
#define ATOM_S3_TV1_CRTC_ACTIVE         0x00040000L
#define ATOM_S3_DFP1_CRTC_ACTIVE        0x00080000L
#define ATOM_S3_CRT2_CRTC_ACTIVE        0x00100000L
#define ATOM_S3_LCD2_CRTC_ACTIVE        0x00200000L
#define ATOM_S3_TV2_CRTC_ACTIVE         0x00400000L
#define ATOM_S3_DFP2_CRTC_ACTIVE        0x00800000L
#define ATOM_S3_CV_CRTC_ACTIVE          0x01000000L
#define ATOM_S3_DFP3_CRTC_ACTIVE				0x02000000L

#define ATOM_S3_DEVICE_CRTC_ACTIVE_MASK 0x03FF0000L
#define ATOM_S3_ASIC_GUI_ENGINE_HUNG    0x20000000L
#define ATOM_S3_ALLOW_FAST_PWR_SWITCH   0x40000000L
#define ATOM_S3_RQST_GPU_USE_MIN_PWR    0x80000000L


#define ATOM_S3_CRT1_ACTIVEb0           0x01
#define ATOM_S3_LCD1_ACTIVEb0           0x02
#define ATOM_S3_TV1_ACTIVEb0            0x04
#define ATOM_S3_DFP1_ACTIVEb0           0x08
#define ATOM_S3_CRT2_ACTIVEb0           0x10
#define ATOM_S3_LCD2_ACTIVEb0           0x20
#define ATOM_S3_TV2_ACTIVEb0            0x40
#define ATOM_S3_DFP2_ACTIVEb0           0x80
#define ATOM_S3_CV_ACTIVEb1             0x01
#define ATOM_S3_DFP3_ACTIVEb1						0x02

#define ATOM_S3_ACTIVE_CRTC1w0          0x3FF

#define ATOM_S3_CRT1_CRTC_ACTIVEb2      0x01
#define ATOM_S3_LCD1_CRTC_ACTIVEb2      0x02
#define ATOM_S3_TV1_CRTC_ACTIVEb2       0x04
#define ATOM_S3_DFP1_CRTC_ACTIVEb2      0x08
#define ATOM_S3_CRT2_CRTC_ACTIVEb2      0x10
#define ATOM_S3_LCD2_CRTC_ACTIVEb2      0x20
#define ATOM_S3_TV2_CRTC_ACTIVEb2       0x40
#define ATOM_S3_DFP2_CRTC_ACTIVEb2      0x80
#define ATOM_S3_CV_CRTC_ACTIVEb3        0x01
#define ATOM_S3_DFP3_CRTC_ACTIVEb3			0x02

#define ATOM_S3_ACTIVE_CRTC2w1          0x3FF

#define ATOM_S3_ASIC_GUI_ENGINE_HUNGb3	0x20
#define ATOM_S3_ALLOW_FAST_PWR_SWITCHb3 0x40
#define ATOM_S3_RQST_GPU_USE_MIN_PWRb3  0x80


#define ATOM_S4_LCD1_PANEL_ID_MASK      0x000000FFL
#define ATOM_S4_LCD1_REFRESH_MASK       0x0000FF00L
#define ATOM_S4_LCD1_REFRESH_SHIFT      8



#define ATOM_S4_LCD1_PANEL_ID_MASKb0	  0x0FF
#define ATOM_S4_LCD1_REFRESH_MASKb1		  ATOM_S4_LCD1_PANEL_ID_MASKb0
#define ATOM_S4_VRAM_INFO_MASKb2        ATOM_S4_LCD1_PANEL_ID_MASKb0



#define ATOM_S5_DOS_REQ_CRT1b0          0x01
#define ATOM_S5_DOS_REQ_LCD1b0          0x02
#define ATOM_S5_DOS_REQ_TV1b0           0x04
#define ATOM_S5_DOS_REQ_DFP1b0          0x08
#define ATOM_S5_DOS_REQ_CRT2b0          0x10
#define ATOM_S5_DOS_REQ_LCD2b0          0x20
#define ATOM_S5_DOS_REQ_TV2b0           0x40
#define ATOM_S5_DOS_REQ_DFP2b0          0x80
#define ATOM_S5_DOS_REQ_CVb1            0x01
#define ATOM_S5_DOS_REQ_DFP3b1					0x02

#define ATOM_S5_DOS_REQ_DEVICEw0        0x03FF

#define ATOM_S5_DOS_REQ_CRT1            0x0001
#define ATOM_S5_DOS_REQ_LCD1            0x0002
#define ATOM_S5_DOS_REQ_TV1             0x0004
#define ATOM_S5_DOS_REQ_DFP1            0x0008
#define ATOM_S5_DOS_REQ_CRT2            0x0010
#define ATOM_S5_DOS_REQ_LCD2            0x0020
#define ATOM_S5_DOS_REQ_TV2             0x0040
#define ATOM_S5_DOS_REQ_DFP2            0x0080
#define ATOM_S5_DOS_REQ_CV              0x0100
#define ATOM_S5_DOS_REQ_DFP3						0x0200

#define ATOM_S5_DOS_FORCE_CRT1b2        ATOM_S5_DOS_REQ_CRT1b0
#define ATOM_S5_DOS_FORCE_TV1b2         ATOM_S5_DOS_REQ_TV1b0
#define ATOM_S5_DOS_FORCE_CRT2b2        ATOM_S5_DOS_REQ_CRT2b0
#define ATOM_S5_DOS_FORCE_CVb3          ATOM_S5_DOS_REQ_CVb1
#define ATOM_S5_DOS_FORCE_DEVICEw1      (ATOM_S5_DOS_FORCE_CRT1b2+ATOM_S5_DOS_FORCE_TV1b2+ATOM_S5_DOS_FORCE_CRT2b2+\
                                        (ATOM_S5_DOS_FORCE_CVb3<<8))


#define ATOM_S6_DEVICE_CHANGE           0x00000001L
#define ATOM_S6_SCALER_CHANGE           0x00000002L
#define ATOM_S6_LID_CHANGE              0x00000004L
#define ATOM_S6_DOCKING_CHANGE          0x00000008L
#define ATOM_S6_ACC_MODE                0x00000010L
#define ATOM_S6_EXT_DESKTOP_MODE        0x00000020L
#define ATOM_S6_LID_STATE               0x00000040L
#define ATOM_S6_DOCK_STATE              0x00000080L
#define ATOM_S6_CRITICAL_STATE          0x00000100L
#define ATOM_S6_HW_I2C_BUSY_STATE       0x00000200L
#define ATOM_S6_THERMAL_STATE_CHANGE    0x00000400L
#define ATOM_S6_INTERRUPT_SET_BY_BIOS   0x00000800L
#define ATOM_S6_REQ_LCD_EXPANSION_FULL         0x00001000L 
#define ATOM_S6_REQ_LCD_EXPANSION_ASPEC_RATIO  0x00002000L 

#define ATOM_S6_DISPLAY_STATE_CHANGE    0x00004000L        
#define ATOM_S6_I2C_STATE_CHANGE        0x00008000L        


#define ATOM_S6_ACC_REQ_CRT1            0x00010000L
#define ATOM_S6_ACC_REQ_LCD1            0x00020000L
#define ATOM_S6_ACC_REQ_TV1             0x00040000L
#define ATOM_S6_ACC_REQ_DFP1            0x00080000L
#define ATOM_S6_ACC_REQ_CRT2            0x00100000L
#define ATOM_S6_ACC_REQ_LCD2            0x00200000L
#define ATOM_S6_ACC_REQ_TV2             0x00400000L
#define ATOM_S6_ACC_REQ_DFP2            0x00800000L
#define ATOM_S6_ACC_REQ_CV              0x01000000L
#define ATOM_S6_ACC_REQ_DFP3						0x02000000L

#define ATOM_S6_ACC_REQ_MASK                0x03FF0000L
#define ATOM_S6_SYSTEM_POWER_MODE_CHANGE    0x10000000L
#define ATOM_S6_ACC_BLOCK_DISPLAY_SWITCH    0x20000000L
#define ATOM_S6_VRI_BRIGHTNESS_CHANGE       0x40000000L
#define ATOM_S6_CONFIG_DISPLAY_CHANGE_MASK  0x80000000L


#define ATOM_S6_DEVICE_CHANGEb0         0x01
#define ATOM_S6_SCALER_CHANGEb0         0x02
#define ATOM_S6_LID_CHANGEb0            0x04
#define ATOM_S6_DOCKING_CHANGEb0        0x08
#define ATOM_S6_ACC_MODEb0              0x10
#define ATOM_S6_EXT_DESKTOP_MODEb0      0x20
#define ATOM_S6_LID_STATEb0             0x40
#define ATOM_S6_DOCK_STATEb0            0x80
#define ATOM_S6_CRITICAL_STATEb1        0x01
#define ATOM_S6_HW_I2C_BUSY_STATEb1     0x02  
#define ATOM_S6_THERMAL_STATE_CHANGEb1  0x04
#define ATOM_S6_INTERRUPT_SET_BY_BIOSb1 0x08
#define ATOM_S6_REQ_LCD_EXPANSION_FULLb1        0x10    
#define ATOM_S6_REQ_LCD_EXPANSION_ASPEC_RATIOb1 0x20 

#define ATOM_S6_ACC_REQ_CRT1b2          0x01
#define ATOM_S6_ACC_REQ_LCD1b2          0x02
#define ATOM_S6_ACC_REQ_TV1b2           0x04
#define ATOM_S6_ACC_REQ_DFP1b2          0x08
#define ATOM_S6_ACC_REQ_CRT2b2          0x10
#define ATOM_S6_ACC_REQ_LCD2b2          0x20
#define ATOM_S6_ACC_REQ_TV2b2           0x40
#define ATOM_S6_ACC_REQ_DFP2b2          0x80
#define ATOM_S6_ACC_REQ_CVb3            0x01
#define ATOM_S6_ACC_REQ_DFP3b3					0x02

#define ATOM_S6_ACC_REQ_DEVICEw1        ATOM_S5_DOS_REQ_DEVICEw0
#define ATOM_S6_SYSTEM_POWER_MODE_CHANGEb3 0x10
#define ATOM_S6_ACC_BLOCK_DISPLAY_SWITCHb3 0x20
#define ATOM_S6_VRI_BRIGHTNESS_CHANGEb3    0x40
#define ATOM_S6_CONFIG_DISPLAY_CHANGEb3    0x80

#define ATOM_S6_DEVICE_CHANGE_SHIFT             0
#define ATOM_S6_SCALER_CHANGE_SHIFT             1
#define ATOM_S6_LID_CHANGE_SHIFT                2
#define ATOM_S6_DOCKING_CHANGE_SHIFT            3
#define ATOM_S6_ACC_MODE_SHIFT                  4
#define ATOM_S6_EXT_DESKTOP_MODE_SHIFT          5
#define ATOM_S6_LID_STATE_SHIFT                 6
#define ATOM_S6_DOCK_STATE_SHIFT                7
#define ATOM_S6_CRITICAL_STATE_SHIFT            8
#define ATOM_S6_HW_I2C_BUSY_STATE_SHIFT         9
#define ATOM_S6_THERMAL_STATE_CHANGE_SHIFT      10
#define ATOM_S6_INTERRUPT_SET_BY_BIOS_SHIFT     11
#define ATOM_S6_REQ_SCALER_SHIFT                12
#define ATOM_S6_REQ_SCALER_ARATIO_SHIFT         13
#define ATOM_S6_DISPLAY_STATE_CHANGE_SHIFT      14
#define ATOM_S6_I2C_STATE_CHANGE_SHIFT          15
#define ATOM_S6_SYSTEM_POWER_MODE_CHANGE_SHIFT  28
#define ATOM_S6_ACC_BLOCK_DISPLAY_SWITCH_SHIFT  29
#define ATOM_S6_VRI_BRIGHTNESS_CHANGE_SHIFT     30
#define ATOM_S6_CONFIG_DISPLAY_CHANGE_SHIFT     31


#define ATOM_S7_DOS_MODE_TYPEb0             0x03
#define ATOM_S7_DOS_MODE_VGAb0              0x00
#define ATOM_S7_DOS_MODE_VESAb0             0x01
#define ATOM_S7_DOS_MODE_EXTb0              0x02
#define ATOM_S7_DOS_MODE_PIXEL_DEPTHb0      0x0C
#define ATOM_S7_DOS_MODE_PIXEL_FORMATb0     0xF0
#define ATOM_S7_DOS_8BIT_DAC_ENb1           0x01
#define ATOM_S7_DOS_MODE_NUMBERw1           0x0FFFF

#define ATOM_S7_DOS_8BIT_DAC_EN_SHIFT       8


#define ATOM_S8_I2C_CHANNEL_BUSY_MASK       0x00000FFFF
#define ATOM_S8_I2C_HW_ENGINE_BUSY_MASK     0x0FFFF0000   

#define ATOM_S8_I2C_CHANNEL_BUSY_SHIFT      0
#define ATOM_S8_I2C_ENGINE_BUSY_SHIFT       16


#ifndef ATOM_S9_I2C_CHANNEL_COMPLETED_MASK 
#define ATOM_S9_I2C_CHANNEL_COMPLETED_MASK  0x0000FFFF
#endif
#ifndef ATOM_S9_I2C_CHANNEL_ABORTED_MASK  
#define ATOM_S9_I2C_CHANNEL_ABORTED_MASK    0xFFFF0000
#endif
#ifndef ATOM_S9_I2C_CHANNEL_COMPLETED_SHIFT 
#define ATOM_S9_I2C_CHANNEL_COMPLETED_SHIFT 0
#endif
#ifndef ATOM_S9_I2C_CHANNEL_ABORTED_SHIFT   
#define ATOM_S9_I2C_CHANNEL_ABORTED_SHIFT   16
#endif

 
#define ATOM_FLAG_SET                         0x20
#define ATOM_FLAG_CLEAR                       0
#define CLEAR_ATOM_S6_ACC_MODE                ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_ACC_MODE_SHIFT | ATOM_FLAG_CLEAR)
#define SET_ATOM_S6_DEVICE_CHANGE             ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_DEVICE_CHANGE_SHIFT | ATOM_FLAG_SET)
#define SET_ATOM_S6_VRI_BRIGHTNESS_CHANGE     ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_VRI_BRIGHTNESS_CHANGE_SHIFT | ATOM_FLAG_SET)
#define SET_ATOM_S6_SCALER_CHANGE             ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_SCALER_CHANGE_SHIFT | ATOM_FLAG_SET)
#define SET_ATOM_S6_LID_CHANGE                ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_LID_CHANGE_SHIFT | ATOM_FLAG_SET)

#define SET_ATOM_S6_LID_STATE                 ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_LID_STATE_SHIFT | ATOM_FLAG_SET)
#define CLEAR_ATOM_S6_LID_STATE               ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_LID_STATE_SHIFT | ATOM_FLAG_CLEAR)

#define SET_ATOM_S6_DOCK_CHANGE			          ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_DOCKING_CHANGE_SHIFT | ATOM_FLAG_SET)
#define SET_ATOM_S6_DOCK_STATE                ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_DOCK_STATE_SHIFT | ATOM_FLAG_SET)
#define CLEAR_ATOM_S6_DOCK_STATE              ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_DOCK_STATE_SHIFT | ATOM_FLAG_CLEAR)

#define SET_ATOM_S6_THERMAL_STATE_CHANGE      ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_THERMAL_STATE_CHANGE_SHIFT | ATOM_FLAG_SET)
#define SET_ATOM_S6_SYSTEM_POWER_MODE_CHANGE  ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_SYSTEM_POWER_MODE_CHANGE_SHIFT | ATOM_FLAG_SET)
#define SET_ATOM_S6_INTERRUPT_SET_BY_BIOS     ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_INTERRUPT_SET_BY_BIOS_SHIFT | ATOM_FLAG_SET)

#define SET_ATOM_S6_CRITICAL_STATE            ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_CRITICAL_STATE_SHIFT | ATOM_FLAG_SET)
#define CLEAR_ATOM_S6_CRITICAL_STATE          ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_CRITICAL_STATE_SHIFT | ATOM_FLAG_CLEAR)

#define SET_ATOM_S6_REQ_SCALER                ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_REQ_SCALER_SHIFT | ATOM_FLAG_SET)  
#define CLEAR_ATOM_S6_REQ_SCALER              ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_REQ_SCALER_SHIFT | ATOM_FLAG_CLEAR )

#define SET_ATOM_S6_REQ_SCALER_ARATIO         ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_REQ_SCALER_ARATIO_SHIFT | ATOM_FLAG_SET )
#define CLEAR_ATOM_S6_REQ_SCALER_ARATIO       ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_REQ_SCALER_ARATIO_SHIFT | ATOM_FLAG_CLEAR )

#define SET_ATOM_S6_I2C_STATE_CHANGE          ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_I2C_STATE_CHANGE_SHIFT | ATOM_FLAG_SET )

#define SET_ATOM_S6_DISPLAY_STATE_CHANGE      ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_DISPLAY_STATE_CHANGE_SHIFT | ATOM_FLAG_SET )

#define SET_ATOM_S6_DEVICE_RECONFIG           ((ATOM_ACC_CHANGE_INFO_DEF << 8 )|ATOM_S6_CONFIG_DISPLAY_CHANGE_SHIFT | ATOM_FLAG_SET)
#define CLEAR_ATOM_S0_LCD1                    ((ATOM_DEVICE_CONNECT_INFO_DEF << 8 )|  ATOM_S0_LCD1_SHIFT | ATOM_FLAG_CLEAR )
#define SET_ATOM_S7_DOS_8BIT_DAC_EN           ((ATOM_DOS_MODE_INFO_DEF << 8 )|ATOM_S7_DOS_8BIT_DAC_EN_SHIFT | ATOM_FLAG_SET )
#define CLEAR_ATOM_S7_DOS_8BIT_DAC_EN         ((ATOM_DOS_MODE_INFO_DEF << 8 )|ATOM_S7_DOS_8BIT_DAC_EN_SHIFT | ATOM_FLAG_CLEAR )

/****************************************************************************/	

/****************************************************************************/



#define	GetIndexIntoMasterTable(MasterOrData, FieldName) (((char*)(&((ATOM_MASTER_LIST_OF_##MasterOrData##_TABLES*)0)->FieldName)-(char*)0)/sizeof(USHORT))

#define GET_COMMAND_TABLE_COMMANDSET_REVISION(TABLE_HEADER_OFFSET) ((((ATOM_COMMON_TABLE_HEADER*)TABLE_HEADER_OFFSET)->ucTableFormatRevision)&0x3F)
#define GET_COMMAND_TABLE_PARAMETER_REVISION(TABLE_HEADER_OFFSET)  ((((ATOM_COMMON_TABLE_HEADER*)TABLE_HEADER_OFFSET)->ucTableContentRevision)&0x3F)

#define GET_DATA_TABLE_MAJOR_REVISION GET_COMMAND_TABLE_COMMANDSET_REVISION
#define GET_DATA_TABLE_MINOR_REVISION GET_COMMAND_TABLE_PARAMETER_REVISION

/****************************************************************************/	

/****************************************************************************/
#define ATOM_DAC_SRC					0x80
#define ATOM_SRC_DAC1					0
#define ATOM_SRC_DAC2					0x80


#ifdef	UEFI_BUILD
	#define	USHORT	UTEMP
#endif

typedef struct _MEMORY_PLLINIT_PARAMETERS
{
  ULONG ulTargetMemoryClock; 
  UCHAR   ucAction;					 
  UCHAR   ucFbDiv_Hi;				 
  UCHAR   ucFbDiv;					 
  UCHAR   ucPostDiv;				 
}MEMORY_PLLINIT_PARAMETERS;

#define MEMORY_PLLINIT_PS_ALLOCATION  MEMORY_PLLINIT_PARAMETERS


#define	GPIO_PIN_WRITE													0x01			
#define	GPIO_PIN_READ														0x00

typedef struct  _GPIO_PIN_CONTROL_PARAMETERS
{
  UCHAR ucGPIO_ID;           
  UCHAR ucGPIOBitShift;	     
	UCHAR ucGPIOBitVal;		     
  UCHAR ucAction;				     
}GPIO_PIN_CONTROL_PARAMETERS;

typedef struct _ENABLE_SCALER_PARAMETERS
{
  UCHAR ucScaler;            
  UCHAR ucEnable;            
  UCHAR ucTVStandard;        
  UCHAR ucPadding[1];
}ENABLE_SCALER_PARAMETERS; 
#define ENABLE_SCALER_PS_ALLOCATION ENABLE_SCALER_PARAMETERS 


#define SCALER_BYPASS_AUTO_CENTER_NO_REPLICATION    0
#define SCALER_BYPASS_AUTO_CENTER_AUTO_REPLICATION  1
#define SCALER_ENABLE_2TAP_ALPHA_MODE               2
#define SCALER_ENABLE_MULTITAP_MODE                 3

typedef struct _ENABLE_HARDWARE_ICON_CURSOR_PARAMETERS
{
  ULONG  usHWIconHorzVertPosn;        
  UCHAR  ucHWIconVertOffset;          
  UCHAR  ucHWIconHorzOffset;          
  UCHAR  ucSelection;                 
  UCHAR  ucEnable;                    
}ENABLE_HARDWARE_ICON_CURSOR_PARAMETERS;

typedef struct _ENABLE_HARDWARE_ICON_CURSOR_PS_ALLOCATION
{
  ENABLE_HARDWARE_ICON_CURSOR_PARAMETERS  sEnableIcon;
  ENABLE_CRTC_PARAMETERS                  sReserved;  
}ENABLE_HARDWARE_ICON_CURSOR_PS_ALLOCATION;

typedef struct _ENABLE_GRAPH_SURFACE_PARAMETERS
{
  USHORT usHight;                     
  USHORT usWidth;                     
  UCHAR  ucSurface;                   
  UCHAR  ucPadding[3];
}ENABLE_GRAPH_SURFACE_PARAMETERS;

typedef struct _ENABLE_GRAPH_SURFACE_PARAMETERS_V1_2
{
  USHORT usHight;                     
  USHORT usWidth;                     
  UCHAR  ucSurface;                   
  UCHAR  ucEnable;                    
  UCHAR  ucPadding[2];
}ENABLE_GRAPH_SURFACE_PARAMETERS_V1_2;

typedef struct _ENABLE_GRAPH_SURFACE_PS_ALLOCATION
{
  ENABLE_GRAPH_SURFACE_PARAMETERS sSetSurface;          
  ENABLE_YUV_PS_ALLOCATION        sReserved; 
}ENABLE_GRAPH_SURFACE_PS_ALLOCATION;

typedef struct _MEMORY_CLEAN_UP_PARAMETERS
{
  USHORT  usMemoryStart;                
  USHORT  usMemorySize;                 
}MEMORY_CLEAN_UP_PARAMETERS;
#define MEMORY_CLEAN_UP_PS_ALLOCATION MEMORY_CLEAN_UP_PARAMETERS

typedef struct  _GET_DISPLAY_SURFACE_SIZE_PARAMETERS
{
  USHORT  usX_Size;                     
  USHORT  usY_Size;
}GET_DISPLAY_SURFACE_SIZE_PARAMETERS; 

typedef struct _INDIRECT_IO_ACCESS
{
  ATOM_COMMON_TABLE_HEADER sHeader;  
  UCHAR                    IOAccessSequence[256];
} INDIRECT_IO_ACCESS;

#define INDIRECT_READ              0x00
#define INDIRECT_WRITE             0x80

#define INDIRECT_IO_MM             0
#define INDIRECT_IO_PLL            1
#define INDIRECT_IO_MC             2
#define INDIRECT_IO_PCIE           3
#define INDIRECT_IO_PCIEP          4
#define INDIRECT_IO_NBMISC         5

#define INDIRECT_IO_PLL_READ       INDIRECT_IO_PLL   | INDIRECT_READ
#define INDIRECT_IO_PLL_WRITE      INDIRECT_IO_PLL   | INDIRECT_WRITE
#define INDIRECT_IO_MC_READ        INDIRECT_IO_MC    | INDIRECT_READ
#define INDIRECT_IO_MC_WRITE       INDIRECT_IO_MC    | INDIRECT_WRITE
#define INDIRECT_IO_PCIE_READ      INDIRECT_IO_PCIE  | INDIRECT_READ
#define INDIRECT_IO_PCIE_WRITE     INDIRECT_IO_PCIE  | INDIRECT_WRITE
#define INDIRECT_IO_PCIEP_READ     INDIRECT_IO_PCIEP | INDIRECT_READ
#define INDIRECT_IO_PCIEP_WRITE    INDIRECT_IO_PCIEP | INDIRECT_WRITE
#define INDIRECT_IO_NBMISC_READ    INDIRECT_IO_NBMISC | INDIRECT_READ
#define INDIRECT_IO_NBMISC_WRITE   INDIRECT_IO_NBMISC | INDIRECT_WRITE

typedef struct _ATOM_OEM_INFO
{ 
  ATOM_COMMON_TABLE_HEADER	sHeader;
  ATOM_I2C_ID_CONFIG_ACCESS sucI2cId;
}ATOM_OEM_INFO;

typedef struct _ATOM_TV_MODE
{
   UCHAR	ucVMode_Num;			  
   UCHAR	ucTV_Mode_Num;			
}ATOM_TV_MODE;

typedef struct _ATOM_BIOS_INT_TVSTD_MODE
{
  ATOM_COMMON_TABLE_HEADER sHeader;  
   USHORT	usTV_Mode_LUT_Offset;	
   USHORT	usTV_FIFO_Offset;		  
   USHORT	usNTSC_Tbl_Offset;		
   USHORT	usPAL_Tbl_Offset;		  
   USHORT	usCV_Tbl_Offset;		  
}ATOM_BIOS_INT_TVSTD_MODE;


typedef struct _ATOM_TV_MODE_SCALER_PTR
{
   USHORT	ucFilter0_Offset;		
   USHORT	usFilter1_Offset;		
   UCHAR	ucTV_Mode_Num;
}ATOM_TV_MODE_SCALER_PTR;

typedef struct _ATOM_STANDARD_VESA_TIMING
{
  ATOM_COMMON_TABLE_HEADER sHeader;  
  ATOM_MODE_TIMING				 aModeTimings[16];      
}ATOM_STANDARD_VESA_TIMING;


typedef struct _ATOM_STD_FORMAT
{ 
  USHORT    usSTD_HDisp;
  USHORT    usSTD_VDisp;
  USHORT    usSTD_RefreshRate;
  USHORT    usReserved;
}ATOM_STD_FORMAT;

typedef struct _ATOM_VESA_TO_EXTENDED_MODE
{
  USHORT  usVESA_ModeNumber;
  USHORT  usExtendedModeNumber;
}ATOM_VESA_TO_EXTENDED_MODE;

typedef struct _ATOM_VESA_TO_INTENAL_MODE_LUT
{ 
  ATOM_COMMON_TABLE_HEADER   sHeader;  
  ATOM_VESA_TO_EXTENDED_MODE asVESA_ToExtendedModeInfo[76];
}ATOM_VESA_TO_INTENAL_MODE_LUT;

/*************** ATOM Memory Related Data Structure ***********************/
typedef struct _ATOM_MEMORY_VENDOR_BLOCK{
	UCHAR												ucMemoryType;
	UCHAR												ucMemoryVendor;
	UCHAR												ucAdjMCId;
	UCHAR												ucDynClkId;
	ULONG												ulDllResetClkRange;
}ATOM_MEMORY_VENDOR_BLOCK;


typedef struct _ATOM_MEMORY_SETTING_ID_CONFIG{
	ULONG												ulMemClockRange:24;
	ULONG												ucMemBlkId:8;
}ATOM_MEMORY_SETTING_ID_CONFIG;

typedef union _ATOM_MEMORY_SETTING_ID_CONFIG_ACCESS
{
  ATOM_MEMORY_SETTING_ID_CONFIG slAccess;
  ULONG                         ulAccess;
}ATOM_MEMORY_SETTING_ID_CONFIG_ACCESS;


typedef struct _ATOM_MEMORY_SETTING_DATA_BLOCK{
	ATOM_MEMORY_SETTING_ID_CONFIG_ACCESS			ulMemoryID;
	ULONG															        aulMemData[1];
}ATOM_MEMORY_SETTING_DATA_BLOCK;


typedef struct _ATOM_INIT_REG_INDEX_FORMAT{
	 USHORT											usRegIndex;                                     
	 UCHAR											ucPreRegDataLength;                             
}ATOM_INIT_REG_INDEX_FORMAT;


typedef struct _ATOM_INIT_REG_BLOCK{
	USHORT													usRegIndexTblSize;													
	USHORT													usRegDataBlkSize;														
	ATOM_INIT_REG_INDEX_FORMAT			asRegIndexBuf[1];
	ATOM_MEMORY_SETTING_DATA_BLOCK	asRegDataBuf[1];
}ATOM_INIT_REG_BLOCK;

#define END_OF_REG_INDEX_BLOCK  0x0ffff
#define END_OF_REG_DATA_BLOCK   0x00000000
#define ATOM_INIT_REG_MASK_FLAG 0x80
#define	CLOCK_RANGE_HIGHEST			0x00ffffff

#define VALUE_DWORD             SIZEOF ULONG
#define VALUE_SAME_AS_ABOVE     0
#define VALUE_MASK_DWORD        0x84

typedef struct _ATOM_MC_INIT_PARAM_TABLE
{ 
  ATOM_COMMON_TABLE_HEADER		sHeader;
  USHORT											usAdjustARB_SEQDataOffset;
  USHORT											usMCInitMemTypeTblOffset;
  USHORT											usMCInitCommonTblOffset;
  USHORT											usMCInitPowerDownTblOffset;
	ULONG												ulARB_SEQDataBuf[32];
	ATOM_INIT_REG_BLOCK					asMCInitMemType;
	ATOM_INIT_REG_BLOCK					asMCInitCommon;
}ATOM_MC_INIT_PARAM_TABLE;


#define _4Mx16              0x2
#define _4Mx32              0x3
#define _8Mx16              0x12
#define _8Mx32              0x13
#define _16Mx16             0x22
#define _16Mx32             0x23
#define _32Mx16             0x32
#define _32Mx32             0x33
#define _64Mx8              0x41
#define _64Mx16             0x42

#define SAMSUNG             0x1
#define INFINEON            0x2
#define ELPIDA              0x3
#define ETRON               0x4
#define NANYA               0x5
#define HYNIX               0x6
#define MOSEL               0x7
#define WINBOND             0x8
#define ESMT                0x9
#define MICRON              0xF

#define QIMONDA             INFINEON
#define PROMOS              MOSEL

#define ATOM_MAX_NUMBER_OF_VRAM_MODULE	16

#define ATOM_VRAM_MODULE_MEMORY_VENDOR_ID_MASK	0xF
typedef struct _ATOM_VRAM_MODULE_V1
{
  ULONG                      ulReserved;
  USHORT                     usEMRSValue;  
  USHORT                     usMRSValue;
  USHORT                     usReserved;
  UCHAR                      ucExtMemoryID;     
  UCHAR                      ucMemoryType;      
  UCHAR                      ucMemoryVenderID;  
  UCHAR                      ucMemoryDeviceCfg; 
  UCHAR                      ucRow;             
  UCHAR                      ucColumn;          
  UCHAR                      ucBank;            
  UCHAR                      ucRank;            
  UCHAR                      ucChannelNum;      
  UCHAR                      ucChannelConfig;   
  UCHAR                      ucDefaultMVDDQ_ID; 
  UCHAR                      ucDefaultMVDDC_ID; 
  UCHAR                      ucReserved[2];
}ATOM_VRAM_MODULE_V1;


typedef struct _ATOM_VRAM_MODULE_V2
{
  ULONG                      ulReserved;
  ULONG                      ulFlags;     			
  ULONG                      ulEngineClock;     
  ULONG                      ulMemoryClock;     
  USHORT                     usEMRS2Value;      
  USHORT                     usEMRS3Value;      
  USHORT                     usEMRSValue;  
  USHORT                     usMRSValue;
  USHORT                     usReserved;
  UCHAR                      ucExtMemoryID;     
  UCHAR                      ucMemoryType;      
  UCHAR                      ucMemoryVenderID;  
  UCHAR                      ucMemoryDeviceCfg; 
  UCHAR                      ucRow;             
  UCHAR                      ucColumn;          
  UCHAR                      ucBank;            
  UCHAR                      ucRank;            
  UCHAR                      ucChannelNum;      
  UCHAR                      ucChannelConfig;   
  UCHAR                      ucDefaultMVDDQ_ID; 
  UCHAR                      ucDefaultMVDDC_ID; 
  UCHAR                      ucRefreshRateFactor;
  UCHAR                      ucReserved[3];
}ATOM_VRAM_MODULE_V2;


typedef	struct _ATOM_MEMORY_TIMING_FORMAT
{
	ULONG											 ulClkRange;				
	USHORT										 usMRS;							
	USHORT										 usEMRS;						
	UCHAR											 ucCL;							
	UCHAR											 ucWL;							
	UCHAR											 uctRAS;						
	UCHAR											 uctRC;							
	UCHAR											 uctRFC;						
	UCHAR											 uctRCDR;						
	UCHAR											 uctRCDW;						
	UCHAR											 uctRP;							
	UCHAR											 uctRRD;						
	UCHAR											 uctWR;							
	UCHAR											 uctWTR;						
	UCHAR											 uctPDIX;						
	UCHAR											 uctFAW;						
	UCHAR											 uctAOND;						
	UCHAR											 ucflag;						
	UCHAR											 ucReserved;				
}ATOM_MEMORY_TIMING_FORMAT;

#define	MEM_TIMING_FLAG_APP_MODE								0x01									

typedef	struct _ATOM_MEMORY_FORMAT
{
	ULONG											 ulDllDisClock;			
  USHORT                     usEMRS2Value;      
  USHORT                     usEMRS3Value;      
  UCHAR                      ucMemoryType;      
  UCHAR                      ucMemoryVenderID;  
  UCHAR                      ucRow;             
  UCHAR                      ucColumn;          
  UCHAR                      ucBank;            
  UCHAR                      ucRank;            
	UCHAR											 ucBurstSize;				
  UCHAR                      ucDllDisBit;				
  UCHAR                      ucRefreshRateFactor;	
	UCHAR											 ucDensity;					
	UCHAR											 ucPreamble;				
  UCHAR											 ucMemAttrib;				
	ATOM_MEMORY_TIMING_FORMAT	 asMemTiming[5];		
}ATOM_MEMORY_FORMAT;


typedef struct _ATOM_VRAM_MODULE_V3
{
	ULONG											 ulChannelMapCfg;		
	USHORT										 usSize;						
  USHORT                     usDefaultMVDDQ;		
  USHORT                     usDefaultMVDDC;		
	UCHAR                      ucExtMemoryID;     
  UCHAR                      ucChannelNum;      
	UCHAR											 ucChannelSize;			
	UCHAR											 ucVREFI;						
	UCHAR											 ucNPL_RT;					
	UCHAR											 ucFlag;						
	ATOM_MEMORY_FORMAT				 asMemory;					
}ATOM_VRAM_MODULE_V3;



#define NPL_RT_MASK															0x0f
#define BATTERY_ODT_MASK												0xc0

#define ATOM_VRAM_MODULE		 ATOM_VRAM_MODULE_V3

typedef struct _ATOM_VRAM_INFO_V2
{
  ATOM_COMMON_TABLE_HEADER   sHeader;
  UCHAR                      ucNumOfVRAMModule;
  ATOM_VRAM_MODULE           aVramInfo[ATOM_MAX_NUMBER_OF_VRAM_MODULE];      
}ATOM_VRAM_INFO_V2;

typedef struct _ATOM_VRAM_INFO_V3
{
  ATOM_COMMON_TABLE_HEADER   sHeader;
	USHORT										 usMemAdjustTblOffset;													 
	USHORT										 usMemClkPatchTblOffset;												 
	USHORT										 usRerseved;
	UCHAR           	         aVID_PinsShift[9];															 
  UCHAR                      ucNumOfVRAMModule;
  ATOM_VRAM_MODULE		       aVramInfo[ATOM_MAX_NUMBER_OF_VRAM_MODULE];      
	ATOM_INIT_REG_BLOCK				 asMemPatch;																		 
																																						 
}ATOM_VRAM_INFO_V3;

#define	ATOM_VRAM_INFO_LAST	     ATOM_VRAM_INFO_V3

typedef struct _ATOM_VRAM_GPIO_DETECTION_INFO
{
  ATOM_COMMON_TABLE_HEADER   sHeader;
  UCHAR           	         aVID_PinsShift[9];   
}ATOM_VRAM_GPIO_DETECTION_INFO;


typedef struct _ATOM_MEMORY_TRAINING_INFO
{
	ATOM_COMMON_TABLE_HEADER   sHeader;
	UCHAR											 ucTrainingLoop;
	UCHAR											 ucReserved[3];
	ATOM_INIT_REG_BLOCK				 asMemTrainingSetting;
}ATOM_MEMORY_TRAINING_INFO;


typedef struct SW_I2C_CNTL_DATA_PARAMETERS
{
  UCHAR    ucControl;
  UCHAR    ucData; 
  UCHAR    ucSatus; 
  UCHAR    ucTemp; 
} SW_I2C_CNTL_DATA_PARAMETERS;

#define SW_I2C_CNTL_DATA_PS_ALLOCATION  SW_I2C_CNTL_DATA_PARAMETERS

typedef struct _SW_I2C_IO_DATA_PARAMETERS
{                               
  USHORT   GPIO_Info;
  UCHAR    ucAct; 
  UCHAR    ucData; 
 } SW_I2C_IO_DATA_PARAMETERS;

#define SW_I2C_IO_DATA_PS_ALLOCATION  SW_I2C_IO_DATA_PARAMETERS

/****************************SW I2C CNTL DEFINITIONS**********************/
#define SW_I2C_IO_RESET       0
#define SW_I2C_IO_GET         1
#define SW_I2C_IO_DRIVE       2
#define SW_I2C_IO_SET         3
#define SW_I2C_IO_START       4

#define SW_I2C_IO_CLOCK       0
#define SW_I2C_IO_DATA        0x80

#define SW_I2C_IO_ZERO        0
#define SW_I2C_IO_ONE         0x100

#define SW_I2C_CNTL_READ      0
#define SW_I2C_CNTL_WRITE     1
#define SW_I2C_CNTL_START     2
#define SW_I2C_CNTL_STOP      3
#define SW_I2C_CNTL_OPEN      4
#define SW_I2C_CNTL_CLOSE     5
#define SW_I2C_CNTL_WRITE1BIT 6


#define VESA_OEM_PRODUCT_REV			            '01.00'
#define VESA_MODE_ATTRIBUTE_MODE_SUPPORT	     0xBB	
#define VESA_MODE_WIN_ATTRIBUTE						     7
#define VESA_WIN_SIZE											     64

typedef struct _PTR_32_BIT_STRUCTURE
{
	USHORT	Offset16;			
	USHORT	Segment16;				
} PTR_32_BIT_STRUCTURE;

typedef union _PTR_32_BIT_UNION
{
	PTR_32_BIT_STRUCTURE	SegmentOffset;
	ULONG					        Ptr32_Bit;
} PTR_32_BIT_UNION;

typedef struct _VBE_1_2_INFO_BLOCK_UPDATABLE
{
	UCHAR				      VbeSignature[4];
	USHORT				    VbeVersion;
	PTR_32_BIT_UNION	OemStringPtr;
	UCHAR				      Capabilities[4];
	PTR_32_BIT_UNION	VideoModePtr;
	USHORT				    TotalMemory;
} VBE_1_2_INFO_BLOCK_UPDATABLE;


typedef struct _VBE_2_0_INFO_BLOCK_UPDATABLE
{
	VBE_1_2_INFO_BLOCK_UPDATABLE	CommonBlock;
	USHORT							    OemSoftRev;
	PTR_32_BIT_UNION				OemVendorNamePtr;
	PTR_32_BIT_UNION				OemProductNamePtr;
	PTR_32_BIT_UNION				OemProductRevPtr;
} VBE_2_0_INFO_BLOCK_UPDATABLE;

typedef union _VBE_VERSION_UNION
{
	VBE_2_0_INFO_BLOCK_UPDATABLE	VBE_2_0_InfoBlock;
	VBE_1_2_INFO_BLOCK_UPDATABLE	VBE_1_2_InfoBlock;
} VBE_VERSION_UNION;

typedef struct _VBE_INFO_BLOCK
{
	VBE_VERSION_UNION			UpdatableVBE_Info;
	UCHAR						      Reserved[222];
	UCHAR						      OemData[256];
} VBE_INFO_BLOCK;

typedef struct _VBE_FP_INFO
{
  USHORT	HSize;
	USHORT	VSize;
	USHORT	FPType;
	UCHAR		RedBPP;
	UCHAR		GreenBPP;
	UCHAR		BlueBPP;
	UCHAR		ReservedBPP;
	ULONG		RsvdOffScrnMemSize;
	ULONG		RsvdOffScrnMEmPtr;
	UCHAR		Reserved[14];
} VBE_FP_INFO;

typedef struct _VESA_MODE_INFO_BLOCK
{

  USHORT    ModeAttributes;  
	UCHAR     WinAAttributes;  
	UCHAR     WinBAttributes;  
	USHORT    WinGranularity;  
	USHORT    WinSize;         
	USHORT    WinASegment;     
	USHORT    WinBSegment;     
	ULONG     WinFuncPtr;      
	USHORT    BytesPerScanLine;


  USHORT    XResolution;      
	USHORT    YResolution;      
	UCHAR     XCharSize;        
	UCHAR     YCharSize;        
	UCHAR     NumberOfPlanes;   
	UCHAR     BitsPerPixel;     
	UCHAR     NumberOfBanks;    
	UCHAR     MemoryModel;      
	UCHAR     BankSize;         
	UCHAR     NumberOfImagePages;
	UCHAR     ReservedForPageFunction;


	UCHAR			RedMaskSize;        
	UCHAR			RedFieldPosition;   
	UCHAR			GreenMaskSize;      
	UCHAR			GreenFieldPosition; 
	UCHAR			BlueMaskSize;       
	UCHAR			BlueFieldPosition;  
	UCHAR			RsvdMaskSize;       
	UCHAR			RsvdFieldPosition;  
	UCHAR			DirectColorModeInfo;


	ULONG			PhysBasePtr;        
	ULONG			Reserved_1;         
	USHORT		Reserved_2;         


	USHORT		LinBytesPerScanLine;  
	UCHAR			BnkNumberOfImagePages;
	UCHAR			LinNumberOfImagPages; 
	UCHAR			LinRedMaskSize;       
	UCHAR			LinRedFieldPosition;  
	UCHAR			LinGreenMaskSize;     
	UCHAR			LinGreenFieldPosition;
	UCHAR			LinBlueMaskSize;      
	UCHAR			LinBlueFieldPosition; 
	UCHAR			LinRsvdMaskSize;      
	UCHAR			LinRsvdFieldPosition; 
	ULONG			MaxPixelClock;        
	UCHAR			Reserved;             
} VESA_MODE_INFO_BLOCK;


#define ATOM_BIOS_EXTENDED_FUNCTION_CODE        0xA0	        
#define ATOM_BIOS_FUNCTION_COP_MODE             0x00
#define ATOM_BIOS_FUNCTION_SHORT_QUERY1         0x04
#define ATOM_BIOS_FUNCTION_SHORT_QUERY2         0x05
#define ATOM_BIOS_FUNCTION_SHORT_QUERY3         0x06
#define ATOM_BIOS_FUNCTION_GET_DDC              0x0B   
#define ATOM_BIOS_FUNCTION_ASIC_DSTATE          0x0E
#define ATOM_BIOS_FUNCTION_DEBUG_PLAY           0x0F
#define ATOM_BIOS_FUNCTION_STV_STD              0x16
#define ATOM_BIOS_FUNCTION_DEVICE_DET           0x17
#define ATOM_BIOS_FUNCTION_DEVICE_SWITCH        0x18

#define ATOM_BIOS_FUNCTION_PANEL_CONTROL        0x82
#define ATOM_BIOS_FUNCTION_OLD_DEVICE_DET       0x83
#define ATOM_BIOS_FUNCTION_OLD_DEVICE_SWITCH    0x84
#define ATOM_BIOS_FUNCTION_HW_ICON              0x8A 
#define ATOM_BIOS_FUNCTION_SET_CMOS             0x8B
#define SUB_FUNCTION_UPDATE_DISPLAY_INFO        0x8000          
#define SUB_FUNCTION_UPDATE_EXPANSION_INFO      0x8100          

#define ATOM_BIOS_FUNCTION_DISPLAY_INFO         0x8D
#define ATOM_BIOS_FUNCTION_DEVICE_ON_OFF        0x8E
#define ATOM_BIOS_FUNCTION_VIDEO_STATE          0x8F 
#define ATOM_SUB_FUNCTION_GET_CRITICAL_STATE    0x0300          
#define ATOM_SUB_FUNCTION_GET_LIDSTATE          0x0700          
#define ATOM_SUB_FUNCTION_THERMAL_STATE_NOTICE  0x1400          
#define ATOM_SUB_FUNCTION_CRITICAL_STATE_NOTICE 0x8300          
#define ATOM_SUB_FUNCTION_SET_LIDSTATE          0x8500          
#define ATOM_SUB_FUNCTION_GET_REQ_DISPLAY_FROM_SBIOS_MODE 0x8900
#define ATOM_SUB_FUNCTION_INFORM_ADC_SUPPORT    0x9400          
     

#define ATOM_BIOS_FUNCTION_VESA_DPMS            0x4F10          
#define ATOM_SUB_FUNCTION_SET_DPMS              0x0001          
#define ATOM_SUB_FUNCTION_GET_DPMS              0x0002          
#define ATOM_PARAMETER_VESA_DPMS_ON             0x0000          
#define ATOM_PARAMETER_VESA_DPMS_STANDBY        0x0100          
#define ATOM_PARAMETER_VESA_DPMS_SUSPEND        0x0200          
#define ATOM_PARAMETER_VESA_DPMS_OFF            0x0400          
#define ATOM_PARAMETER_VESA_DPMS_REDUCE_ON      0x0800          

#define ATOM_BIOS_RETURN_CODE_MASK              0x0000FF00L
#define ATOM_BIOS_REG_HIGH_MASK                 0x0000FF00L
#define ATOM_BIOS_REG_LOW_MASK                  0x000000FFL




typedef struct _ASIC_TRANSMITTER_INFO
{
	USHORT usTransmitterObjId;
	USHORT usSupportDevice;
  UCHAR  ucTransmitterCmdTblId;
	UCHAR  ucConfig;
	UCHAR  ucEncoderID;					 
	UCHAR  ucOptionEncoderID;    
	UCHAR  uc2ndEncoderID;
	UCHAR  ucReserved;
}ASIC_TRANSMITTER_INFO;

typedef struct _ASIC_ENCODER_INFO
{
	UCHAR ucEncoderID;
	UCHAR ucEncoderConfig;
  USHORT usEncoderCmdTblId;
}ASIC_ENCODER_INFO;

typedef struct _ATOM_DISP_OUT_INFO
{
  ATOM_COMMON_TABLE_HEADER sHeader;  
	USHORT ptrTransmitterInfo;
	USHORT ptrEncoderInfo;
	ASIC_TRANSMITTER_INFO  asTransmitterInfo[1];
	ASIC_ENCODER_INFO      asEncoderInfo[1];
}ATOM_DISP_OUT_INFO;


typedef struct _ATOM_DISPLAY_DEVICE_PRIORITY_INFO
{
  ATOM_COMMON_TABLE_HEADER sHeader;  
	USHORT asDevicePriority[16];
}ATOM_DISPLAY_DEVICE_PRIORITY_INFO;


typedef struct _PROCESS_AUX_CHANNEL_TRANSACTION_PARAMETERS
{
	USHORT	lpAuxRequest;
	USHORT  lpDataOut;
	UCHAR		ucChannelID;
	union
	{
  UCHAR   ucReplyStatus;
	UCHAR   ucDelay;
	} unionname;
  UCHAR   ucDataOutLen;
	UCHAR   ucReserved;
}PROCESS_AUX_CHANNEL_TRANSACTION_PARAMETERS;

#define PROCESS_AUX_CHANNEL_TRANSACTION_PS_ALLOCATION			PROCESS_AUX_CHANNEL_TRANSACTION_PARAMETERS



typedef struct _DP_ENCODER_SERVICE_PARAMETERS
{
	USHORT ucLinkClock;
	union 
	{
	UCHAR ucConfig;				
	UCHAR ucI2cId;				
	} unionname;
	UCHAR ucAction;
	UCHAR ucStatus;
	UCHAR ucLaneNum;
	UCHAR ucReserved[2];
}DP_ENCODER_SERVICE_PARAMETERS;


#define ATOM_DP_ACTION_GET_SINK_TYPE							0x01
#define ATOM_DP_ACTION_TRAINING_START							0x02
#define ATOM_DP_ACTION_TRAINING_COMPLETE					0x03
#define ATOM_DP_ACTION_TRAINING_PATTERN_SEL				0x04
#define ATOM_DP_ACTION_SET_VSWING_PREEMP					0x05
#define ATOM_DP_ACTION_GET_VSWING_PREEMP					0x06


#define ATOM_DP_CONFIG_ENCODER_SEL_MASK						0x03
#define ATOM_DP_CONFIG_DIG1_ENCODER								0x00
#define ATOM_DP_CONFIG_DIG2_ENCODER								0x01
#define ATOM_DP_CONFIG_EXTERNAL_ENCODER						0x02
#define ATOM_DP_CONFIG_LINK_SEL_MASK							0x04
#define ATOM_DP_CONFIG_LINK_A											0x00
#define ATOM_DP_CONFIG_LINK_B											0x04

#define DP_ENCODER_SERVICE_PS_ALLOCATION				WRITE_ONE_BYTE_HW_I2C_DATA_PARAMETERS


#define DPCD_SET_LINKRATE_LANENUM_PATTERN1_TBL_ADDR				ATOM_DP_TRAINING_TBL_ADDR		
#define DPCD_SET_SS_CNTL_TBL_ADDR													(ATOM_DP_TRAINING_TBL_ADDR + 8 )
#define DPCD_SET_LANE_VSWING_PREEMP_TBL_ADDR							(ATOM_DP_TRAINING_TBL_ADDR + 16 )
#define DPCD_SET_TRAINING_PATTERN0_TBL_ADDR								(ATOM_DP_TRAINING_TBL_ADDR + 24 )
#define DPCD_SET_TRAINING_PATTERN2_TBL_ADDR								(ATOM_DP_TRAINING_TBL_ADDR + 32)
#define DPCD_GET_LINKRATE_LANENUM_SS_TBL_ADDR							(ATOM_DP_TRAINING_TBL_ADDR + 40)
#define	DPCD_GET_LANE_STATUS_ADJUST_TBL_ADDR							(ATOM_DP_TRAINING_TBL_ADDR + 48)
#define DP_I2C_AUX_DDC_WRITE_START_TBL_ADDR								(ATOM_DP_TRAINING_TBL_ADDR + 60)
#define DP_I2C_AUX_DDC_WRITE_TBL_ADDR											(ATOM_DP_TRAINING_TBL_ADDR + 64)
#define DP_I2C_AUX_DDC_READ_START_TBL_ADDR								(ATOM_DP_TRAINING_TBL_ADDR + 72)
#define DP_I2C_AUX_DDC_READ_TBL_ADDR											(ATOM_DP_TRAINING_TBL_ADDR + 76)
#define DP_I2C_AUX_DDC_READ_END_TBL_ADDR									(ATOM_DP_TRAINING_TBL_ADDR + 80)


typedef struct _PROCESS_I2C_CHANNEL_TRANSACTION_PARAMETERS
{
	UCHAR   ucI2CSpeed;
 	union
	{
   UCHAR ucRegIndex;
   UCHAR ucStatus;
	} unionname;
	USHORT  lpI2CDataOut;
  UCHAR   ucFlag;               
  UCHAR   ucTransBytes;
  UCHAR   ucSlaveAddr;
  UCHAR   ucLineNumber;
}PROCESS_I2C_CHANNEL_TRANSACTION_PARAMETERS;

#define PROCESS_I2C_CHANNEL_TRANSACTION_PS_ALLOCATION       PROCESS_I2C_CHANNEL_TRANSACTION_PARAMETERS


#define HW_I2C_WRITE        1
#define HW_I2C_READ         0


/****************************************************************************/	

/****************************************************************************/



typedef struct _ATOM_DAC_INFO
{
  ATOM_COMMON_TABLE_HEADER sHeader;  
  USHORT                   usMaxFrequency;      
  USHORT                   usReserved;
}ATOM_DAC_INFO;


typedef struct  _COMPASSIONATE_DATA           
{
  ATOM_COMMON_TABLE_HEADER sHeader; 

  
  UCHAR   ucDAC1_BG_Adjustment;
  UCHAR   ucDAC1_DAC_Adjustment;
  USHORT  usDAC1_FORCE_Data;
  
  UCHAR   ucDAC2_CRT2_BG_Adjustment;
  UCHAR   ucDAC2_CRT2_DAC_Adjustment;
  USHORT  usDAC2_CRT2_FORCE_Data;
  USHORT  usDAC2_CRT2_MUX_RegisterIndex;
  UCHAR   ucDAC2_CRT2_MUX_RegisterInfo;     
  UCHAR   ucDAC2_NTSC_BG_Adjustment;
  UCHAR   ucDAC2_NTSC_DAC_Adjustment;
  USHORT  usDAC2_TV1_FORCE_Data;
  USHORT  usDAC2_TV1_MUX_RegisterIndex;
  UCHAR   ucDAC2_TV1_MUX_RegisterInfo;      
  UCHAR   ucDAC2_CV_BG_Adjustment;
  UCHAR   ucDAC2_CV_DAC_Adjustment;
  USHORT  usDAC2_CV_FORCE_Data;
  USHORT  usDAC2_CV_MUX_RegisterIndex;
  UCHAR   ucDAC2_CV_MUX_RegisterInfo;       
  UCHAR   ucDAC2_PAL_BG_Adjustment;
  UCHAR   ucDAC2_PAL_DAC_Adjustment;
  USHORT  usDAC2_TV2_FORCE_Data;
}COMPASSIONATE_DATA;

/****************************Supported Device Info Table Definitions**********************/























typedef struct _ATOM_CONNECTOR_INFO
{
  UCHAR   bfAssociatedDAC:4;
  UCHAR   bfConnectorType:4;
}ATOM_CONNECTOR_INFO;

typedef union _ATOM_CONNECTOR_INFO_ACCESS
{
  ATOM_CONNECTOR_INFO sbfAccess;
  UCHAR               ucAccess;
}ATOM_CONNECTOR_INFO_ACCESS;

typedef struct _ATOM_CONNECTOR_INFO_I2C
{
  ATOM_CONNECTOR_INFO_ACCESS sucConnectorInfo;
  ATOM_I2C_ID_CONFIG_ACCESS  sucI2cId;
}ATOM_CONNECTOR_INFO_I2C;


typedef struct _ATOM_SUPPORTED_DEVICES_INFO
{ 
  ATOM_COMMON_TABLE_HEADER	sHeader;
  USHORT                    usDeviceSupport;
  ATOM_CONNECTOR_INFO_I2C   asConnInfo[ATOM_MAX_SUPPORTED_DEVICE_INFO];
}ATOM_SUPPORTED_DEVICES_INFO;

#define NO_INT_SRC_MAPPED       0xFF

typedef struct _ATOM_CONNECTOR_INC_SRC_BITMAP
{
  UCHAR   ucIntSrcBitmap;
}ATOM_CONNECTOR_INC_SRC_BITMAP;

typedef struct _ATOM_SUPPORTED_DEVICES_INFO_2
{ 
  ATOM_COMMON_TABLE_HEADER      sHeader;
  USHORT                        usDeviceSupport;
  ATOM_CONNECTOR_INFO_I2C       asConnInfo[ATOM_MAX_SUPPORTED_DEVICE_INFO_2];
  ATOM_CONNECTOR_INC_SRC_BITMAP asIntSrcInfo[ATOM_MAX_SUPPORTED_DEVICE_INFO_2];
}ATOM_SUPPORTED_DEVICES_INFO_2;

typedef struct _ATOM_SUPPORTED_DEVICES_INFO_2d1
{ 
  ATOM_COMMON_TABLE_HEADER      sHeader;
  USHORT                        usDeviceSupport;
  ATOM_CONNECTOR_INFO_I2C       asConnInfo[ATOM_MAX_SUPPORTED_DEVICE];
  ATOM_CONNECTOR_INC_SRC_BITMAP asIntSrcInfo[ATOM_MAX_SUPPORTED_DEVICE];
}ATOM_SUPPORTED_DEVICES_INFO_2d1;

#define ATOM_SUPPORTED_DEVICES_INFO_LAST ATOM_SUPPORTED_DEVICES_INFO_2d1



typedef struct _ATOM_MISC_CONTROL_INFO
{
   USHORT usFrequency;
   UCHAR  ucPLL_ChargePump;				                
   UCHAR  ucPLL_DutyCycle;				                
   UCHAR  ucPLL_VCO_Gain;				                  
   UCHAR  ucPLL_VoltageSwing;			                
}ATOM_MISC_CONTROL_INFO;  


#define ATOM_MAX_MISC_INFO       4

typedef struct _ATOM_TMDS_INFO
{
  ATOM_COMMON_TABLE_HEADER sHeader;  
  USHORT							usMaxFrequency;             
  ATOM_MISC_CONTROL_INFO				asMiscInfo[ATOM_MAX_MISC_INFO];
}ATOM_TMDS_INFO;


typedef struct _ATOM_ENCODER_ANALOG_ATTRIBUTE
{
  UCHAR ucTVStandard;     
  UCHAR ucPadding[1];
}ATOM_ENCODER_ANALOG_ATTRIBUTE;

typedef struct _ATOM_ENCODER_DIGITAL_ATTRIBUTE
{
  UCHAR ucAttribute;      
  UCHAR ucPadding[1];		
}ATOM_ENCODER_DIGITAL_ATTRIBUTE;

typedef union _ATOM_ENCODER_ATTRIBUTE
{
  ATOM_ENCODER_ANALOG_ATTRIBUTE sAlgAttrib;
  ATOM_ENCODER_DIGITAL_ATTRIBUTE sDigAttrib;
}ATOM_ENCODER_ATTRIBUTE;


typedef struct _DVO_ENCODER_CONTROL_PARAMETERS
{
  USHORT usPixelClock; 
  USHORT usEncoderID; 
  UCHAR  ucDeviceType;												
  UCHAR  ucAction;														
  ATOM_ENCODER_ATTRIBUTE usDevAttr;     		
}DVO_ENCODER_CONTROL_PARAMETERS;

typedef struct _DVO_ENCODER_CONTROL_PS_ALLOCATION
{                               
  DVO_ENCODER_CONTROL_PARAMETERS    sDVOEncoder;
  WRITE_ONE_BYTE_HW_I2C_DATA_PS_ALLOCATION      sReserved;     
}DVO_ENCODER_CONTROL_PS_ALLOCATION;


#define ATOM_XTMDS_ASIC_SI164_ID        1
#define ATOM_XTMDS_ASIC_SI178_ID        2
#define ATOM_XTMDS_ASIC_TFP513_ID       3
#define ATOM_XTMDS_SUPPORTED_SINGLELINK 0x00000001
#define ATOM_XTMDS_SUPPORTED_DUALLINK   0x00000002
#define ATOM_XTMDS_MVPU_FPGA            0x00000004

                           
typedef struct _ATOM_XTMDS_INFO
{
  ATOM_COMMON_TABLE_HEADER   sHeader;  
  USHORT                     usSingleLinkMaxFrequency; 
  ATOM_I2C_ID_CONFIG_ACCESS  sucI2cId;           
  UCHAR                      ucXtransimitterID;          
  UCHAR                      ucSupportedLink;    
  UCHAR                      ucSequnceAlterID;   
                                                 
  UCHAR                      ucMasterAddress;    
  UCHAR                      ucSlaveAddress;     
}ATOM_XTMDS_INFO;

typedef struct _DFP_DPMS_STATUS_CHANGE_PARAMETERS
{  
  UCHAR ucEnable;                     
  UCHAR ucDevice;                     
  UCHAR ucPadding[2];             
}DFP_DPMS_STATUS_CHANGE_PARAMETERS;

/****************************Legacy Power Play Table Definitions **********************/


#define ATOM_PM_MISCINFO_SPLIT_CLOCK                     0x00000000L
#define ATOM_PM_MISCINFO_USING_MCLK_SRC                  0x00000001L
#define ATOM_PM_MISCINFO_USING_SCLK_SRC                  0x00000002L

#define ATOM_PM_MISCINFO_VOLTAGE_DROP_SUPPORT            0x00000004L
#define ATOM_PM_MISCINFO_VOLTAGE_DROP_ACTIVE_HIGH        0x00000008L

#define ATOM_PM_MISCINFO_LOAD_PERFORMANCE_EN             0x00000010L

#define ATOM_PM_MISCINFO_ENGINE_CLOCK_CONTRL_EN          0x00000020L
#define ATOM_PM_MISCINFO_MEMORY_CLOCK_CONTRL_EN          0x00000040L
#define ATOM_PM_MISCINFO_PROGRAM_VOLTAGE                 0x00000080L  
 
#define ATOM_PM_MISCINFO_ASIC_REDUCED_SPEED_SCLK_EN      0x00000100L
#define ATOM_PM_MISCINFO_ASIC_DYNAMIC_VOLTAGE_EN         0x00000200L
#define ATOM_PM_MISCINFO_ASIC_SLEEP_MODE_EN              0x00000400L
#define ATOM_PM_MISCINFO_LOAD_BALANCE_EN                 0x00000800L
#define ATOM_PM_MISCINFO_DEFAULT_DC_STATE_ENTRY_TRUE     0x00001000L
#define ATOM_PM_MISCINFO_DEFAULT_LOW_DC_STATE_ENTRY_TRUE 0x00002000L
#define ATOM_PM_MISCINFO_LOW_LCD_REFRESH_RATE            0x00004000L

#define ATOM_PM_MISCINFO_DRIVER_DEFAULT_MODE             0x00008000L
#define ATOM_PM_MISCINFO_OVER_CLOCK_MODE                 0x00010000L 
#define ATOM_PM_MISCINFO_OVER_DRIVE_MODE                 0x00020000L
#define ATOM_PM_MISCINFO_POWER_SAVING_MODE               0x00040000L
#define ATOM_PM_MISCINFO_THERMAL_DIODE_MODE              0x00080000L

#define ATOM_PM_MISCINFO_FRAME_MODULATION_MASK           0x00300000L  
#define ATOM_PM_MISCINFO_FRAME_MODULATION_SHIFT          20 

#define ATOM_PM_MISCINFO_DYN_CLK_3D_IDLE                 0x00400000L
#define ATOM_PM_MISCINFO_DYNAMIC_CLOCK_DIVIDER_BY_2      0x00800000L
#define ATOM_PM_MISCINFO_DYNAMIC_CLOCK_DIVIDER_BY_4      0x01000000L
#define ATOM_PM_MISCINFO_DYNAMIC_HDP_BLOCK_EN            0x02000000L  
#define ATOM_PM_MISCINFO_DYNAMIC_MC_HOST_BLOCK_EN        0x04000000L  
#define ATOM_PM_MISCINFO_3D_ACCELERATION_EN              0x08000000L  

#define ATOM_PM_MISCINFO_POWERPLAY_SETTINGS_GROUP_MASK   0x70000000L  
#define ATOM_PM_MISCINFO_POWERPLAY_SETTINGS_GROUP_SHIFT  28
#define ATOM_PM_MISCINFO_ENABLE_BACK_BIAS                0x80000000L

#define ATOM_PM_MISCINFO2_SYSTEM_AC_LITE_MODE            0x00000001L
#define ATOM_PM_MISCINFO2_MULTI_DISPLAY_SUPPORT          0x00000002L
#define ATOM_PM_MISCINFO2_DYNAMIC_BACK_BIAS_EN           0x00000004L
#define ATOM_PM_MISCINFO2_FS3D_OVERDRIVE_INFO            0x00000008L
#define ATOM_PM_MISCINFO2_FORCEDLOWPWR_MODE              0x00000010L
#define ATOM_PM_MISCINFO2_VDDCI_DYNAMIC_VOLTAGE_EN       0x00000020L
#define ATOM_PM_MISCINFO2_VIDEO_PLAYBACK_CAPABLE         0x00000040L  
                                                                      
#define ATOM_PM_MISCINFO2_NOT_VALID_ON_DC                0x00000080L
#define ATOM_PM_MISCINFO2_STUTTER_MODE_EN                0x00000100L
#define ATOM_PM_MISCINFO2_UVD_SUPPORT_MODE               0x00000200L 



typedef struct  _ATOM_POWERMODE_INFO
{
  ULONG     ulMiscInfo;                 
  ULONG     ulReserved1;                
  ULONG     ulReserved2;                
  USHORT    usEngineClock;
  USHORT    usMemoryClock;
  UCHAR     ucVoltageDropIndex;         
  UCHAR     ucSelectedPanel_RefreshRate;
  UCHAR     ucMinTemperature;
  UCHAR     ucMaxTemperature;
  UCHAR     ucNumPciELanes;             
}ATOM_POWERMODE_INFO;



typedef struct  _ATOM_POWERMODE_INFO_V2
{
  ULONG     ulMiscInfo;                 
  ULONG     ulMiscInfo2;                
  ULONG     ulEngineClock;                
  ULONG     ulMemoryClock;
  UCHAR     ucVoltageDropIndex;         
  UCHAR     ucSelectedPanel_RefreshRate;
  UCHAR     ucMinTemperature;
  UCHAR     ucMaxTemperature;
  UCHAR     ucNumPciELanes;             
}ATOM_POWERMODE_INFO_V2;



typedef struct  _ATOM_POWERMODE_INFO_V3
{
  ULONG     ulMiscInfo;                 
  ULONG     ulMiscInfo2;                
  ULONG     ulEngineClock;                
  ULONG     ulMemoryClock;
  UCHAR     ucVoltageDropIndex;         
  UCHAR     ucSelectedPanel_RefreshRate;
  UCHAR     ucMinTemperature;
  UCHAR     ucMaxTemperature;
  UCHAR     ucNumPciELanes;             
  UCHAR     ucVDDCI_VoltageDropIndex;   
}ATOM_POWERMODE_INFO_V3;


#define ATOM_MAX_NUMBEROF_POWER_BLOCK  8

#define ATOM_PP_OVERDRIVE_INTBITMAP_AUXWIN            0x01
#define ATOM_PP_OVERDRIVE_INTBITMAP_OVERDRIVE         0x02

#define ATOM_PP_OVERDRIVE_THERMALCONTROLLER_LM63      0x01
#define ATOM_PP_OVERDRIVE_THERMALCONTROLLER_ADM1032   0x02
#define ATOM_PP_OVERDRIVE_THERMALCONTROLLER_ADM1030   0x03
#define ATOM_PP_OVERDRIVE_THERMALCONTROLLER_MUA6649   0x04
#define ATOM_PP_OVERDRIVE_THERMALCONTROLLER_LM64      0x05
#define ATOM_PP_OVERDRIVE_THERMALCONTROLLER_F75375    0x06
#define ATOM_PP_OVERDRIVE_THERMALCONTROLLER_ASC7512   0x07	


typedef struct  _ATOM_POWERPLAY_INFO
{
  ATOM_COMMON_TABLE_HEADER	sHeader; 
  UCHAR    ucOverdriveThermalController;
  UCHAR    ucOverdriveI2cLine;
  UCHAR    ucOverdriveIntBitmap;
  UCHAR    ucOverdriveControllerAddress;
  UCHAR    ucSizeOfPowerModeEntry;
  UCHAR    ucNumOfPowerModeEntries;
  ATOM_POWERMODE_INFO asPowerPlayInfo[ATOM_MAX_NUMBEROF_POWER_BLOCK];
}ATOM_POWERPLAY_INFO;

typedef struct  _ATOM_POWERPLAY_INFO_V2
{
  ATOM_COMMON_TABLE_HEADER	sHeader; 
  UCHAR    ucOverdriveThermalController;
  UCHAR    ucOverdriveI2cLine;
  UCHAR    ucOverdriveIntBitmap;
  UCHAR    ucOverdriveControllerAddress;
  UCHAR    ucSizeOfPowerModeEntry;
  UCHAR    ucNumOfPowerModeEntries;
  ATOM_POWERMODE_INFO_V2 asPowerPlayInfo[ATOM_MAX_NUMBEROF_POWER_BLOCK];
}ATOM_POWERPLAY_INFO_V2;
  
typedef struct  _ATOM_POWERPLAY_INFO_V3
{
  ATOM_COMMON_TABLE_HEADER	sHeader; 
  UCHAR    ucOverdriveThermalController;
  UCHAR    ucOverdriveI2cLine;
  UCHAR    ucOverdriveIntBitmap;
  UCHAR    ucOverdriveControllerAddress;
  UCHAR    ucSizeOfPowerModeEntry;
  UCHAR    ucNumOfPowerModeEntries;
  ATOM_POWERMODE_INFO_V3 asPowerPlayInfo[ATOM_MAX_NUMBEROF_POWER_BLOCK];
}ATOM_POWERPLAY_INFO_V3;



/**************************************************************************/



#define ATOM_MASTER_DATA_TABLE_REVISION   0x01
#define Object_Info												Object_Header			
#define	AdjustARB_SEQ											MC_InitParameter
#define	VRAM_GPIO_DetectionInfo						VoltageObjectInfo
#define	ASIC_VDDCI_Info                   ASIC_ProfilingInfo														
#define ASIC_MVDDQ_Info										MemoryTrainingInfo
#define SS_Info                           PPLL_SS_Info                      
#define ASIC_MVDDC_Info                   ASIC_InternalSS_Info
#define DispDevicePriorityInfo						SaveRestoreInfo
#define DispOutInfo												TV_VideoMode


#define ATOM_ENCODER_OBJECT_TABLE         ATOM_OBJECT_TABLE
#define ATOM_CONNECTOR_OBJECT_TABLE       ATOM_OBJECT_TABLE


#define DFP2I_OUTPUT_CONTROL_PARAMETERS    CRT1_OUTPUT_CONTROL_PARAMETERS
#define DFP2I_OUTPUT_CONTROL_PS_ALLOCATION DFP2I_OUTPUT_CONTROL_PARAMETERS

#define DFP1X_OUTPUT_CONTROL_PARAMETERS    CRT1_OUTPUT_CONTROL_PARAMETERS
#define DFP1X_OUTPUT_CONTROL_PS_ALLOCATION DFP1X_OUTPUT_CONTROL_PARAMETERS

#define DFP1I_OUTPUT_CONTROL_PARAMETERS    DFP1_OUTPUT_CONTROL_PARAMETERS
#define DFP1I_OUTPUT_CONTROL_PS_ALLOCATION DFP1_OUTPUT_CONTROL_PS_ALLOCATION

#define ATOM_DEVICE_DFP1I_SUPPORT          ATOM_DEVICE_DFP1_SUPPORT
#define ATOM_DEVICE_DFP1X_SUPPORT          ATOM_DEVICE_DFP2_SUPPORT

#define ATOM_DEVICE_DFP1I_INDEX            ATOM_DEVICE_DFP1_INDEX
#define ATOM_DEVICE_DFP1X_INDEX            ATOM_DEVICE_DFP2_INDEX
 
#define ATOM_DEVICE_DFP2I_INDEX            0x00000009
#define ATOM_DEVICE_DFP2I_SUPPORT          (0x1L << ATOM_DEVICE_DFP2I_INDEX)

#define ATOM_S0_DFP1I                      ATOM_S0_DFP1
#define ATOM_S0_DFP1X                      ATOM_S0_DFP2

#define ATOM_S0_DFP2I                      0x00200000L
#define ATOM_S0_DFP2Ib2                    0x20

#define ATOM_S2_DFP1I_DPMS_STATE           ATOM_S2_DFP1_DPMS_STATE
#define ATOM_S2_DFP1X_DPMS_STATE           ATOM_S2_DFP2_DPMS_STATE

#define ATOM_S2_DFP2I_DPMS_STATE           0x02000000L
#define ATOM_S2_DFP2I_DPMS_STATEb3         0x02

#define ATOM_S3_DFP2I_ACTIVEb1             0x02

#define ATOM_S3_DFP1I_ACTIVE               ATOM_S3_DFP1_ACTIVE 
#define ATOM_S3_DFP1X_ACTIVE               ATOM_S3_DFP2_ACTIVE

#define ATOM_S3_DFP2I_ACTIVE               0x00000200L

#define ATOM_S3_DFP1I_CRTC_ACTIVE          ATOM_S3_DFP1_CRTC_ACTIVE
#define ATOM_S3_DFP1X_CRTC_ACTIVE          ATOM_S3_DFP2_CRTC_ACTIVE
#define ATOM_S3_DFP2I_CRTC_ACTIVE          0x02000000L

#define ATOM_S3_DFP2I_CRTC_ACTIVEb3        0x02
#define ATOM_S5_DOS_REQ_DFP2Ib1            0x02

#define ATOM_S5_DOS_REQ_DFP2I              0x0200
#define ATOM_S6_ACC_REQ_DFP1I              ATOM_S6_ACC_REQ_DFP1
#define ATOM_S6_ACC_REQ_DFP1X              ATOM_S6_ACC_REQ_DFP2

#define ATOM_S6_ACC_REQ_DFP2Ib3            0x02
#define ATOM_S6_ACC_REQ_DFP2I              0x02000000L

#define TMDS1XEncoderControl               DVOEncoderControl           
#define DFP1XOutputControl                 DVOOutputControl

#define ExternalDFPOutputControl           DFP1XOutputControl
#define EnableExternalTMDS_Encoder         TMDS1XEncoderControl

#define DFP1IOutputControl                 TMDSAOutputControl
#define DFP2IOutputControl                 LVTMAOutputControl      

#define DAC1_ENCODER_CONTROL_PARAMETERS    DAC_ENCODER_CONTROL_PARAMETERS
#define DAC1_ENCODER_CONTROL_PS_ALLOCATION DAC_ENCODER_CONTROL_PS_ALLOCATION

#define DAC2_ENCODER_CONTROL_PARAMETERS    DAC_ENCODER_CONTROL_PARAMETERS
#define DAC2_ENCODER_CONTROL_PS_ALLOCATION DAC_ENCODER_CONTROL_PS_ALLOCATION

#define ucDac1Standard  ucDacStandard
#define ucDac2Standard  ucDacStandard  

#define TMDS1EncoderControl TMDSAEncoderControl
#define TMDS2EncoderControl LVTMAEncoderControl

#define DFP1OutputControl   TMDSAOutputControl
#define DFP2OutputControl   LVTMAOutputControl
#define CRT1OutputControl   DAC1OutputControl
#define CRT2OutputControl   DAC2OutputControl


#define EnableLVDS_SS   EnableSpreadSpectrumOnPPLL
#define ENABLE_LVDS_SS_PARAMETERS_V3  ENABLE_SPREAD_SPECTRUM_ON_PPLL  

/*********************************************************************************/
#define ATOM_S3_SCALER2_ACTIVE_H          0x00004000L
#define ATOM_S3_SCALER2_ACTIVE_V          0x00008000L
#define ATOM_S6_REQ_SCALER2_H             0x00004000L
#define ATOM_S6_REQ_SCALER2_V             0x00008000L
 
#define ATOM_S3_SCALER1_ACTIVE_H          ATOM_S3_LCD_FULLEXPANSION_ACTIVE
#define ATOM_S3_SCALER1_ACTIVE_V          ATOM_S3_LCD_EXPANSION_ASPEC_RATIO_ACTIVE
 
#define ATOM_S6_REQ_SCALER1_H             ATOM_S6_REQ_LCD_EXPANSION_FULL
#define ATOM_S6_REQ_SCALER1_V             ATOM_S6_REQ_LCD_EXPANSION_ASPEC_RATIO


#pragma pack() 

#endif /* _ATOMBIOS_H */
