/*
 * Copyright 2006-2007 Advanced Micro Devices, Inc.  
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

/*++

Module Name:

CD_OPCODEs.h

Abstract:

Defines Command Decoder OPCODEs

Revision History:

NEG:24.09.2002	Initiated.
--*/
#ifndef _CD_OPCODES_H_
#define _CD_OPCODES_H_

typedef enum _OPCODE {
    Reserved_00= 0,				
    
    MOVE_REG_OPCODE,			
    FirstValidCommand=MOVE_REG_OPCODE,
    MOVE_PS_OPCODE,				
    MOVE_WS_OPCODE,				
    MOVE_FB_OPCODE,				
    MOVE_PLL_OPCODE,			
    MOVE_MC_OPCODE,				
    
    AND_REG_OPCODE,				
    AND_PS_OPCODE,				
    AND_WS_OPCODE,				
    AND_FB_OPCODE,				
    AND_PLL_OPCODE,				
    AND_MC_OPCODE,				
    OR_REG_OPCODE,				
    OR_PS_OPCODE,				
    OR_WS_OPCODE,				
    OR_FB_OPCODE,				
    OR_PLL_OPCODE,				
    OR_MC_OPCODE,				
    SHIFT_LEFT_REG_OPCODE,		
    SHIFT_LEFT_PS_OPCODE,		
    SHIFT_LEFT_WS_OPCODE,		
    SHIFT_LEFT_FB_OPCODE,		
    SHIFT_LEFT_PLL_OPCODE,		
    SHIFT_LEFT_MC_OPCODE,		
    SHIFT_RIGHT_REG_OPCODE,		
    SHIFT_RIGHT_PS_OPCODE,		
    SHIFT_RIGHT_WS_OPCODE,		
    SHIFT_RIGHT_FB_OPCODE,		
    SHIFT_RIGHT_PLL_OPCODE,		
    SHIFT_RIGHT_MC_OPCODE,		
    
    MUL_REG_OPCODE,				
    MUL_PS_OPCODE,				
    MUL_WS_OPCODE,				
    MUL_FB_OPCODE,				
    MUL_PLL_OPCODE,				
    MUL_MC_OPCODE,				
    DIV_REG_OPCODE,				
    DIV_PS_OPCODE,				
    DIV_WS_OPCODE,				
    DIV_FB_OPCODE,				
    DIV_PLL_OPCODE,				
    DIV_MC_OPCODE,				
    ADD_REG_OPCODE,				
    ADD_PS_OPCODE,				
    ADD_WS_OPCODE,				
    ADD_FB_OPCODE,				
    ADD_PLL_OPCODE,				
    ADD_MC_OPCODE,				
    SUB_REG_OPCODE,				
    SUB_PS_OPCODE,				
    SUB_WS_OPCODE,				
    SUB_FB_OPCODE,				
    SUB_PLL_OPCODE,				
    SUB_MC_OPCODE,				
    
    SET_ATI_PORT_OPCODE,		
    SET_PCI_PORT_OPCODE,		
    SET_SYS_IO_PORT_OPCODE,		
    SET_REG_BLOCK_OPCODE,		
    SET_FB_BASE_OPCODE,			
    COMPARE_REG_OPCODE,			
    COMPARE_PS_OPCODE,			
    COMPARE_WS_OPCODE,			
    COMPARE_FB_OPCODE,			
    COMPARE_PLL_OPCODE,			
    COMPARE_MC_OPCODE,			
    SWITCH_OPCODE,				
    JUMP__OPCODE,				
    JUMP_EQUAL_OPCODE,			
    JUMP_BELOW_OPCODE,			
    JUMP_ABOVE_OPCODE,			
    JUMP_BELOW_OR_EQUAL_OPCODE,	
    JUMP_ABOVE_OR_EQUAL_OPCODE,	
    JUMP_NOT_EQUAL_OPCODE,		
    TEST_REG_OPCODE,			
    TEST_PS_OPCODE,				
    TEST_WS_OPCODE,				
    TEST_FB_OPCODE,				
    TEST_PLL_OPCODE,			
    TEST_MC_OPCODE,				
    DELAY_MILLISEC_OPCODE,		
    DELAY_MICROSEC_OPCODE,		
    CALL_TABLE_OPCODE,			
    REPEAT_OPCODE,				
    
    CLEAR_REG_OPCODE,			
    CLEAR_PS_OPCODE,			
    CLEAR_WS_OPCODE,			
    CLEAR_FB_OPCODE,			
    CLEAR_PLL_OPCODE,			
    CLEAR_MC_OPCODE,			
    NOP_OPCODE,					
    EOT_OPCODE,					
    MASK_REG_OPCODE,			
    MASK_PS_OPCODE,				
    MASK_WS_OPCODE,				
    MASK_FB_OPCODE,				
    MASK_PLL_OPCODE,			
    MASK_MC_OPCODE,				
    
    POST_CARD_OPCODE,			
    BEEP_OPCODE,				
    SAVE_REG_OPCODE,			
    RESTORE_REG_OPCODE,			
    SET_DATA_BLOCK_OPCODE,			

    XOR_REG_OPCODE,				
    XOR_PS_OPCODE,				
    XOR_WS_OPCODE,				
    XOR_FB_OPCODE,				
    XOR_PLL_OPCODE,				
    XOR_MC_OPCODE,				

    SHL_REG_OPCODE,				
    SHL_PS_OPCODE,				
    SHL_WS_OPCODE,				
    SHL_FB_OPCODE,				
    SHL_PLL_OPCODE,				
    SHL_MC_OPCODE,				

    SHR_REG_OPCODE,				
    SHR_PS_OPCODE,				
    SHR_WS_OPCODE,				
    SHR_FB_OPCODE,				
    SHR_PLL_OPCODE,				
    SHR_MC_OPCODE,				

    DEBUG_OPCODE,                           
    CTB_DS_OPCODE,                          

    LastValidCommand = CTB_DS_OPCODE,
    
    Extension	= 0x80,			
    Reserved_FF = 255			
}OPCODE;
#endif		
