#ifndef _FrontBuffer_hh_
#define _FrontBuffer_hh_

#include "Compat.hh"
#include "GraphConfig.hh"
#include "Transparency.hh"

class FrameBuffer;
class DirtyWindow;

class FrontBuffer {
  protected:
    static const int MAXFrameBuffers = 30;
    static const int MAXChangesDW = 8100;
    int lastFB;
    FrameBuffer * framebufs[MAXFrameBuffers];
    FrameBuffer ** lastFBp;
    DirtyWindow * dw, * last;
    Pixel_t * buffer;
    static const int WindowSizeX = ScreenSizeX;
    static const int WindowSizeY = ScreenSizeY;
    FrontBuffer();
    void RemoveDuplicateDW();
    inline void CopyRegion(const TransparencyType transparency,
			   Pixel_t * src, Pixel_t * dst, const int X, const int Y, const int W, const int H);
    inline void UpdateDirtyWindow(DirtyWindow * dirty);
    virtual void UpdateScreen() = 0;
  public:
    inline void AddDirty(const int X, const int Y, const int W, const int H);
    inline bool Clip(int& X, int& Y, int& W, int& H);  
    bool FindDuplicate(const int X, const int Y, const int W, const int H);  
    virtual ~FrontBuffer();
    void AddFrameBuffer(FrameBuffer * fb);
    void InsertFrameBuffer(FrameBuffer *fb, FrameBuffer * before);
    void RemoveFrameBuffer(FrameBuffer * fb);
    void Clear();
    void Show();
    virtual void ShowWindow() { };
};

class DirtyWindow {
  public:
    int X, Y, W, H;
    inline DirtyWindow(const int _X=0, const int _Y=0, const int _W=0, const int _H=0)
      : X(_X), Y(_Y), W(_W), H(_H) { };
    inline void Set(const int _X, const int _Y, const int _W, const int _H)
      { X=_X; Y=_Y; W=_W; H=_H; };
};

inline void FrontBuffer::AddDirty(const int X, const int Y, const int W, const int H)
{
  (last++)->Set(X, Y, W, H);
}

inline bool FrontBuffer::Clip(int& X, int& Y, int& W, int& H)
{
  if (Y<0) {
    if ((H += Y) <= 0)
      return FALSE;
    Y = 0;
  }
  if ((Y+H) >= WindowSizeY) {
    if (Y>=WindowSizeY)
      return FALSE;
    H = WindowSizeY-Y;
  }
  if (X<0) {
    if ((W += X) <= 0)
      return FALSE;
    X = 0;
  }
  if ((X+W) >= WindowSizeX) {
    if (X>=WindowSizeX)
      return FALSE;
    W = WindowSizeX-X;
  }
  return TRUE;
}

#endif
