#ifndef _FrameBuffer_hh_
#define _FrameBuffer_hh_

#include "Compat.hh"
#include "GraphConfig.hh"
#include "Transparency.hh"

class FrameBuffer {
  protected:
    const TransparencyType transparency;
    friend class FrontBuffer; //????
    FrontBuffer * front;
  public:
    Pixel_t * buffer;
    static const int WindowSizeX = ScreenSizeX;
    static const int WindowSizeY = ScreenSizeY;
    FrameBuffer(const TransparencyType _transparency);
    virtual ~FrameBuffer();
    void Clear();
    void Fill(int X, int Y, int Width, int Height, const Pixel_t color);
    inline void PutImage(int X, int Y, int Width, int Height,
			 const Pixel_t * Img, const int Img_width);
    inline void PutMaskImage(int X, int Y, int Width, int Height,
			 const Pixel_t * Img, const int Img_width);
    void TileImage(const int Width, const int Height,
			 const Pixel_t * Img, const int Img_width);
    // same, but search for duplicates and clipping
    void Fill_sd(int X, int Y, int Width, int Height, const Pixel_t color);
    inline void PutImage_sd(int X, int Y, int Width, int Height,
			 const Pixel_t * Img, const int Img_width);    
    void PutMaskImage_sd(int X, int Y, int Width, int Height,
		      const Pixel_t * Img, const int Img_width);
    void TileImageWindow_sd(int X, int Y, int Width, int Height,
			 const Pixel_t * Img, const int Img_width, const int Img_height);
    void TileMaskImageWindow_sd(int X, int Y, int Width, int Height,
			 const Pixel_t * Img, const int Img_width, const int Img_height);    
    void ClearMaskImage_sd(int X, int Y, int Width, int Height,
		      const Pixel_t * Img, const int Img_width);    
};

// for-cycle for rectangle in FrameBuffer
// _p is name of variable of type pointer to Pixel_t, it will point to actual pixel
#define XYCycle(_p, _X, _Y, _W, _H) \
Pixel_t * _p = buffer+_X+_Y*WindowSizeX; \
int _add = WindowSizeX-Width; \
Pixel_t * _end_of_img = _p + _H*WindowSizeX; \
for (; _p<_end_of_img; _p += _add) \
for (int _j=_W; _j; _j--, _p++)

// same as XYCycle, but used for bitblt from another image        
// _img is same as _p, but for (source) image
#define ImgCycle(_p, _X, _Y, _W, _H, _img, _Img, _ImW) \
Pixel_t * _p = buffer+_X+_Y*WindowSizeX; \
int _add = WindowSizeX-Width; \
const Pixel_t * _img = _Img; \
int _img_add = _ImW - _W; \
const Pixel_t * _end_of_img = _p + _H*WindowSizeX; \
for (; _p<_end_of_img; _p += _add, _img += _img_add) \
for (int _j=_W; _j; _j--, _p++, _img++)

#include "FrontBuffer.hh"
    
// inline functions

inline void FrameBuffer::PutImage(int X, int Y, int Width, int Height,
			 const Pixel_t * Img, const int Img_width)
{
  front->AddDirty(X, Y, Width, Height);
  ImgCycle(p, X, Y, Width, Height, s, Img, Img_width)
    *p = *s;
}

inline void FrameBuffer::PutMaskImage(int X, int Y, int Width, int Height,
			 const Pixel_t * Img, const int Img_width)
{
  front->AddDirty(X, Y, Width, Height);
  ImgCycle(p, X, Y, Width, Height, s, Img, Img_width)
    if (s->NotZero())
      *p = *s;
}


#endif
