#ifndef _Filler_hh_
#define _Filler_hh_

#include "GraphConfig.hh"

enum FillerType_t { ftFlat, ftCircle, ftChecker, ftPicture };
const int FillerType_t_count = 4;

class Filler {
  public:
    int ImageWidth;
    const int ImageSize = 5;
    FillerType_t type;
    int ImageHS;
  protected:    
    Filler(FillerType_t _type);
    void TileBuffer(const Pixel_t* image, const int Width, const int Height);
    Pixel_t * buffer;
  public:
    virtual ~Filler();
    inline Pixel_t * GetImage(const int X, const int Y);
    inline int GetLinear(const int x, const int y) const;
    virtual Filler * CreateCopy()=0;
    void CircleFirstOption() { SetFirstOption(GetFirstOption()+1); };
    void CircleSecondOption() { SetSecondOption(GetSecondOption()+1); };
    FillerType_t GetType() { return type; };
    virtual int GetFirstOption() { return 0; };
    virtual void SetFirstOption(int /* _opt */) { };
    virtual int GetSecondOption() { return -GetFirstOption(); };
    virtual void SetSecondOption(int _opt) { SetFirstOption(-_opt); };
};

int Filler::GetLinear(const int x, const int y) const
{
  return x + ImageWidth*y;
}

Pixel_t * Filler::GetImage(const int X, const int Y)
{
  return buffer + GetLinear(X%(ImageWidth-ImageSize), (Y%ImageHS));
}

#endif
