#ifndef _Event_hh_
#define _Event_hh_

#include "Utils.hh"

typedef enum { evInvalid=0, evnCommand, evKeypress,
			      evKeyrelease, evMouseclick, evMouserelease,
	                      evMousemove, evRedraw, evFocusOut} EventType;

typedef int CommandType;
typedef int KeypressType; 
typedef int MousebuttonType;
typedef Point MousemoveType;
typedef Rectangle RedrawType;
typedef char KeyChar;

class EventManager;

extern EventManager * global_EventManager;

class Event {
  protected:
    friend class EventManager;
    Event * next;
  public:
    Event(void * _creator=0) : next(0), type(evInvalid), creator(_creator) { };
    ~Event();
    EventType type;
    Point mousepos;
    Rectangle drawarea;
    CommandType command;
    KeypressType key;
    KeyChar keychar;
    void * creator;
    void * to;
    int data;
    bool Valid() { return (type != evInvalid); };
    bool SendToUnvisible() { return type == evnCommand; }
    const char * GetKeyString(); // can use ONLY key, not keychar!!!
    bool KeyPrintable();
};

const int ktInvalid = 0;
const int ktTable1Start = 10;
const int ktNum = 10; // 10 == 0, 11 = 1...
const int ktKeypadNum = 20; // same in keychar, different in keyp[]
const int ktAlpha = 30; // 30 == A, 31 == B...
// small and capital letters are different only in keychar
const int ktSpace = 56;
const int ktTable1End = 56;
// 57-255 unused
const int ktOtherPrintableStart = 256; //from 256 to 511, have keychars like ;'[]`
const int ktOtherPrintableEnd = 511;
// from 512 to 600 are non-printable keys, but with 'right' GetKeyString()
const int ktTable2Start = 512;
const int ktDown = 512;
const int ktUp = 513;
const int ktLeft = 514;
const int ktRight = 515;
const int ktEnter = 516;
const int ktEsc = 517;
const int ktTab = 518;
const int ktCapsLock = 519;
const int ktLeftShift = 520;
const int ktLeftControl = 521;
const int ktLeftAlt = 522;
const int ktModeSwitch = 523;
const int ktRightAlt = 524;
const int ktRightControl = 525;
const int ktRightShift = 526;
const int ktBackspace = 527;
const int ktInsert = 528;
const int ktHome = 529;
const int ktPageUp = 530;
const int ktDelete = 531;
const int ktEnd = 532;
const int ktPageDown = 533;
const int ktKPEnter = 534;
const int ktLeftMeta = 535;
const int ktRightMeta = 536;
const int ktNumLock = 537;
const int ktKPDivide = 538;
const int ktKPMultiply = 539;
const int ktKPMinus = 540;
const int ktKPPlus = 541;
const int ktKPHome = 542; // KP7
const int ktKPEnd = 543; // KP1
const int ktKPPageUp = 544; // KP9
const int ktKPPageDown = 545; // KP3
const int ktKPUp = 546; // KP8
const int ktKPDown = 547; // KP2
const int ktKPLeft = 548; // KP4
const int ktKPRight = 549; // KP6
const int ktKPBegin = 550; // KP5
const int ktKPInsert = 551; // KP0
const int ktKPDelete = 552; // KP.
const int ktTable2End = 552;
// from 600 to 699 are Fxxs
const int ktFxxStart = 600;
const int ktFxxEnd = 699; // 50 Fxx...
const int ktMouseButtonStart = 700;
const int ktMouseButtonEnd = 799; // 100 mouse buttons should be enough :)
const int ktNoSymbolStart = 800;
const int ktNoSymbolEnd = 1055;
const int ktMAX = 1056;


const cmInvalid = 0;

class EventManager {
  protected:
    Event * first, * last;
    virtual Event * New() = 0;
    bool keyp[ktMAX];
  public:
    EventManager();
    virtual ~EventManager() { delete first; };
    Event* Get();
    void Put(Event& ev);
    void PutFirst(Event& ev);
    bool Keypressed(KeypressType which) { return keyp[which]; };
};

#endif
