#ifndef _Compat_hh_
#define _Compat_hh_

//!!!
#ifndef PI
#define PI M_PI
#endif

#ifdef Solaris
extern "C" {
int gethostname(char * name, int namelen);
};
#endif

#ifndef Linux

#include <bool.h>
#include <string.h>

inline void bzero(void * data, int size)
{
	memset(data, 0, size);
}

const double PI=3.1415926535797;

inline int byteswap(int old)
{
  return ((old & 0xff) << 24)
       + ((old & 0xff00) << 8)
       + ((old & 0xff0000) >> 8)
       + ((old & 0xff000000) >> 24);
}

inline int byteswapshort(unsigned short old)
{
  return ((old & 0xff) << 8)
       + ((old & 0xff00) >> 8);
}
extern "C" {
int usleep(unsigned int);
}

#endif
#ifdef Linux

#define TRUE true
#define FALSE false

inline int byteswap(int old)
{
  return old;
}

inline int byteswapshort(unsigned short old)
{
  return old;
}

#endif

#include <unistd.h>
#include <sys/time.h>
#include <time.h>

inline void microsleep(int wtime)
{
//#ifndef Solaris
      timespec sleepval;
      sleepval.tv_sec = 0;
      sleepval.tv_nsec = wtime*1000;
      nanosleep(&sleepval, 0);
//#else
//      usleep(wtime);
//#endif
}

#endif
