#ifndef _XlibImage_hh_
#define _XlibImage_hh_

#include "GraphConfig.hh"
#include <X11/Xlib.h>
#include <X11/extensions/XShm.h>
#include <Utils.hh>

class XBuffer;

class XDrawable {
    protected:
    GC gc;
    Drawable d; // not initialized in XDrawable!!!
    Display * display;
    Visual visual;
    int screen;
    void InitGC(); // call after creating d
  public:
    XDrawable();
    virtual ~XDrawable();
    static const int WindowSizeX = ScreenSizeX;
    static const int WindowSizeY = ScreenSizeY;
    Display * GetDisplay() { return display; };
    Drawable GetDrawable() { return d; };
    Visual GetVisual() { return visual; };
    int GetScreen() { return screen; };
    GC GetGC() { return gc; };
    virtual void Show() { };
    virtual void Hide() { };
    virtual XBuffer * CreateXImage() = 0;
};

class XlibMainWindow : public XDrawable {
    Colormap colormap;
    void CreateColormap();
  public:
    XlibMainWindow(char ** argv, int argc);
    ~XlibMainWindow();
    void Show();
    void Hide();
    virtual XBuffer * CreateXImage();    
};

class XPixmap : public XDrawable {
  public:
    XPixmap(XDrawable * parent);
    virtual XBuffer * CreateXImage();
};

class XBuffer {
  protected:
    GC gc;
    const Drawable d;
    Display * display;
    Visual visual;
    int screen;
    bool Shared;
    XBuffer(XDrawable * mainw, bool _Shared);    
  public:
    Pixel_t * buffer;
    XImage * image;  
    static const int WindowSizeX = ScreenSizeX;
    static const int WindowSizeY = ScreenSizeY;
    virtual ~XBuffer();
    inline void UpdateWindow(const int X, const int Y, const int W, const int H);
    inline void GetWindow(const int X, const int Y, const int W, const int H);
    void Sync() { XSync(display, FALSE); };
};

class XSHMBuffer : public XBuffer {
  protected:
    XShmSegmentInfo shminfo;
  public:
    XSHMBuffer(XDrawable * mainw);
    ~XSHMBuffer();
};

class XImageBuffer : public XBuffer {
  protected:
  public:
    XImageBuffer(XDrawable * mainw);
};

void InstallErrorHandler();

//

inline void XBuffer::UpdateWindow(const int X, const int Y, const int W, const int H)
{
  // this should be virtual method, but this is faster
  if (Shared)
    XShmPutImage(display, d, gc, image, X, Y, X, Y, W, H, FALSE);
  else {
    XPutImage(display, d, gc, image, X, Y, X, Y, W, H);
    XClearArea(display, d, X, Y, W, H, FALSE);
  }
}

inline void XBuffer::GetWindow(const int X, const int Y, const int W, const int H)
{
  // this should be virtual method, but this is faster
  if (Shared)
    XShmGetImage(display, d, image, X, Y, (unsigned long) -1);
  else
    XGetSubImage(display, d, X, Y, W, H, (unsigned long) -1, ZPixmap, image, X, Y);
}

#endif
