#include "XlibEvent.hh"
#include <X11/keysym.h>
#include <X11/keysymdef.h>
#include <X11/Xutil.h>
#include "XlibImage.hh"

XlibEventManager::XlibEventManager(XDrawable * _mainw)
    : mainw(_mainw)
{
  XSelectInput (mainw->GetDisplay(), mainw->GetDrawable(),
		KeyPressMask | KeyReleaseMask |
		ButtonPressMask | ButtonReleaseMask | PointerMotionMask |
		ExposureMask | FocusChangeMask);
}

void XlibEventManager::RemapKey(XEvent& xe, bool set, Event& e)
{
  char retbuf[5];
  e.keychar = ' ';
  KeySym k = XLookupKeysym (&xe.xkey, 0);
  bool HasKeyChar = FALSE;
  if (XLookupString(&xe.xkey, retbuf, 1, 0, 0) == 1) {
    e.keychar = retbuf[0];
    HasKeyChar = TRUE;
  }
  KeypressType t = ktMAX;
  if (between(k, XK_0, XK_9)) {
    t = ktNum + (k-XK_0);
    if (!HasKeyChar)
      e.keychar = t - ktNum + '0';
    goto end;
  }
  if (between(k, XK_KP_0, XK_KP_9)) {
    t = ktKeypadNum + (k-XK_KP_0);
    if (!HasKeyChar)
      e.keychar = t - ktKeypadNum + '0';
    goto end;
  }
  if (between(k, XK_A, XK_Z)) {
    t = ktAlpha + (k-XK_A);
    if (!HasKeyChar)
      e.keychar = t - ktAlpha + 'A';
    goto end;
  }
  if (between(k, XK_a, XK_z)) {
    t = ktAlpha + (k-XK_a);
    if (!HasKeyChar)
      e.keychar = t - ktAlpha + 'a';
    goto end;
  }
  if (between(k, XK_F1, XK_F35)) {
    t = ktFxxStart + (k-XK_F1) + 1;
    goto end;
  }
  if ((k == XK_KP_Space) || (k == XK_space)) {
    t = ktSpace;
    e.keychar = ' ';
    goto end;
  }
  switch (k) {
#define CS(x, y) case x: t = y; break
  CS(XK_Down, ktDown);
  CS(XK_Up, ktUp);
  CS(XK_Left, ktLeft);
  CS(XK_Right, ktRight);
  CS(XK_Return, ktEnter);
  CS(XK_Escape, ktEsc);
  CS(XK_Tab, ktTab);
  CS(XK_Caps_Lock, ktCapsLock);
  CS(XK_Shift_L, ktLeftShift);
  CS(XK_Control_L, ktLeftControl);
  CS(XK_Alt_L, ktLeftAlt);
  CS(XK_Mode_switch, ktModeSwitch);
  CS(XK_Alt_R, ktRightAlt);
  CS(XK_Control_R, ktRightControl);
  CS(XK_Shift_R, ktRightShift);
  CS(XK_BackSpace, ktBackspace);
  CS(XK_Insert, ktInsert);
  CS(XK_Home, ktHome);
  CS(XK_Page_Up, ktPageUp);
  CS(XK_Delete, ktDelete);
  CS(XK_End, ktEnd);
  CS(XK_Page_Down, ktPageDown);
  CS(XK_KP_Enter, ktKPEnter);
  CS(XK_Meta_L, ktLeftMeta);
  CS(XK_Meta_R, ktRightMeta);
  CS(XK_Num_Lock, ktNumLock);
  CS(XK_KP_Divide, ktKPDivide);
  CS(XK_KP_Multiply, ktKPMultiply);
  CS(XK_KP_Subtract, ktKPMinus);
  CS(XK_KP_Add, ktKPPlus);
  CS(XK_KP_Home, ktKPHome);
  CS(XK_KP_End, ktKPEnd);
  CS(XK_KP_Page_Up, ktKPPageUp);
  CS(XK_KP_Page_Down, ktKPPageDown);
  CS(XK_KP_Up, ktKPUp);
  CS(XK_KP_Down, ktKPDown);
  CS(XK_KP_Left, ktKPLeft);
  CS(XK_KP_Right, ktKPRight);
  CS(XK_KP_Begin, ktKPBegin);
  CS(XK_KP_Insert, ktKPInsert);
  CS(XK_KP_Delete, ktKPDelete);
#undef CS
  default: // uhm, trying XLookupString
    if (HasKeyChar) {
      t = ktOtherPrintableStart + e.keychar;
    } else // no keychar
      if (xe.xkey.keycode < (ktNoSymbolEnd - ktNoSymbolStart))
	t = ktNoSymbolStart + xe.xkey.keycode;
  }
  end:
  if (t != ktMAX) {
    if (keyp[t] != set) 
      keyp[t] = set;
    else
      t = ktMAX;
  }
  e.key = t;
}

Event * XlibEventManager::New()
{
  XEvent xe;
  Event e;
  XSync(mainw->GetDisplay(), FALSE); // needed???
  XFlush(mainw->GetDisplay());
  while (XEventsQueued(mainw->GetDisplay(), QueuedAlready)) {
    XNextEvent(mainw->GetDisplay(), &xe); // ? XWindowEvent???
    switch (xe.type) {
    case KeyRelease:
      RemapKey(xe, FALSE, e);
      if (e.key != ktMAX) {
	e.type = evKeyrelease;
	Put(e);
      }
      break;
    case KeyPress:
      RemapKey(xe, TRUE, e);
      if (e.key != ktMAX) {
	e.type = evKeypress;
	Put(e);
      }
      break;
    case FocusOut:
      e.type = evFocusOut;
      Put(e);
      // when the focus is out, we have to release all keys
      e.type = evKeyrelease;
      for (int i=0; i<ktMAX; i++)
	if (keyp[i]) {
	  e.key = i;
	  Put(e);
      }
      break;
      // case FocusIn:
    case Expose:
      e.drawarea.Origin.X = xe.xexpose.x;
      e.drawarea.Origin.Y = xe.xexpose.y;
      e.drawarea.Size.X = xe.xexpose.width;
      e.drawarea.Size.Y = xe.xexpose.height;
      e.type = evRedraw;
      Put(e);
      break;
    case ButtonPress:
    case ButtonRelease:
      // assert: xe.window == window (rellative coords)
      e.type = (xe.type == ButtonPress ? evMouseclick : evMouserelease);
      e.keychar = ' ';
      e.mousepos.X = xe.xbutton.x;
      e.mousepos.Y = xe.xbutton.y;
      if (xe.xbutton.button < (ktMouseButtonEnd - ktMouseButtonStart)) {
	e.key = xe.xbutton.button + ktMouseButtonStart;
	keyp[e.key] = (e.type == evMouseclick);
	Put(e);
      }
      break;
    case MotionNotify:
      e.type = evMousemove;
      e.mousepos.X = xe.xmotion.x;
      e.mousepos.Y = xe.xmotion.y;
      Put(e);
    }
  }
  return first;
}
