#ifndef _SimpleViews_hh_
#define _SimpleViews_hh_

#include "View.hh"
#include "Group.hh"
#include "FontCreator.hh"

class StaticText : public SelectableView {
  protected:
    char * text;
    Pixel_t * buffer1, * buffer2, *buffer3;
    TextDirection direction;
    FontShape fontshape;
    void CreateBufs();
  public:
    StaticText(const char * _text, TextDirection _direction=tdNorth,
	       FontShape _fontshape=fsRegular);
    ~StaticText();
    void Draw();
    void SetText(const char * _text);
    const char * GetText() { return text; };
    void SetColor(const Pixel_t color, const ColorIndex index);
};

class Label : public StaticText {
  public:
    Label(const char * _text, const CommandType _cc = cmInvalid,
	  const bool _AutoResize = TRUE, TextDirection _direction=tdNorth,
	  FontShape _fontshape=fsRegular);
};

class Padding : public View {
  public:
    Padding(const Align direction=VAVertical, const int Size=20);
};

class Title : public StaticText {
  public:
    Title(const char * _text, TextDirection _direction=tdNorth,
	  FontShape _fontshape=fsRegular);
};

class Picture; // defined in Picture.hh

class PictureView : public SelectableView {
  protected:
    Picture * picture;
    bool DeleteP;
  public:
    PictureView(Picture * _picture=0, bool _DeleteP = TRUE, const CommandType _cc = cmInvalid);
    ~PictureView();
    void SetPicture(Picture * _picture);
    void Draw();
};

class CheckBoxImg; // defined in SimpleViews.cc

class CheckBox : public Group {
  protected:
    friend class CheckBoxImg;
    bool Checked;
    bool * Valuep;
    CheckBoxImg * Status_v;
  public:
    StaticText * Text;
    CheckBox(const char * _text, bool _Checked=FALSE, bool * _Valuep=0,
	     FontShape _fontshape=fsRegular);
    bool IsChecked() { return Checked; };
    void SetChecked(bool _Checked);
};

class Selector : public Label {
  protected:
    const char ** Items;
    const int NumItems;
    int SelectedItem;
  public:
    Selector(const char ** _Items, const int _NumItems, const int _SelectedItem=0,
	     const bool _AutoResize = TRUE, TextDirection _direction=tdNorth,
	     FontShape _fontshape=fsRegular);
    void Choose();
};

class InputLine : public Label {
  protected:
    const int MAXTextLen;
  public:
    InputLine(const char * _text, const int _MAXTextLen, const CommandType _cc = cmInvalid,
	  const bool _AutoResize = TRUE, TextDirection _direction=tdNorth,
	  FontShape _fontshape=fsRegular);
    bool HandleEvent(Event& event);
};

class InputNumber : public Label {
  protected:
    int Number;
    int * const Valuep;
    const int MinNumber;
    const int MaxNumber;
  public:
    InputNumber(const int _Number, const int _MinNumber, const int _MaxNumber,
		int * const _Valuep=0,
		const CommandType _cc = cmInvalid,
		const bool _AutoResize = TRUE, TextDirection _direction=tdNorth,
		FontShape _fontshape=fsRegular);
    bool HandleEvent(Event& event);
    void Deselect();
    void SetNumber(const int _Number, bool DoCheck=TRUE);
    const int GetNumber() const { return Number; };
};

class PictureSelector : public PictureView {
  protected:
    const int NumPictures;
    Picture ** pictures;
    int ItemNum;
  public:
    PictureSelector(const int _NumPictures, Picture ** _pictures);
    void SetItem(int _ItemNum);
    int GetItem() { return ItemNum; };
    void Choose();
};

#endif
