#include "SimpleViews.hh"
#include "FontCreator.hh"
#include "Group.hh"
#include "Picture.hh"
#include "Application.hh"
#include "XVisionGlobal.hh"
#include <stdio.h>

StaticText::StaticText(const char * _text, TextDirection _direction=tdNorth,
		       FontShape _fontshape=fsRegular)
    : text(0), buffer1(0), buffer2(0), buffer3(0),
  direction(_direction), fontshape(_fontshape)
{
  AutoCenter = TRUE;
  AutoResize = TRUE;
  SetText(_text);
}

StaticText::~StaticText()
{
  delete text;
  delete buffer1;
  delete buffer2;
  delete buffer3;
}

void StaticText::CreateBufs()
{
  delete buffer1;
  buffer1 = 0;
  delete buffer2;
  buffer2 =0;
  delete buffer3;
  buffer3 = 0;
  int FontWidth = 0;
  int FontHeight = 0;
  if (text) {
    buffer1 = fontcreator->CreateFontImage(text, Colors[ciForeground], direction,
					   fontshape, FontWidth, FontHeight);
    buffer2 = fontcreator->CreateFontImage(text, Colors[ciHighlightedFG],  direction,
					   fontshape, FontWidth, FontHeight);
    buffer3 = fontcreator->CreateFontImage(text, Colors[ciDisabledFG],  direction,
					   fontshape, FontWidth, FontHeight);    
  }
/*  bool Xsize = (direction == tdNorth) || (direction == tdSouth);
  int omS = (Xsize ? MinSize.X : MinSize.Y);
  int oaS = (Xsize ? Area.Size.X : Area.Size.Y); */
  MinSize.X = FontWidth;
  MinSize.Y = FontHeight;    
/*  int nmS = (Xsize ? MinSize.X : MinSize.Y);
  if ((!AutoCenter) || ((omS != nmS) && (nmS > oaS))) */
  if (!AutoCenter || (MinSize.X > Area.Size.X) || (MinSize.Y > Area.Size.Y))
    SetSize(MinSize);
}

void StaticText::SetText(const char * _text)
{
  if (((!text) && (!_text)) || (text && _text && (!strcmp(text, _text))))
    return;
  delete text;
  text = 0;
  if (_text) {
    text = new char[strlen(_text)+1];
    strcpy(text, _text);
  }
  CreateBufs();
  if (Visible && (!Hidden)) {
//    Hide();
//    Show();
    (parent ? parent : this)->Redraw();
  }
}

void StaticText::SetColor(const Pixel_t color, const ColorIndex index)
{
  if (!(Colors[index] == color)) {
    SelectableView::SetColor(color, index);
    CreateBufs();
    if (IsUsedNow(index))
      Redraw();
  }
}

void StaticText::Draw()
{
  if (text) {
    int nX = GetX();
    int nY = GetY();
    if (AutoCenter) {
      if (parent && (parent->ChildAlign == VAVertical))
	nX += (Area.Size.X - MinSize.X)/2;
      else
	nY += (Area.Size.Y - MinSize.Y)/2;
    }
    Pixel_t * buf = buffer1;
    if (!Enabled)
      buf = buffer3;
    else
      if (Selected)
	buf = buffer2;
    app_global->fb->PutMaskImage_sd(nX, nY,
				    Min(Area.Size.X, MinSize.X), Min(Area.Size.Y, MinSize.Y),
				    buf, MinSize.X);
  }
}

Label::Label(const char * _text, const CommandType _cc,
	     const bool _AutoResize=TRUE, TextDirection _direction=tdNorth,
	     FontShape _fontshape=fsRegular)
    : StaticText(_text, _direction, _fontshape)
{
  AutoResize = _AutoResize;
  choosecommand = _cc;
  Selectable = TRUE;
}
   
Padding::Padding(const Align direction=VAVertical, const int Size=20)
{
  if (direction == VAVertical)
    SetSize(Point(1, Size));
  else
    SetSize(Point(Size, 1));    
  MinSize = Area.Size;
}

Title::Title(const char * _text, TextDirection _direction=tdNorth,
	     FontShape _fontshape=fsRegular)
    : StaticText(_text, _direction, _fontshape)
{
  SetColor(Pixel_t_Yellow, ciForeground);
}

PictureView::PictureView(Picture * _picture=0, bool _DeleteP = TRUE, const CommandType _cc/*  = cmInvalid */)
    : picture(_picture), DeleteP(_DeleteP)
{
  if (_cc != cmInvalid) {
    Selectable = TRUE;
    choosecommand = _cc;
  }
  if (picture) {
    MinSize.X = picture->Width();
    MinSize.Y = picture->Height();
    SetSize(MinSize);  
  }
}

PictureView::~PictureView()
{
  if (DeleteP)
    delete picture;
}

void PictureView::SetPicture(Picture * _picture)
{
  if (DeleteP)
    delete picture;
  picture = _picture;
  if (picture) {
    MinSize.X = picture->Width();
    MinSize.Y = picture->Height();
    SetSize(MinSize);
  }
  if (parent)
    parent->DrawPartBG(this);
  Redraw();
}

void PictureView::Draw()
{
  if (picture)
    app_global->fb->PutMaskImage_sd(GetX(), GetY(), picture->Width(), picture->Height(),
		 picture->Data(), picture->Width());
}

class CheckBoxImg : public PictureView {
  protected:
    friend class CheckBox;
    CheckBoxImg(bool Checked);
  public:
    void Choose();
};

CheckBoxImg::CheckBoxImg(bool Checked)
    : PictureView(Checked ? checkbox_checked : checkbox_unchecked,
		  FALSE)
{
  Selectable = TRUE;
}

void CheckBoxImg::Choose()
{
  CheckBox * c = (CheckBox *) parent;
  c->Checked = !c->Checked;
  SetPicture(c->Checked ? checkbox_checked : checkbox_unchecked);
  if (c->Valuep)
    *(c->Valuep) = c->Checked;
  parent->SendDataChanged();
}

CheckBox::CheckBox(const char * _text, bool _Checked=FALSE,
		   bool * _Valuep=0, FontShape _fontshape=fsRegular)
    : Group(VAHorizontal), Checked(_Checked), Valuep(_Valuep)
{
  AutoResize = TRUE;
  Status_v = new CheckBoxImg(Checked);
  SetColor(Status_v->GetColor(ciHighlightedBG), ciHighlightedBG);  
  Insert(Status_v);
  Insert(new Padding(VAHorizontal));
  Text = new StaticText(_text, tdNorth, _fontshape);
  Insert(Text);
}

void CheckBox::SetChecked(bool _Checked)
{
  if (Checked == _Checked)
    return;
  Status_v->Choose();
}

Selector::Selector(const char ** _Items, const int _NumItems, const int _SelectedItem=0,
	 const bool _AutoResize = TRUE, TextDirection _direction=tdNorth,
		   FontShape _fontshape=fsRegular)
    : Label(_Items[_SelectedItem], cmInvalid, _AutoResize, _direction, _fontshape),
  Items(_Items), NumItems(_NumItems), SelectedItem(_SelectedItem)
{
}

void Selector::Choose()
{
  SelectedItem++;
  if (SelectedItem>=NumItems)
    SelectedItem = 0;
  SetText(Items[SelectedItem]);
}

InputLine::InputLine(const char * _text, const int _MAXTextLen, const CommandType _cc /* = cmInvalid */,
	  const bool _AutoResize = TRUE, TextDirection _direction=tdNorth,
	  FontShape _fontshape=fsRegular)
    : Label(_text, _cc, _AutoResize, _direction, _fontshape),
  MAXTextLen(_MAXTextLen)
{
}

bool InputLine::HandleEvent(Event& event)
{
  if ((!Visible) || Hidden)
    return TRUE;
  if (!Label::HandleEvent(event))
    return FALSE;
  if ((event.type == evKeypress) && event.KeyPrintable()) {
    int slen = strlen(text);
    if (slen>MAXTextLen)
      return FALSE;
    char * s = new char[slen+2];
    strcpy(s, text);
    s[slen] = event.keychar;
    s[slen+1] = 0;
    SetText(s);
    SendDataChanged();
    return FALSE;
  }
  if ((event.type == evKeypress) &&
      ((event.key == ktDelete) || (event.key == ktBackspace))) {
    int slen = strlen(text);
    if (slen <= 0)
      return FALSE;
    char * s = new char[slen+1];
    strcpy(s, text);
    s[slen-1] = 0;
    SetText(s);
    SendDataChanged();
    return FALSE;
  }
  return TRUE;
}

PictureSelector::PictureSelector(const int _NumPictures, Picture ** _pictures)
    : PictureView(_pictures[0], FALSE), NumPictures(_NumPictures),
  pictures(_pictures), ItemNum(0)
{
  Selectable = TRUE;
}

void PictureSelector::Choose()
{
  SetItem(ItemNum+1);
}

void PictureSelector::SetItem(int _ItemNum)
{
  if (ItemNum == _ItemNum)
    return;
  ItemNum = _ItemNum;
  if (ItemNum >= NumPictures)
    ItemNum = 0;
  SetPicture(pictures[ItemNum]);
  SendDataChanged();
}

static const int invalid_number = -4888839; // can't initialize on this number

InputNumber::InputNumber(const int _Number, const int _MinNumber, const int _MaxNumber,
		int * const _Valuep=0,
		const CommandType _cc /* = cmInvalid */,
		const bool _AutoResize = TRUE, TextDirection _direction=tdNorth,
		FontShape _fontshape=fsRegular)
    : Label(" ", _cc, _AutoResize, _direction, _fontshape),
  Number(invalid_number), Valuep(_Valuep), MinNumber(_MinNumber), MaxNumber(_MaxNumber)
{
  SetNumber(_Number);
}

bool InputNumber::HandleEvent(Event& event)
{
  if ((!Visible) || Hidden)
    return TRUE;
  if (!Label::HandleEvent(event))
    return FALSE;
  if ((event.type == evKeypress) && between(event.keychar, '0', '9')) {
    SetNumber(Number*10 + (event.keychar - '0'), TRUE);
    return FALSE;
  }
  if ((event.type == evKeypress) &&
      ((event.key == ktDelete) || (event.key == ktBackspace))) {
    SetNumber(Number/10, FALSE);
    return FALSE;
  }
  return TRUE;
}

void InputNumber::Deselect()
{
  if (!between(Number, MinNumber, MaxNumber))
    SetNumber(MinNumber);
  Label::Deselect();
}

void InputNumber::SetNumber(const int _Number, bool DoCheck=TRUE)
{
  if (DoCheck && (_Number > MaxNumber))
    return;
  bool Pass = FALSE;
  if (between(_Number, MinNumber, MaxNumber)) {
    Pass = TRUE;
    if (Valuep)
      *Valuep = _Number;
  }
  if (Number == _Number)
    return;
  Number = _Number;
  char s[40];
  sprintf(s, "%i", Number);
  SetText(s);
  if (Pass)
    SendDataChanged();
}

