#include "Application.hh"
#include "FontCreator.hh"
#include "FrameBuffer.hh"

Application * app_global = 0;

Application::Application(FrontBuffer * _front, FrameBuffer * _fb,
			 EventManager * _evman, const Align _align=VAVertical)
    : Group(_align), evman(_evman), front(_front), fb_save(_fb),
  fbstop_count(0), rearrange_count(0), fb(_fb)
{
  app_global = this;
}

Application::~Application()
{
  delete evman;
  app_global = 0;
}

void Application::CreateEvent(Event& ev)
{
  evman->Put(ev);
}

void Application::Initialize()
{
  ReArrange(TRUE);
  Show();
  Select();
}

bool Application::Run()
{
  Event * e;
  if ((e = evman->Get())) {
    HandleEvent(*e);
    delete e;
    return TRUE;
  }
  return FALSE;
}

bool Application::HandleEvent(Event& event)
{
  if (event.type == evRedraw) {
    front->AddDirty(event.drawarea.Origin.X, event.drawarea.Origin.Y,
		    event.drawarea.Size.X, event.drawarea.Size.Y);
    return FALSE;
  }
  return Group::HandleEvent(event);
}


void Application::ReArrange(bool CallParent=TRUE, View * except=0)
{
  StopRedraw();
  Group::ReArrange(CallParent, except);
  StartRedraw();
  Center();
}

void Application::Center()
{
  SetOrigin(Point(
		  (fb->WindowSizeX-Area.Size.X)/2,
		  (fb->WindowSizeY-Area.Size.Y)/2));
  if (fb) {
    fb->Fill(0, 0, fb->WindowSizeX, fb->WindowSizeY, RGB(0, 0, 0));
    Redraw();
  }
}
