#ifndef _GameServer_hh_
#define _GameServer_hh_

#include "Network/NetMessage.hh"
#include "Game/Players.hh"
#include "Network/Connection.hh"

class NetConnector;

enum GSPlayerState_t {
  gspsSetup, gspsStartGame, gspsStartRound, gspsPlaying,
					    gspsEndRound, gspsEndGame };

class GameServer {
  public:
    static const int MaxClients = 16;
    static const int MAXPlayers = Players::MAXPlayers;
  protected:
    NetConnector * init_network;
    NetConnector * clients[MaxClients];
    GSPlayerState_t client_state[MaxClients];
    int num_clients;
    int rounds;
    int ScreenSzX, ScreenSzY;
    void ProcessInit();
    void CollectMessages();
    void ProcessMessages();
    void SendMessages();
    void KillPlayer(int player_num);
    void SendAll(NetMessage * nm);
    void SendAllExcept(NetMessage * nm, int except);
    void ProcessQuit();
    void ProcessSetGameFPS();
    void CheckState();
    void ProcessStateType(MsgType_t2 which, GSPlayerState_t type2);
    void ProcessResendAllExcept(MsgType_t2 which);
    nmOptions * cached_options;
    void ProcessOptions();
    nmPlayerSetup * player_setup[MAXPlayers];
    int player_setup_clientnum[MAXPlayers];
    void ProcessPlayerSetup();
    int frametime;
    Multiplexor * multip;
    int fd2netconn[Multiplexor::MaxFD];
  public:
    GameServer(int port);
    ~GameServer();
    void Run();
};

#endif
