#include "FrontBuffer.hh"
#include "FrameBuffer.hh"
#include "Debug.hh"
#include <string.h>
#include "Compat.hh"

FrontBuffer::FrontBuffer()
    : lastFB(0), lastFBp(&framebufs[0]), dw(new DirtyWindow[MAXChangesDW]), last(dw), buffer(0)
{
  bzero(framebufs, sizeof(framebufs));
  // needs this for AddDirtyWindow
  Clear();
};

FrontBuffer::~FrontBuffer()
{
  delete[] dw;
}

void FrontBuffer::AddFrameBuffer(FrameBuffer * fb)
{
  if (lastFB == MAXFrameBuffers)
    return;
  lastFB++;
  *(lastFBp++) = fb;
  fb->front = this;
}

void FrontBuffer::InsertFrameBuffer(FrameBuffer *fb, FrameBuffer * before)
{
  if (lastFB == MAXFrameBuffers)
    return;
  for(FrameBuffer ** f = &framebufs[0]; f < lastFBp; f++) {
    if ((*f) == before) {
      f--;
      FrameBuffer ** g = lastFBp;
      for(FrameBuffer ** h = g-1; h > f; h--, g--)
	*g = *h;
      *(++f) = fb;
      lastFBp++;
      lastFB++;
      return;
    }
  }
}

void FrontBuffer::RemoveFrameBuffer(FrameBuffer * fb)
{
  for (FrameBuffer ** f = &framebufs[0]; f < lastFBp; f++)
    if ((*f) == fb) {
      for (FrameBuffer ** f2=(f++); f < lastFBp; f2++, f++)
	*f2 = *f;
      *(--lastFBp) = 0;
      lastFB--;
      return;
    }
}

void FrontBuffer::Clear()
{
  AddDirty(0, 0, WindowSizeX, WindowSizeY);
}

void FrontBuffer::RemoveDuplicateDW()
{
}

#ifdef DEBUGPaint
int gq = 0;
#endif

void FrontBuffer::Show()
{
  if ((!lastFB) || (last == dw))
    return;
  if (last != dw) {
    DEBUGPPaint("count: " << (last-dw));
  }
  RemoveDuplicateDW();
#ifdef DEBUGPaint
  int q = 0;
#endif
  for (DirtyWindow * p = dw; p != last; p++) {
    UpdateDirtyWindow(p);
#ifdef DEBUGPaint
    q++;
#endif    
  }
#ifdef DEBUGPaint
  if (q != gq) {
    DEBUGPPaint("dw: " << q);
    gq = q;
  }
#endif
  UpdateScreen();
  last = dw;
}

void FrontBuffer::UpdateDirtyWindow(DirtyWindow * dirty)
{
  int X = dirty->X;
  int Y = dirty->Y;
  int W = dirty->W;
  int H = dirty->H;
  DEBUGPPaint("update: " << X << "x" << Y << ", " << W << "x" << H);
  for (FrameBuffer ** f = &framebufs[0]; f<lastFBp; f++)
    CopyRegion((*f)->transparency, (*f)->buffer,
	       buffer, X, Y, W, H);
}

static inline bool isinside(int X1, int Y1, int X2, int Y2, int PX, int PY)
{
  if ((X1 <= PX) && (PX <= X2) && (Y1 <= PY) && (PY <= Y2))
    return TRUE;
  return FALSE;
}

bool FrontBuffer::FindDuplicate(const int X, const int Y, const int W, const int H)
{
  register int PX1 = X;
  register int PX2 = X+W;
  register int PY1 = Y;
  register int PY2 = Y+H;
  for (register DirtyWindow * d = dw; d != last; d++) {
    register int X1 = d->X;
    register int Y1 = d->Y;
    register int X2 = X1+(d->W);
    register int Y2 = Y1+(d->H);
    if (isinside(X1, Y1, X2, Y2, PX1, PY1) && isinside(X1, Y1, X2, Y2, PX2, PY2))
      return TRUE;
    if (isinside(PX1, PY1, PX2, PY2, X1, Y1) && isinside(PX1, PY1, PX2, PY2, X2, Y2)) {
      // found smaller window -> replace it
      d->Set(PX1, PY1, W, H);
      return TRUE;
    }
  }
  return FALSE;
}

inline void FrontBuffer::CopyRegion(TransparencyType transparency,
				    Pixel_t * src, Pixel_t * dst, const int X, const int Y,
                       const int W, const int H)
{
  switch (transparency) {
  case ttStore:
    for (int i=0; i<H; i++) {
      int shift = X+(Y+i)*WindowSizeX;
      memcpy(dst+shift, src+shift, W*sizeof(Pixel_t));
    }
    return;
  case ttZeroMask:
    for (int i=0; i<H; i++) {
      int shift = X+(Y+i)*WindowSizeX;
      for (int j=0; j<W; j++) {
	Pixel_t s = *(src+shift+j);
	if (s.NotZero())
	  *(dst+shift+j) = s;
      }
    }
    return;
  case ttOr:
    for (int i=0; i<H; i++) {
      int shift = X+(Y+i)*WindowSizeX;
      for (int j=0; j<W; j++)
	 *(dst+shift+j) |= *(src+shift+j);
    }
    return;
  case ttAnd:
    for (int i=0; i<H; i++) {
      int shift = X+(Y+i)*WindowSizeX;
      for (int j=0; j<W; j++) 
	*(dst+shift+j) &= *(src+shift+j);
    }
    return;    
  case ttXor:
    for (int i=0; i<H; i++) {
      int shift = X+(Y+i)*WindowSizeX;
      for (int j=0; j<W; j++) // XOR???
	*(dst+shift+j) &= *(src+shift+j);
    }
    return;        
  case ttAlphaBlend:
    for (int i=0; i<H; i++) {
      int shift = X+(Y+i)*WindowSizeX;
      for (int j=0; j<W; j++)
	(dst+shift+j)->AlphaBlend(*(src+shift+j));
    }
    return;
  case ttAlphaBlendDarker:
    for (int i=0; i<H; i++) {
      int shift = X+(Y+i)*WindowSizeX;
      for (int j=0; j<W; j++)
	(dst+shift+j)->AlphaBlendDarker(*(src+shift+j));
    }
    return;
  case ttInvisible: // gcc warns if ttInvisible is not here
    return;
  }
  return;
}
