#include "Filler.hh"

Filler::Filler(FillerType_t _type)
     : ImageWidth(0), type(_type), ImageHS(0), buffer(0)
{
}

void Filler::TileBuffer(const Pixel_t* image, const int Width, const int Height)
{
  ImageWidth = Width+ImageSize;
  ImageHS = Height;
  delete buffer;
  buffer = new Pixel_t[ImageWidth*(Height+ImageSize)];
  for (int y=0; y<Height+ImageSize; y++)
    for (int x=0; x<ImageWidth; x++) {
    Pixel_t t = image[(x%Width)+(y%Height)*Width];
    *(buffer + GetLinear(x, y)) = t;
  }
}

Filler::~Filler()
{
  delete buffer;
}

