#ifndef _UDPConnection_hh_
#define _UDPConnection_hh_

#include "Connection.hh"
#include "netinet/in.h"

class UDPConnection : public Connection {
  protected:
    sockaddr_in addr;
  public:
    UDPConnection(bool _server);
    virtual ~UDPConnection();
    void SetHostname(const char * _name);
    bool Connect();
    void Disconnect();
    bool Listen();
    bool Send(char * buffer, int bufsize);
    int SendReceive(char * sendbuffer, int bufsize, char * recvbuffer, int maxsize);
    int Receive(char * buffer, int maxsize, bool Wait=TRUE);
};

#endif
