#include "Connection.hh"
#include "Utils.hh"
#include "NetworkTimings.hh"
#include "Compat.hh"
#include <string.h>

Connection::Connection(bool _server)
    : hostname(0), client_hostname(0), our_port(0), peer_port(0),
  connected(FALSE), server(_server), socket_fd(-1)
{
}

void Connection::SetHostname(const char * _name)
{
  delete hostname;
  int slen = 0;
  if (_name)
    slen = strlen(_name);
  if (slen) {
    hostname = new char[slen+1];
    strcpy(hostname, _name);
    any_addr = FALSE;
  } else {
    hostname = 0;
    any_addr = TRUE;
  }
}

Connection::~Connection()
{
}

Multiplexor::Multiplexor()
    : timeout_usec(MultiplexorConnectionTimeout), max_fd(0)
{
  FD_ZERO(&init_fdset);
  Reset();
}

void Multiplexor::Reset()
{
  current_fdset = init_fdset;
}

void Multiplexor::AddConnection(Connection * c)
{
  int cfd = c->GetFD();
  if (!between(cfd, 0, MaxFD-1)) {
    Error("addconnection: invalid fd number");
    return;
  }
  FD_SET(cfd, &init_fdset);
  FD_SET(cfd, &current_fdset);
  fd2con[cfd] = c;
  if (cfd > max_fd)
    max_fd = cfd;
}

void Multiplexor::RemoveConnection(Connection *c)
{
  int cfd = c->GetFD();
  if (!between(cfd, 0, MaxFD-1)) {
    Error("removeconnection: invalid fd number");
    return;
  }
  FD_CLR(cfd, &init_fdset);
  FD_CLR(cfd, &current_fdset);
  fd2con[cfd] = 0;
  if (max_fd == cfd)
    for(; (max_fd>=0) && !fd2con[max_fd]; max_fd--);
}

void Multiplexor::ReWaitConnection(Connection *c)
{
  FD_SET(c->GetFD(), &current_fdset);
}

Connection * Multiplexor::WaitForConnection()
{
  timeval tv;
  tv.tv_sec = 0;
  tv.tv_usec = timeout_usec;
  fd_set cur = current_fdset;
  int retval = select(max_fd+1, &cur, 0, 0, &tv);
  if (retval && (retval != -1)) {
    for (int i=0; i<=max_fd; i++)
      if (fd2con[i] && FD_ISSET(i, &cur)) {
        //        PrintErr << "c: " << i << nl;
        // changed!
        FD_CLR(i, &current_fdset);
	return fd2con[i];
      }
    Error("not in set");
  }
//  Error("t/o");
  return 0;
}
