#include "AI.hh"
#include "Utils.hh"
#include "Compat.hh"
#include <math.h>

static const int DoCrashCheckCounter = 3; // each xx steps recompute new_dir; uhm, not exactly, see below

static const int Parts = 8;
static const double PartAngle = 2*PI/Parts;
static const int R = 200;
static const int Step = 5;
static const int RStep = R/Step;
static const double AngleStep = 1/double(R);
static const int AngleCount = int(2*PI*R/Parts);
static const PartPoints = RStep*AngleCount;
static const Rshift = 5;

static int linear2crash[Parts][PartPoints];

bool linear2crash_initialized = FALSE;

static void init_linear2crash()
{
  int * q = linear2crash[0];
  for(int p=0; p<Parts; p++) {
    for(int r=0; r<RStep; r++) {
      double ang = p*PartAngle;
      for (int a=0; a<AngleCount; a++) {
	int x = int(cos(ang)*(r+Rshift));
	int y = int(sin(ang)*(r+Rshift));
	ang += AngleStep;
	int linearPos = x + y*Worm::PlaygroundXSize;
	*(q++) = linearPos;
      }
    }
  }
}

static int detect_crash(int part, int linearPos)
{
  int * f = linear2crash[part];
  int cbmin = -linearPos;
  int cbmax = CrashBufferSize-linearPos;
  CrashBufferItem_t * start = &(*crashBuffer)[linearPos];
  int ret = 0;
  for (int i=PartPoints; i>0; i--) {
    int pos = *(f++);
    if (between(pos, cbmin, cbmax)) {
      if ((start+pos)->PlayerNumber)
	ret++;
    } else
      ret += 2; // end of playground
  }
  return ret;
}

AI::AI()
    : Worm(ptAI), control_counter(0), new_dir(0)
{
  if (!linear2crash_initialized) {
    linear2crash_initialized = TRUE;
    init_linear2crash();
  }
}

void AI::Control()
{
  if (!control_counter) {
    int part = (Angle*Parts+MAXAngle/2)/MAXAngle;  
    int pl = (part ? (part-1) : (Parts-1));
    int pr = part;
    int cl = detect_crash(pl, linearPos);
    int cr = detect_crash(pr, linearPos);
    new_dir = cl - cr;
    control_counter = Rand(DoCrashCheckCounter)+DoCrashCheckCounter;
  }
  if (new_dir>0)
    TurnRight();
  else
    if (new_dir<0)
      TurnLeft();  
  control_counter--;
}
  
