#include "GGIEvent.hh"
#include "GGIFrontBuffer.hh"

GGIEventManager::GGIEventManager(GGIFrontBuffer * _frontb)
  : frontb(_frontb)
{
}

Event * GGIEventManager::New()
{
  Event e(this);
  int evmask;
  ggi_event ev;
  struct timeval t={0,0};
  evmask=emKeyPress|emKeyRelease|emPointer;
  
  while (ggiEventPoll(frontb->vis,evmask,&t)) {
    do {
      ggiEventRead(frontb->vis,&ev,evmask);
    } while(! ( (1 << ev.any.type) & evmask ) );
    
    switch(ev.any.type) { 
    case evPtrButtonPress:
    case evPtrButtonRelease:
      e.type = ((ev.any.type == evPtrButtonPress) ? evMouseclick : evMouserelease);
      e.keychar = ' ';
      e.mousepos.X = lastMoveX; //!!! seems like mouse click events are f*cked up
      e.mousepos.Y = lastMoveY;
      e.key = ktMouseButtonStart;
      if (ev.pbutton.button&2)
	e.key = ktMouseButtonStart+1;
      if (ev.pbutton.button&4)
	e.key = ktMouseButtonStart + 2;
       keyp[e.key] = (e.type == evMouseclick);
       Put(e);
       break;
    case evPtrAbsolute:
      e.type = evMousemove;
      e.keychar = ' ';
      e.mousepos.X = ev.pmove.x;
      e.mousepos.Y = ev.pmove.y;
      lastMoveX = e.mousepos.X;
      lastMoveY = e.mousepos.Y;
      Put(e);
      break;
    case evKeyPress:
    case evKeyRepeat:	    
      RemapKey(ev, TRUE, e);
      if (e.key != ktMAX) {
	e.type = evKeypress;
	Put(e);
      }
      break;
    case evKeyRelease:
      RemapKey(ev, FALSE, e);
      if (e.key != ktMAX) {
	e.type = evKeyrelease;
	Put(e);
      }
      break;
    }
  }
  return first;
}

void GGIEventManager::RemapKey(ggi_event& ev, bool set, Event& e)
{
  e.keychar = ' ';
  KeypressType t = ktMAX;
  switch (KTYP(ev.key.sym)) {
  case KT_LATIN:
  case KT_LETTER:
     e.keychar = KVAL(ev.key.sym);
     t = ktOtherPrintableStart + e.keychar;
     if (e.keychar == '\x1b' /* esc */) {
	t = ktEsc;
	e.keychar = ' ';
     }
     if (e.keychar == '\x7f' /* BS */) {
	t = ktBackspace;
	e.keychar = ' ';
     }
    break;
  default:
    switch (ev.key.sym) {
#define CS(x, y) case x: t = y; break
       CS(K_DOWN, ktDown);
       CS(K_UP, ktUp);
       CS(K_LEFT, ktLeft);
       CS(K_RIGHT, ktRight);
       CS(K_ENTER, ktEnter);
  /*  CS(K_Escape, ktEsc);
  CS(XK_Tab, ktTab);
  CS(XK_Caps_Lock, ktCapsLock);
  CS(XK_Shift_L, ktLeftShift);
  CS(XK_Control_L, ktLeftControl);
  CS(XK_Alt_L, ktLeftAlt);
  CS(XK_Mode_switch, ktModeSwitch);
  CS(XK_Alt_R, ktRightAlt);
  CS(XK_Control_R, ktRightControl);
  CS(XK_Shift_R, ktRightShift);
  CS(XK_BackSpace, ktBackspace);
  CS(XK_Insert, ktInsert);
  CS(XK_Home, ktHome);
  CS(XK_Page_Up, ktPageUp);
  CS(XK_Delete, ktDelete);
  CS(XK_End, ktEnd);
  CS(XK_Page_Down, ktPageDown);
  CS(XK_KP_Enter, ktKPEnter);
  CS(XK_Meta_L, ktLeftMeta);
  CS(XK_Meta_R, ktRightMeta);
  CS(XK_Num_Lock, ktNumLock);
  CS(XK_KP_Divide, ktKPDivide);
  CS(XK_KP_Multiply, ktKPMultiply);
  CS(XK_KP_Subtract, ktKPMinus);
  CS(XK_KP_Add, ktKPPlus);
  CS(XK_KP_Home, ktKPHome);
  CS(XK_KP_End, ktKPEnd);
  CS(XK_KP_Page_Up, ktKPPageUp);
  CS(XK_KP_Page_Down, ktKPPageDown);
  CS(XK_KP_Up, ktKPUp);
  CS(XK_KP_Down, ktKPDown);
  CS(XK_KP_Left, ktKPLeft);
  CS(XK_KP_Right, ktKPRight);
  CS(XK_KP_Begin, ktKPBegin);
  CS(XK_KP_Insert, ktKPInsert);
  CS(XK_KP_Delete, ktKPDelete);
  */
#undef CS
    }
  }
  if (t != ktMAX) {
    if (keyp[t] != set) 
      keyp[t] = set;
    else
      t = ktMAX;
  }
  e.key = t;
}
