#include "ScoreTable.hh"
#include "Game/Players.hh"
#include "XVision/SimpleViews.hh"
#include "Game/Worm.hh"
#include <stdlib.h>

ScoreTable::ScoreTable()
    : Group(VAHorizontal)
{
  Group * order_g = new Group(VAVertical);
  StaticText * q = new StaticText("Order", tdNorth, fsSmallOblique);
  q->SetAutoCenter(FALSE);
  order_g->Insert(q);
  Group * points_g = new Group(VAVertical);
  q = new StaticText("Points", tdNorth, fsSmallOblique);
  q->SetAutoCenter(FALSE);  
  points_g->Insert(q);
  Group * name_g = new Group(VAVertical);
  q = new StaticText("Name", tdNorth, fsSmallOblique);
  q->SetAutoCenter(FALSE);  
  name_g->Insert(q);
  for (int i=0; i<showitems; i++) {
    StaticText * o, * p, *n;
    char tx[40];
    sprintf(tx, "%i.", i+1);
    o = new StaticText(tx);
    p = new StaticText("");
    n = new StaticText("");
    o->SetAutoCenter(FALSE);    
    p->SetAutoCenter(FALSE);          
    n->SetAutoCenter(FALSE);
    if (!i) {// first is hightlighted
      o->SetColor(Pixel_t_Yellow, ciForeground);
      p->SetColor(Pixel_t_Yellow, ciForeground);
      n->SetColor(Pixel_t_Yellow, ciForeground);
    }
    order_g->Insert(o);
    points_g->Insert(p);
    name_g->Insert(n);
    points[i] = p;
    names[i] = n;
  }
  Insert(order_g);
  Insert(points_g);
  Insert(name_g);
}

struct sc_t {
  int player_num;
  int score;
};

static int sc_t_sort(const void * i1, const void * i2)
{
  // need descending order (higher first)
  return (((const sc_t *) i1)->score > ((const sc_t *) i2)->score) ? -1 : 1;
}

void ScoreTable::UpdateScores(Players * players)
{
  sc_t sortt[players->MAXPlayers];
  int pl_count = players->MAXPlayers;
  sc_t * s = sortt;
  for (int i=0; i<pl_count; i++) {
    Worm * w = players->GetPlayer(i);
    if (w) {
      s->player_num = i;
      (s++)->score = w->GetScore();
    }
  }
  int cnt = s-sortt;
  if (cnt)
    qsort(sortt, cnt, sizeof(sc_t), sc_t_sort);
  // fill first cnt items with name
  s = sortt;
  cnt = Min(cnt, showitems);
  for (int i=0; i<cnt; i++, s++) {
    Worm * w = players->GetPlayer(s->player_num);
    char tx[40];
    sprintf(tx, "%i", s->score);
    points[i]->SetText(tx);
    names[i]->SetText(w->GetName());    
  }
  // other set to ""
  for (int i=cnt; i<showitems; i++) {
    points[i]->SetText("");
    names[i]->SetText("");
  }
}
