#ifndef _PlayerSelector_hh_
#define _PlayerSelector_hh_

#include "XVision/Group.hh"
#include "Event.hh"
#include "MainGlobal.hh"
#include "Filler.hh"
#include "Game/Worm.hh"

const CommandType cmPrevPage = 3000;
const CommandType cmNextPage = 3001;
const CommandType cmStart = 3002;

class Players;
class PlayerSelectorItem;
class Picture;

class PlayerSelector : public Group {
  protected:
    bool KeyCaptured[ktMAX];
    Players * players;
    int Page;
    PlayerSelectorItem * selectors[PanelSize];
    bool CanClose();
    bool SetPage(int _Page);
    View * start, * prev, * next;
    void CreatePlayer(int ItemNum, PlayerType_t type, Filler * filler, const char * name,
			KeypressType leftkey=ktInvalid, KeypressType rightkey=ktInvalid);
  public:
    PlayerSelector(Players * _players);
    bool HandleEvent(Event& event);
    bool CanStart();
    void SetHidden(bool _hidden, bool rearrange=TRUE);
    void ChangeRemoteItem(int ItemNum, PlayerType_t _type,
 	  FillerType_t _filler, int _filler_opt1, int _filler_opt2, const char * _name);
    void DeleteAllCapturedKeys();
};

#endif
