#include "PlayerSelector.hh"
#include "PaintInterface/TargaPicture.hh"
#include "Event.hh"
#include "XVision/SimpleViews.hh"
#include "MainGlobal.hh"
#include "Game/Players.hh"
#include "Game/AI.hh"
#include "Game/Human.hh"
#include "Game/Remote.hh"
#include "WormApp.hh"
#include "Debug.hh"
#include <string.h>
#include <stdio.h>
#include "Compat.hh"

#include "FillerSelector.hh"
#include "PlayerControlView.hh"
#include "PlayerTypeView.hh"
#include "PlayerSelectorItem.hh"

const int pgReread = -2;

PlayerSelector::PlayerSelector(Players * _players)
    : Group(VAVertical), players(_players), Page(0)
{
  DeleteAllCapturedKeys();
  for (int i=0; i<PanelSize; i++) {
    selectors[i] = new PlayerSelectorItem;
    Insert(selectors[i]);
  }
  start = new Label("Start!", cmStart);
  prev = new PictureView(global_ArrowLeft, FALSE, cmPrevPage);
  next = new PictureView(global_ArrowRight, FALSE, cmNextPage);
  Insert(
    CreateGroup(new Group(VAHorizontal),
      CreateItem(new Padding(VAHorizontal, 180),		
      CreateItem(prev,
      CreateItem(new Padding(VAHorizontal),
      CreateItem(next,
      CreateItem(new Padding(VAHorizontal),			 
      CreateItem(start,
      CreateItem(new Padding(VAHorizontal, 180),
      0))))))))); 
  SetPage(pgReread);
}

void PlayerSelector::CreatePlayer(int ItemNum, PlayerType_t type, Filler * filler, const char * name,
				    KeypressType leftkey /* = ktInvalid */, KeypressType rightkey /* = ktInvalid */)
{
  Worm * w = players->GetPlayer(ItemNum);
  if (w && (w->GetType() == ptNone))
    w = 0;
  if (!w || (type != w->GetType())) {
    switch (type) {
    case ptNone:
      w = 0;
      break;
    case ptAI:
      w = new AI;
      break;
    case ptHuman:
      w = new Human;
      break;
    case ptNetwork:
      w = new Remote;
      break;
    }
  }
  if (w) {
    w->SetName(name);
    w->SetFiller(filler);
    if (type == ptHuman)
      ((Human *) w)->SetKeys(leftkey, rightkey);
  } else
    delete filler;
  players->AddPlayer(w, ItemNum);
}
    
bool PlayerSelector::HandleEvent(Event& event)
{
  if (event.type == evnCommand) {
    if ((event.command == cmKeyCaptured) && (event.to == this)) {
      if (KeyCaptured[event.key])
	event.key = ktInvalid;
      else
	KeyCaptured[event.key] = TRUE;
      return FALSE;
    }
    if ((event.command == cmKeyUncapture) && (event.to == this)) {
      if (event.key != ktInvalid)
	KeyCaptured[event.key] = FALSE;
      return FALSE;
    }  
    if (event.command == cmPrevPage) {
      SetPage(Page-1);
      return FALSE;
    }
    if (event.command == cmNextPage) {
      SetPage(Page+1);
      return FALSE;
    }
    if (event.command == cmStart) {
      if (SetPage(Page)) {
	Event e(this);
	e.type = evnCommand;
	if (((WormApp *) app_global)->PlayingGame)
	  e.command = cmContinueGame;
	else
	  e.command = cmStartGame;
	PutEvent(e);
	return FALSE;
      }
    }
    if ((event.command == cmSlotCaptured) && (event.to == this)) {
      int in;
      for (in = 0; (in < PanelSize) && (selectors[in] != event.creator); in++);
      if (in >= PanelSize) // strange?
	return FALSE;
      Event e(event.creator);
      e.type = evnCommand;
      e.command = cmSlotCaptured;
      e.data = in + PanelSize*Page;
      e.to = app_global;
      PutEvent(e);
    }
  }
  if ((event.type == evnCommand) && (event.command == cmCancel) &&
      (!SetPage(Page)))
      return FALSE;
  return Group::HandleEvent(event);
}

bool PlayerSelector::CanClose()
{
  return TRUE;
}

bool PlayerSelector::SetPage(int _Page)
{
  if (!CanClose())
    return FALSE;
  DEBUGP("SetPage start");  
  if (_Page != pgReread) {
    // store old information back to Players
    for (int i=0; i<PanelSize; i++) {
      PlayerSelectorItem * sel = selectors[i];
      PlayerType_t type;
      FillerType_t filler_type;
      int fopt1, fopt2;
      const char * name;
      sel->GetPlayer(type, filler_type, fopt1, fopt2, &name);
      CreatePlayer(PanelSize*Page+i, type, sel->filler->GetFiller()->CreateCopy(),
		   name, sel->control->leftkey, sel->control->rightkey);
    }
  }
  if ((_Page != pgReread) && ((_Page < 0) || (_Page >= (players->MAXPlayers/PanelSize))))
    return FALSE;
  if (_Page != pgReread) {
    if (Page == _Page) {
      DEBUGP("SetPage stop (1/2)");
      return TRUE;
    } else
      Page = _Page;
  }
  app_global->StopReArrange();
  prev->SetEnabled((Page != 0));
  next->SetEnabled((Page != (players->MAXPlayers/PanelSize)));
  // load new info from players
  for (int i=0; i<PanelSize; i++) {
    PlayerSelectorItem * sel = selectors[i];
    Worm * w = players->GetPlayer(PanelSize*Page+i);
    sel->control->SetKeys(ktInvalid, ktInvalid, FALSE);
    PlayerType_t type = ptNone;    
    FillerType_t fil_type = ftFlat;
    int fil_opt1 = 0, fil_opt2 = 0;
    char s[40];
    const char * name = s;
    if (w) {
      type = w->GetType();
      Filler * fil = w->GetFiller();
      fil_type = fil->GetType();
      fil_opt1 = fil->GetFirstOption();
      fil_opt2 = fil->GetSecondOption();
      name = w->GetName();
    } else
      sprintf(s, "worm %i", PanelSize*Page+i);
    sel->Change(type, fil_type, fil_opt1, fil_opt2, name);
    if (w && (type == ptHuman)) {
      Human * h = (Human *) w;
      sel->control->SetKeys(h->KeyLeft, h->KeyRight, FALSE);
    }
    if (!w && (type != ptNone))
      sel->filler->SetRandomFiller();
  }
  app_global->StartReArrange();
  if ((!Hidden) && Visible)
    ReArrange(TRUE);
  DEBUGP("SetPage stop");
  return TRUE;
}

void PlayerSelector::SetHidden(bool _hidden, bool rearrange=TRUE)
{
  Group::SetHidden(_hidden, rearrange);
  if (!_hidden)
    SetPage(pgReread);
}

void PlayerSelector::ChangeRemoteItem(int ItemNum, PlayerType_t _type,
		FillerType_t _filler, int _filler_opt1, int _filler_opt2,
		const char * _name)
{
  if (between(ItemNum, Page*PanelSize, (Page+1)*PanelSize-1)) {
    // is also in selector...
    PlayerSelectorItem * sel = selectors[ItemNum-Page*PanelSize];
    sel->Change(_type, _filler, _filler_opt1, _filler_opt2, _name);
  }
  Filler * filler = FillerSelector::CreateNumFiller(_filler);
  filler->SetFirstOption(_filler_opt1);
  filler->SetSecondOption(_filler_opt2);
  CreatePlayer(ItemNum, _type, filler, _name);
  // deleted in CreatePlayer... delete filler;
}

void PlayerSelector::DeleteAllCapturedKeys()
{
  bzero(KeyCaptured, sizeof(KeyCaptured));  
}
