#include "PlayerControlView.hh"
#include <string.h>

PlayerControlView::PlayerControlView(TextDirection _direction=tdNorth, FontShape _fontshape=fsRegular)
    : Label("<none>", cmInvalid, TRUE, _direction, _fontshape),
  savel(ktInvalid), saver(ktInvalid),
  WaitForLKey(FALSE), WaitForRKey(FALSE),
  leftkey(ktInvalid), rightkey(ktInvalid)    
{
}

void PlayerControlView::Choose()
{
  savel = leftkey;
  saver = rightkey;
  Event e(this);
  e.type = evnCommand;
  e.command = cmKeyUncapture;
  e.to = parent->parent;
  e.key = savel;
  PutEvent(e);
  e.key = saver;
  PutEvent(e);
  WaitForLKey = TRUE;
  WaitForRKey = FALSE;
  leftkey = ktInvalid;
  rightkey = ktInvalid;
  SetText("<left?>");
}
 
void PlayerControlView::Deselect()
{
  WaitForLKey = FALSE;
  WaitForRKey = FALSE;
  if ((leftkey == ktInvalid) || (rightkey == ktInvalid))
    SetKeys(savel, saver, TRUE);
  Label::Deselect();
}

bool PlayerControlView::HandleEvent(Event& event)
{
  if ((!Visible) || Hidden || (!Enabled))
    return TRUE;
  if (Selected && (WaitForLKey || WaitForRKey)) {
    if ((event.type == evKeypress) && (event.key == ktEsc)) {
      SetKeys(savel, saver, TRUE);
      return FALSE;
    }
    if ((event.type == evKeypress) || (event.type == evMouseclick)) {
      Event e(this);
      e.type = evnCommand;
      e.command = cmKeyCaptured;
      e.key = event.key;
      e.to = parent->parent;
      PutEvent(e); // what means these codes is in PlayerSelector::HandleEvent
      if (e.key == ktInvalid)
	return FALSE;
      if (WaitForLKey) {
	leftkey = event.key;
	char s[40];
	strcpy(s, event.GetKeyString());
	strcat(s, " + <right?>");
	WaitForRKey = TRUE;
	SetText(s);
	WaitForLKey = FALSE;
      } else { // WaitForRKey
	rightkey = event.key;
	WaitForRKey = FALSE;      
	SetKeys(leftkey, rightkey, TRUE);
      }
      return FALSE;
    }
    if (event.type == evMouseclick)
      return FALSE;
  }
  return Label::HandleEvent(event);
}

void PlayerControlView::SetKeys(KeypressType _leftkey,KeypressType _rightkey,
				bool UncaptureOld)
{
  Event e(this);
  e.type = evnCommand;
  if (UncaptureOld) {
    e.command = cmKeyUncapture;
    e.key = leftkey;
    e.to = parent->parent;
    PutEvent(e);
    e.key = rightkey;
    PutEvent(e);
  }
  if ((_leftkey != ktInvalid) && (_rightkey != ktInvalid)) {
    e.command = cmKeyCaptured;
    e.key = _leftkey;
    PutEvent(e);
    if (UncaptureOld)
      leftkey = e.key;
    else
      leftkey = _leftkey;
    if (leftkey != ktInvalid) {
      e.key = _rightkey;
      PutEvent(e);
      if (UncaptureOld)
	rightkey = e.key;
      else
	rightkey = _rightkey;
      if (rightkey == ktInvalid) {
	e.command = cmKeyUncapture;
	e.key = leftkey;
	PutEvent(e);
      }
    }
  } else {
    leftkey = ktInvalid;
    rightkey = ktInvalid;
  }
  if ((leftkey == ktInvalid) || (rightkey == ktInvalid))
    SetText("<none>");
  else {
    char s[40];
    Event e;
    e.key = leftkey;
    strcpy(s, e.GetKeyString());
    strcat(s, " + ");
    e.key = rightkey;    
    strcat(s, e.GetKeyString());
    SetText(s);  
  }
}
