#ifndef _Fillers_hh_
#define _Fillers_hh_

#include "Filler.hh"

class FlatFiller: public Filler {
  protected:
    int color;
    void CreateImage();
  public:
    FlatFiller(int _color=0);
    Filler * CreateCopy() { return new FlatFiller(color); };
    int GetFirstOption() { return color; };
    void SetFirstOption(int _opt) { color = _opt; CreateImage(); };
};

class TwoOptFiller : public Filler {
  protected:
    int opt1, opt2;
    virtual void CreateImage() = 0;
    TwoOptFiller(FillerType_t _type, int _opt1, int _opt2)
      : Filler(_type), opt1(_opt1), opt2(_opt2) { };
  public:
    int GetFirstOption() { return opt1; };
    void SetFirstOption(int _opt) { opt1 = _opt; CreateImage(); };
    int GetSecondOption() { return opt2; };
    void SetSecondOption(int _opt) { opt2 = _opt; CreateImage(); };
};

class CircleFiller : public TwoOptFiller {
  protected:
    void CreateImage();    
  public:
    CircleFiller(int _circle_color=0, int _bg_color=0);
    Filler * CreateCopy() { return new CircleFiller(opt1, opt2); };  
};

class CheckerFiller : public TwoOptFiller {
  protected:
    void CreateImage();    
  public:
    CheckerFiller(int _white=0, int _black=0);
    Filler * CreateCopy() { return new CheckerFiller(opt1, opt2); };  
};

class Picture;

class PictureFiller : public Filler {
  protected:
    Picture ** pictures;
    int NumPictures, ActualPicture;
    void CreateImage();    
  public:
    PictureFiller(int _NumPictures, Picture ** _picture, int _ActualPicture=0);
    Filler * CreateCopy()
      { return new PictureFiller(NumPictures, pictures, ActualPicture); };
    int GetFirstOption() { return ActualPicture; };
    void SetFirstOption(int _opt) { ActualPicture = _opt; CreateImage(); };
};

#endif
