#!/bin/sh

MTAB_FILE=/etc/mtab
UMOUNT=umount
KILL=kill
ENTRY=shlight

umount_all=no
umount_path=
print_mounted=no

retval=0

Usage="Usage: `basename $0` (-a | <mounted path>)"

while [ $# -gt 0 ]; do
    case $1 in
    -a)      	umount_all=yes ;;
    -*)         echo $Usage 1>&2 ; exit 1 ;;
    *)          umount_path=$1 ;;
    esac
    shift
done

if [ $umount_all = no -a -z "$umount_path" ]; then
	echo $Usage 1>&2
	echo "$ENTRY mounted directories:"
	grep $ENTRY $MTAB_FILE | sed -e 's/^[^"]*["]//g' | sed -e 's/["][^"]*$//g'
	exit 1
fi

unmount_dir()
{
	dir=$1
	pid=`grep "$dir" $MTAB_FILE | awk '{print $1}' | grep ${ENTRY}- | \
													sed -e "s/${ENTRY}-//g"`
	if [ -z "$pid" ]; then
		echo "$dir not found in $MTAB_FILE" 2>&1
		retval=1
	else
		if $UMOUNT $1; then		# if there was an error in the unmount
			$KILL -HUP $pid
		else
			retval=1
		fi
	fi
}

if [ -n "$umount_path" ]; then
	unmount_dir "$umount_path"
else
	for i in `grep $ENTRY $MTAB_FILE | sed -e 's/^[^"]*["]//g' | \
											sed -e 's/["][^"]*$//g'`; do
		echo "going to unmount $i"
		unmount_dir $i
	done
fi

exit $revtal
