/*
 * Name: syshdr.h
 * Description: This file includes all system headers that are needed and
 *     contains some system dependent defines.
 * Author: Christian Starkjohann <cs@hal.kph.tuwien.ac.at>
 * Date: 1996-12-14
 * Copyright: GNU-GPL
 * Tabsize: 4
 */

#include <sys/types.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/socket.h>
#include <unistd.h>
#include <sys/time.h>
#include <fcntl.h>
#include <sys/errno.h>
#include <errno.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <signal.h>
#include <stdarg.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define	CONSOLE_DEVICE	"/dev/console"

/*
 * System dependent includes:
 */
/* ------------------------------------------------------------------------- */
#ifdef NeXT
#	include <libc.h>
	/* the following should have been in sys/param.h: */
	extern char	*realpath(char *file_name, char *resolved_name);
#endif
/* ------------------------------------------------------------------------- */
#ifdef linux
	/* currently nothing special to be done.... */
#endif
/* ------------------------------------------------------------------------- */
#ifdef __FreeBSD__
#	include <osreldate.h>
#	if __FreeBSD_version >= 300000
#		define BSD4_4_LITE2
#	endif
#endif
#if defined(BSD4_4) && !defined(BSD4_4_LITE2)
#	define BSD4_4_LITE
#endif

#ifdef BSD4_4
#	define NFS
#endif
#ifdef BSD4_4_LITE2
#	define _NEW_VFSCONF
#endif

#ifdef SOLARIS
#define bzero(p, s) memset(p, 0, s)
#endif

/* ------------------------------------------------------------------------- */
/*
 * Continuation of standard system includes:
 */
#include <sys/mount.h>

/* ------------------------------------------------------------------------- */

/*
 * Interface for functions from "nfs/syscalls.c":
 */
struct sockaddr_in;	/* possibly not defined in any header... */
extern int	syscall_mount(char *dir, void *root_fh, int sock_fd,
									struct sockaddr_in *socket, char* fsname);
extern int  syscall_unmount(char* dir);
extern int	syscall_insert_mtab(char *mountpoint, char *fsname);
extern int	syscall_delete_mtab(char *mountpoint);
