from distutils.core import setup
from distutils.extension import Extension
from Pyrex.Distutils import build_ext

import sys

if sys.platform == 'win32':
    sslLibs = ['libeay32','gdi32']
    extra_link_args = []
else:
    sslLibs = []
    extra_link_args = ['/usr/lib/libcrypto.a']

setup(
  name = "SSLCrypto",
  version = '0.1.1',
  ext_modules=[ 
    Extension("SSLCrypto", ["SSLCrypto.pyx", 'die.c'],
              libraries=sslLibs,
              extra_link_args=extra_link_args)
    ],
  cmdclass = {'build_ext': build_ext}
)
