/*
    common.h
    OpenAG, libOpenAG, OpenAG X
     
    Created by Eric Seidel on Sun Mar 31 2002.
    
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    
    *****
    
    This file should be included in nearly all files and handles some
    of the portablity changes necessary in dealing with Autoconf etc.
*/

#ifndef _AG_COMMON_H_
#define _AG_COMMON_H_


#include "../../config.h" /* Did you run ./configure before compiling?? You should have.... */

/* Deals with Time stuff */

#if TIME_WITH_SYS_TIME
    #include <sys/time.h>
    #include <time.h>
#else
    #if HAVE_SYS_TIME_H
        #include <sys/time.h>
    #else
        #include <time.h>
    #endif
#endif


/* Default includes, from the Autoconf manual */

#include <stdio.h> /* everyone must have this! */

#if HAVE_SYS_TYPES_H
    #include <sys/types.h>
#endif
#if HAVE_SYS_STAT_H
    #include <sys/stat.h>
#endif
#if STDC_HEADERS
    #include <stdlib.h>
    //#include <stddef.h> /* Not used by OpenAG, as far as I know */
#else
    #if HAVE_STDLIB_H
        #include <stdlib.h>
    #endif
#endif
#if HAVE_STRING_H
    #if !STDC_HEADERS && HAVE_MEMORY_H
        #include <memory.h>
    #endif
    #include <string.h>
#endif
#if HAVE_STRINGS_H
    #include <strings.h>
#endif
#if HAVE_INTTYPES_H
    #include <inttypes.h> /* Not used by OpenAG, as far as I know */
#else
    #if HAVE_STDINT_H
        #include <stdint.h> /* Not used by OpenAG, as far as I know */
    #endif
#endif
#if HAVE_UNISTD_H
    #include <unistd.h>
#endif


/* Fake bzero if they don't have it */
#if !HAVE_BZERO && HAVE_MEMSET
    # define bzero(buf, bytes)      ((void) memset (buf, 0, bytes))
#endif

/* Include sys/socket.h */
#include <sys/socket.h>

/* Define socklen_t if they don't have it */
#if !HAVE_SOCKLEN_T
    #ifndef socklen_t
	#define socklen_t int
    #endif
#endif


/* Timer stuff */

#if !HAVE_TIMERSUB
    #ifndef timersub
        #define	timersub(tvp, uvp, vvp)						\
                do {								\
                        (vvp)->tv_sec = (tvp)->tv_sec - (uvp)->tv_sec;		\
                        (vvp)->tv_usec = (tvp)->tv_usec - (uvp)->tv_usec;	\
                        if ((vvp)->tv_usec < 0) {				\
                                (vvp)->tv_sec--;				\
                                (vvp)->tv_usec += 1000000;			\
                        }							\
                } while (0)
    #endif
    /* They are more likely to have this one. -- I don't check for it explicitly though */
    #ifndef timercmp
        #define	timercmp(tvp, uvp, cmp)					\
            (((tvp)->tv_sec == (uvp)->tv_sec) ?				\
                ((tvp)->tv_usec cmp (uvp)->tv_usec) :			\
                ((tvp)->tv_sec cmp (uvp)->tv_sec))
    #endif
#endif

#endif // _AG_COMMON_H 


