/*
    FileList.h
    OpenAG, libOpenAG, OpenAG X
    
    Created by Eric Seidel on Tue Nov 20 2001.
    
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _AGFILELIST_H_
#define _AGFILELIST_H_

#include <stdio.h>
#include "AGConnection.h"

// see AGMain.h  -- #define NOT_IN_USE 0 
#define VALIDATED_SHARE		1
#define UNVALIDATED_SHARE	2

/* Revision codes
1 - cvs 1.12
2 - cvs 1.16 - added diskname
3 - cvs 1.19 - added uniqueLocalID
4 - cvs 1.24 - nothing added, just testing.
5 - cvs 1.25 - added all the mp3Info stuff - ID3 Tags etc.
6 - cvs 1.25 - added FileLastModifed
7 - cvs 1.27 - fixed writing of ID3 flags!
8 - cvs 1.35 - fixed string encoding, finally.
*/

#define FILELIST_REVISION_CODE  8

#define RESUME_DATABASE_NAME	"resumes.data"
#define SHARE_DATABASE_NAME	"shares.data"

#define USE_DISK_NAME		true
#define USE_SUGGESTED_NAME	false


struct FileRecord
{
    /*
    ~FileRecord()
    {
        printf("deleting file record!!!!\n");
    }
    */
    
    long flags;
    char*  SuggestedFileName;	// Always server based?
    char*  DiskFileName;	// Always local based?  Or AGString?
    char*  DirectoryName;	// AGString?
    char*  FileSet;		// Always server?  AGString?
    long LocalID;
    connection* ConnectionPtr;
    short Bitrate;
    long SongLength;
    long FileResumePosition;
    long FileSize;
    long FileLastModified;
    long SongID;
    
    /* These do NOT need to be AGString, I don't know how they are encoded, but I don't touch them */
    bool  HasID3v1;
    char*  ID3v1_Title;
    char*  ID3v1_Artist;
    char*  ID3v1_Album;
    
    bool  HasID3v2;
    char*  ID3v2_Title;
    char*  ID3v2_Artist;
    char*  ID3v2_Album;
    short ID3v2_Track;
    char*  ID3v2_Tag;
};


class FileList
{
public:
    FileList(char* path); // creates an emply FileList
    FileList(int size, char* path); //create new FileList of atleast size

    ~FileList(); // cleans up.
    
    FileRecord* getNewFileRecord();
    void deleteFileRecordWithLocalID(int x);
    
    int addNewFileRecordFromPath(const char* FileName, const char* DirectoryName);
    int addNewFileRecordFromFileRecord(FileRecord* newFile);
    void updateMP3InfoForUnvalidatedRecords();
    FileRecord* getFileRecordByLocalID(int LocalID); // returns the share associated with that ID.
    //FileRecord* getFileRecordByFileID(char* FileID, int FileIDLength);
        // returns the first FileRecord with that FileID
    FileRecord* getFileRecordBySuggestedNameAndSize(const char* FileName, unsigned int size);
    FileRecord* getFileRecordByDiskNameAndSize(const char* FileName, unsigned int size);
    FileRecord* getFileRecordByGivenNameAndSize(const char* FileName, unsigned int size, bool useDiskName);
        
    //int setFileID(int LocalID, char* FileID, int FileIDLength);
    //int setFileID(char* FileName, int FileSize, char* FileID, int FileIDLength);
    int setFileSet(int LocalID, const char* FileSet);
    int getLocalID(char* FileName, int FileSize);
    //int setServerID(int LocalID, int ServerID);
    int setSongID(int LocalID, int SongID);
    int howManyFiles() {return lastRecordPlus1;}
    void printList();
    
    int readFromDisk();
    int readFromDisk(char* Path);
    int writeToDisk(void (*setDisplayedFileSystemChange) (char*));
    
    void sortListByFileName();
    void removeBlankRecords();
    void removeDuplicateRecords();
    void reassignLocalIDs();
    
//protected:
    FileRecord*	FilesArray;
    char*	DatabasePath;
    int		lastRecordPlus1; // one more than the last record
    int		recordCount;	// the actual number of records in use.

private:
    int FilesArraySize; // current Maximum Capacity
    void expand(); // increases the capacity of the list.
};



FileList* MergeSharesDatabase(FileList* &Old, FileList* &Current);
FileList* MergeResumesDatabase(FileList* &Old, FileList* &Current, bool deleteOK);

#endif



