/*
    AGConnection.h
    OpenAG, libOpenAG, OpenAG X
    
    Created by Eric Seidel on Fri Dec 21 2001.
    
    Copyright (c) 2001-2002 Eric Seidel. All rights reserved.
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _AGCONNECTION_H_
#define _AGCONNECTION_H_

#include "common.h"

#define AGGRESSIVE_BUFFER_CLEAR true

#define DEFAULT_TIMEOUT 120

/*  Connection Status Flag  */
#define NOT_IN_USE		0

#define CONNECTING		1
#define ACCEPTING		2

#define SENDING_REQUEST		4
#define WAIT_REQUEST		8

#define SENDING_RESPONSE	16
#define WAIT_RESPONSE		32

#define TRANSFER_SENDING	64
#define TRANSFER_RECEIVING	128
#define TRANSFER_COMPLETE	256

#define TIMEOUT			512
#define CLOSING			1024

#define INFOSERVER_FLAG		2048


#define BUFFER_SIZE		4000


/* For flages */
#define DIRECTION_SEND 0
#define DIRECTION_READ 1


/* for connections array */
#define INFOSERVER		0

#define NUMBER_BPS_RECORDS	5


struct connection
{
    int socket;
    int file;
    int flags;
    
    char Obuf[BUFFER_SIZE];
    char* OwPtr;
    char* OrPtr;
    
    char Ibuf[BUFFER_SIZE];
    char* IwPtr;
    char* IrPtr;
    
    bool hasOpenFile;
    int LocalID;
    
    unsigned short FileIDLength;
    char* FileID;
    char ConnectFlag;
    char DirectionFlag;
    char* ServerIP; // could also be a string, but doesn't really need to be.
    int ServerPort;
    char*  FileName;
    char*  FileDirectory;
    int SongLength;
    int FileSize;
    int FileResumePosition;
    
    /* For BPS */
    long BPS;
    
    unsigned long DataSinceLastKPS;
    timeval TimeOfLastKPS;
    
    unsigned long BPSTotal;
    short BPSRecordCount;
    
    short currentBPSRecord;
    unsigned long BPSARRAY[NUMBER_BPS_RECORDS];
    
    /* For Timeouts */
    time_t lastTime;
    time_t TimeOut;
};

//  SEE ABOVE => #define NOT_IN_USE	0
#define	R_CONNECTING	1
#define	I_CONNECTING	2
#define RESETTING	4


struct redirectionConnection
{
    char	RedirectServerIP[16];
    char	InfoServerIP[16];
    unsigned short	InfoServerPort;
    int			socket;
    int			flags;
    time_t		lastTime;
    time_t		TimeOut;
    bool		socketOpen;
};


#endif


