/* 1710, Mon 9 Sep 96

   SNMP.H:  Global declarations for SNMP routines.
            NeTraMet version, based on CMU SNMPv2 (see below).

   Copyright (C) 1992-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */

/*
 * $Log: snmp.h,v $
 * Revision 1.1.1.2.2.7  2002/02/23 01:57:38  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.3  2000/06/06 03:38:27  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2  1999/10/03 21:06:31  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.1  1999/01/08 01:38:38  nevil
 * Distribution file for 4.3b7
 *
 * Revision 1.1.1.1  1998/11/16 03:57:31  nevil
 * Import of NeTraMet 4.3b3
 *
 * Revision 1.1.1.1  1998/11/16 03:22:02  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.1.1  1998/10/28 20:31:31  nevil
 * Import of NeTraMet 4.3b1
 *
 * Revision 1.1.3.2  1998/10/14 04:13:46  nevil
 * Merge Nicolai's patches into 4.2.1 distribution
 *
 * Revision 1.1.1.1  1998/10/13 01:35:01  nevil
 * Import of NeTraMet 4.2.1
 *
 * Revision 1.1.1.1  1998/08/24 12:09:30  nguba
 * NetraMet 4.2 Original Distribution
 */

/***********************************************************
    Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#define SNMP_PORT        (au_snmp_port)    /* 161  Nevil, 29 Apr 97 */
#define SNMP_TRAP_PORT   (au+snmp_port+1)  /* 162 */

#define SNMP_MAX_LEN        1500

#define SNMP_VERSION_1      0
#define SNMP_VERSION_2C     1  /* RFC 1901 */
/* #define SNMP_SECURITY_1     1  */
/* #define SNMP_VERSION_2      2  */
/* Version nbr for party-based SNMPv2 authentication, RFC 1441 */

#define GET_REQ_MSG     (ASN_CONTEXT | ASN_CONSTRUCTOR | 0x0)
#define GETNEXT_REQ_MSG     (ASN_CONTEXT | ASN_CONSTRUCTOR | 0x1)
#define GET_RSP_MSG     (ASN_CONTEXT | ASN_CONSTRUCTOR | 0x2)
#define SET_REQ_MSG     (ASN_CONTEXT | ASN_CONSTRUCTOR | 0x3)
#define TRP_REQ_MSG     (ASN_CONTEXT | ASN_CONSTRUCTOR | 0x4)
#define BULK_REQ_MSG        (ASN_CONTEXT | ASN_CONSTRUCTOR | 0x5)
#define INFORM_REQ_MSG      (ASN_CONTEXT | ASN_CONSTRUCTOR | 0x6)
#define TRP2_REQ_MSG        (ASN_CONTEXT | ASN_CONSTRUCTOR | 0x7)

#define SNMP_NOSUCHOBJECT    (ASN_CONTEXT | ASN_PRIMITIVE | 0x0)
#define SNMP_NOSUCHINSTANCE  (ASN_CONTEXT | ASN_PRIMITIVE | 0x1)
#define SNMP_ENDOFMIBVIEW    (ASN_CONTEXT | ASN_PRIMITIVE | 0x2)

#define SNMP_ERR_NOERROR    (0x0)
#define SNMP_ERR_TOOBIG     (0x1)
#define SNMP_ERR_NOSUCHNAME (0x2)
#define SNMP_ERR_BADVALUE   (0x3)
#define SNMP_ERR_READONLY   (0x4)
#define SNMP_ERR_GENERR     (0x5)

#define SNMP_ERR_NOACCESS       (6)
#define SNMP_ERR_WRONGTYPE      (7)
#define SNMP_ERR_WRONGLENGTH        (8)
#define SNMP_ERR_WRONGENCODING      (9)
#define SNMP_ERR_WRONGVALUE     (10)
#define SNMP_ERR_NOCREATION     (11)
#define SNMP_ERR_INCONSISTENTVALUE  (12)
#define SNMP_ERR_RESOURCEUNAVAILABLE    (13)
#define SNMP_ERR_COMMITFAILED       (14)
#define SNMP_ERR_UNDOFAILED     (15)
#define SNMP_ERR_AUTHORIZATIONERROR (16)
#define SNMP_ERR_NOTWRITABLE        (17)

#define SNMP_TRAP_COLDSTART     (0x0)
#define SNMP_TRAP_WARMSTART     (0x1)
#define SNMP_TRAP_LINKDOWN      (0x2)
#define SNMP_TRAP_LINKUP        (0x3)
#define SNMP_TRAP_AUTHFAIL      (0x4)
#define SNMP_TRAP_EGPNEIGHBORLOSS   (0x5)
#define SNMP_TRAP_ENTERPRISESPECIFIC    (0x6)

void xdump(u_char *cp, int length, char *prefix);
u_char *snmp_parse_var_op(u_char *data, oid *var_name,
   int *var_name_len, u_char *var_val_type,
   int *var_val_len, u_char **var_val, int *listlength);
u_char *snmp_build_var_op(u_char *data, oid *var_name,
   int *var_name_len, u_char var_val_type,
   int var_val_len, u_char far *var_val, int *listlength);

#ifdef __cplusplus
}           // end extern "C"
#endif
