/* 1705, Mon 9 Sep 96

   PARSE.H:  Global declarations for MIB parser.
            NeTraMet version, based on CMU SNMPv2 (see below).

   Copyright (C) 1992-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */

/*
 * $Log: parse.h,v $
 * Revision 1.1.1.2.2.7  2002/02/23 01:57:38  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.3  2000/06/06 03:38:26  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2  1999/10/03 21:06:30  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.2  1999/09/22 05:38:46  nevil
 * Improve code to work properly on 64-bit machines
 * - Add OS=ALPHA handling to configure.in
 * - Clean up the Alpha compiler warnings
 * - Change all the snmp-related code to use Bit32 instead of unsigned long
 *
 * Revision 1.1.1.1.2.1  1999/01/08 01:38:37  nevil
 * Distribution file for 4.3b7
 *
 * Revision 1.1.1.1  1998/11/16 03:57:31  nevil
 * Import of NeTraMet 4.3b3
 *
 * Revision 1.1.1.1  1998/11/16 03:22:02  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.1.1  1998/10/28 20:31:30  nevil
 * Import of NeTraMet 4.3b1
 *
 * Revision 1.1.3.2  1998/10/14 04:13:45  nevil
 * Merge Nicolai's patches into 4.2.1 distribution
 *
 * Revision 1.2  1998/10/08 09:22:34  nguba
 * -Added -b switch to NeMaC so that MIBs can be loaded from the command
 *  line instead of relying on the current working directory or an
 *  environment variable.  I have a mib in /etc/mib.txt but it gives me
 *  errors.  Being able to give a MIB via command line helps.
 * -I also had to increase the size of fn[64] to 256, which is --I
 *  belive-- the maximum a Unix command line can take.  I wonder whether
 *  Unix systems define this one somewhere...  Anyway, this variable is
 *  #define'd via MAXLINE.
 * -Use the function set_mibfile(char*) to set the mibfile via
 *  command-line.  This function is defined in parse.h, implemented in
 *  mib.c and is available via libsnmp.a
 *
 * Revision 1.1.1.1  1998/10/13 01:35:01  nevil
 * Import of NeTraMet 4.2.1
 *
 * Revision 1.1.1.1  1998/08/24 12:09:30  nguba
 * NetraMet 4.2 Original Distribution
 */

/***********************************************************
    Copyright 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
/*
 * parse.h
 */

#define MAXLABEL    64  /* maximum characters in a label */
#define MAXTOKEN    64  /* maximum characters in a token */
#define MAXQUOTESTR 512 /* maximum characters in a quoted string */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * A linked list of tag-value pairs for enumerated integers.
 */
struct enum_list {
    struct enum_list *next;
    int value;
    char *label;
};

/*
 * A linked list of nodes.
 */
struct node {
    struct node *next;
    char label[MAXLABEL];     /* This node's (unique) textual name */
    Bit32 subid;              /* This node's integer subidentifier */
    char parent[MAXLABEL];    /* The parent's textual name */
    int type;                 /* The type of object this represents */
    struct enum_list *enums;  /* (Optional) list of enumerated integers */
    char *description;        /* Description (a quoted string) */
};

/*
 * A tree in the format of the tree structure of the MIB.
 */
struct tree {
   struct tree *child_list;  /* list of children of this node */
   struct tree *next_peer;   /* Next node in list of peers */
   struct tree *parent;
   char label[MAXLABEL];     /* This node's textual name */
   Bit32 subid;              /* This node's integer subidentifier */
   int type;                 /* This node's object type */
   struct enum_list *enums;  /* (optional) list of enumerated integers */
   void (*printer)(          /* Value printing function */
      char *buf, struct variable_list *var, struct enum_list *enums);
   char *description;        /* Description (a quoted string) */
   };

/* non-aggregate types for tree end nodes */
#define TYPE_OTHER      0
#define TYPE_OBJID      1
#define TYPE_OCTETSTR       2
#define TYPE_INTEGER        3
#define TYPE_NETADDR        4
#define TYPE_IPADDR     5
#define TYPE_COUNTER        6
#define TYPE_GAUGE      7
#define TYPE_TIMETICKS      8
#define TYPE_OPAQUE     9
#define TYPE_NULL       10
#define TYPE_COUNTER64      11
#define TYPE_BITSTRING      12
#define TYPE_NSAPADDRESS    13
#define TYPE_UINTEGER       14

#ifdef __cplusplus
extern "C" {
#endif

/* Prototypes for functions in mib.c and parse.c */

void         build_translation_table(void);
struct tree *find_node(char *name, struct tree *subtree);
int          get_node(char *name, oid *objid, int *objidlen);
struct tree *get_symbol(oid *objid, int objidlen,
               struct tree *subtree, char *buf);
struct tree *get_tree(oid *objid, int objidlen,
               struct tree *subtree);
char        *get_description(oid *objid, int objidlen);
void         init_mib(void);
char        *set_mibfile(char*);
void         init_node_hash(struct node *nodes);
int          parse_mib_header(FILE *fp, char *name);
void         print_description(oid *objid, int objidlen);
void         print_objid(oid *objid, int objidlen);
void         print_value(oid *objid, int objidlen,
               struct variable_list *variable);
void         print_variable(oid *objid, int objidlen,
               struct variable_list *variable);
struct tree *read_mib(char *filename);
int          read_objid(char *input, oid *output, int *out_len);
void         sprint_objid(char *buf, oid *objid, int objidlen);
void         sprint_value(char *buf, oid *objid, int objidlen,
               struct variable_list *variable);
void         sprint_variable(char *buf, oid *objid, int objidlen,
               struct variable_list *variable);

#ifdef __cplusplus
}           // end extern "C"
#endif

