/* 1545, Tue 21 Sep 99

   Header file for DOS implementation of CMU SNMP

   Copyright (C) 1992-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */

/*
 * $Log: ausnmp.h,v $
 * Revision 1.1.1.2.2.10  2002/02/23 01:57:36  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.6  2000/08/08 19:44:57  nevil
 * 44b8 release
 *
 * Revision 1.1.1.2.2.4  2000/06/06 03:38:25  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2.2.1  1999/11/29 00:17:29  nevil
 * Make changes to support NetBSD on an Alpha (see version.history for details)
 *
 * Revision 1.1.1.2  1999/10/03 21:06:29  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.4  1999/09/24 02:58:42  nevil
 * Polish up code to get rid of warning messages from Borland (DOS) compiler.
 * Make manager PeerAddress buffers NSAP_ADDR_LEN bytes long.
 * Add asn_lookup variable - only call FindSubnet if ruleset uses ASNs.
 *
 * Revision 1.1.1.1.2.3  1999/09/22 05:38:46  nevil
 * Improve code to work properly on 64-bit machines
 * - Add OS=ALPHA handling to configure.in
 * - Clean up the Alpha compiler warnings
 * - Change all the snmp-related code to use Bit32 instead of unsigned long
 *
 * Revision 1.1.1.1.2.2  1999/05/26 02:41:42  nevil
 * Integrate V6 and ASN code into PC versions of the meter.
 * This required a rework of the makefiles, using @cflags.opt files
 * to provide a much longer command line to the Borland C compiler.
 *
 * Revision 1.1.1.1.2.1  1999/01/08 01:38:36  nevil
 * Distribution file for 4.3b7
 *
 * Revision 1.1.1.1  1998/11/16 03:57:31  nevil
 * Import of NeTraMet 4.3b3
 *
 * Revision 1.1.1.1  1998/11/16 03:22:02  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.1.1.2.1  1998/11/11 23:14:47  nevil
 * Only include malloc.h if we HAVE_MALLOC_H
 *
 * Revision 1.1.1.1  1998/10/28 20:31:30  nevil
 * Import of NeTraMet 4.3b1
 *
 * Revision 1.1.3.2.2.2  1998/10/22 01:28:05  nevil
 * Community data wasn't being copied when PDUs were cloned, which gave
 * unpredictable results when the cloned pdu was freed.  Added code to
 * copy community data properly.  Also added PDU_MALLOC_CHECK define
 * to trace malloc() and Free() operations on pdus.
 *
 * Revision 1.1.3.2.2.1  1998/10/19 02:30:35  nevil
 * Use log_msg() to report errors instead of fprintf(stderr ..)
 *
 * Revision 1.1.3.2  1998/10/14 04:13:43  nevil
 * Merge Nicolai's patches into 4.2.1 distribution
 *
 * Revision 1.1.1.1  1998/10/13 01:35:00  nevil
 * Import of NeTraMet 4.2.1
 *
 * Revision 1.1.1.1  1998/08/24 12:09:30  nguba
 * NetraMet 4.2 Original Distribution
 *
 * Revision 1.2  1998/04/30 04:57:13  rtfm
 * Bug fixes, change copyright date
 */

#ifdef __cplusplus
extern "C" {
#endif

#ifndef EXTSNMP  /* Nevil, 29 Apr 97 */
extern int au_snmp_port;
#else
int au_snmp_port = 161;  /* Default = SNMP well-known port */
#endif

#ifndef _TYPES_H  /* CAUTION: Must match Joel's types\types.h */
typedef unsigned char  Bit8;
typedef unsigned short  Bit16;
# if SIZEOF_LONG == 4 || defined(DOS)
typedef unsigned long  Bit32;
# elif SIZEOF_LONG == 8
typedef unsigned int  Bit32;
# endif
#endif

# if SIZEOF_LONG == 4 || defined(DOS)  /* Int32 not in types\types.h !!! */
typedef long  Int32;
typedef Bit32  IntFromPtr;  /* For x_support.c */
# elif SIZEOF_LONG == 8
typedef int Int32;
typedef unsigned long  IntFromPtr;  /* 64-bit */
# endif

#ifdef _AIX
#define _XOPEN_EXTENDED_SOURCE  /* Needed to get syslog defined properly */
#endif

#if defined(DOS)
#define LOG_ERR      3
#define LOG_WARNING  4
#define LOG_INFO     6
#define LOG_DEBUG    7
#else
#include <syslog.h>
#endif

#ifdef _AIX
#undef _XOPEN_EXTENDED_SOURCE
#endif

void log_msg(int priority, int die, char *fmt, ...);
   /* Generalised error message handler.  Nevil, 9 Sep 98 */

#ifdef DOS

#ifndef NULL
#define NULL ((void *)0)
#endif

#define WORDS_BIGENDIAN  0
#define SIZEOF_LONG      4  /* for ifdef DOS */

#ifndef WTCP_U_DEFS
typedef unsigned char   u_char;
typedef unsigned short  u_short;
typedef unsigned int    u_int;
typedef unsigned long   u_long;
#endif

#include <string.h>
#include <stdlib.h>
#include <mem.h>

#ifdef __FLAT__  /* Flat 32-bit memory model */

#define far
#define huge
#define farfree free
#define farmalloc malloc
#define farmove(d,s,n)  memcpy((char *)d,(char *)s,n)
#define qcmp(d,s,n)     memcmp((char *)d,(char *)s,n)

#else  /* Large memory model */
#define farmove(d,s,n)  memcpy((char *)d,(char *)s,n)
#define qcmp(d,s,n)     memcmp((char *)d,(char *)s,n)
#endif

#else  /* Not DOS */

#ifndef SUNOS
#define farmove(d,s,n)  memmove((char *)d,(char *)s,n)
#else
#define farmove(d,s,n)  memcpy((char *)d,(char *)s,n)
#endif
#define qcmp(d,s,n)     memcmp((char *)d,(char *)s,n)

#define scpos(x,y)  /* Used in TESTING code */

#define far
#define huge

#define farfree free
#define farmalloc malloc
#include <sys/types.h>
#include <string.h>
#if HAVE_MALLOC_H
# include <malloc.h>
#endif
#include <memory.h>

#endif




#ifdef __cplusplus
}           // end extern "C"
#endif
