/* 1030, Tue 21 Sep 99

   ASN1.H:  Global declarations for ASN.1 routines
            NeTraMet version, based on CMU SNMPv2 (see below).

   Copyright (C) 1992-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */

/*
 * $Log: asn1.h,v $
 * Revision 1.1.1.2.2.7  2002/02/23 01:57:36  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.3  2000/06/06 03:38:24  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2  1999/10/03 21:06:28  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.2  1999/09/22 05:38:45  nevil
 * Improve code to work properly on 64-bit machines
 * - Add OS=ALPHA handling to configure.in
 * - Clean up the Alpha compiler warnings
 * - Change all the snmp-related code to use Bit32 instead of unsigned long
 *
 * Revision 1.1.1.1.2.1  1999/01/08 01:38:35  nevil
 * Distribution file for 4.3b7
 *
 * Revision 1.1.1.1  1998/11/16 03:57:30  nevil
 * Import of NeTraMet 4.3b3
 *
 * Revision 1.1.1.1  1998/11/16 03:22:02  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.1.1  1998/10/28 20:31:30  nevil
 * Import of NeTraMet 4.3b1
 *
 * Revision 1.1.3.2  1998/10/14 04:13:43  nevil
 * Merge Nicolai's patches into 4.2.1 distribution
 *
 * Revision 1.1.1.1  1998/10/13 01:35:00  nevil
 * Import of NeTraMet 4.2.1
 *
 * Revision 1.1.1.1  1998/08/24 12:09:30  nguba
 * NetraMet 4.2 Original Distribution
 */

/***********************************************************
    Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

#ifdef EIGHTBIT_SUBIDS
typedef Bit8 oid;
#define MAX_SUBID   0xFF
#elif SIXTEENBIT_SUBIDS
typedef Bit16 oid;
#define MAX_SUBID   0xFFFF
#else
typedef Bit32 oid;
#define MAX_SUBID   0xFFFFFFFF
#endif

#define MAX_OID_LEN     64  /* max subid's in an oid */

#define ASN_BOOLEAN     (0x01)
#define ASN_INTEGER     (0x02)
#define ASN_BIT_STR     (0x03)
#define ASN_OCTET_STR       (0x04)
#define ASN_NULL        (0x05)
#define ASN_OBJECT_ID       (0x06)
#define ASN_SEQUENCE        (0x10)
#define ASN_SET         (0x11)

#define ASN_UNIVERSAL       (0x00)
#define ASN_APPLICATION     (0x40)
#define ASN_CONTEXT     (0x80)
#define ASN_PRIVATE     (0xC0)

#define ASN_PRIMITIVE       (0x00)
#define ASN_CONSTRUCTOR     (0x20)

#define ASN_LONG_LEN        (0x80)
#define ASN_EXTENSION_ID    (0x1F)
#define ASN_BIT8        (0x80)

#define IS_CONSTRUCTOR(byte)    ((byte) & ASN_CONSTRUCTOR)
#define IS_EXTENSION_ID(byte)   (((byte) & ASN_EXTENSION_ID) == ASN_EXTENSION_ID)

#if SIZEOF_LONG_LONG == 8  /* e.g. Pentium */
/* #warning  Using long long for counter64 */
typedef unsigned long long counter64;
#elif SIZEOF_LONG == 8  /* e.g. Alpha */
typedef unsigned long counter64;
#elif SIZEOF_LONG == 4
struct c64 {
   unsigned long high;
   unsigned long low;
   };
typedef struct c64 counter64;
#else
#error sizeof(long) not 4 or 8 <<<<<
#endif

u_char *asn_parse_int(u_char *data, int *datalength,
   u_char *type, Bit32 far *intp, int intsize);
u_char *asn_build_int(u_char *data, int *datalength,
   u_char type, Bit32 far *intp, int intsize);

u_char *asn_parse_unsigned_int(u_char *data, int *datalength,
   u_char *type, Bit32 far *intp, int intsize);
u_char *asn_build_unsigned_int(u_char *data, int *datalength,
   u_char type, Bit32 far *intp, int intsize);

u_char *asn_parse_string(u_char *data,int *datalength,
   u_char *type, u_char far *string, int *strlength);
u_char *asn_build_string(u_char *data, int *datalength,
   u_char type, u_char far *string, int strlength);


u_char *asn_parse_header(u_char *data, int *datalength,
   u_char *type);
u_char *asn_build_header(u_char *data, int *datalength,
   u_char type, int length);

u_char *asn_build_sequence(u_char *data, int *datalength,
   u_char type, int length);

u_char *asn_parse_length(u_char *data, Bit32 *length);
u_char *asn_build_length(u_char *data, int *datalength,
   int length);

u_char *asn_parse_objid(u_char *data, int *datalength,
   u_char *type, oid *objid, int *objidlength);
u_char *asn_build_objid(u_char *data, int *datalength,
   u_char type, oid far *objid, int objidlength);

u_char *asn_parse_null(u_char *data, int *datalength,
   u_char *type);
u_char *asn_build_null(u_char *data, int *datalength,
   u_char type);


u_char *asn_parse_bitstring(u_char *data, int *datalength,
   u_char *type, u_char far *string, int *strlength);
u_char *asn_build_bitstring(u_char *data, int *datalength,
   u_char type, u_char far *string, int strlength);

u_char *asn_parse_unsigned_int64(u_char *data, int *datalength,
   u_char *type, counter64 far *cp, int countersize);
u_char *asn_build_unsigned_int64(u_char *data, int *datalength,
   u_char type, counter64 far *cp, int countersize);

#ifdef __cplusplus
}           // end extern "C"
#endif
