/* ct.c - a minimal test program for the console interafce */

#include <dos.h>
#include "..\dpmi32\realmode.h"

#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <conio.h>

#define  CARRY  1  /* Carry bit in flags register */

void scpos(int x, int y)  /* Set Cursor Position */
{
#ifdef __DPMI32__
   union REGS regs;
   regs.h.ah = 2;
   regs.h.bh = 0;
   regs.h.dh = y;  regs.h.dl = x;
   regs.w.flags = 0;
   int386(0x10, &regs, &regs);
#else
   regs.w.ax = 0x200;
   regs.w.bx = 0;
   regs.w.dx = y << 8 | x;
   regs.w.flags = 0;

   _AH = 2;  _BH = 0;  _DH = y;  _DL = x;
   geninterrupt(0x10);
#endif
   }

void sputc(int c)  /* Write char to screen, don't move cursor */
{
#ifdef __DPMI32__
   union REGS regs;
   regs.w.flags = 0;
   regs.h.bh = 0;
   regs.w.cx = 1;
   regs.h.ah = 10;
   regs.h.al = c;
   int386(0x10, &regs, &regs);
#else
   _BH = 0;  _CX = 1;  _AH = 10;  _AL = c;
   geninterrupt(0x10);
#endif
   }

#define UP     0x06  /* BIOS scroll parameters */
#define DOWN   0x07
#define CHATR  0x07  /* Screen attribute for chart */

void bios_scroll(int way, int tx,int ty, int bx,int by, int nrows, int attr)
{
#ifdef __DPMI32__
   union REGS regs;
   regs.w.flags = 0;
   regs.h.ah = (way == UP) ? UP : DOWN;  /* Scroll direction */
   regs.h.al = nrows;  /* Rows to scroll */
   regs.h.bh = attr;  /* Screen attribute for blank fill */
   regs.h.ch = ty;  regs.h.cl = tx;  /* Top left */
   regs.h.dh = by;  regs.h.dl = bx;  /* Bottom right */
   int386(0x10, &regs, &regs);
#else
   _AH = (way == UP) ? UP : DOWN;  /* Scroll direction */
   _AL = nrows;  /* Rows to scroll */
   _BH = attr;  /* Screen attribute for blank fill */
   _CH = ty; _CL = tx;  /* Top left */
   _DH = by; _DL = bx;  /* Bottom right */
   geninterrupt(0x10);
#endif
   }

int tod_h,tod_m,tod_s;

#define DOT  0xFA  /* Small dot in centre of char rectangle */

void chart(int tx,int ty, int bx,int by, int x1,int x2,int x3)
{
   int w,k;
#define TIMEWIDTH  8
   char buf[TIMEWIDTH+102], *bar;
   bios_scroll(UP, tx,ty,  bx,by, 1, CHATR);
   w = bx+1-tx - TIMEWIDTH;  /* Plot chars from bar[0] to bar[w-1], 0-org */
   bar = &buf[TIMEWIDTH];
   if (tod_s%30 == 0) {
      sprintf(buf, "%02d%02d:%02d +", tod_h,tod_m,tod_s);
      memset(bar+1,DOT,w-1);
      }
   else {
      memset(buf, ' ',TIMEWIDTH+w);
      bar[0] = '|';
      }
   for (k = 10; k < w; k += 10) bar[k] = ':';
   if (x1 >= w) x1 = w;
   if (x2 >= w) x2 = w;
   if (x3 >= w) x3 = w;
   for (k = x1+1; k < x3; ++k) bar[k] = '-';
   for (k = 10; k < w; k += 10)
      if (bar[k] == '-') bar[k] = '+';
   bar[x1] = '<';
   bar[x3] = '>';
   bar[x2] = '*';
   k = bar[w-1];  bar[w-1] = '\0';
   scpos(tx,by);  cputs(buf);
/*   for (bar = buf; *bar; ) swrite(*bar++);
   sputc(k);  /* Leave cursor at (bx,by) */
   }

void sclear(void)
{
   bios_scroll(UP, 0,0,  79,24, 0, CHATR);  /* Blank screen */
   }

int main(int argc, char *argv[])
{
   int j;
   sclear();
   for (j = 0; j != 20; ++j) {
      scpos(j,j); 
      printf("*");
      }
   tod_h = 10; tod_m = 20;
   for (j = 0; j != 15; ++j)
      chart(41,0, 79,24, j,j*2,j*3);
   scpos(0,10);
   }

