/* 2010, Thu 17 May 01 (EST)

   MET_VARS.H:  Data structures for AU Meter SNMP interface

   Copyright (C) 1992-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */

/*
 * $Log: met_vars.h,v $
 * Revision 1.1.1.2.2.7  2002/02/23 01:57:32  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.5  2001/05/24 02:19:55  nevil
 * LfapMet implemented by Remco Poortinga.
 * MinPDUs implemented by Nevil.
 *
 * Revision 1.1.1.2.2.3  2000/06/06 03:38:21  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2.2.1  2000/01/12 02:57:11  nevil
 * Implement 'packet pair matched' turnaroundtime distribution attributes.
 * Fix ASN-related bugs in NeTraMet, distribution-related bugs in fd_filter.
 *
 * Revision 1.1.1.2  1999/10/03 21:06:25  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.2  1999/09/22 05:38:43  nevil
 * Improve code to work properly on 64-bit machines
 * - Add OS=ALPHA handling to configure.in
 * - Clean up the Alpha compiler warnings
 * - Change all the snmp-related code to use Bit32 instead of unsigned long
 *
 * Revision 1.1.1.1.2.1  1999/01/08 01:31:55  nevil
 * Implementation of TCP attributes, part 3
 *
 * Revision 1.1.1.1  1998/11/16 03:57:29  nevil
 * Import of NeTraMet 4.3b3
 *
 * Revision 1.1.1.1  1998/11/16 03:22:01  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.1.1  1998/10/28 20:31:27  nevil
 * Import of NeTraMet 4.3b1
 *
 * Revision 1.1.3.1.2.2  1998/10/19 22:32:47  nevil
 * Meter improvements, mostly arising from developments for the
 * OCxMON meter.  These are documented in notes_oc.txt
 *
 * Revision 1.1.3.1.2.1  1998/10/18 20:51:23  nevil
 * Added Nicolai's patches, some 'tidying up' of the source
 *
 * Revision 1.1  1998/05/07 04:13:44  rtfm
 * Initial revision
 */

#define AGENT_OID_LEN  11

struct variable {
   u_short name[AGENT_OID_LEN];  /* Object identifier of variable */
   u_char namelen;	     /* Length of above */
   char	  type;	             /* Type of variable */
   u_char magic;	     /* Passed to function as a hint */
   u_short  acl;	     /* Access control list for variable */
   u_char far *(*findVar)(   /* Function that finds variable */
      struct variable *vp, oid *name, int *length,
      int exact, int *var_len, write_fn_type *write_method);
   };

/* met_vars functions */

int compare(oid *name1,int len1, oid *name2,int len2);

/*  Old (SNMPv1) version of getStatPtr ..
u_char far *getStatPtr(oid *name,int *namelen,u_char *type,
   int *len,u_short *acl,int exact,int *access_method);
*/
void display_msg(int timestamp, char *msg);
int set_RowStatus(int action, u_char *var_val,
   u_char var_val_type, int var_val_len,
   u_char far *statP, oid *name, int name_len);
int set_Name(int action, u_char *var_val,
   u_char var_val_type, int var_val_len,
   u_char far *statP, oid *name, int name_len);
int set_Integer(int action, u_char *var_val,
   u_char var_val_type, int var_val_len,
   u_char far *statP, oid *name, int name_len);
int set_RuleSize(int action, u_char *var_val,
   u_char var_val_type, int var_val_len,
   u_char far *statP, oid *name, int name_len);
int set_RuleSet(int action, u_char *var_val,
   u_char var_val_type, int var_val_len,
   u_char far *statP, oid *name, int name_len);
int set_ReaderSet(int action, u_char *var_val,
   u_char var_val_type, int var_val_len,
   u_char far *statP, oid *name, int name_len);
int set_LastTime(int action, u_char *var_val,
   u_char var_val_type, int var_val_len,
   u_char far *statP, oid *name, int name_len);
int set_Bit16(int action, u_char *var_val,
   u_char var_val_type, int var_val_len,
   u_char far *statP, oid *name, int name_len);

int writeMask(int action, u_char *var_val,
   u_char var_val_type, int var_val_len,
   u_char far *statP, oid *name, int name_len);
int writeStatsReset(int action, u_char *var_val,
   u_char var_val_type, int var_val_len,
   u_char far *statP, oid *name, int name_len);
int string_OK(int t);
int int_OK(int t);

u_char far *var_system(struct variable *vp, oid *name, int *length,
   int exact, int *var_len, write_fn_type *write_method);
u_char far *var_rinfo(struct variable *vp, oid *name, int *length,
   int exact, int *var_len, write_fn_type *write_method);

u_char far *var_ft(struct variable *vp,oid *name, int *length,
   int exact, int *var_len, write_fn_type *write_method);
u_char far *var_package(struct variable *vp,oid *name, int *length,
   int exact, int *var_len, write_fn_type *write_method);
u_char far *var_rt(struct variable *vp,oid *name, int *length,
   int exact, int *var_len, write_fn_type *write_method);

/*
 * These are unit magic numbers for each variable.
 */

#define VERSION_DESCR	      0
#define VERSION_ID	      1
#define UPTIME		      3
#define IFNUMBER	      2

#define RIINDEX		 1
#define RIRULESIZE	 2
#define RIOWNER          3
#define RITIMESTAMP      4
#define RISTATUS         5
#define RINAME           6  /* Added 5 Mar 97 */
#define RIRULESREADY     7  /* Added 5 Mar 97, Deleted 18 Nov 97 */
#define RIFLOWCOUNT      8  /* Added 5 Mar 97 */

#define IIINDEX         11
#define IFACE_RATE      12
#define IFACE_LOST      13

#define CIINDEX 	21
#define CITIMEOUT	22
#define CIOWNER 	23
#define CILASTTIME	24
#define CIPREVTIME	25
#define CISTATUS	26
#define CIRULESET       27  /* Added 5 Mar 97 */
#define CIMINPDUS       28  /* Added 10 May 01 (for nifty) */
#define CITIMEMARK      29

#define MIINDEX 	  31
#define MICURRENTRULESET  32
#define MISTANDBYRULESET  33
#define MIHIGHWATERMARK   34
#define MICOUNTERWRAP     35
#define MIOWNER           36
#define MITIMESTAMP       37
#define MISTATUS          38
#define MIRUNNINGSTANDBY  39  /* Added 5 Mar 97 */

#define FLOODMARK            15
#define INACT_TIMEOUT        16
#define ACTIVE_FLOWS         17
#define MAX_FLOWS            18
#define FLOOD_MODE           19  /* Added 5 Mar 97 */

#define MSSTATSRESET         31
#define MSSTATSTIME          32
#define MSNPACKETS           33
#define MSTBACKLOG           34
#define MSMXPKTRATE          35
#define MSMXBACKLOG          36
#define MSNFLOWS             37
#define MSFLOWSRCV           38
#define MSNMATCHES           39
#define MSHASHSRCHS          40
#define MSHASHCMPS           41
#define MSTHASHSZ            42
#define MSNHASHENTS          43
#define MSGCINTERVAL         44
#define MSMXFLOWS            45
#define MSAVIDLEPER1000      46
#define MSMINIDLEPER1000     47
#define INTERFACENAME        48

#define PCNEARMEM	     61
#define PCFARMEM             62
#define PCBADPKTS	     63
#define PCNOBUFPKTS	     64
#define PCLOSTPKTS	     65
#define PCLOSTPKTS	     65
#define PCBADTIMES	     66

#define TR_STATE	     67
#define TR_INFO	             68
#define TR_TIME 	     69

#define IFINDEX		 1
#define IFDESCR		 2
#define IFTYPE	         3
#define IFMTU		 4
#define IFSPEED		 5
#define IFPHYSADDRESS	 6
#define IFADMINSTATUS	 7
#define IFOPERSTATUS	 8
#define IFLASTCHANGE	 9
#define IFINOCTETS	10
#define IFINUCASTPKTS	11
#define IFINNUCASTPKTS	12
#define IFINDISCARDS	13
#define IFINERRORS	14
#define IFINUNKNOWNPROTOS 15
#define IFOUTOCTETS	16
#define IFOUTUCASTPKTS	17
#define IFOUTNUCASTPKTS 18
#define IFOUTDISCARDS	19
#define IFOUTERRORS	20
#define IFOUTQLEN	21

#define ATIFINDEX	0
#define ATPHYSADDRESS	1
#define ATNETADDRESS	2

#define IPFORWARDING	0
#define IPDEFAULTTTL	1
#define IPINRECEIVES	2
#define IPINHDRERRORS	3
#define IPINADDRERRORS	4
#define IPFORWDATAGRAMS 5
#define IPINUNKNOWNPROTOS 6
#define IPINDISCARDS	7
#define IPINDELIVERS	8
#define IPOUTREQUESTS	9
#define IPOUTDISCARDS	10
#define IPOUTNOROUTES	11
#define IPREASMTIMEOUT	12
#define IPREASMREQDS	13
#define IPREASMOKS	14
#define IPREASMFAILS	15
#define IPFRAGOKS	16
#define IPFRAGFAILS	17
#define IPFRAGCREATES	18

#define IPADADDR	1
#define IPADIFINDEX	2
#define IPADNETMASK	3
#define IPADBCASTADDR	4

#define IPROUTEDEST	0
#define IPROUTEIFINDEX	1
#define IPROUTEMETRIC1	2
#define IPROUTEMETRIC2	3
#define IPROUTEMETRIC3	4
#define IPROUTEMETRIC4	5
#define IPROUTENEXTHOP	6
#define IPROUTETYPE	7
#define IPROUTEPROTO	8
#define IPROUTEAGE	9

#define ICMPINMSGS	     0
#define ICMPINERRORS	     1
#define ICMPINDESTUNREACHS   2
#define ICMPINTIMEEXCDS      3
#define ICMPINPARMPROBS      4
#define ICMPINSRCQUENCHS     5
#define ICMPINREDIRECTS      6
#define ICMPINECHOS	     7
#define ICMPINECHOREPS	     8
#define ICMPINTIMESTAMPS     9
#define ICMPINTIMESTAMPREPS 10
#define ICMPINADDRMASKS     11
#define ICMPINADDRMASKREPS  12
#define ICMPOUTMSGS	    13
#define ICMPOUTERRORS	    14
#define ICMPOUTDESTUNREACHS 15
#define ICMPOUTTIMEEXCDS    16
#define ICMPOUTPARMPROBS    17
#define ICMPOUTSRCQUENCHS   18
#define ICMPOUTREDIRECTS    19
#define ICMPOUTECHOS	    20
#define ICMPOUTECHOREPS     21
#define ICMPOUTTIMESTAMPS   22
#define ICMPOUTTIMESTAMPREPS 23
#define ICMPOUTADDRMASKS    24
#define ICMPOUTADDRMASKREPS 25

#define TCPRTOALGORITHM      1
#define TCPRTOMIN	     2
#define TCPRTOMAX	     3
#define TCPMAXCONN	     4
#define TCPACTIVEOPENS	     5
#define TCPPASSIVEOPENS      6
#define TCPATTEMPTFAILS      7
#define TCPESTABRESETS	     8
#define TCPCURRESTAB	     9
#define TCPINSEGS	    10
#define TCPOUTSEGS	    11
#define TCPRETRANSSEGS	    12
#define TCPCONNSTATE	    13
#define TCPCONNLOCALADDRESS 14
#define TCPCONNLOCALPORT    15
#define TCPCONNREMADDRESS   16
#define TCPCONNREMPORT	    17

#define UDPINDATAGRAMS	    0
#define UDPNOPORTS	    1
#define UDPINERRORS	    2
#define UDPOUTDATAGRAMS     3

#define EVENTCLASS		    0
#define EVENTINSTANCE		    1
#define EVENTALARMTYPE		    2
#define EVENTTIME		    3
#define EVENTPROBCAUSE		    4
#define EVENTSPECIFICPROBLEM	    5
#define EVENTSEVERITY		    6
#define EVENTBACKUPSTATUS	    7
#define EVENTBACKUPINSTANCE	    8
#define EVENTTREND		    9
#define EVENTTHRESHOLD		    10
#define EVENTTHRESHOLDLEVEL	    11
#define EVENTTHRESHOLDOBSVALUE	    12
#define EVENTID			    13
#define EVENTCORRELATIONS	    14
#define EVENTOPERSTATE		    16
#define EVENTADMINSTATE		    17
#define EVENTMONATTRIBUTES	    18
#define EVENTREPAIRACTION	    19
#define EVENTDATA		    20
#define EVENTTEXT		    21
#define EVENTCREDIBILITY	    22
#define EVENTINDEX		    23
#define EVENTVALID		    24

/* FT defines for flow table moved to flowhash.h */

#define FTCOLATTRIB	       11
#define FTCOLTIME	       12
#define FTCOLINDEX	       13
#define FTCOLBLOB	       14

#define PTSELECTOR	       21
#define PTRULESET	       22
#define PTTIME	               23
#define PTINDEX	               24
#define PTPACKAGE	       25

#define RTRULESET  	 	1
#define RTRULEINDEX	 	2
#define RTSELECTOR	 	3
#define RTRULEMASK	 	4
#define RTMATCHVALUE	 	5
#define RTRULEACTION	 	6
#define RTJUMPINDEX	 	7
