/* 1555, Wed 30 Sep 92

   DECnet packet layouts

   Nevil Brownlee,
   ITSS Technology Development,  The University of Auckland */

struct level1_routing {  /* Type 07 */
   unsigned char
      src_dn_addr[2],      /* Router DECnet address */
      rsrv1[5],            /* 00 20 00 e0 01 */
      rt_info;             /* 2 bytes per entry */
   };

struct level2_routing {  /* Type 09 */
   unsigned char
      src_dn_addr[2],      /* Router DECnet address */
      rsrv1[5],            /* 00 20 00 01 00 */
      rt_info;             /* 2 bytes per entry */
   };

struct router_hello {  /* Type 0b, (81 0b ?) */
   unsigned char rsrv1,    /* 02 */
      en_zero1[2],         /* 00 00 */
      dec_en_hdr1[4],      /* aa 00 04 00 */
      src_dn_addr[2],      /* Router DECnet address */
      rsrv2[17],           /* 02 da 05 00 ... */
      dec_en_hdr2[4],      /* aa 00 04 00 Other Router addresses */
      rtr_dn_addr[2],      /* DECnet address */
      rtr_info;            /* 7 bytes per entry */
   };

struct endnode_hello {  /* Type 0d, 81 0d */
   unsigned char rsrv1,    /* 02 */
      en_zero1[2],         /* 00 00 */
      dec_en_hdr1[4],      /* aa 00 04 00 */
      src_dn_addr[2],      /* Host DECnet address */
      rsrv2[10],           /* 03 da 05 00 ... */
      en_zero2[2],         /* 00 00 */
      dec_en_hdr2[4],      /* aa 00 04 00 */
      rtr_dn_addr[2];      /* Designated Router DECnet address */
   };

struct data {  /* Type 26, 81 26, 2e, 81 2e */
   unsigned char
      en_zero1[2],         /* 00 00 */
      dec_en_hdr1[4],      /* aa 00 04 00 */
      dest_dn_addr[2],     /* Host DECnet address */
      en_zero2[2],         /* 00 00 */
      dec_en_hdr2[4],      /* aa 00 04 00 */
      src_dn_addr[2],      /* Host DECnet address */
      data[1];
   };

union decnet {
   struct level1_routing l1r;
   struct level2_routing l2r;
   struct router_hello rh;
   struct endnode_hello eh;
   struct data d;
   };


