#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#if HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#define EXTSNMP
#include "ausnmp.h"

#ifdef DOS
#include "..\wattcp\tcp.h"

#else
#include <sys/time.h>
#include <netinet/in.h>
#endif

#include "asn1.h"
#include "snmp.h"
#include "snmpimpl.h"
#include "snmpapi.h"
#include "snmpclnt.h"

extern int  errno;
int command = GET_REQ_MSG;
int	snmp_dump_packet = 0;

void test_oid(oid *ot, int l_ot)
{
   unsigned char uc[60], *r, *s;
   oid rot[20];
   int j,k, rl, sl, l_rot;
   unsigned char typ;

   printf("ot = %lx . %lx", ot[0],ot[1]); 
   for (j = 2; j != l_ot; ++j) printf(" . %lx", ot[j]);
   printf("\n");

   rl = sizeof(uc);
   r = asn_build_objid(uc,&rl, ASN_INTEGER, ot,l_ot);
   k = r-uc;
   printf("k = %d, uc =", k);
   for (j = 0; j != k; ++j) printf(" %02x", uc[j]);
   printf("\n");

   sl = sizeof(uc);
   l_rot = 20;
   s = asn_parse_objid(uc,&sl, &typ, rot,&l_rot);
#if 0
   printf("rot = %lx . %lx", rot[0],rot[1]); 
   for (j = 2; j != l_ot; ++j) printf(" . %lx", rot[j]);
   printf("\n");
#endif
   if (l_rot != l_ot)
      printf("   Lengths differ <<<\n");
   else for (j = 0; j != l_rot; ++j) {
      if (rot[j] != ot[j]) {
         printf("   OIDs differ <<<\n");
         break;
	 }
      }
   printf("\n");
   }

int main(int argc, char *argv[])
{
   int j;
   oid ot[20] = {1, 2};
   unsigned long v;

   v = 0x1040C205 << 3;
   for (j = 32; j != 0; --j) {
      ot[2] = v >> (j-1);
      test_oid(ot, 3);   
      }
   ot[2] = 0xFFFFFFFF;
   test_oid(ot, 3);   
   ot[2] = 0;
   test_oid(ot, 3);   
   }
