#ifndef _READBGP_H
#define _READBGP_H



#define ERROR_READBGP_FILE_OPEN         1
#define ERROR_READBGP_FILE_READ         2
#define ERROR_READBGP_FILE_CLOSE        3
#define ERROR_READBGP_OCTET_TOO_BIG     4
#define ERROR_READBGP_MASK_TOO_BIG      5
#define ERROR_READBGP_MASK_UNKNOWN      6
#define ERROR_READBGP_ALLOC_SUBNET      7
#define ERROR_READBGP_ALLOC_AS_PATH     8
#define ERROR_READBGP_INSERT_SUBNET     9
#define ERROR_READBGP_ALLOC_DUMP        10
#define ERROR_READBGP_BAD_PARMS         11
#define ERROR_READBGP_NO_ENVAR          12
#define ERROR_READBGP_CANNOT_CVT_ENVAR  13
#define ERROR_READBGP_BAD_ENVAR_VALUE   14
#define ERROR_READBGP_SUBALLOC_SUBNET   15



#define DEFAULT_AS_ENVAR    "DEFAULT_AS"
#define SKIPPED_AS_ENVAR    "SKIPPED_AS"
#define NORMAL_AS_BASE      1               /* inclusive */
#define NORMAL_AS_MAX       32767           /* inclusive */
#define AGGREGATE_AS_BASE   64512           /* inclusive */
#define AGGREGATE_AS_MAX    65534           /* inclusive */
#define AGGREGATE_AS_COUNT  (AGGREGATE_AS_MAX - AGGREGATE_AS_BASE + 1)


Bit32 get_mask_from_length( unsigned length );
/* static int init_bgp( void ); */
/* static int parse_bgp_line( char *buffer, unsigned length ); */
int read_bgp_file( const char *infile_name );
unsigned get_bgp_line_count( void );
const char *get_aggregate_as_expansion( unsigned short as_number );



#endif      /* not included yet */
