/* 1245, Wed 11 Sep 96

   SNMPBULKWALK.C:  Walk an agent's MIB using GET_BULK requests.
            NeTraMet version, based on CMU SNMPv2 (see below).

   Copyright (C) 1992-2002 by Nevil Brownlee,
   CAIDA | University of Auckland */

/*
 * $Log: snmpbulkwalk.c,v $
 * Revision 1.1.1.2.2.9  2002/02/23 01:57:13  nevil
 * Moving srl examples to examples/ directory.  Modified examples/Makefile.in
 *
 * Revision 1.1.1.2.2.5  2000/08/08 19:44:40  nevil
 * 44b8 release
 *
 * Revision 1.1.1.2.2.3  2000/06/06 03:38:04  nevil
 * Combine NEW_ATR with TCP_ATR, various bug fixes
 *
 * Revision 1.1.1.2  1999/10/03 21:06:03  nevil
 * *** empty log message ***
 *
 * Revision 1.1.1.1.2.2  1999/01/27 04:26:10  nevil
 * Minor corrections to fix compiler warnings
 *
 * Revision 1.1.1.1.2.1  1999/01/08 01:38:14  nevil
 * Distribution file for 4.3b
 *
 * Revision 1.1.1.1  1998/11/16 03:57:26  nevil
 * Import of NeTraMet 4.3b3
 *
 * Revision 1.1.1.1  1998/11/16 03:22:00  nevil
 * Import of release 4.3b3
 *
 * Revision 1.1.1.1.2.1  1998/11/11 23:14:33  nevil
 * Only include malloc.h if we HAVE_MALLOC_H
 *
 * Revision 1.1.1.1  1998/10/28 20:31:22  nevil
 * Import of NeTraMet 4.3b1
 *
 * Revision 1.1.3.2.2.3  1998/10/27 04:39:11  nevil
 * 4.3b1 release
 *
 * Revision 1.1.3.2.2.2  1998/10/22 23:03:20  nevil
 * Provide log_msg() for snmp library, check length of input strings
 */

/*********************************************************************
	Copyright 1988, 1989, 1991, 1992 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
**********************************************************************/

#if HAVE_CONFIG_H
#include <ntm_conf.h>
#endif

#include <sys/types.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <netdb.h>
#if HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#define EXTSNMP
#include "ausnmp.h"

#include "asn1.h"
#include "snmp.h"
#include "snmpimpl.h"
#include "snmpapi.h"
#include "snmpclnt.h"

oid objid_mib[] = {1, 3, 6, 1, 2, 1};

int snmp_dump_packet = 0;

void usage(void) {
   fprintf(stderr,
      "Usage: snmpbulkwalk -v 2 hostname community [objectID]\n");
   fprintf(stderr,
      "or:    snmpbulkwalk -v 1 hostname community [objectID]\n");
   }

void log_msg(int priority, int die, char *fmt, ...)
{
   char msg[100];
   va_list ap;

   va_start(ap, fmt);
   vsprintf(msg, fmt, ap);
   va_end(ap);
   printf("%s\n",msg);

   if (die) exit(die);
   }

int main(int argc, char *argv[])
{
   struct snmp_session	session, *ss;
   struct snmp_pdu *pdu, *response;
   struct variable_list *vars;
   int	arg;
   char *hostname = NULL;
   char *community = NULL;
   int gotroot = 0, version = 2;
   oid	name[MAX_NAME_LEN];
   int name_length;
   oid root[MAX_NAME_LEN];
   int	rootlen, count;
   int err, running;
   int status;
   int port_flag = 0;
   int dest_port = 0;
   int reps = 1000;

   init_mib();

   for (arg = 1; arg < argc; arg++) {
      if (argv[arg][0] == '-') {
	 switch(argv[arg][1]) {
	 case 'd':
	    snmp_dump_packet++;
	    break;
	 case 'm':
	    au_snmp_port = atoi(argv[++arg]);
	    break;
	 case 'p':
	    port_flag++;
	    dest_port = atoi(argv[++arg]);
	    break;
	 case 'r':
	    reps = atoi(argv[++arg]);
	    break;
	 case 'v':
	    version = atoi(argv[++arg]);
	    if (version < 1 || version > 2) {
	       fprintf(stderr, "Invalid version\n");
	       usage();
	       exit(1);
	       }
	    break;
	 default:
	    printf("invalid option: -%c\n", argv[arg][1]);
	    break;
	    }
	 continue;
	 }
      if (hostname == NULL) {
	 hostname = argv[arg];
	 }
      else if ((version == 2 || version == 1) && community == NULL) {
	 community = argv[arg]; 
	 }
      else {
	 rootlen = MAX_NAME_LEN;
	 if (read_objid(argv[arg], root, &rootlen)) {
	    gotroot = 1;
	    }
	 else {
	    printf("Invalid object identifier: %s\n", argv[arg]);
	    }
	 }
      }
   
   if (gotroot == 0) {
      memcpy((char *)root, (char *)objid_mib, sizeof(objid_mib));
      rootlen = sizeof(objid_mib) / sizeof(oid);
      gotroot = 1;
      }

   if (!hostname || (version < 1) || (version > 2) || (!community)) {
      usage();
      exit(1);
      }

   memset((char *)&session, 0, sizeof(struct snmp_session));
   session.peername = hostname;
   if (port_flag)
      session.remote_port = dest_port;

   if (version == 1) session.version = SNMP_VERSION_1;
   else session.version = SNMP_VERSION_2C;
   session.community = (u_char *)community;
   session.community_len = strlen((char *)community);

   session.retries = SNMP_DEFAULT_RETRIES;
   session.timeout = 2000000L;
   session.authenticator = NULL;
   snmp_synch_setup(&session);
   ss = snmp_open(&session);
   if (ss == NULL) {
      printf("Couldn't open snmp\n");
      exit(-1);
      }

   memcpy((char *)name, (char *)root, rootlen * sizeof(oid));
   name_length = rootlen;

   running = 1;
   while (running) {
      err = 0;
      running = 1;
      pdu = snmp_pdu_create(BULK_REQ_MSG);
      pdu->non_repeaters = 0;
      pdu->max_repetitions = reps; /* Fill the packet */

      snmp_add_null_var(pdu, name, name_length);

      status = snmp_synch_response(ss, pdu, &response);
      if (status == STAT_SUCCESS) {
	 if (response->errstat == SNMP_ERR_NOERROR) {
	    for (vars = response->variables; vars;
		  vars = vars->next_variable) {
	       if (vars->name_length < rootlen
		     || memcmp(root, vars->name, rootlen * sizeof(oid))) {
		  running = 0;
		  continue;	/* Not part of this subtree */
		  }
	       if (vars->type != SNMP_ENDOFMIBVIEW)
		  print_variable(vars->name, vars->name_length, vars);
	       if (vars->type == SNMP_ENDOFMIBVIEW
		     || vars->type == SNMP_NOSUCHOBJECT /* For robustness */
		     || vars->type == SNMP_NOSUCHINSTANCE) {
	          if (vars->type == SNMP_ENDOFMIBVIEW)
		     printf("\nEnd of MIB view\n");
		  if (vars->type == SNMP_NOSUCHOBJECT)
		     printf("\nNo such object\n");
		  if (vars->type == SNMP_NOSUCHINSTANCE)
		     printf("\nNo such instance\n");
		  err = 1;
		  running = 0;	/* Time to stop! */
		  }
	       if (!vars->next_variable) { /* Repeat on last variable */
		  memcpy((char *)name, (char *)vars->name,
			vars->name_length * sizeof(oid));
		  name_length = vars->name_length;
		  }
	       }
	    if (running == 0 && !err)
	       printf("\nEnd of specified subtree\n");
	    }
	 else {
	    running = 0;
	    if (response->errstat == SNMP_ERR_NOSUCHNAME) {
	       printf("\nError: no such name\n");
	       }
	    else {
	       printf("\nError in packet.\nReason: %s\n",
		  snmp_errstring(response->errstat));
	       if (response->errstat == SNMP_ERR_NOSUCHNAME) {
		  printf("The request for this object identifier failed: ");
		  for (count = 1, vars = response->variables; vars
		        && count != response->errindex;
		        vars = vars->next_variable, count++)
		     ; /*EMPTY*/
		  if (vars)
		     print_objid(vars->name, vars->name_length);
		  printf("\n");
		  }
	       }
	    }

	 }
      else if (status == STAT_TIMEOUT) {
	 printf("No Response from %s\n", hostname);
	 running = 0;
	 }
      else {		/* status == STAT_ERROR */
	 printf("An error occurred, Quitting\n");
	 running = 0;
	 }
      
      if (response)
	 snmp_free_pdu(response);
      }
   snmp_close(ss);
   }
