// EXchess source code, (c) Daniel C. Homan  1997-2000
// Released under the GNU public license, see file license.txt

/*-------------------------- Sorting Routines ------------------------*/
//  This is a collection of sorting routines from various sources
//  The Insert Sort seems to be the fastest for these applications
//  and it is also a "stable" sort - which is desirable

#include "define.h"
#include "chess.h"
#include "const.h"
#include "funct.h"

#define CompGT(a,b) (a < b)

void InsertSort(move_rec *Lb, move_rec *Ub);
void ShellSort(move_rec *Lb, move_rec *Ub);

void Sort(move_rec *Lb, move_rec *Ub)
{
   InsertSort(Lb, Ub);
}

/* -------------- Insert Sort Routine ---------------------*/

void InsertSort (move_rec *Lb, move_rec *Ub) {
   move_rec V, *I, *J, *Jmin;
   /**********************
   *  Sort Array(Lb..Ub) *
   **********************/
   Jmin = Lb - 1;
   for (I = Lb + 1; I <= Ub; I++) {
       V = *I;
       for ( J = I-1; J != Jmin && CompGT(J->score,V.score); J--)
	   *(J+1) = *J;
       *(J+1) = V;
   }
}

void ShellSort (move_rec *Lb, move_rec *Ub) {
  int inc = 1; move_rec V, *I, *J;
  do {
     inc *= 3;
     inc++;
  } while (inc <= Ub - Lb);
  do {
     inc /= 3;
     for (I = Lb+inc; I <= Ub; I++) {
         V = *I;
         J = I;
         while ((J-inc)->score < V.score) {
             *J = *(J-inc);
              J -= inc;
              if ((J-Lb) < inc) break;
         }
         *J = V;
     }
  } while (inc > 1);
}

/*------------------- Quick Sort Routine --------------------*/
// Used for sorting book move records based on hash code

/* typedefs for sort routines below */
typedef book_rec TT;
typedef book_rec TblIndex;

#define CompTT(a,b) (a > b)

TT *Partition(TT *Lb, TT *Ub) {
    TT  V, Pivot, *I, *J, *P;

    unsigned int Offset;

    Offset = (Ub - Lb)>>1;
    P = Lb + Offset;
    Pivot = *P;
    *P = *Lb;

    I = Lb + 1;
    J = Ub;
    while (1) {
	while (I < J && CompTT(Pivot.pos_code, I->pos_code)) I++;
	while (J >= I && CompTT(J->pos_code, Pivot.pos_code)) J--;

	if (I >= J) break;
	V = *I;
	*I = *J;
	*J = V;
	J--; I++;
    }

    *Lb = *J;
    *J = Pivot;

    return J;
}

void QuickSort(TT *Lb, TT *Ub) {
    TT *M;

    while (Lb < Ub) {

      M = Partition (Lb, Ub);

      if (M - Lb <= Ub - M) {
	  QuickSort(Lb, M-1);
	  Lb = M+1;
      } else {
	  QuickSort(M+1, Ub);
	  Ub = M - 1;
      }
   }
}








