// EXchess source code, (c) Daniel C. Homan  1997-2000
// Released under the GNU public license, see file license.txt

/*--------------------- setup.cpp ------------------------*/
//
//  This file contains setup routines for EXchess.  These
//  routines are run when EXchess first starts up.
//

#include <iostream.h>
#include <fstream.h>
#include <stdlib.h>
#include <string.h>

#include "define.h"
#include "chess.h"
#include "const.h"
#include "funct.h"
#include "hash.h"

/* Simple tables for quick in_check? tests */
int check_table[64][64];
int rook_check_table[64][64];
int bishop_check_table[64][64];
int knight_check_table[64][64];

/* flag for logging */
int logging = 0;

/* taxi-cab distance between squares */
int taxi_cab[64][64];

/* piece values */
extern int value[7];

/* extensions */
extern int CAPT_EXT, CHECK_EXT, PAWN_EXT, RE_CAPT_EXT;
extern int ONE_REPLY_TO_CHECK, MATE_EXT, INIT_EXT, R, RAZOR_DEPTH;

/* other external variables */
extern char exec_path[100], EGTB_PATH[100], BOOK_FILE[100];
extern float CACHE_SIZE;
extern int MAX_LOGS, GAMBIT_SCORE, BOOK_LEARNING;

/*-------- Set search and scoring parameters ------------*/
//
// This function sets certain search and scoring parameters.
// It is part of the initialization startup of EXchess.
//
//

void set_score_param()
{

 char dummy[50], line[200], parameter_file[100];
 int HASH;

 // look for the search parameter file in the
 // executable directory and in the current directory

 strcpy(parameter_file, exec_path);
 strcat(parameter_file, "search.par");

 ifstream parfile(parameter_file);
 if(!parfile) parfile.open("search.par");
 if(!parfile) { cout << "Error(NoScoreFile)"; return; }

 // Read through search parameter file, setting
 // values as appropriate.

 while(!parfile.eof()) {
  parfile >> dummy;
  if(dummy[0] == '#') {
    parfile.getline(line, 199);
    continue;
  }

  if(!strcmp(dummy, "PAWN_VALUE")) {
    parfile >> value[PAWN];
  } else if(!strcmp(dummy, "KNIGHT_VALUE")) {
    parfile >> value[KNIGHT];
  } else if(!strcmp(dummy, "BISHOP_VALUE")) {
    parfile >> value[BISHOP];
  } else if(!strcmp(dummy, "ROOK_VALUE")) {
    parfile >> value[ROOK];
  } else if(!strcmp(dummy, "QUEEN_VALUE")) {
    parfile >> value[QUEEN];
  } else if(!strcmp(dummy, "KING_VALUE")) {
    parfile >> value[KING];
  } else if(!strcmp(dummy, "CHECK_EXTENSION")) {
    parfile >> CHECK_EXT;
  } else if(!strcmp(dummy, "ONE_REPLY_TO_CHECK")) {
    parfile >> ONE_REPLY_TO_CHECK;
  } else if(!strcmp(dummy, "PAWN_PUSH_EXTENSION")) {
    parfile >> PAWN_EXT;
  } else if(!strcmp(dummy, "RECAPTURE_EXTENSION")) {
    parfile >> RE_CAPT_EXT;
  } else if(!strcmp(dummy, "MATE_EXTENSION")) {
    parfile >> MATE_EXT;
  } else if(!strcmp(dummy, "INITIAL_EXTENSION")) {
    parfile >> INIT_EXT;
  } else if(!strcmp(dummy, "NULL_MOVE_REDUCTION")) {
    parfile >> R; if(R <= 0) { R = 0; }
  } else if(!strcmp(dummy, "RAZORING_DEPTH")) {
    parfile >> RAZOR_DEPTH;
  } else if(!strcmp(dummy, "EGTB_PATH")) {
    parfile >> EGTB_PATH;
  } else if(!strcmp(dummy, "EGTB_CACHE_SIZE")) {
    parfile >> CACHE_SIZE;
  } else if(!strcmp(dummy, "LOG")) {
    parfile >> logging;
  } else if(!strcmp(dummy, "GAMBIT_SCORE")) {
    parfile >> GAMBIT_SCORE;
  } else if(!strcmp(dummy, "MAX_LOGS")) {
    parfile >> MAX_LOGS;
  } else if(!strcmp(dummy, "BOOK_FILE")) {
    parfile >> BOOK_FILE;
  } else if(!strcmp(dummy, "HASH")) {
    parfile >> HASH; set_hash_size(HASH);
  } else if(!strcmp(dummy, "BOOK_LEARNING")) {
    parfile >> BOOK_LEARNING;
  } else parfile.getline(line, 199);

 }


}

/* Function to generate check tables */
//
//  Simply sets a "1" if a given FROM-TO attack
//  combination is at all possible.  Sets a "0" if
//  such a combination is not possible.
//
//  These tables help to quickly rule out certain
//  kinds of attacks which could generate a check.
//
//  Function also generates the 'taxi-cab' distance
//  table used in the scoring functions

void gen_check_table()
{

  int i, j;
  for(i = 0; i < 64; i++) {
   for(j = 0; j < 64; j++) {
     // setup the taxi-cab distance table
     taxi_cab[i][j] = MAX((ABS(FILE(i)-FILE(j))),(ABS(RANK(i)-RANK(j))));
     if(FILE(i)==FILE(j) || RANK(i)==RANK(j)) {
      rook_check_table[i][j] = 1;
      check_table[i][j] = 1;
     } else { 
      rook_check_table[i][j] = 0;
      check_table[i][j] = 0;
     }
     bishop_check_table[i][j] = 0;
     knight_check_table[i][j] = 0;
   }
  }

  for(i = 0; i < 64; i++) {
    j = i; while(RANK(j) && FILE(j))
            { j -= 9; bishop_check_table[i][j] = 1; check_table[i][j] = 1; }
    j = i; while(RANK(j) && FILE(j) < 7)
            { j -= 7; bishop_check_table[i][j] = 1; check_table[i][j] = 1; }
    j = i; while(RANK(j) < 7 && FILE(j))
            { j += 7; bishop_check_table[i][j] = 1; check_table[i][j] = 1; }
    j = i; while(RANK(j) < 7 && FILE(j) < 7)
            { j += 9; bishop_check_table[i][j] = 1; check_table[i][j] = 1; }
    if(FILE(i) < 6 && RANK(i) < 7) { knight_check_table[i][i+10] = 1; }
    if(FILE(i) < 6 && RANK(i)) { knight_check_table[i][i-6] = 1; }
    if(FILE(i) > 1 && RANK(i) < 7) { knight_check_table[i][i+6] = 1; }
    if(FILE(i) > 1 && RANK(i)) { knight_check_table[i][i-10] = 1; }
    if(FILE(i) < 7 && RANK(i) < 6) { knight_check_table[i][i+17] = 1; }
    if(FILE(i) && RANK(i) < 6) { knight_check_table[i][i+15] = 1; }
    if(FILE(i) < 7 && RANK(i) > 1) { knight_check_table[i][i-15] = 1; }
    if(FILE(i) && RANK(i) > 1) { knight_check_table[i][i-17] = 1; }
  }

}
