// EXchess source code, (c) Daniel C. Homan  1997-2000
// Released under the GNU public license, see file license.txt

/* Move generator functions */
// These basically loop through all the squares, calling the appropriate
// subroutines to generate moves/captures for the given piece.

#include "define.h"
#include "chess.h"
#include "const.h"
#include "funct.h"

/*------------------------- Semi-legal moves generator ---------------------*/

void legalmoves(position *p, move_list *list)
{
  register int i;
  list->count = 0;

  for(i=1;i<=p->plist[p->wtm][PAWN][0];i++) 
    pawn_moves(p, list, p->plist[p->wtm][PAWN][i]);
  for(i=1;i<=p->plist[p->wtm][KNIGHT][0];i++) 
    knight_moves(p, list, p->plist[p->wtm][KNIGHT][i]);
  for(i=1;i<=p->plist[p->wtm][BISHOP][0];i++) 
    bishop_moves(p, list, p->plist[p->wtm][BISHOP][i]);
  for(i=1;i<=p->plist[p->wtm][ROOK][0];i++) 
    rook_moves(p, list, p->plist[p->wtm][ROOK][i]);
  for(i=1;i<=p->plist[p->wtm][QUEEN][0];i++) {
    bishop_moves(p, list, p->plist[p->wtm][QUEEN][i]);
    rook_moves(p, list, p->plist[p->wtm][QUEEN][i]);
  }
  for(i=1;i<=p->plist[p->wtm][KING][0];i++) 
    king_moves(p, list, p->plist[p->wtm][KING][i]);

}

/*------------------------- Semi-legal capture generator ---------------------*/

void captures(position *p, move_list *list)
{
  register int i;
  list->count = 0;

  for(i=1;i<=p->plist[p->wtm][PAWN][0];i++) 
    pawn_capts(p, list, p->plist[p->wtm][PAWN][i]);
  for(i=1;i<=p->plist[p->wtm][KNIGHT][0];i++) 
    knight_capts(p, list, p->plist[p->wtm][KNIGHT][i]);
  for(i=1;i<=p->plist[p->wtm][BISHOP][0];i++) 
    bishop_capts(p, list, p->plist[p->wtm][BISHOP][i]);
  for(i=1;i<=p->plist[p->wtm][ROOK][0];i++) 
    rook_capts(p, list, p->plist[p->wtm][ROOK][i]);
  for(i=1;i<=p->plist[p->wtm][QUEEN][0];i++) {
    bishop_capts(p, list, p->plist[p->wtm][QUEEN][i]);
    rook_capts(p, list, p->plist[p->wtm][QUEEN][i]);
  }
  for(i=1;i<=p->plist[p->wtm][KING][0];i++) 
    king_capts(p, list, p->plist[p->wtm][KING][i]);

}
