#include <stdio.h>
#include <time.h>
#include <sys/time.h>
#include <sys/errno.h>

FILE  *f;
FILE *of;
FILE *of1;
FILE *ef;

#define ACTFILE_FSCANF_FORMAT \
"\n%[^:]:%[^:]:%ld:%[^:]:%[^:]:%[^:]:%[^:]:%[^:]:%[^:]:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld:%ld"

#define ACTFILE_FSCANF_COUNT 33

#define ACTFILE_FSCANF_VARS \
             d->qname, \
             d->hostname, \
             &d->master, \
             qcomplex_str, \
             d->group, \
             d->owner, \
             d->job_name, \
             d->dqs_job_name, \
             d->account, \
             &d->priority, \
             &d->job_number, \
             &d->submission_time, \
             &d->start_time, \
             &d->end_time, \
             &d->exit_status, \
             &d->ru_wallclock, \
             &d->ru_utime, \
             &d->ru_stime, \
             &d->ru_maxrss, \
             &d->ru_ixrss, \
             &d->ru_ismrss, \
             &d->ru_idrss, \
             &d->ru_isrss, \
             &d->ru_minflt, \
             &d->ru_majflt, \
             &d->ru_nswap, \
             &d->ru_inblock, \
             &d->ru_oublock, \
             &d->ru_msgsnd, \
             &d->ru_msgrcv, \
             &d->ru_nsignals, \
             &d->ru_nvcsw, \
             &d->ru_nivcsw
#define u_long32 long
struct drusage {
    char     qname[1024];
    char     hostname[1024];
        u_long32 master;
        char     group[1024];
    char     owner[1024];
    char     job_name[1024];
    char     dqs_job_name[1024];
    char     account[1024];
    u_long32 priority;
    u_long32 job_number;
    u_long32 submission_time;
    u_long32 start_time;
    u_long32 end_time;
    u_long32 exit_status;
    u_long32 ru_wallclock;
    u_long32 ru_utime;      /* user time used */
    u_long32 ru_stime;      /* system time used */
    u_long32 ru_maxrss;
    u_long32 ru_ixrss;      /* integral shared text size */
    u_long32 ru_ismrss;     /* integral shared memory size*/
    u_long32 ru_idrss;      /* integral unshared data " */
    u_long32 ru_isrss;      /* integral unshared stack " */
    u_long32 ru_minflt;     /* page reclaims */
    u_long32 ru_majflt;     /* page faults */
    u_long32 ru_nswap;      /* swaps */
    u_long32 ru_inblock;    /* block input operations */
    u_long32 ru_oublock;    /* block output operations */
    u_long32 ru_msgsnd;     /* messages sent */
    u_long32 ru_msgrcv;     /* messages received */
    u_long32 ru_nsignals;   /* signals received */
    u_long32 ru_nvcsw;      /* voluntary context switches */
    u_long32 ru_nivcsw;     /* involuntary " */
};

typedef struct drusage drusage_t;             




main( int argc, char **argv)
{
int fscanf_count,i;
char  qcomplex_str[1024];
char ssubtime[1024];
char ssttime[1024];
char setime[1024];
char infile[1024];
char *ttime;
drusage_t *d;
time_t subtime, sttime, etime, timenow, timethen, timetemp;
int firsttime;
struct timeval  now;
struct timezone tzp;

gettimeofday(&now, &tzp);
timenow=
now.tv_sec;

if(argc>2){
	timetemp= atoi(argv[1]);   /* how many days to include */
	timethen= timenow - (timetemp * 86400);
}
else {
   timethen=0;
}

if(argc>1){
	       strcpy(infile, argv[1]);
}
else{
	    strcpy(infile,"act_file");
}

d= (drusage_t*) malloc(sizeof(drusage_t) );

f= fopen(infile,"r");
if(!f){
	fprintf("cannot open %s errno=%d\n", infile, errno);
	exit(-1);
}
of= fopen("act_stats","w");
of1= fopen("user_stats","w");
ef= fopen("error_stats","w");

firsttime=1;


while(1) {

    fscanf_count = fscanf(f,ACTFILE_FSCANF_FORMAT,ACTFILE_FSCANF_VARS);
    if(fscanf_count<  ACTFILE_FSCANF_COUNT) break;
    
   subtime= d->submission_time;
   if(subtime< timethen) continue;
   if(d->exit_status==-3072) continue;  /* eliminate draitt weekend disaster */
   
   sttime= d->start_time;
   etime= d->end_time;
   ttime= ctime(&subtime);
   strcpy(ssubtime,ttime);
   ttime= ctime(&sttime);
   strcpy(ssttime,ttime);
   ttime= ctime(&etime);
   strcpy(setime,ttime);

   if(firsttime){
        fprintf(of,"  timethen= %d  timenow= %d\n",subtime,timenow);
        fprintf(of1,"  timethen= %d  timenow= %d\n",subtime,timenow);
        fprintf(ef,"  timethen= %d  timenow= %d\n",subtime,timenow);
        printf("  timethen= %d  timenow= %d\n",subtime,timenow);
        firsttime=0;
   }   	
   	
   printf(" qname= %s     hostname= %s     master= %d\n",d->qname,d->hostname,d->master);
   printf("      complex_str= %s group= %s  owner= %s\n      jobname=%s dqs_job_name=%s \n",
                 qcomplex_str,d->group,d->owner,d->job_name,d->dqs_job_name);
   printf("      account=%s priority=%d job_number=%d \n",
                 d->account,d->priority,d->job_number );
   printf("      submission_time=%s      start_time= %s      end_time=%s",
                 ssubtime,ssttime,setime);
   printf("      delay=%d elapsed=%d exit_status=%d ru_wallclock=%d\n",
                 (d->start_time-d->submission_time),
                 (d->end_time-d->start_time),
                 d->exit_status,d->ru_wallclock);
   printf("      ru_utime=%d ru_stime=%d ru_maxrss=%d ru_ixrss=%d ru_ismrss=%d\n",
                 d->ru_utime,d->ru_stime,d->ru_maxrss,d->ru_ixrss,d->ru_ismrss);
   printf("      ru_idrss=%d ru_isrss=%d ru_minflt=%d ru_majflt=%d ru_nswap=%d\n",
                 d->ru_idrss,d->ru_isrss,d->ru_minflt,d->ru_majflt,d->ru_nswap);
   printf("      ru_inblock=%d ru_oublock=%d ru_msgsnd=%d ru_msgrcv=%d\n",
                 d->ru_inblock,d->ru_oublock,d->ru_msgsnd, d->ru_msgrcv);
   printf("      ru_nsignals=%d ru_nvcsw=%d ru_nivcsw\n\n\n",
                 d->ru_nsignals, d->ru_nvcsw,d->ru_nivcsw);

if( (d->exit_status !=0) &&( abs(d->exit_status) !=256 ) ) {                 
   fprintf(ef," qname= %s     hostname= %s     master= %d\n",d->qname,d->hostname,d->master);
   fprintf(ef,"      complex_str= %s group= %s  owner= %s\n      jobname=%s dqs_job_name=%s \n",
                 qcomplex_str,d->group,d->owner,d->job_name,d->dqs_job_name);
   fprintf(ef,"      account=%s priority=%d job_number=%d \n",
                 d->account,d->priority,d->job_number );
   fprintf(ef,"      submission_time=%s      start_time= %s      end_time=%s",
                 ssubtime,ssttime,setime);
   fprintf(ef,"      delay=%d elapsed=%d exit_status=%d ru_wallclock=%d\n",
                 (d->start_time-d->submission_time),
                 (d->end_time-d->start_time),
                 d->exit_status,d->ru_wallclock);
   fprintf(ef,"      ru_utime=%d ru_stime=%d ru_maxrss=%d ru_ixrss=%d ru_ismrss=%d\n",
                 d->ru_utime,d->ru_stime,d->ru_maxrss,d->ru_ixrss,d->ru_ismrss);
   fprintf(ef,"      ru_idrss=%d ru_isrss=%d ru_minflt=%d ru_majflt=%d ru_nswap=%d\n",
                 d->ru_idrss,d->ru_isrss,d->ru_minflt,d->ru_majflt,d->ru_nswap);
   fprintf(ef,"      ru_inblock=%d ru_oublock=%d ru_msgsnd=%d ru_msgrcv=%d\n",
                 d->ru_inblock,d->ru_oublock,d->ru_msgsnd, d->ru_msgrcv);
   fprintf(ef,"      ru_nsignals=%d ru_nvcsw=%d ru_nivcsw\n\n\n",
                 d->ru_nsignals, d->ru_nvcsw,d->ru_nivcsw);
}
fprintf(of,"%s %s %s %d %d %d %d %d %d\n",
        d->qname,
        d->owner,        
        qcomplex_str,
        (d->start_time-d->submission_time),
        d->ru_wallclock,
        d->ru_utime,
        d->ru_maxrss,
        d->start_time,
        d->end_time);

fprintf(of1,"%s %s %s %d %d %d %d %d %d\n",
        d->owner,
        d->qname,        
        qcomplex_str,
        (d->start_time-d->submission_time),
        d->ru_wallclock,
        d->ru_utime,
        d->ru_maxrss,
        d->start_time,
        d->end_time);
                

}



}


