static char showacct_c_rcsid[]="showacct.c,v 1.2 1994/06/25 16:25:22 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * showacct.c,v
 * Revision 1.2  1994/06/25  16:25:22  kerce
 * changed version numbers from 3.05 to 3.1.0
 *
 * Revision 1.1.1.1  1994/06/18  19:43:29  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#define MAINPROGRAM
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include "error.h"
#include "strdup.h"
#include "stdstuff.h"
#include "cpyright.h"
#include "acctfile.h"
#include "util.h"

char *ProgramName = NULL;
void (*FatalErrorHook)();
char *Title = "DQS Accounting File Viewer";

#ifndef __DATE__
char *Version = " v3.1.0 beta";
#else
char *Version = " v3.1.0 beta (compiled " __DATE__ " " __TIME__ ")";
#endif

static char *AboutTextString = COPYRIGHT;

static void
ShowUsage ()
{
  fprintf (stderr, "Usage: %s ", ProgramName);
  fprintf (stderr, "[-f AcctFileName] ");
  fprintf (stderr, "[-x] ");

  fprintf (stderr, "\n");
  
  fprintf (stderr, "   or: %s -help\n", ProgramName);
  fprintf (stderr, "   or: %s -version\n", ProgramName);
}

static void
ShowHelp ()
{
  ShowUsage ();
  fprintf (stderr, "\n");
  fprintf (stderr, "where: AcctFileName is the name of a accounting file\n");
  fprintf (stderr, "       `x' (exactly) means echo the accounting file as-is\n");
}

static void
ShowVersion ()
{
  fprintf (stderr, BuildAboutTextString (Title, Version, AboutTextString));
}

static void
ProcessCmdLine (argc, argv, EnvAcctFileName, AcctFileName, Exactly)
     int *argc;
     char **argv;
     char *EnvAcctFileName;
     char **AcctFileName;
     BOOLEAN *Exactly;
{
  char c;
  BOOLEAN NextOption;
  int sscanfResult;

  DENTER ((DQS_EVENT, "ProcessCmdLine"));

  if (DEBUG_ON == 1)
    DisplayArgs (*argc, argv);
  
  while ((--*argc > 0) && ((*++argv)[0] == '-'))
    {
      NextOption = FALSE;
      while ((c = *++argv[0]) && (NextOption == FALSE))
	switch (c)
	  {
	  case 'f':
	    --*argc;
	    if (*argc > 0)
	      {
		argv++;
		if (EnvAcctFileName != NULL)
		  Error (NULL, 0, 0,
			 "WARNING: overriding environment variable %s=%s",
			 ACCTFILEENVVARNAME, EnvAcctFileName);

		*AcctFileName = argv[0];
		NextOption = TRUE;
	      }
	    else
	      {
		Error (NULL, 0, 0,
		       "-f option must be followed by a file name");
		ShowUsage ();
		DEXIT;
		exit (EXIT_FAILURE);
	      }

	    break;

	  case 'x':
	    *Exactly = TRUE;
	    break;

	  case 'h':
	  case '?':
	    ShowHelp ();
	    DEXIT;
	    exit (EXIT_SUCCESS);
	    break;
	    
	  case 'v':
	    ShowVersion ();
	    DEXIT;
	    exit (EXIT_SUCCESS);
	    break;
	    
	  default:
	    Error (NULL, 0, 0, "unknown option `%c'", c);
	    break;
	  }
    }

  if (DEBUG_ON == 1)
    DisplayArgs (*argc, argv);

  if (*argc > 0)
    {
      Error (NULL, 0, 0,
	     "WARNING: the following command line arguments were unused:");

      while (*argc > 0)
	{
	  fprintf (stderr, "%s ", argv[0]);
	  *argc -= 1;
	  argv++;
	}

      fputc ('\n', stderr);
    }

  fflush (stderr);
  DEXIT;
}

void
Writedusage (DUsage, QComplexStr, Exactly)
     dqs_rusage_type DUsage;
     char * QComplexStr;
     BOOLEAN Exactly;
{
  if (Exactly == FALSE)
    {
      printf ("qname:\t\t\t\\%s\\\n", DUsage.qname);
      printf ("hostname:\t\t\\%s\\\n", DUsage.hostname);
      printf ("master:\t\t\t%ld\n", DUsage.master);
      printf ("complex:\t\t\\%s\\\n", QComplexStr);
      printf ("group:\t\t\t\\%s\\\n", DUsage.group);
      printf ("owner:\t\t\t\\%s\\\n", DUsage.owner);
      printf ("job_name:\t\t\\%s\\\n", DUsage.job_name);
      printf ("dqs_job_name:\t\t\\%s\\\n", DUsage.dqs_job_name);
      printf ("job_number:\t\t%ld\n", DUsage.job_number);
      printf ("submission_time:\t%ld (%s)\n", DUsage.submission_time,
	      TimeC ((time_t *) DUsage.submission_time));
      printf ("start_time:\t\t%ld (%s)\n", DUsage.start_time,
	      TimeC ((time_t *) DUsage.start_time));
      printf ("end_time:\t\t%ld (%s)\n", DUsage.end_time,
	      TimeC ((time_t *) DUsage.end_time));
      printf ("exit_status:\t\t%ld\n", DUsage.exit_status);
      printf ("ru_wallclock:\t\t%ld\n", DUsage.ru_wallclock);
      printf ("ru_utime:\t\t%ld\n", DUsage.ru_utime);
      printf ("ru_stime:\t\t%ld\n", DUsage.ru_stime);
      printf ("ru_maxrss:\t\t%ld\n", DUsage.ru_maxrss);
      printf ("ru_ixrss:\t\t%ld\n", DUsage.ru_ixrss);
      printf ("ru_ismrss:\t\t%ld\n", DUsage.ru_ismrss);
      printf ("ru_idrss:\t\t%ld\n", DUsage.ru_idrss);
      printf ("ru_isrss:\t\t%ld\n", DUsage.ru_isrss);
      printf ("ru_minflt:\t\t%ld\n", DUsage.ru_minflt);
      printf ("ru_majflt:\t\t%ld\n", DUsage.ru_majflt);
      printf ("ru_nswap:\t\t%ld\n", DUsage.ru_nswap);
      printf ("ru_inblock:\t\t%ld\n", DUsage.ru_inblock);
      printf ("ru_oublock:\t\t%ld\n", DUsage.ru_oublock);
      printf ("ru_msgsnd:\t\t%ld\n", DUsage.ru_msgsnd);
      printf ("ru_msgrcv:\t\t%ld\n", DUsage.ru_msgrcv);
      printf ("ru_nsignals:\t\t%ld\n", DUsage.ru_nsignals);
      printf ("ru_nvcsw:\t\t%ld\n", DUsage.ru_nvcsw);
      printf ("ru_nivcsw:\t\t%ld\n", DUsage.ru_nivcsw);
      
      printf ("---------------------------------------------------------------\n");
    }
  else
    /*
     *  The following should exactly reproduce the act_file.
     */
    {
      printf ("%s:", 	     DUsage.qname);
      printf ("%s:", 	     DUsage.hostname);
      printf ("%ld:", 	     DUsage.master);
      printf ("%s:", 	     QComplexStr);
      printf ("%s:", 	     DUsage.group);
      printf ("%s:", 	     DUsage.owner);
      printf ("%s:", 	     DUsage.job_name);
      printf ("%s:", 	     DUsage.dqs_job_name);
      printf ("%ld:", 	     DUsage.job_number);
      printf ("%ld:", 	     DUsage.submission_time);
      printf ("%ld:", 	     DUsage.start_time);
      printf ("%ld:", 	     DUsage.end_time);
      printf ("%ld:", 	     DUsage.exit_status);
      printf ("%ld:", 	     DUsage.ru_wallclock);
      printf ("%ld:", 	     DUsage.ru_utime);
      printf ("%ld:", 	     DUsage.ru_stime);
      printf ("%ld:", 	     DUsage.ru_maxrss);
      printf ("%ld:", 	     DUsage.ru_ixrss);
      printf ("%ld:", 	     DUsage.ru_ismrss);
      printf ("%ld:", 	     DUsage.ru_idrss);
      printf ("%ld:", 	     DUsage.ru_isrss);
      printf ("%ld:", 	     DUsage.ru_minflt);
      printf ("%ld:", 	     DUsage.ru_majflt);
      printf ("%ld:", 	     DUsage.ru_nswap);
      printf ("%ld:", 	     DUsage.ru_inblock);
      printf ("%ld:", 	     DUsage.ru_oublock);
      printf ("%ld:", 	     DUsage.ru_msgsnd);
      printf ("%ld:", 	     DUsage.ru_msgrcv);
      printf ("%ld:", 	     DUsage.ru_nsignals);
      printf ("%ld:", 	     DUsage.ru_nvcsw);
      printf ("%ld\n",           DUsage.ru_nivcsw);
    }
}

int
main (argc, argv)
     int argc;
     char **argv;
{
  char *EnvAcctFileName;
  char *AcctFileName;
  int sscanfResult;
  FILE *AcctFilePtr;
  int read_dusageResult;
  dqs_rusage_type DUsage;
  char QComplexStr[10240];
  BOOLEAN Exactly, GotSomeData;

  DENTER_MAIN ((DQS_EVENT, "showacct"));
  dqs_setup (QSUB, argv[0]);

  FatalErrorHook = NULL;
  ProgramName = argv[0];

  if (DEBUG_ON == 1)
    DisplayArgs (argc, argv);

  EnvAcctFileName = getenv (ACCTFILEENVVARNAME);
  AcctFileName = EnvAcctFileName;

  Exactly = FALSE;
  ProcessCmdLine (&argc, argv, EnvAcctFileName, &AcctFileName, &Exactly);

  if (AcctFileName == (char *) NULL)
    {
      AcctFileName = BuildFileName (ACCTF);
      if (AcctFileName == (char *) NULL)
	{
	  Error (__FILE__, __LINE__, 0, "FATAL ERROR: out of memory");
	  exit (EXIT_FAILURE);
	}
    }
  
  AcctFilePtr = fopen (AcctFileName, "r");
  if (AcctFilePtr == NULL)
    {
      Error (NULL, 0, errno,
	     "FATAL ERROR: can't open accounting file named `%s'",
	     AcctFileName);
      exit (EXIT_FAILURE);
    }

  DUsage.qname = (char *) calloc (1, (256 * sizeof (char)));
  DUsage.hostname = (char *) calloc (1, (256 * sizeof (char)));
  DUsage.group = (char *) calloc (1, (256 * sizeof (char)));
  DUsage.owner = (char *) calloc (1, (256 * sizeof (char)));
  DUsage.job_name = (char *) calloc (1, (256 * sizeof (char)));
  DUsage.dqs_job_name = (char *) calloc (1, (256 * sizeof (char)));
  if ((DUsage.qname == (char *) NULL)
      || (DUsage.hostname == (char *) NULL)
      || (DUsage.group == (char *) NULL)
      || (DUsage.owner == (char *) NULL)
      || (DUsage.job_name == (char *) NULL)
      || (DUsage.dqs_job_name == (char *) NULL))
    {
      Error (NULL, 0, 0, "out of memory");
      exit (EXIT_FAILURE);
    }

  read_dusageResult = 0;
  GotSomeData = FALSE;

  while (read_dusageResult == 0)
    {
      read_dusageResult =
	dqs_read_rusage (AcctFilePtr, &DUsage, QComplexStr);

      switch (read_dusageResult)
	{
	case -3:
	  /* The file should be open... */
	  Error (__FILE__, __LINE__, 0, "FATAL INTERNAL ERROR");
	  exit (-3);
	  break;

	case -2:
	  Error (NULL, 0, 0,
		 "Unexpectedly reached end of accounting file named `%s'",
		 AcctFileName);
	  exit (-2);
	  break;

	case -1:
	  Error (NULL, 0, 0, "Cannot parse data in accounting file named `%s'",
		 AcctFileName);
	  exit (-1);
	  break;

	case 0:
	  GotSomeData = TRUE;
	  Writedusage (DUsage, QComplexStr, Exactly);
	  break;

	case 1:
	  if ((Exactly == FALSE) && (GotSomeData == FALSE))
	    Error (NULL, 0, 0, "WARNING: accounting file named `%s' is empty",
		   AcctFileName);
	  break;

	default:
	  Error (__FILE__, __LINE__, 0, "INTERNAL ERROR");
	  break;
	}	  
    }

  return (0);
}


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
