#ifndef __ACCTFILE_H__

static char acctfile_h_rcsid[]="acctfile.h,v 1.2 1994/12/01 14:45:52 kerce Exp";

/*-----------------------------------------------------------------------------
 * Kingsley Kerce
 *
 * Copyright (c) 1994
 *
 * Supercomputer Computations Research Institute (SCRI)
 * Florida State University
 *
 * SCRI representatives make no claims about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * acctfile.h,v
 * Revision 1.2  1994/12/01  14:45:52  kerce
 * Solaris 2.x mods
 *
 * Revision 1.1.1.1  1994/06/18  19:43:31  kerce
 * DQS X Distribution
 *
 *---------------------------------------------------------------------------*/

#define __ACCTFILE_H__ 1

#include <stdio.h>
#include <math.h>
#include <sys/time.h>
#if defined(SYSV) || defined(SVR4)
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>
#include "h.h"
#include "def.h"
#include "dqs.h"
#include "struct.h"
#include "func.h"
#include "globals.h"
#include "proto.h"
#include "request.h"

#define DEFAULTBINSIZE 3600
#define ACCTFILEENVVARNAME "DQSACCTFILE"
#define DEFAULTSTARTDAYSAGO 7
#define DEFAULTDAYS 7

typedef struct
{
  unsigned long NumPoints;
  double *DataPoints;
}
WALLCLOCKDATA;

typedef struct
{
  unsigned long NumPoints;
  double *UserDataPoints, *SysDataPoints;
}
CPUDATA;

typedef struct
{
  /* Input fields. */
  char *AcctFileName;
  unsigned long int IStart;
  unsigned long int IStop;
  unsigned int BinSize;
  unsigned long int LinesToRead;
  /* Input/Output fields. */
  FILE *AcctFilePtr;
  /* Output fields. */
  WALLCLOCKDATA Wallclock;
  CPUDATA CPU;
  unsigned long int LinesRead;
  unsigned long int TotalLinesRead;
  unsigned int PercentageRead;
  struct stat FileStat;
  dqs_rusage_type *DUsage;
  unsigned long int Matches;
}
ACCTFILE;

ACCTFILE *
AcctFileCreate PROTO((char *AcctFileName, unsigned long int IStart,
		      unsigned long int IStop, unsigned int BinSize,
		      int *Result));

void
AcctFileDestroy PROTO((ACCTFILE *AcctFile));

int
AcctFileRead PROTO((ACCTFILE *AcctFile, REQUEST *Req, int LinesToRead));

#define ACCTFILE_SUCCESS		 0
#define ACCTFILE_OUTOFMEM		-1
#define ACCTFILE_NOFOPEN		-2
#define ACCTFILE_NOSTAT			-3
#define ACCTFILE_SMALLBINSIZE		-4
#define ACCTFILE_LARGEBINSIZE		-5
#define ACCTFILE_SMALLISTOP		-6
#define ACCTFILE_SMALLISTART		-7

#endif /* __ACCTFILE_H__ */


/* Set Emacs C-mode style.
   Local Variables:
   c-style: GNU
   End:
 */
